/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateGroupDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataAndEnterpriseInfoDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.entity.SupplierInfoChangeHead;
import com.els.modules.supplier.entity.SupplierInfoChangeItem;
import com.els.modules.supplier.entity.SupplierMasterCustom1;
import com.els.modules.supplier.entity.SupplierMasterCustom10;
import com.els.modules.supplier.entity.SupplierMasterCustom2;
import com.els.modules.supplier.entity.SupplierMasterCustom3;
import com.els.modules.supplier.entity.SupplierMasterCustom4;
import com.els.modules.supplier.entity.SupplierMasterCustom5;
import com.els.modules.supplier.entity.SupplierMasterCustom6;
import com.els.modules.supplier.entity.SupplierMasterCustom7;
import com.els.modules.supplier.entity.SupplierMasterCustom8;
import com.els.modules.supplier.entity.SupplierMasterCustom9;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.enumerate.SupplierDictEnum;
import com.els.modules.supplier.enumerate.SupplierInfoChangStatusEnum;
import com.els.modules.supplier.mapper.SupplierInfoChangeHeadMapper;
import com.els.modules.supplier.mapper.SupplierInfoChangeItemMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.PurchaseCertificatedInfoService;
import com.els.modules.supplier.service.SupplierInfoChangeHeadService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.util.TwoBeanComparatorUtils;
import com.els.modules.supplier.util.assist.SupplierFiledJointAssist;
import com.els.modules.supplier.util.assist.SupplierFiledRecordAssist;
import com.els.modules.supplier.vo.EnterpriseInfoVo;
import com.els.modules.supplier.vo.FieldRecordVo;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SupplierInfoChangeHeadServiceImpl
extends BaseServiceImpl<SupplierInfoChangeHeadMapper, SupplierInfoChangeHead>
implements SupplierInfoChangeHeadService {
    private static final Logger log = LoggerFactory.getLogger(SupplierInfoChangeHeadServiceImpl.class);
    @Autowired
    private SupplierInfoChangeHeadMapper supplierInfoChangeHeadMapper;
    @Autowired
    private SupplierInfoChangeItemMapper supplierInfoChangeItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService supplierinvokeEnterpriseRpcService;
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    @Lazy
    private PurchaseCertificatedInfoService purchaseCertificatedInfoService;
    @Autowired
    @Lazy
    private SupplierInvokeBaseRpcService supplierinvokeBaseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private final String INFOCHANGE_KEY = "supplier:supplierinfochange:";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SupplierMasterDataVO supplierMasterDataVO) {
        if (StringUtils.isNotBlank((CharSequence)supplierMasterDataVO.getSupplierMasterDataId())) {
            supplierMasterDataVO.setId(supplierMasterDataVO.getSupplierMasterDataId());
        }
        String optElsAccount = supplierMasterDataVO.getElsAccount();
        String elsAccount = TenantContext.getTenant();
        SupplierMasterData masterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)supplierMasterDataVO), (Object)((Object)masterData));
        String needAudit = StringUtils.isNotBlank((CharSequence)masterData.getNeedAudit()) ? masterData.getNeedAudit() : "0";
        SupplierInfoChangeHead supplierInfoChangeHead = new SupplierInfoChangeHead();
        String changeId = supplierMasterDataVO.getSupplierInfoChangeId();
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            log.info("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u4fe1\u606f-----start");
            supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)changeId)));
        } else {
            String changeNumber = this.invokeBaseRpcService.getNextCode("supplierInfoChangeNumber", (Object)supplierInfoChangeHead, supplierMasterDataVO.getElsAccount());
            supplierInfoChangeHead.setChangeNumber(changeNumber);
        }
        supplierInfoChangeHead.setSupplierId(masterData.getId());
        supplierInfoChangeHead.setInitiatorElsAccount(elsAccount);
        supplierInfoChangeHead.setElsAccount(masterData.getElsAccount());
        if (StringUtils.isBlank((CharSequence)masterData.getPurchaseName())) {
            ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierinvokeEnterpriseRpcService.getByElsAccount(masterData.getElsAccount());
            supplierInfoChangeHead.setPurchaseName(elsEnterpriseInfo.getName());
        } else {
            supplierInfoChangeHead.setPurchaseName(masterData.getPurchaseName());
        }
        supplierInfoChangeHead.setToElsAccount(masterData.getToElsAccount());
        supplierInfoChangeHead.setSupplierName(masterData.getSupplierName());
        supplierInfoChangeHead.setTemplateAccount(masterData.getTemplateAccount());
        supplierInfoChangeHead.setTemplateName(masterData.getTemplateName());
        supplierInfoChangeHead.setTemplateNumber(masterData.getTemplateNumber());
        supplierInfoChangeHead.setTemplateVersion(masterData.getTemplateVersion());
        supplierInfoChangeHead.setSupplierCode(masterData.getSupplierCode());
        supplierInfoChangeHead.setFile(JSONObject.toJSONString(supplierMasterDataVO.getSupplierInfoChangeAttachmentList()));
        if (!optElsAccount.equals(elsAccount)) {
            supplierInfoChangeHead.setPublishStatus("0");
        }
        if (StringUtils.isBlank((CharSequence)supplierInfoChangeHead.getPublishStatus())) {
            if (needAudit.equals("0")) {
                supplierInfoChangeHead.setNeedAudit(needAudit);
                supplierInfoChangeHead.setAuditStatus("4");
            } else {
                supplierInfoChangeHead.setNeedAudit(needAudit);
                supplierInfoChangeHead.setAuditStatus("0");
            }
        }
        supplierInfoChangeHead.setStatus("0");
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            this.supplierInfoChangeHeadMapper.updateById((Object)supplierInfoChangeHead);
        } else {
            this.supplierInfoChangeHeadMapper.insert((Object)supplierInfoChangeHead);
        }
        supplierMasterDataVO.setSupplierInfoChangeId(supplierInfoChangeHead.getId());
        SupplierInfoChangeItem supplierInfoChangeItem = new SupplierInfoChangeItem();
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            supplierInfoChangeItem = this.supplierInfoChangeItemMapper.selectByMainId(changeId).get(0);
        }
        supplierInfoChangeItem.setHeadId(supplierInfoChangeHead.getId());
        supplierInfoChangeItem.setChangeNumber(supplierInfoChangeHead.getChangeNumber());
        supplierInfoChangeItem.setInitiatorElsAccount(elsAccount);
        supplierInfoChangeItem.setElsAccount(masterData.getElsAccount());
        supplierInfoChangeItem.setToElsAccount(masterData.getToElsAccount());
        supplierInfoChangeItem.setUpdateAfterData(JSONObject.toJSONString((Object)((Object)supplierMasterDataVO)));
        List<SupplierAddressInfo> addressInfoList = supplierMasterDataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> bankInfoList = supplierMasterDataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> contactsInfoList = supplierMasterDataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> orgInfoList = supplierMasterDataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> custom1List = supplierMasterDataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> custom2List = supplierMasterDataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> custom3List = supplierMasterDataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> custom4List = supplierMasterDataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> custom5List = supplierMasterDataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> custom6List = supplierMasterDataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> custom7List = supplierMasterDataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> custom8List = supplierMasterDataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> custom9List = supplierMasterDataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> custom10List = supplierMasterDataVO.getSupplierMasterCustom10List();
        log.info("\u83b7\u53d6\u4fee\u6539\u524d\u7684\u3010\u65e7\u6570\u636e\u3011-----start");
        SupplierMasterDataVO oldMasterDataVO = this.supplierMasterDataService.getDataById(supplierMasterDataVO.getId());
        log.info("\u83b7\u53d6\u4fee\u6539\u524d\u7684\u3010\u65e7\u6570\u636e\u3011-----end");
        SupplierMasterData oldMasterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)oldMasterDataVO), (Object)((Object)oldMasterData));
        List<SupplierAddressInfo> oldAddressInfoList = oldMasterDataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> oldBankInfoList = oldMasterDataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> oldContactsInfoList = oldMasterDataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> oldOrgInfoList = oldMasterDataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> oldCustom1List = oldMasterDataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> oldCustom2List = oldMasterDataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> oldCustom3List = oldMasterDataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> oldCustom4List = oldMasterDataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> oldCustom5List = oldMasterDataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> oldCustom6List = oldMasterDataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> oldCustom7List = oldMasterDataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> oldCustom8List = oldMasterDataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> oldCustom9List = oldMasterDataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> oldCustom10List = oldMasterDataVO.getSupplierMasterCustom10List();
        supplierInfoChangeItem.setUpdateBeforeData(JSONObject.toJSONString((Object)((Object)oldMasterDataVO)));
        String accessCategroy = "";
        for (SupplierOrgInfo entity : orgInfoList) {
            if (!StringUtils.isNotBlank((CharSequence)entity.getAccessCategory())) continue;
            accessCategroy = accessCategroy + entity.getAccessCategory() + ";";
        }
        supplierMasterDataVO.setAccessCategory(accessCategroy);
        ArrayList<FieldRecordVo> list = new ArrayList<FieldRecordVo>();
        list.addAll(TwoBeanComparatorUtils.compareBeanToFieldRecord("headData", oldMasterData.getId(), "1", (Object)oldMasterDataVO, (Object)supplierMasterDataVO));
        list.addAll(SupplierFiledRecordAssist.getSupplierAddressInfoFiledRecord("supplierAddressInfoList", addressInfoList, oldAddressInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierBankInfoFiledRecord("supplierBankInfoList", bankInfoList, oldBankInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierContactsInfoFiledRecord("supplierContactsInfoList", contactsInfoList, oldContactsInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierOrgInfoFiledRecord("supplierOrgInfoList", orgInfoList, oldOrgInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom1FiledRecord("supplierMasterCustom1List", custom1List, oldCustom1List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom2FiledRecord("supplierMasterCustom2List", custom2List, oldCustom2List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom3FiledRecord("supplierMasterCustom3List", custom3List, oldCustom3List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom4FiledRecord("supplierMasterCustom4List", custom4List, oldCustom4List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom5FiledRecord("supplierMasterCustom5List", custom5List, oldCustom5List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom6FiledRecord("supplierMasterCustom6List", custom6List, oldCustom6List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom7FiledRecord("supplierMasterCustom7List", custom7List, oldCustom7List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom8FiledRecord("supplierMasterCustom8List", custom8List, oldCustom8List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom9FiledRecord("supplierMasterCustom9List", custom9List, oldCustom9List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom10FiledRecord("supplierMasterCustom10List", custom10List, oldCustom10List));
        if (!list.isEmpty() && list.size() > 0) {
            if (list.size() == 1 && ((FieldRecordVo)list.get(0)).getField().equals("supplierInfoChangeId")) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_sMKmWLIiucrjVHW_7dae2e32", (String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u672a\u68c0\u6d4b\u5230\u4fee\u6539\u7684\u4fe1\u606f\uff01"));
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_sMKmWLIiucrjVHW_7dae2e32", (String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u672a\u68c0\u6d4b\u5230\u4fee\u6539\u7684\u4fe1\u606f\uff01"));
        }
        supplierInfoChangeItem.setUpdateFieldData(JSONObject.toJSONString(list));
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            this.supplierInfoChangeItemMapper.updateById((Object)supplierInfoChangeItem);
        } else {
            this.supplierInfoChangeItemMapper.insert((Object)supplierInfoChangeItem);
        }
        supplierMasterDataVO.setId(supplierInfoChangeItem.getHeadId());
    }

    @Override
    public void insertPurchaseInfoChang(List<SupplierMasterDataAndEnterpriseInfoDTO> purchaseList) {
        SupplierMasterDataVO newMasterDataVO = null;
        SupplierMasterDataVO oldMasterDataVO = null;
        ArrayList<String> supplierInfoChangeIds = new ArrayList<String>();
        for (SupplierMasterDataAndEnterpriseInfoDTO infoDTO : purchaseList) {
            newMasterDataVO = (SupplierMasterDataVO)((Object)SysUtil.copyProperties((Object)infoDTO, SupplierMasterDataVO.class));
            newMasterDataVO = this.setPropertiesByEnterpriseInfo(newMasterDataVO, infoDTO.getElsEnterpriseInfoNew());
            List<SupplierContactsInfo> contactsInfoListNew = newMasterDataVO.getSupplierContactsInfoList();
            contactsInfoListNew.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierContactsInfoListNew(), SupplierContactsInfo.class));
            newMasterDataVO.setSupplierContactsInfoList(contactsInfoListNew);
            List<SupplierAddressInfo> addressInfoListNew = newMasterDataVO.getSupplierAddressInfoList();
            addressInfoListNew.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierAddressInfoListNew(), SupplierAddressInfo.class));
            newMasterDataVO.setSupplierAddressInfoList(addressInfoListNew);
            List<SupplierBankInfo> bankInfoListNew = newMasterDataVO.getSupplierBankInfoList();
            bankInfoListNew.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierBankInfoListNew(), SupplierBankInfo.class));
            newMasterDataVO.setSupplierBankInfoList(bankInfoListNew);
            oldMasterDataVO = (SupplierMasterDataVO)((Object)SysUtil.copyProperties((Object)infoDTO, SupplierMasterDataVO.class));
            oldMasterDataVO = this.setPropertiesByEnterpriseInfo(oldMasterDataVO, infoDTO.getElsEnterpriseInfoOld());
            List<SupplierContactsInfo> contactsInfoListOld = oldMasterDataVO.getSupplierContactsInfoList();
            contactsInfoListOld.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierContactsInfoListOld(), SupplierContactsInfo.class));
            oldMasterDataVO.setSupplierContactsInfoList(contactsInfoListOld);
            List<SupplierAddressInfo> addressInfoListOld = oldMasterDataVO.getSupplierAddressInfoList();
            addressInfoListOld.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierAddressInfoListOld(), SupplierAddressInfo.class));
            oldMasterDataVO.setSupplierAddressInfoList(addressInfoListOld);
            List<SupplierBankInfo> bankInfoListOld = oldMasterDataVO.getSupplierBankInfoList();
            bankInfoListOld.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierBankInfoListOld(), SupplierBankInfo.class));
            oldMasterDataVO.setSupplierBankInfoList(bankInfoListOld);
            List purchaseAttachmentDTOList = JSONObject.parseArray((String)infoDTO.getSupplierInfoChangeAttachmentJson(), PurchaseAttachmentDTO.class);
            newMasterDataVO.setSupplierInfoChangeAttachmentList(purchaseAttachmentDTOList);
            oldMasterDataVO.setSupplierInfoChangeAttachmentList(purchaseAttachmentDTOList);
            String infoChangId = this.insertPurchaseInfoChang(newMasterDataVO, oldMasterDataVO);
            supplierInfoChangeIds.add(infoChangId);
        }
        if (!supplierInfoChangeIds.isEmpty() && supplierInfoChangeIds.size() > 0) {
            this.redisUtil.set("supplier:supplierinfochange:purchaseIds", (Object)StringUtils.strip((String)((Object)supplierInfoChangeIds).toString(), (String)"[]"));
        }
    }

    @Override
    public boolean isExistUnconfirmed(String elsAccount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"to_els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.isNotNull((Object)"publish_status");
        queryWrapper.and(o -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)o.and(t -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)t.eq((Object)"status", (Object)"0")).eq((Object)"publish_status", (Object)"0");
            })).or(k -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)k.eq((Object)"status", (Object)"3")).eq((Object)"publish_status", (Object)"1");
            });
        });
        Integer count = this.supplierInfoChangeHeadMapper.selectCount((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    public boolean isExistInfoUpdate(EnterpriseInfoVo enterpriseInfoVo, EnterpriseInfoVo enterpriseInfoVoOld) {
        com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = new com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO();
        BeanUtils.copyProperties((Object)((Object)enterpriseInfoVo), (Object)elsEnterpriseInfoDTO);
        List<SupplierContactsInfo> supplierContactsInfoList = enterpriseInfoVo.getSupplierContactsInfoList();
        List<SupplierAddressInfo> supplierAddressInfoList = enterpriseInfoVo.getSupplierAddressInfoList();
        List<SupplierBankInfo> supplierBankInfoList = enterpriseInfoVo.getSupplierBankInfoList();
        com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO elsEnterpriseInfoDTOOld = new com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO();
        BeanUtils.copyProperties((Object)((Object)enterpriseInfoVoOld), (Object)elsEnterpriseInfoDTOOld);
        List<SupplierContactsInfo> supplierContactsInfoListOld = enterpriseInfoVoOld.getSupplierContactsInfoList();
        List<SupplierAddressInfo> supplierAddressInfoListOld = enterpriseInfoVoOld.getSupplierAddressInfoList();
        List<SupplierBankInfo> supplierBankInfoListOld = enterpriseInfoVoOld.getSupplierBankInfoList();
        ArrayList<FieldRecordVo> list = new ArrayList<FieldRecordVo>();
        list.addAll(TwoBeanComparatorUtils.compareBeanToFieldRecord("headData", elsEnterpriseInfoDTOOld.getId(), "1", elsEnterpriseInfoDTOOld, elsEnterpriseInfoDTO));
        list.addAll(SupplierFiledRecordAssist.getSupplierAddressInfoFiledRecord("supplierAddressInfoList", supplierAddressInfoList, supplierAddressInfoListOld));
        list.addAll(SupplierFiledRecordAssist.getSupplierBankInfoFiledRecord("supplierBankInfoList", supplierBankInfoList, supplierBankInfoListOld));
        list.addAll(SupplierFiledRecordAssist.getSupplierContactsInfoFiledRecord("supplierContactsInfoList", supplierContactsInfoList, supplierContactsInfoListOld));
        if (!list.isEmpty() && list.size() > 0) {
            return list.size() == 1 && ((FieldRecordVo)list.get(0)).getField().equals("supplierInfoChangeId");
        }
        return true;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(SupplierMasterDataVO supplierMasterDataVO) {
        String supplierInfoChangeId = supplierMasterDataVO.getSupplierInfoChangeId();
        SupplierInfoChangeHead supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)supplierInfoChangeId)));
        supplierInfoChangeHead.setNeedAudit("0");
        supplierInfoChangeHead.setAuditStatus("4");
        supplierInfoChangeHead.setStatus(SupplierInfoChangStatusEnum.EFFECTIVE.getValue());
        this.supplierInfoChangeHeadMapper.updateById((Object)supplierInfoChangeHead);
        List<SupplierInfoChangeItem> changeItemList = this.supplierInfoChangeItemMapper.selectByMainId(supplierInfoChangeId);
        SupplierInfoChangeItem infoChangeItem = changeItemList.get(0);
        String updateAfterData = infoChangeItem.getUpdateAfterData();
        SupplierMasterDataVO masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)updateAfterData, SupplierMasterDataVO.class));
        this.supplierMasterDataService.updateMainNoAudit(masterDataVO);
        supplierMasterDataVO.setId(supplierInfoChangeId);
        String url = "id=" + supplierInfoChangeId;
        super.sendMsg(supplierInfoChangeHead.getElsAccount(), (List)Lists.newArrayList((Object[])new String[]{supplierInfoChangeHead.getElsAccount()}), (Object)supplierInfoChangeHead, url, "SupplierInfoChange", "purchasePublish");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SupplierMasterDataVO supplierMasterDataVO) {
    }

    @Override
    public JSONObject getDataById(String id) {
        String elsAccount = TenantContext.getTenant();
        SupplierInfoChangeHead changeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
        List<SupplierInfoChangeItem> supplierInfoChangeItemList = this.supplierInfoChangeItemMapper.selectByMainId(id);
        SupplierInfoChangeItem changeItem = supplierInfoChangeItemList.get(0);
        String beforeData = changeItem.getUpdateBeforeData();
        SupplierMasterDataVO dataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)beforeData, SupplierMasterDataVO.class));
        List<SupplierAddressInfo> addressInfoList = dataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> bankInfoList = dataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> contactsInfoList = dataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> orgInfoList = dataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> custom1List = dataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> custom2List = dataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> custom3List = dataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> custom4List = dataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> custom5List = dataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> custom6List = dataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> custom7List = dataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> custom8List = dataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> custom9List = dataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> custom10List = dataVO.getSupplierMasterCustom10List();
        String fieldData = changeItem.getUpdateFieldData();
        ArrayList recordVoList = JSONObject.parseArray((String)fieldData, FieldRecordVo.class);
        if (recordVoList == null) {
            recordVoList = new ArrayList();
        }
        List headRecordList = recordVoList.parallelStream().filter(o -> "headData".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> addressRecordList = recordVoList.parallelStream().filter(o -> "supplierAddressInfoList".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> bankRecordList = recordVoList.parallelStream().filter(o -> "supplierBankInfoList".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> contactsRecordList = recordVoList.parallelStream().filter(o -> "supplierContactsInfoList".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> orgRecordList = recordVoList.parallelStream().filter(o -> "supplierOrgInfoList".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom1RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom1List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom2RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom2List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom3RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom3List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom4RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom4List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom5RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom5List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom6RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom6List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom7RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom7List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom8RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom8List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom9RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom9List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom10RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom10List".equals(o.getGroup())).collect(Collectors.toList());
        JSONObject jsonObject = JSONObject.parseObject((String)beforeData);
        Result result = new Result();
        result = Result.ok((Object)((Object)dataVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        JSONObject parseVo = (JSONObject)result.getResult();
        jsonObject.putAll((Map)parseVo);
        jsonObject = this.getDateTypeToString(jsonObject);
        jsonObject.put("infoChangId", (Object)changeHead.getId());
        jsonObject.put("supplierInfoChangeId", (Object)changeHead.getId());
        jsonObject.put("infoChangFlowId", (Object)changeHead.getFlowId());
        jsonObject.put("infoChangWorkFlowType", (Object)changeHead.getWorkFlowType());
        jsonObject.put("infoChangAuditStatus", (Object)changeHead.getAuditStatus());
        jsonObject.put("infoChangStatus", (Object)changeHead.getStatus());
        jsonObject.put("infoChangPublishStatus", (Object)changeHead.getPublishStatus());
        jsonObject.put("infoChangNeedAudit", (Object)changeHead.getNeedAudit());
        TemplateHeadDTO templateHeadDTO = this.supplierinvokeBaseRpcService.getConfig(changeHead.getTemplateAccount(), changeHead.getTemplateNumber(), changeHead.getTemplateVersion());
        List headList = templateHeadDTO.getTemplateGroupList().stream().filter(o -> o.getGroupType().equals("head")).collect(Collectors.toList());
        block0: for (TemplateGroupDTO groupDTO : headList) {
            jsonObject.put(groupDTO.getGroupCode() + "_hasStar", (Object)false);
            List configHeadDTOList = templateHeadDTO.getTemplateConfigHeadList().stream().filter(o -> o.getGroupCode().equals(groupDTO.getGroupCode())).collect(Collectors.toList());
            HashSet<String> fildName = new HashSet<String>();
            Iterator iterator = configHeadDTOList.iterator();
            while (iterator.hasNext()) {
                TemplateConfigHeadDTO dto = (TemplateConfigHeadDTO)iterator.next();
                fildName.add(dto.getFieldName());
            }
            for (FieldRecordVo vo : headRecordList) {
                if (!fildName.contains(vo.getField())) continue;
                jsonObject.put(groupDTO.getGroupCode() + "_hasStar", (Object)true);
                continue block0;
            }
        }
        jsonObject.put("supplierAddressInfoList_hasStar", (Object)(CollUtil.isNotEmpty(addressRecordList) ? 1 : 0));
        jsonObject.put("supplierBankInfoList_hasStar", (Object)(CollUtil.isNotEmpty(bankRecordList) ? 1 : 0));
        jsonObject.put("supplierContactsInfoList_hasStar", (Object)(CollUtil.isNotEmpty(contactsRecordList) ? 1 : 0));
        jsonObject.put("supplierOrgInfoList_hasStar", (Object)(CollUtil.isNotEmpty(orgRecordList) ? 1 : 0));
        jsonObject.put("supplierMasterCustom1List_hasStar", (Object)(CollUtil.isNotEmpty(custom1RecordList) ? 1 : 0));
        jsonObject.put("supplierMasterCustom2List_hasStar", (Object)(CollUtil.isNotEmpty(custom2RecordList) ? 1 : 0));
        jsonObject.put("supplierMasterCustom3List_hasStar", (Object)(CollUtil.isNotEmpty(custom3RecordList) ? 1 : 0));
        jsonObject.put("supplierMasterCustom4List_hasStar", (Object)(CollUtil.isNotEmpty(custom4RecordList) ? 1 : 0));
        jsonObject.put("supplierMasterCustom5List_hasStar", (Object)(CollUtil.isNotEmpty(custom5RecordList) ? 1 : 0));
        jsonObject.put("supplierMasterCustom6List_hasStar", (Object)(CollUtil.isNotEmpty(custom6RecordList) ? 1 : 0));
        jsonObject.put("supplierMasterCustom7List_hasStar", (Object)(CollUtil.isNotEmpty(custom7RecordList) ? 1 : 0));
        jsonObject.put("supplierMasterCustom8List_hasStar", (Object)(CollUtil.isNotEmpty(custom8RecordList) ? 1 : 0));
        jsonObject.put("supplierMasterCustom9List_hasStar", (Object)(CollUtil.isNotEmpty(custom9RecordList) ? 1 : 0));
        jsonObject.put("supplierMasterCustom10List_hasStar", (Object)(CollUtil.isNotEmpty(custom10RecordList) ? 1 : 0));
        for (FieldRecordVo vo : headRecordList) {
            jsonObject.put(vo.getField() + "_new", (Object)vo.getFieldValue());
            if (!StringUtils.isNotBlank((CharSequence)SupplierDictEnum.getByField(vo.getField()))) continue;
            String[] split = vo.getFieldValue().split(",");
            StringBuilder textValue = new StringBuilder();
            List dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode(SupplierDictEnum.getByField(vo.getField()), elsAccount);
            for (String k : split) {
                if (textValue != null && !"".equals(textValue.toString())) {
                    textValue.append("\uff0c");
                }
                textValue.append(dictDTOS.parallelStream().filter(o -> o.getValue().equals(k)).map(DictDTO::getText).collect(Collectors.joining()));
            }
            jsonObject.put(vo.getField() + "_new_dictText", (Object)textValue.toString());
        }
        jsonObject.put("supplierAddressInfoList", (Object)SupplierFiledJointAssist.getAddressInfoJsonArray(addressInfoList, addressRecordList));
        jsonObject.put("supplierBankInfoList", (Object)SupplierFiledJointAssist.getBankInfoJsonArray(bankInfoList, bankRecordList));
        jsonObject.put("supplierContactsInfoList", (Object)SupplierFiledJointAssist.getContactsInfoJsonArray(contactsInfoList, contactsRecordList));
        jsonObject.put("supplierOrgInfoList", (Object)SupplierFiledJointAssist.getOrgInfoJsonArray(orgInfoList, orgRecordList));
        jsonObject.put("supplierInfoChangeAttachmentList", (Object)JSONObject.parseArray((String)changeHead.getFile(), PurchaseAttachmentDTO.class));
        jsonObject.put("supplierMasterCustom1List", (Object)SupplierFiledJointAssist.getCustom1JsonArray(custom1List, custom1RecordList));
        jsonObject.put("supplierMasterCustom2List", (Object)SupplierFiledJointAssist.getCustom2JsonArray(custom2List, custom2RecordList));
        jsonObject.put("supplierMasterCustom3List", (Object)SupplierFiledJointAssist.getCustom3JsonArray(custom3List, custom3RecordList));
        jsonObject.put("supplierMasterCustom4List", (Object)SupplierFiledJointAssist.getCustom4JsonArray(custom4List, custom4RecordList));
        jsonObject.put("supplierMasterCustom5List", (Object)SupplierFiledJointAssist.getCustom5JsonArray(custom5List, custom5RecordList));
        jsonObject.put("supplierMasterCustom6List", (Object)SupplierFiledJointAssist.getCustom6JsonArray(custom6List, custom6RecordList));
        jsonObject.put("supplierMasterCustom7List", (Object)SupplierFiledJointAssist.getCustom7JsonArray(custom7List, custom7RecordList));
        jsonObject.put("supplierMasterCustom8List", (Object)SupplierFiledJointAssist.getCustom8JsonArray(custom8List, custom8RecordList));
        jsonObject.put("supplierMasterCustom9List", (Object)SupplierFiledJointAssist.getCustom9JsonArray(custom9List, custom9RecordList));
        jsonObject.put("supplierMasterCustom10List", (Object)SupplierFiledJointAssist.getCustom10JsonArray(custom10List, custom10RecordList));
        List<PurchaseCertificatedInfo> supplierCertificatedInfoList = this.purchaseCertificatedInfoService.getPurchaseCertificatedListByToElsAccount(changeHead.getElsAccount(), changeHead.getToElsAccount());
        jsonObject.put("supplierCertificatedInfoList", supplierCertificatedInfoList);
        String afterData = changeItem.getUpdateAfterData();
        JSONObject afterDataJson = JSONObject.parseObject((String)afterData);
        jsonObject.put("frozenFunction", (Object)afterDataJson.getString("frozenFunction"));
        jsonObject.put("supplierMasterFrozenList", (Object)afterDataJson.getJSONArray("supplierMasterFrozenList"));
        jsonObject.put("supplierMasterFrozenHistoryList", (Object)afterDataJson.getJSONArray("supplierMasterFrozenHistoryList"));
        return jsonObject;
    }

    @Override
    public SupplierMasterDataVO getAfterDataById(String id) {
        SupplierInfoChangeHead changeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
        List<SupplierInfoChangeItem> supplierInfoChangeItemList = this.supplierInfoChangeItemMapper.selectByMainId(id);
        SupplierInfoChangeItem changeItem = supplierInfoChangeItemList.get(0);
        String afterData = changeItem.getUpdateAfterData();
        SupplierMasterDataVO dataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)afterData, SupplierMasterDataVO.class));
        dataVO.setSupplierInfoChangeId(id);
        List<PurchaseCertificatedInfo> supplierCertificatedInfoList = this.purchaseCertificatedInfoService.getPurchaseCertificatedListByToElsAccount(changeHead.getElsAccount(), changeHead.getToElsAccount());
        dataVO.setSupplierCertificatedInfoList(supplierCertificatedInfoList);
        dataVO.setSupplierMasterDataId(dataVO.getId());
        dataVO.setId(changeHead.getId());
        return dataVO;
    }

    @Override
    public SupplierInfoChangeHead getInfoChangById(String id) {
        return (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.supplierInfoChangeItemMapper.deleteByMainId(id);
        this.supplierInfoChangeHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    public void invalidById(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            SupplierInfoChangeHead supplierInfoChangeHead = new SupplierInfoChangeHead();
            supplierInfoChangeHead.setId(id);
            supplierInfoChangeHead.setStatus(SupplierInfoChangStatusEnum.INVALID.getValue());
            this.supplierInfoChangeHeadMapper.updateById((Object)supplierInfoChangeHead);
        }
    }

    @Override
    public void releaseByIds(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            List<String> ids = Arrays.asList(id.replace(" ", "").split(","));
            SupplierInfoChangeHead supplierInfoChangeHead = new SupplierInfoChangeHead();
            supplierInfoChangeHead.setStatus(SupplierInfoChangStatusEnum.WAIT_CONFIRM.getValue());
            supplierInfoChangeHead.setPublishStatus("1");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", ids);
            this.supplierInfoChangeHeadMapper.update((Object)supplierInfoChangeHead, (Wrapper)queryWrapper);
            List headList = this.supplierInfoChangeHeadMapper.selectList((Wrapper)queryWrapper);
            if (!headList.isEmpty() && headList.size() > 0) {
                for (SupplierInfoChangeHead head : headList) {
                    String url = "id=" + head.getId();
                    super.sendMsg(head.getElsAccount(), (List)Lists.newArrayList((Object[])new String[]{head.getElsAccount()}), (Object)head, url, "SupplierInfoChange", "salePublish");
                }
            }
        }
    }

    @Override
    public void confirmById(String id) {
        SupplierInfoChangeHead changeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
        SupplierInfoChangeItem changeItem = this.supplierInfoChangeItemMapper.selectByMainId(changeHead.getId()).get(0);
        String afterData = changeItem.getUpdateAfterData();
        changeHead.setStatus(SupplierInfoChangStatusEnum.CONFIRM.getValue());
        this.supplierInfoChangeHeadMapper.updateById((Object)changeHead);
        SupplierMasterDataVO masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)afterData, SupplierMasterDataVO.class));
        masterDataVO.setEnterpriseInfoRecordId("");
        this.supplierMasterDataService.updateMainNoAudit(masterDataVO);
    }

    @Override
    public void rejectedById(SupplierInfoChangeHead head) {
        if (StringUtils.isNotBlank((CharSequence)head.getId())) {
            SupplierInfoChangeHead oldHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)head.getId())));
            if (oldHead != null && StringUtils.isBlank((CharSequence)oldHead.getPurchaseName())) {
                ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierinvokeEnterpriseRpcService.getByElsAccount(oldHead.getElsAccount());
                oldHead.setPurchaseName(elsEnterpriseInfo != null ? elsEnterpriseInfo.getName() : "");
            }
            oldHead.setStatus(SupplierInfoChangStatusEnum.BLACKLIST.getValue());
            oldHead.setRejectReason(head.getRejectReason());
            this.supplierInfoChangeHeadMapper.updateById((Object)oldHead);
            String url = "id=" + oldHead.getId();
            super.sendMsg(oldHead.getElsAccount(), (List)Lists.newArrayList((Object[])new String[]{oldHead.getToElsAccount()}), (Object)oldHead, url, "SupplierInfoChange", "purchaseReject");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.supplierInfoChangeItemMapper.deleteByMainId(serializable.toString());
            this.supplierInfoChangeHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public boolean isHaveNewAndWaitConfirm(String supplierId, String status) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.eq((Object)"status", (Object)status);
        Integer count = this.supplierInfoChangeHeadMapper.selectCount((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    public Result<?> isHaveNewData(String supplierId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.eq((Object)"status", (Object)"0");
        queryWrapper.eq((Object)"publish_status", (Object)"0");
        List infoChangeHeadList = this.supplierInfoChangeHeadMapper.selectList((Wrapper)queryWrapper);
        if (!infoChangeHeadList.isEmpty() && infoChangeHeadList.size() > 0) {
            SupplierInfoChangeHead supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)infoChangeHeadList.get(0));
            return Result.ok((Object)((Object)supplierInfoChangeHead));
        }
        return Result.error((String)"Unable to find data");
    }

    @Override
    public List<SupplierInfoChangeHead> getEffectiveListBySupplierId(String supplierId) {
        ArrayList<String> status = new ArrayList<String>();
        status.add("1");
        status.add("4");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.in((Object)"status", status);
        queryWrapper.orderByDesc((Object)"create_time");
        List list = this.supplierInfoChangeHeadMapper.selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public IPage<SupplierInfoChangeHead> selectChangInfoAndEnterprisePage(Page<SupplierInfoChangeHead> page, QueryWrapper<SupplierInfoChangeHead> queryWrapper) {
        return this.supplierInfoChangeHeadMapper.selectChangInfoAndEnterprisePage(page, queryWrapper);
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public String insertPurchaseInfoChang(SupplierMasterDataVO newMasterDataVO, SupplierMasterDataVO oldMasterDataVO) {
        List<SupplierAddressInfo> addressInfoList = newMasterDataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> bankInfoList = newMasterDataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> contactsInfoList = newMasterDataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> orgInfoList = newMasterDataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> custom1List = newMasterDataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> custom2List = newMasterDataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> custom3List = newMasterDataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> custom4List = newMasterDataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> custom5List = newMasterDataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> custom6List = newMasterDataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> custom7List = newMasterDataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> custom8List = newMasterDataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> custom9List = newMasterDataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> custom10List = newMasterDataVO.getSupplierMasterCustom10List();
        SupplierMasterData oldMasterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)oldMasterDataVO), (Object)((Object)oldMasterData));
        List<SupplierAddressInfo> oldAddressInfoList = oldMasterDataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> oldBankInfoList = oldMasterDataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> oldContactsInfoList = oldMasterDataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> oldOrgInfoList = oldMasterDataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> oldCustom1List = oldMasterDataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> oldCustom2List = oldMasterDataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> oldCustom3List = oldMasterDataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> oldCustom4List = oldMasterDataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> oldCustom5List = oldMasterDataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> oldCustom6List = oldMasterDataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> oldCustom7List = oldMasterDataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> oldCustom8List = oldMasterDataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> oldCustom9List = oldMasterDataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> oldCustom10List = oldMasterDataVO.getSupplierMasterCustom10List();
        String elsAccount = TenantContext.getTenant();
        SupplierMasterData masterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)oldMasterDataVO), (Object)((Object)masterData));
        SupplierInfoChangeHead supplierInfoChangeHead = new SupplierInfoChangeHead();
        String changeNumber = this.invokeBaseRpcService.getNextCode("supplierInfoChangeNumber", (Object)supplierInfoChangeHead, oldMasterDataVO.getElsAccount());
        supplierInfoChangeHead.setChangeNumber(changeNumber);
        supplierInfoChangeHead.setSupplierId(masterData.getId());
        supplierInfoChangeHead.setInitiatorElsAccount(elsAccount);
        supplierInfoChangeHead.setElsAccount(masterData.getElsAccount());
        if (StringUtils.isBlank((CharSequence)masterData.getPersonName())) {
            ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = this.supplierinvokeEnterpriseRpcService.getByElsAccount(masterData.getElsAccount());
            supplierInfoChangeHead.setPurchaseName(elsEnterpriseInfoDTO != null ? elsEnterpriseInfoDTO.getName() : "");
        } else {
            supplierInfoChangeHead.setPurchaseName(masterData.getPurchaseName());
        }
        supplierInfoChangeHead.setToElsAccount(masterData.getToElsAccount());
        supplierInfoChangeHead.setSupplierName(masterData.getSupplierName());
        supplierInfoChangeHead.setTemplateAccount(masterData.getTemplateAccount());
        supplierInfoChangeHead.setTemplateName(masterData.getTemplateName());
        supplierInfoChangeHead.setTemplateNumber(masterData.getTemplateNumber());
        supplierInfoChangeHead.setTemplateVersion(masterData.getTemplateVersion());
        supplierInfoChangeHead.setSupplierCode(masterData.getSupplierCode());
        supplierInfoChangeHead.setFile(JSONObject.toJSONString(newMasterDataVO.getSupplierInfoChangeAttachmentList()));
        supplierInfoChangeHead.setStatus("0");
        supplierInfoChangeHead.setPublishStatus("0");
        this.supplierInfoChangeHeadMapper.insert((Object)supplierInfoChangeHead);
        SupplierInfoChangeItem supplierInfoChangeItem = new SupplierInfoChangeItem();
        supplierInfoChangeItem.setHeadId(supplierInfoChangeHead.getId());
        supplierInfoChangeItem.setChangeNumber(supplierInfoChangeHead.getChangeNumber());
        supplierInfoChangeItem.setInitiatorElsAccount(elsAccount);
        supplierInfoChangeItem.setElsAccount(masterData.getElsAccount());
        supplierInfoChangeItem.setToElsAccount(masterData.getToElsAccount());
        supplierInfoChangeItem.setUpdateAfterData(JSONObject.toJSONString((Object)((Object)newMasterDataVO)));
        supplierInfoChangeItem.setUpdateBeforeData(JSONObject.toJSONString((Object)((Object)oldMasterDataVO)));
        String accessCategroy = "";
        for (SupplierOrgInfo entity : orgInfoList) {
            if (!StringUtils.isNotBlank((CharSequence)entity.getAccessCategory())) continue;
            accessCategroy = accessCategroy + entity.getAccessCategory() + ";";
        }
        newMasterDataVO.setAccessCategory(accessCategroy);
        ArrayList<FieldRecordVo> list = new ArrayList<FieldRecordVo>();
        list.addAll(TwoBeanComparatorUtils.compareBeanToFieldRecord("headData", oldMasterData.getId(), "1", (Object)oldMasterDataVO, (Object)newMasterDataVO));
        list.addAll(SupplierFiledRecordAssist.getSupplierAddressInfoFiledRecord("supplierAddressInfoList", addressInfoList, oldAddressInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierBankInfoFiledRecord("supplierBankInfoList", bankInfoList, oldBankInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierContactsInfoFiledRecord("supplierContactsInfoList", contactsInfoList, oldContactsInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierOrgInfoFiledRecord("supplierOrgInfoList", orgInfoList, oldOrgInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom1FiledRecord("supplierMasterCustom1List", custom1List, oldCustom1List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom2FiledRecord("supplierMasterCustom2List", custom2List, oldCustom2List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom3FiledRecord("supplierMasterCustom3List", custom3List, oldCustom3List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom4FiledRecord("supplierMasterCustom4List", custom4List, oldCustom4List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom5FiledRecord("supplierMasterCustom5List", custom5List, oldCustom5List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom6FiledRecord("supplierMasterCustom6List", custom6List, oldCustom6List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom7FiledRecord("supplierMasterCustom7List", custom7List, oldCustom7List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom8FiledRecord("supplierMasterCustom8List", custom8List, oldCustom8List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom9FiledRecord("supplierMasterCustom9List", custom9List, oldCustom9List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom10FiledRecord("supplierMasterCustom10List", custom10List, oldCustom10List));
        if (!list.isEmpty() && list.size() > 0) {
            supplierInfoChangeItem.setUpdateFieldData(JSONObject.toJSONString(list));
        }
        this.supplierInfoChangeItemMapper.insert((Object)supplierInfoChangeItem);
        return supplierInfoChangeHead.getId();
    }

    private JSONObject getDateTypeToString(JSONObject jsonObject) {
        if (jsonObject.getDate("fromTime") != null) {
            jsonObject.put("fromTime", (Object)new SimpleDateFormat("yyyy-MM-dd").format(jsonObject.getDate("fromTime")));
        }
        if (jsonObject.getDate("approvedTime") != null) {
            jsonObject.put("approvedTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("approvedTime")));
        }
        if (jsonObject.getDate("updateTimes") != null) {
            jsonObject.put("updateTimes", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("updateTimes")));
        }
        if (jsonObject.getDate("establishTime") != null) {
            jsonObject.put("establishTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("establishTime")));
        }
        if (jsonObject.getDate("toTime") != null) {
            jsonObject.put("toTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("toTime")));
        }
        if (jsonObject.getDate("revokeDate") != null) {
            jsonObject.put("revokeDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("revokeDate")));
        }
        if (jsonObject.getDate("cancelDate") != null) {
            jsonObject.put("cancelDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("cancelDate")));
        }
        if (jsonObject.getDate("registerDate") != null) {
            jsonObject.put("registerDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("registerDate")));
        }
        if (jsonObject.getDate("createTime") != null) {
            jsonObject.put("createTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("createTime")));
        }
        if (jsonObject.getDate("updateTime") != null) {
            jsonObject.put("updateTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("updateTime")));
        }
        return jsonObject;
    }

    private SupplierMasterDataVO setPropertiesByEnterpriseInfo(SupplierMasterDataVO supplierMasterDataVO, com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO ElsEnterpriseInfoDTO2) {
        supplierMasterDataVO.setName(ElsEnterpriseInfoDTO2.getName());
        supplierMasterDataVO.setPercentileScore(ElsEnterpriseInfoDTO2.getPercentileScore());
        supplierMasterDataVO.setStaffNumRange(ElsEnterpriseInfoDTO2.getStaffNumRange());
        supplierMasterDataVO.setFromTime(ElsEnterpriseInfoDTO2.getFromTime());
        supplierMasterDataVO.setType(ElsEnterpriseInfoDTO2.getType());
        supplierMasterDataVO.setBondBame(ElsEnterpriseInfoDTO2.getBondBame());
        supplierMasterDataVO.setMicroEnt(ElsEnterpriseInfoDTO2.getMicroEnt());
        supplierMasterDataVO.setUsedBondName(ElsEnterpriseInfoDTO2.getUsedBondName());
        supplierMasterDataVO.setRegNumber(ElsEnterpriseInfoDTO2.getRegNumber());
        supplierMasterDataVO.setRegCapital(ElsEnterpriseInfoDTO2.getRegCapital());
        supplierMasterDataVO.setRegInstitute(ElsEnterpriseInfoDTO2.getRegInstitute());
        supplierMasterDataVO.setRegLocation(ElsEnterpriseInfoDTO2.getRegLocation());
        supplierMasterDataVO.setIndustry(ElsEnterpriseInfoDTO2.getIndustry());
        supplierMasterDataVO.setApprovedTime(ElsEnterpriseInfoDTO2.getApprovedTime());
        supplierMasterDataVO.setUpdateTimes(ElsEnterpriseInfoDTO2.getUpdateTimes());
        supplierMasterDataVO.setSocialStaffNum(ElsEnterpriseInfoDTO2.getSocialStaffNum());
        supplierMasterDataVO.setTags(ElsEnterpriseInfoDTO2.getTags());
        supplierMasterDataVO.setTaxNumber(ElsEnterpriseInfoDTO2.getTaxNumber());
        supplierMasterDataVO.setBusinessScope(ElsEnterpriseInfoDTO2.getBusinessScope());
        supplierMasterDataVO.setProperty3(ElsEnterpriseInfoDTO2.getProperty3());
        supplierMasterDataVO.setAlias(ElsEnterpriseInfoDTO2.getAlias());
        supplierMasterDataVO.setOrgNumber(ElsEnterpriseInfoDTO2.getOrgNumber());
        supplierMasterDataVO.setRegStatus(ElsEnterpriseInfoDTO2.getRegStatus());
        supplierMasterDataVO.setEstablishTime(ElsEnterpriseInfoDTO2.getEstablishTime());
        supplierMasterDataVO.setBondType(ElsEnterpriseInfoDTO2.getBondType());
        supplierMasterDataVO.setLegalPersonName(ElsEnterpriseInfoDTO2.getLegalPersonName());
        supplierMasterDataVO.setToTime(ElsEnterpriseInfoDTO2.getToTime());
        supplierMasterDataVO.setActualCapital(ElsEnterpriseInfoDTO2.getActualCapital());
        supplierMasterDataVO.setCompanyOrgType(ElsEnterpriseInfoDTO2.getCompanyOrgType());
        supplierMasterDataVO.setBase(ElsEnterpriseInfoDTO2.getBase());
        supplierMasterDataVO.setArea(ElsEnterpriseInfoDTO2.getArea());
        supplierMasterDataVO.setCountry(ElsEnterpriseInfoDTO2.getCountry());
        supplierMasterDataVO.setCreditCode(ElsEnterpriseInfoDTO2.getCreditCode());
        supplierMasterDataVO.setHistoryNames(ElsEnterpriseInfoDTO2.getHistoryNames());
        supplierMasterDataVO.setHistoryNameList(ElsEnterpriseInfoDTO2.getHistoryNameList());
        supplierMasterDataVO.setBondNum(ElsEnterpriseInfoDTO2.getBondNum());
        supplierMasterDataVO.setRegCapitalCurrency(ElsEnterpriseInfoDTO2.getRegCapitalCurrency());
        supplierMasterDataVO.setActualCapitalCurrency(ElsEnterpriseInfoDTO2.getActualCapitalCurrency());
        supplierMasterDataVO.setEmail(ElsEnterpriseInfoDTO2.getEmail());
        supplierMasterDataVO.setWebsiteList(ElsEnterpriseInfoDTO2.getWebsiteList());
        supplierMasterDataVO.setPhoneNumber(ElsEnterpriseInfoDTO2.getPhoneNumber());
        supplierMasterDataVO.setRevokeDate(ElsEnterpriseInfoDTO2.getRevokeDate());
        supplierMasterDataVO.setRevokeReason(ElsEnterpriseInfoDTO2.getRevokeReason());
        supplierMasterDataVO.setCancelDate(ElsEnterpriseInfoDTO2.getCancelDate());
        supplierMasterDataVO.setCancelReason(ElsEnterpriseInfoDTO2.getCancelReason());
        supplierMasterDataVO.setCity(ElsEnterpriseInfoDTO2.getCity());
        supplierMasterDataVO.setDistrict(ElsEnterpriseInfoDTO2.getDistrict());
        supplierMasterDataVO.setCategory(ElsEnterpriseInfoDTO2.getCategory());
        supplierMasterDataVO.setCategoryBig(ElsEnterpriseInfoDTO2.getCategoryBig());
        supplierMasterDataVO.setCategoryMiddle(ElsEnterpriseInfoDTO2.getCategoryMiddle());
        supplierMasterDataVO.setCategorySmall(ElsEnterpriseInfoDTO2.getCategorySmall());
        supplierMasterDataVO.setRegisterDate(ElsEnterpriseInfoDTO2.getRegisterDate());
        supplierMasterDataVO.setBusinessLicense(ElsEnterpriseInfoDTO2.getBusinessLicense());
        supplierMasterDataVO.setStaging(ElsEnterpriseInfoDTO2.getStaging());
        supplierMasterDataVO.setStagingReason(ElsEnterpriseInfoDTO2.getStagingReason());
        return supplierMasterDataVO;
    }
}

