/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.partnership.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.partnership.entity.PartnershipInvitation;
import com.els.modules.partnership.enumerate.InvitationConfirmStatusEnum;
import com.els.modules.partnership.enumerate.InvitationTypeEnum;
import com.els.modules.partnership.mapper.PartnershipInvitationMapper;
import com.els.modules.partnership.service.PartnershipInvitationService;
import com.els.modules.partnership.vo.InvitationVO;
import com.els.modules.supplier.enumerate.SourceTypeEnum;
import com.els.modules.supplier.rpc.service.SupplierInvokeOtherRpcService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.RegisterVO;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PartnershipInvitationServiceImpl
extends BaseServiceImpl<PartnershipInvitationMapper, PartnershipInvitation>
implements PartnershipInvitationService {
    private static final String REMIND_MSG_FLAG = "sys:invitation:remind:";
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private SupplierInvokeOtherRpcService supplierInvokeOtherRpcService;
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;

    private boolean isExist(String elsAccount) {
        InvokeAccountRpcService invokeAccountRpcService = (InvokeAccountRpcService)SpringContextUtils.getBean(InvokeAccountRpcService.class);
        ElsEnterpriseInfoDTO enterpriseInfoDTO = invokeAccountRpcService.getByElsAccount(elsAccount);
        ElsSubAccountDTO subAccountDTO = invokeAccountRpcService.getAccount(elsAccount, "1001");
        return enterpriseInfoDTO != null && subAccountDTO != null;
    }

    @Override
    @SrmTransaction
    public void add(InvitationVO invitationVO) {
        PartnershipInvitation invitation = new PartnershipInvitation();
        invitation.setElsAccount(TenantContext.getTenant());
        invitation.setInvitingParty(SysUtil.getLoginUser().getEnterpriseName());
        invitation.setInviter(SysUtil.getCurrentBy());
        invitation.setInvitationTime(new Date());
        invitation.setToElsAccount(invitationVO.getElsAccount());
        invitation.setInvitationType(InvitationTypeEnum.CLIENT.getValue());
        invitation.setInvitingObject(invitationVO.getName());
        invitation.setConfirmStatus(InvitationConfirmStatusEnum.UN_CONFIRM.getValue());
        invitation.setSourceAccount(SysUtil.getPurchaseAccount());
        this.save((Object)invitation);
        if (this.isExist(invitationVO.getElsAccount())) {
            int count = this.supplierMasterDataService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)invitation.getToElsAccount())).eq((Object)"to_els_account", (Object)invitation.getElsAccount()));
            if (count > 0) {
                throw new ELSBootException("\u5bf9\u65b9\u5df2\u7ecf\u662f\u60a8\u7684\u5ba2\u6237\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0\uff01");
            }
        } else {
            JSONObject body = SysUtil.objectToJSON((Object)((Object)invitation));
            JSONObject result = this.supplierInvokeOtherRpcService.callPanshi("createInvitation", body);
            if (result.getIntValue("code") != 200) {
                throw new ELSBootException("\u53d1\u9001\u5408\u4f5c\u9080\u7ea6\u5f02\u5e38\uff0c\u8bf7\u552e\u540e\u518d\u8bd5\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + result.getString("message"));
            }
        }
        JSONObject data = new JSONObject();
        data.put("companyName", (Object)invitation.getInvitingParty());
        data.put("invitationType", (Object)InvitationTypeEnum.CLIENT.getDesc());
        this.sendMessage(data, invitationVO);
    }

    private void sendMessage(JSONObject data, InvitationVO invitationVO) {
        try {
            JSONObject zhuyeResult;
            JSONArray array;
            JSONArray emailArray = new JSONArray();
            JSONArray phoneArray = new JSONArray();
            JSONObject param = new JSONObject();
            param.put("elsAccount", (Object)invitationVO.getElsAccount());
            JSONObject result = this.supplierInvokeOtherRpcService.callPanshi("getContacts", param);
            if (result.getIntValue("code") == 200 && (array = (zhuyeResult = result.getJSONObject("result").getJSONObject("result")).getJSONArray("context")) != null && array.size() > 0) {
                for (Object obj : array) {
                    JSONObject object = (JSONObject)obj;
                    if (StrUtil.isNotBlank((CharSequence)object.getString("phone"))) {
                        phoneArray.add((Object)object.getString("phone"));
                    }
                    if (!StrUtil.isNotBlank((CharSequence)object.getString("email"))) continue;
                    emailArray.add((Object)object.getString("email"));
                }
            }
            if (emailArray.size() == 0 && StrUtil.isNotBlank((CharSequence)invitationVO.getEmail())) {
                emailArray.add((Object)invitationVO.getEmail());
            }
            if (phoneArray.size() == 0 && StrUtil.isNotBlank((CharSequence)invitationVO.getPhoneNumber())) {
                phoneArray.add((Object)invitationVO.getPhoneNumber());
            }
            JSONObject body = new JSONObject();
            body.put("data", (Object)data);
            body.put("emailList", (Object)emailArray);
            body.put("phoneList", (Object)phoneArray);
            this.supplierInvokeOtherRpcService.callPanshi("invitationMsgSend", body);
        }
        catch (Exception e) {
            this.log.error("sendMessage_failed:", (Throwable)e);
        }
    }

    @Override
    public void createInvitation(JSONObject param) {
        PartnershipInvitation invitation = (PartnershipInvitation)((Object)JSON.parseObject((String)JSON.toJSONString((Object)param), PartnershipInvitation.class));
        invitation.setSourceId(invitation.getId());
        invitation.setId(null);
        this.save((Object)invitation);
    }

    @Override
    public void replyInvitation(JSONObject param) {
        PartnershipInvitation invitation = (PartnershipInvitation)((Object)JSON.parseObject((String)JSON.toJSONString((Object)param), PartnershipInvitation.class));
        PartnershipInvitation update = new PartnershipInvitation();
        update.setId(invitation.getSourceId());
        update.setConfirmStatus(invitation.getConfirmStatus());
        update.setConfirmPerson(invitation.getConfirmPerson());
        update.setConfirmTime(invitation.getConfirmTime());
        this.updateById((Object)update);
    }

    @Override
    public void remind(PartnershipInvitation invitation) {
        String toElsAccount = invitation.getToElsAccount();
        if (this.redisUtil.hasKey(REMIND_MSG_FLAG + toElsAccount)) {
            throw new ELSBootException("\u4e09\u5929\u5185\u53ea\u80fd\u63d0\u9192\u4e00\u6b21\uff01");
        }
        JSONObject data = new JSONObject();
        data.put("companyName", (Object)invitation.getInvitingParty());
        data.put("invitationType", (Object)InvitationTypeEnum.CLIENT.getDesc());
        InvitationVO invitationVO = new InvitationVO();
        invitationVO.setElsAccount(invitation.getToElsAccount());
        this.sendMessage(data, invitationVO);
        this.redisUtil.set(REMIND_MSG_FLAG + toElsAccount, (Object)toElsAccount, 259200L);
    }

    @Override
    @SrmTransaction
    public String confirm(InvitationVO invitationVO) {
        JSONObject body;
        JSONObject result;
        PartnershipInvitation partnershipInvitation = (PartnershipInvitation)((Object)this.getById((Serializable)((Object)invitationVO.getId())));
        partnershipInvitation.setConfirmStatus(InvitationConfirmStatusEnum.CONFIRMED.getValue());
        partnershipInvitation.setConfirmPerson(SysUtil.getLoginUser().getSubAccount());
        partnershipInvitation.setConfirmTime(new Date());
        this.updateById((Object)partnershipInvitation);
        RegisterVO registerVO = new RegisterVO();
        BeanUtils.copyProperties((Object)invitationVO, (Object)registerVO);
        registerVO.setSourceType(SourceTypeEnum.PLATFIRM_SEARCH.getValue());
        registerVO.setPassword("123456");
        Result<?> registerResult = this.supplierMasterDataService.unfamiliarToPotential(registerVO);
        if (registerResult.getCode() != 200) {
            throw new ELSBootException(registerResult.getMessage());
        }
        if (!this.isExist(partnershipInvitation.getElsAccount()) && (result = this.supplierInvokeOtherRpcService.callPanshi("replyInvitation", body = SysUtil.objectToJSON((Object)((Object)partnershipInvitation)))).getIntValue("code") != 200) {
            throw new ELSBootException("\u64cd\u4f5c\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + result.getString("message"));
        }
        return registerResult.getMessage();
    }

    @Override
    @SrmTransaction
    public void reject(PartnershipInvitation partnershipInvitation) {
        JSONObject body;
        JSONObject result;
        partnershipInvitation.setConfirmStatus(InvitationConfirmStatusEnum.REJECTED.getValue());
        partnershipInvitation.setConfirmPerson(SysUtil.getLoginUser().getSubAccount());
        partnershipInvitation.setConfirmTime(new Date());
        this.updateById((Object)partnershipInvitation);
        if (!this.isExist(partnershipInvitation.getElsAccount()) && (result = this.supplierInvokeOtherRpcService.callPanshi("replyInvitation", body = SysUtil.objectToJSON((Object)((Object)partnershipInvitation)))).getIntValue("code") != 200) {
            throw new ELSBootException("\u64cd\u4f5c\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + result.getString("message"));
        }
    }
}

