/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.supplier.entity.SaleCertificatedInfo;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.service.SaleCertificatedInfoService;
import com.els.modules.supplier.vo.SaleCertificatedInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/saleCertificatedInfo"})
@Api(tags={"\u9500\u552e\u8ba4\u8bc1\u8d44\u6599"})
public class SaleCertificatedInfoController
extends BaseController<SaleCertificatedInfo, SaleCertificatedInfoService> {
    private static final Logger log = LoggerFactory.getLogger(SaleCertificatedInfoController.class);
    @Autowired
    private SaleCertificatedInfoService saleCertificatedInfoService;
    @Autowired
    private SupplierInvokeBaseRpcService supplierInvokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"saleCertificatedInfo#saleCertificatedInfo:list"})
    public Result<?> queryPageList(SaleCertificatedInfo saleCertificatedInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleCertificatedInfo), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleCertificatedInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u9500\u552e\u8ba4\u8bc1\u8d44\u6599", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"saleCertificatedInfo#saleCertificatedInfo:add"})
    public Result<?> add(@RequestBody SaleCertificatedInfoVO saleCertificatedInfoPage) {
        SaleCertificatedInfo saleCertificatedInfo = new SaleCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)saleCertificatedInfoPage), (Object)((Object)saleCertificatedInfo));
        this.saleCertificatedInfoService.saveMain(saleCertificatedInfo, saleCertificatedInfoPage.getSaleAttachmentList());
        return Result.ok((Object)((Object)saleCertificatedInfo));
    }

    @SrmValidated
    @AutoLog(busModule="\u9500\u552e\u8ba4\u8bc1\u8d44\u6599", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"saleCertificatedInfo#saleCertificatedInfo:edit"})
    public Result<?> edit(@RequestBody SaleCertificatedInfoVO saleCertificatedInfoPage) {
        SaleCertificatedInfo saleCertificatedInfo = new SaleCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)saleCertificatedInfoPage), (Object)((Object)saleCertificatedInfo));
        this.saleCertificatedInfoService.updateMain(saleCertificatedInfo, saleCertificatedInfoPage.getSaleAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9500\u552e\u8ba4\u8bc1\u8d44\u6599", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"saleCertificatedInfo#saleCertificatedInfo:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.saleCertificatedInfoService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u9500\u552e\u8ba4\u8bc1\u8d44\u6599", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"saleCertificatedInfo#saleCertificatedInfo:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.saleCertificatedInfoService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"saleCertificatedInfo#saleCertificatedInfo:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SaleCertificatedInfo saleCertificatedInfo = (SaleCertificatedInfo)((Object)this.saleCertificatedInfoService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleCertificatedInfoVO saleCertificatedInfoVO = new SaleCertificatedInfoVO();
        BeanUtils.copyProperties((Object)((Object)saleCertificatedInfo), (Object)((Object)saleCertificatedInfoVO));
        List<SaleAttachmentDTO> saleAttachmentList = this.supplierInvokeBaseRpcService.saleSelectByMainId(id);
        saleCertificatedInfoVO.setSaleAttachmentList(saleAttachmentList);
        return Result.ok((Object)((Object)saleCertificatedInfoVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u8ba4\u8bc1\u8d44\u6599id\u67e5\u8be2\u9644\u4ef6", notes="\u901a\u8fc7\u9500\u552e\u8ba4\u8bc1\u8d44\u6599id\u67e5\u8be2\u9644\u4ef6")
    @GetMapping(value={"/querySaleAttachmentByMainId"})
    @RequiresPermissions(value={"saleCertificatedInfo#saleCertificatedInfo:view"})
    public Result<?> querySaleAttachmentListByMainId(@RequestParam(name="id", required=true) String id) {
        List<SaleAttachmentDTO> saleAttachmentList = this.supplierInvokeBaseRpcService.saleSelectByMainId(id);
        return Result.ok(saleAttachmentList);
    }

    @SrmValidated
    @AutoLog(busModule="\u9500\u552e\u8ba4\u8bc1\u8d44\u6599", value="\u53d1\u9001")
    @ApiOperation(value="\u53d1\u9001", notes="\u53d1\u9001")
    @PostMapping(value={"/send"})
    @RequiresPermissions(value={"saleCertificatedInfo#saleCertificatedInfo:edit"})
    public Result<?> send(@RequestBody SaleCertificatedInfoVO saleCertificatedInfoPage) {
        SaleCertificatedInfo saleCertificatedInfo = new SaleCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)saleCertificatedInfoPage), (Object)((Object)saleCertificatedInfo));
        this.saleCertificatedInfoService.send(saleCertificatedInfo, saleCertificatedInfoPage.getSaleAttachmentList());
        return Result.ok();
    }

    @AutoLog(busModule="\u9500\u552e\u8ba4\u8bc1\u8d44\u6599", value="\u5931\u6548")
    @ApiOperation(value="\u5931\u6548", notes="\u5931\u6548")
    @RequiresPermissions(value={"saleCertificatedInfo#saleCertificatedInfo:invalid"})
    @GetMapping(value={"/loseEfficacy"})
    public Result<?> loseEfficacy(@RequestParam(name="id", required=true) String id) {
        this.saleCertificatedInfoService.loseEfficacy(id);
        return Result.ok();
    }
}

