/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.supplier.entity.SaleStandardHead;
import com.els.modules.supplier.entity.SaleStandardItem;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.service.SaleStandardHeadService;
import com.els.modules.supplier.service.SaleStandardItemService;
import com.els.modules.supplier.vo.SaleStandardHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/supplierStandardHead"})
@Api(tags={"\u4f9b\u5e94\u5546\u51c6\u5165\u5934"})
public class SaleStandardHeadController
extends BaseController<SaleStandardHead, SaleStandardHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleStandardHeadController.class);
    @Autowired
    private SaleStandardHeadService supplierStandardHeadService;
    @Autowired
    private SaleStandardItemService supplierStandardItemService;
    @Autowired
    private SupplierInvokeBaseRpcService supplierInvokeBaseRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"sale_standard_head#saleStandardHead:list"})
    public Result<?> queryPageList(SaleStandardHead supplierStandardHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="myToDo", defaultValue="0") Boolean myToDo, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierStandardHead), (Map)req.getParameterMap());
        if (myToDo.booleanValue()) {
            LoginUser loginUser = SysUtil.getLoginUser();
            queryWrapper.gt((Object)("INSTR(respondents_list, 'sale_" + loginUser.getSubAccount() + "_')"), (Object)0);
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.supplierStandardHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"sale_standard_head#saleStandardHead:list"})
    public Result<?> queryTabsCount(SaleStandardHead standardHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)standardHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"standard_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"standard_status");
        List list = ((SaleStandardHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleStandardHead::getStandardStatus, SaleStandardHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "standardStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmStandardStatus", TenantContext.getTenant());
        String[] statuses = new String[]{"1", "2", "3"};
        List<String> statusList = Arrays.asList(statuses);
        for (DictDTO status : srmContractStatus) {
            if (!statusList.contains(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "standardStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @SrmValidated
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"sale_standard_head#saleStandardHead:edit"})
    public Result<?> add(@RequestBody SaleStandardHeadVO supplierStandardHeadPage) {
        SaleStandardHead supplierStandardHead = new SaleStandardHead();
        BeanUtils.copyProperties((Object)((Object)supplierStandardHeadPage), (Object)((Object)supplierStandardHead));
        this.supplierStandardHeadService.saveMain(supplierStandardHead, supplierStandardHeadPage.getSupplierStandardItemList());
        return Result.ok((Object)((Object)supplierStandardHead));
    }

    @SrmValidated
    @AutoLog(busModule="\u5206\u9879\u7b54\u9898", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"sale_standard_head#saleStandardHead:edit"})
    public Result<?> edit(@RequestBody SaleStandardHeadVO supplierStandardHeadPage) {
        SaleStandardHead supplierStandardHead = new SaleStandardHead();
        BeanUtils.copyProperties((Object)((Object)supplierStandardHeadPage), (Object)((Object)supplierStandardHead));
        this.supplierStandardHeadService.updateMain(supplierStandardHead, supplierStandardHeadPage.getSupplierStandardItemList(), supplierStandardHeadPage.getSaleAttachments());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5206\u9879\u7b54\u9898", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"sale_standard_head#saleStandardHead:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.supplierStandardHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u5206\u9879\u7b54\u9898", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"sale_standard_head#saleStandardHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.supplierStandardHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"sale_standard_head#saleStandardHead:details"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SaleStandardHead supplierStandardHead = (SaleStandardHead)((Object)this.supplierStandardHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleStandardHeadVO supplierStandardHeadVO = new SaleStandardHeadVO();
        BeanUtils.copyProperties((Object)((Object)supplierStandardHead), (Object)((Object)supplierStandardHeadVO));
        List<SaleStandardItem> supplierStandardItemList = this.supplierStandardItemService.selectByMainId(id);
        supplierStandardHeadVO.setSupplierStandardItemList(supplierStandardItemList);
        List<SaleAttachmentDTO> saleAttachments = this.supplierInvokeBaseRpcService.saleSelectByMainId(id);
        supplierStandardHeadVO.setSaleAttachments(saleAttachments);
        ArrayList<PurchaseAttachmentDTO> modelList = null;
        if (supplierStandardItemList != null) {
            modelList = new ArrayList<PurchaseAttachmentDTO>();
            for (SaleStandardItem item : supplierStandardItemList) {
                List<PurchaseAttachmentDTO> attachments = this.supplierInvokeBaseRpcService.purcahseSelectByMainId(item.getStandardId());
                modelList.addAll(attachments);
            }
            supplierStandardHeadVO.setModelAttachmentList(modelList);
        }
        return Result.ok((Object)((Object)supplierStandardHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u51c6\u5165\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165\u884c", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u51c6\u5165\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165\u884c")
    @GetMapping(value={"/querysupplierStandardItemByMainId"})
    @RequiresPermissions(value={"sale_standard_head#saleStandardHead:details"})
    public Result<?> querysupplierStandardItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<SaleStandardItem> supplierStandardItemList = this.supplierStandardItemService.selectByMainId(id);
        return Result.ok(supplierStandardItemList);
    }

    @SrmValidated
    @AutoLog(busModule="\u5206\u9879\u7b54\u9898", value="\u7b54\u9898\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"sale_standard_head#saleStandardHead:edit"})
    public Result<?> submit(@RequestBody SaleStandardHeadVO saleStandardHeadVO) {
        SaleStandardHead saleStandardHead = new SaleStandardHead();
        BeanUtils.copyProperties((Object)((Object)saleStandardHeadVO), (Object)((Object)saleStandardHead));
        this.supplierStandardHeadService.submit(saleStandardHead, saleStandardHeadVO.getSupplierStandardItemList(), saleStandardHeadVO.getSaleAttachments());
        return this.commonSuccessResult(3);
    }
}

