/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.supplier.entity.SupplierAccessMgmtQuareviewHead;
import com.els.modules.supplier.entity.SupplierAccessMgmtQuareviewItem;
import com.els.modules.supplier.service.SupplierAccessMgmtQuareviewHeadService;
import com.els.modules.supplier.service.SupplierAccessMgmtQuareviewItemService;
import com.els.modules.supplier.vo.ShiftCertificationVO;
import com.els.modules.supplier.vo.SupplierAccessMgmtQuareviewHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/supplierAccessMgmtQuareview"})
@Api(tags={"\u51c6\u5165\u7ba1\u7406-\u8d44\u8d28\u5ba1\u67e5(\u5934)"})
public class SupplierAccessMgmtQuareviewHeadController
extends BaseController<SupplierAccessMgmtQuareviewHead, SupplierAccessMgmtQuareviewHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SupplierAccessMgmtQuareviewHeadController.class);
    @Autowired
    private SupplierAccessMgmtQuareviewHeadService supplierAccessMgmtQuareviewHeadService;
    @Autowired
    private SupplierAccessMgmtQuareviewItemService supplierAccessMgmtQuareviewItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:list"})
    public Result<?> queryPageList(SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessMgmtQuareviewHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.supplierAccessMgmtQuareviewHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:list"})
    public Result<?> queryTabsCount(SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessMgmtQuareviewHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.select(new String[]{"quareview_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"quareview_status");
        List list = this.supplierAccessMgmtQuareviewHeadService.list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SupplierAccessMgmtQuareviewHead::getQuareviewStatus, SupplierAccessMgmtQuareviewHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "quareviewStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmQuareviewStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "quareviewStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u4f9b\u5e94\u5546\u7aef", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u4f9b\u5e94\u5546\u7aef")
    @GetMapping(value={"/saleList"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:saleList"})
    public Result<?> saleList(SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessMgmtQuareviewHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        String[] quareviewStatus = new String[]{"1", "2", "3", "4", "5"};
        queryWrapper.in((Object)"quareview_status", (Object[])quareviewStatus);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.supplierAccessMgmtQuareviewHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2-\u4f9b\u5e94\u5546\u7aef", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2-\u4f9b\u5e94\u5546\u7aef")
    @GetMapping(value={"/saleCount"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:saleList"})
    public Result<?> saleCount(SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessMgmtQuareviewHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        String[] quareviewStatus = new String[]{"1", "2", "3", "4", "5"};
        queryWrapper.in((Object)"quareview_status", (Object[])quareviewStatus);
        queryWrapper.select(new String[]{"quareview_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"quareview_status");
        List list = this.supplierAccessMgmtQuareviewHeadService.list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SupplierAccessMgmtQuareviewHead::getQuareviewStatus, SupplierAccessMgmtQuareviewHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "quareviewStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmQuareviewStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            if ("0".equals(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "quareviewStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @SrmValidated
    @AutoLog(busModule="\u51c6\u5165\u7ba1\u7406-\u8d44\u8d28\u5ba1\u67e5(\u5934)", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:add"})
    public Result<?> add(@RequestBody SupplierAccessMgmtQuareviewHeadVO supplierAccessMgmtQuareviewHeadPage) {
        SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead = new SupplierAccessMgmtQuareviewHead();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtQuareviewHeadPage), (Object)((Object)supplierAccessMgmtQuareviewHead));
        this.supplierAccessMgmtQuareviewHeadService.saveMain(supplierAccessMgmtQuareviewHead, supplierAccessMgmtQuareviewHeadPage.getSupplierAccessMgmtQuareviewItemList());
        return Result.ok((Object)((Object)supplierAccessMgmtQuareviewHead));
    }

    @SrmValidated
    @AutoLog(busModule="\u51c6\u5165\u7ba1\u7406-\u8d44\u8d28\u5ba1\u67e5(\u5934)", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:edit"})
    public Result<?> edit(@RequestBody SupplierAccessMgmtQuareviewHeadVO supplierAccessMgmtQuareviewHeadPage) {
        SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead = new SupplierAccessMgmtQuareviewHead();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtQuareviewHeadPage), (Object)((Object)supplierAccessMgmtQuareviewHead));
        this.supplierAccessMgmtQuareviewHeadService.updateMain(supplierAccessMgmtQuareviewHead, supplierAccessMgmtQuareviewHeadPage.getSupplierAccessMgmtQuareviewItemList());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u51c6\u5165\u7ba1\u7406-\u8d44\u8d28\u5ba1\u67e5(\u5934)", value="\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:edit"})
    public Result<?> submit(@RequestBody SupplierAccessMgmtQuareviewHeadVO supplierAccessMgmtQuareviewHeadPage) {
        SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead = new SupplierAccessMgmtQuareviewHead();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtQuareviewHeadPage), (Object)((Object)supplierAccessMgmtQuareviewHead));
        this.supplierAccessMgmtQuareviewHeadService.submitMain(supplierAccessMgmtQuareviewHead, supplierAccessMgmtQuareviewHeadPage.getSupplierAccessMgmtQuareviewItemList());
        return Result.ok((Object)((Object)supplierAccessMgmtQuareviewHead));
    }

    @SrmValidated
    @AutoLog(busModule="\u51c6\u5165\u7ba1\u7406-\u8d44\u8d28\u5ba1\u67e5(\u5934)", value="\u4fee\u6539\u72b6\u6001")
    @ApiOperation(value="\u4fee\u6539\u72b6\u6001", notes="\u4fee\u6539\u72b6\u6001")
    @PostMapping(value={"/updStatus"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:reviewReject", "supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:pass"}, logical=Logical.OR)
    public Result<?> updStatus(@RequestBody SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead) {
        this.supplierAccessMgmtQuareviewHeadService.updStatus(supplierAccessMgmtQuareviewHead);
        return Result.ok((Object)((Object)supplierAccessMgmtQuareviewHead));
    }

    @AutoLog(busModule="\u51c6\u5165\u7ba1\u7406-\u8d44\u8d28\u5ba1\u67e5(\u5934)", value="\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @PostMapping(value={"/invalid"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:invalid"})
    public Result<?> invalid(@RequestBody SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead) {
        this.supplierAccessMgmtQuareviewHeadService.invalid(supplierAccessMgmtQuareviewHead);
        return Result.ok((Object)((Object)supplierAccessMgmtQuareviewHead));
    }

    @AutoLog(busModule="\u51c6\u5165\u7ba1\u7406-\u8d44\u8d28\u5ba1\u67e5(\u5934)", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.supplierAccessMgmtQuareviewHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u51c6\u5165\u7ba1\u7406-\u8d44\u8d28\u5ba1\u67e5(\u5934)", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:view"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.supplierAccessMgmtQuareviewHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:view", "saleAccessMgmtQuareviewList#saleAccessMgmtQuareview:view"}, logical=Logical.OR)
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead = (SupplierAccessMgmtQuareviewHead)((Object)this.supplierAccessMgmtQuareviewHeadService.getById((Serializable)((Object)id)));
        SupplierAccessMgmtQuareviewHeadVO supplierAccessMgmtQuareviewHeadVO = new SupplierAccessMgmtQuareviewHeadVO();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtQuareviewHead), (Object)((Object)supplierAccessMgmtQuareviewHeadVO));
        List<SupplierAccessMgmtQuareviewItem> supplierAccessMgmtQuareviewItemList = this.supplierAccessMgmtQuareviewItemService.selectByMainId(id);
        supplierAccessMgmtQuareviewHeadVO.setSupplierAccessMgmtQuareviewItemList(supplierAccessMgmtQuareviewItemList);
        return Result.ok((Object)((Object)supplierAccessMgmtQuareviewHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u51c6\u5165\u7ba1\u7406-\u8d44\u8d28\u5ba1\u67e5(\u5934)id\u67e5\u8be2\u51c6\u5165\u7ba1\u7406-\u8d44\u8d28\u5ba1\u67e5(\u884c)", notes="\u901a\u8fc7\u51c6\u5165\u7ba1\u7406-\u8d44\u8d28\u5ba1\u67e5(\u5934)id\u67e5\u8be2\u51c6\u5165\u7ba1\u7406-\u8d44\u8d28\u5ba1\u67e5(\u884c)")
    @GetMapping(value={"/querysupplierAccessMgmtQuareviewItemByMainId"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:view", "saleAccessMgmtQuareviewList#saleAccessMgmtQuareview:view"}, logical=Logical.OR)
    public Result<?> querysupplierAccessMgmtQuareviewItemListByMainId(@RequestParam(name="id") String id) {
        List<SupplierAccessMgmtQuareviewItem> supplierAccessMgmtQuareviewItemList = this.supplierAccessMgmtQuareviewItemService.selectByMainId(id);
        return Result.ok(supplierAccessMgmtQuareviewItemList);
    }

    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u81ea\u5b9a\u4e49\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/selectCustomPageList"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:list"})
    public Result<?> selectCustomPageList(SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessMgmtQuareviewHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SupplierAccessMgmtQuareviewHead> pageList = this.supplierAccessMgmtQuareviewHeadService.selectCustomPageList((Page<SupplierAccessMgmtQuareviewHead>)page, (QueryWrapper<SupplierAccessMgmtQuareviewHead>)queryWrapper);
        return Result.ok(pageList);
    }

    @SrmValidated
    @ApiOperation(value="\u8f6c\u5165\u8ba4\u8bc1\u8d44\u6599", notes="\u8f6c\u5165\u8ba4\u8bc1\u8d44\u6599")
    @PostMapping(value={"/shiftTo"})
    @RequiresPermissions(value={"supplier_access_mgmt_quareview#supplierAccessMgmtQuareview:edit"})
    public Result<?> shiftTo(@RequestBody ShiftCertificationVO shiftCertificationVO) {
        this.supplierAccessMgmtQuareviewHeadService.shiftTo(shiftCertificationVO);
        return Result.ok((Object)shiftCertificationVO);
    }
}

