/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.supplier.entity.SupplierAccessMgmtQuareviewItem;
import com.els.modules.supplier.entity.SupplierAccessMgmtStrategyHead;
import com.els.modules.supplier.entity.SupplierAccessMgmtStrategyItem;
import com.els.modules.supplier.service.SupplierAccessMgmtQuareviewItemService;
import com.els.modules.supplier.service.SupplierAccessMgmtStrategyHeadService;
import com.els.modules.supplier.service.SupplierAccessMgmtStrategyItemService;
import com.els.modules.supplier.vo.SupplierAccessMgmtStrategyHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/supplierAccessMgmtStrategyHead"})
@Api(tags={"\u4f9b\u5e94\u5546\u7ba1\u7406-\u51c6\u5165\u7b56\u7565\u7ef4\u62a4(\u5934)"})
public class SupplierAccessMgmtStrategyHeadController
extends BaseController<SupplierAccessMgmtStrategyHead, SupplierAccessMgmtStrategyHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SupplierAccessMgmtStrategyHeadController.class);
    @Autowired
    private SupplierAccessMgmtStrategyHeadService supplierAccessMgmtStrategyHeadService;
    @Autowired
    private SupplierAccessMgmtStrategyItemService supplierAccessMgmtStrategyItemService;
    @Autowired
    private SupplierAccessMgmtQuareviewItemService supplierAccessMgmtQuareviewItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"supplier_access_mgmt_strategy#supplierAccessMgmtStrategy:list"})
    public Result<?> queryPageList(SupplierAccessMgmtStrategyHead supplierAccessMgmtStrategyHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessMgmtStrategyHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.supplierAccessMgmtStrategyHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"supplier_access_mgmt_strategy#supplierAccessMgmtStrategy:list"})
    public Result<?> queryTabsCount(SupplierAccessMgmtStrategyHead supplierAccessMgmtStrategyHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessMgmtStrategyHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.select(new String[]{"policy_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"policy_status");
        List list = this.supplierAccessMgmtStrategyHeadService.list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SupplierAccessMgmtStrategyHead::getPolicyStatus, SupplierAccessMgmtStrategyHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "policyStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmAccessMgmtPolicyStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "policyStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @SrmValidated
    @AutoLog(busModule="\u4f9b\u5e94\u5546\u7ba1\u7406-\u51c6\u5165\u7b56\u7565\u7ef4\u62a4(\u5934)", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"supplier_access_mgmt_strategy#supplierAccessMgmtStrategy:add"})
    public Result<?> add(@RequestBody SupplierAccessMgmtStrategyHeadVO supplierAccessMgmtStrategyHeadPage) {
        SupplierAccessMgmtStrategyHead supplierAccessMgmtStrategyHead = new SupplierAccessMgmtStrategyHead();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtStrategyHeadPage), (Object)((Object)supplierAccessMgmtStrategyHead));
        this.supplierAccessMgmtStrategyHeadService.saveMain(supplierAccessMgmtStrategyHead, supplierAccessMgmtStrategyHeadPage.getSupplierAccessMgmtStrategyItemList());
        return Result.ok((Object)((Object)supplierAccessMgmtStrategyHead));
    }

    @SrmValidated
    @AutoLog(busModule="\u4f9b\u5e94\u5546\u7ba1\u7406-\u51c6\u5165\u7b56\u7565\u7ef4\u62a4(\u5934)", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"supplier_access_mgmt_strategy#supplierAccessMgmtStrategy:edit"})
    public Result<?> edit(@RequestBody SupplierAccessMgmtStrategyHeadVO supplierAccessMgmtStrategyHeadPage) {
        SupplierAccessMgmtStrategyHead supplierAccessMgmtStrategyHead = new SupplierAccessMgmtStrategyHead();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtStrategyHeadPage), (Object)((Object)supplierAccessMgmtStrategyHead));
        this.supplierAccessMgmtStrategyHeadService.updateMain(supplierAccessMgmtStrategyHead, supplierAccessMgmtStrategyHeadPage.getSupplierAccessMgmtStrategyItemList());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u4f9b\u5e94\u5546\u7ba1\u7406-\u51c6\u5165\u7b56\u7565\u7ef4\u62a4(\u5934)", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"supplier_access_mgmt_strategy#supplierAccessMgmtStrategy:publish"})
    public Result<?> publish(@RequestBody SupplierAccessMgmtStrategyHeadVO supplierAccessMgmtStrategyHeadPage) {
        SupplierAccessMgmtStrategyHead supplierAccessMgmtStrategyHead = new SupplierAccessMgmtStrategyHead();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtStrategyHeadPage), (Object)((Object)supplierAccessMgmtStrategyHead));
        this.supplierAccessMgmtStrategyHeadService.publishMain(supplierAccessMgmtStrategyHead, supplierAccessMgmtStrategyHeadPage.getSupplierAccessMgmtStrategyItemList());
        return Result.ok((Object)((Object)supplierAccessMgmtStrategyHead));
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u7ba1\u7406-\u51c6\u5165\u7b56\u7565\u7ef4\u62a4(\u5934)", value="\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/invalid"})
    @RequiresPermissions(value={"supplier_access_mgmt_strategy#supplierAccessMgmtStrategy:invalid"})
    public Result<?> invalid(@RequestParam(name="id") String id) {
        this.supplierAccessMgmtStrategyHeadService.invalidById(id);
        return this.commonSuccessResult(7);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u7ba1\u7406-\u51c6\u5165\u7b56\u7565\u7ef4\u62a4(\u5934)", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"supplier_access_mgmt_strategy#supplierAccessMgmtStrategy:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.supplierAccessMgmtStrategyHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u7ba1\u7406-\u51c6\u5165\u7b56\u7565\u7ef4\u62a4(\u5934)", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"supplier_access_mgmt_strategy#supplierAccessMgmtStrategy:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.supplierAccessMgmtStrategyHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"supplier_access_mgmt_strategy#supplierAccessMgmtStrategy:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SupplierAccessMgmtStrategyHead supplierAccessMgmtStrategyHead = (SupplierAccessMgmtStrategyHead)((Object)this.supplierAccessMgmtStrategyHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SupplierAccessMgmtStrategyHeadVO supplierAccessMgmtStrategyHeadVO = new SupplierAccessMgmtStrategyHeadVO();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtStrategyHead), (Object)((Object)supplierAccessMgmtStrategyHeadVO));
        List<SupplierAccessMgmtStrategyItem> supplierAccessMgmtStrategyItemList = this.supplierAccessMgmtStrategyItemService.selectByMainId(id);
        supplierAccessMgmtStrategyHeadVO.setSupplierAccessMgmtStrategyItemList(supplierAccessMgmtStrategyItemList);
        return Result.ok((Object)((Object)supplierAccessMgmtStrategyHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u7ba1\u7406-\u51c6\u5165\u7b56\u7565\u7ef4\u62a4(\u5934)id\u67e5\u8be2\u4f9b\u5e94\u5546\u7ba1\u7406-\u51c6\u5165\u7b56\u7565\u7ef4\u62a4(\u884c)", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u7ba1\u7406-\u51c6\u5165\u7b56\u7565\u7ef4\u62a4(\u5934)id\u67e5\u8be2\u4f9b\u5e94\u5546\u7ba1\u7406-\u51c6\u5165\u7b56\u7565\u7ef4\u62a4(\u884c)")
    @GetMapping(value={"/querySupplierAccessMgmtStrategyItemByMainId"})
    @RequiresPermissions(value={"supplier_access_mgmt_strategy#supplierAccessMgmtStrategy:view"})
    public Result<?> querySupplierAccessMgmtStrategyItemListByMainId(@RequestParam(name="id") String id) {
        List<SupplierAccessMgmtStrategyItem> supplierAccessMgmtStrategyItemList = this.supplierAccessMgmtStrategyItemService.selectByMainId(id);
        return Result.ok(supplierAccessMgmtStrategyItemList);
    }

    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u81ea\u5b9a\u4e49\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/selectCustomPageList"})
    @RequiresPermissions(value={"supplier_access_mgmt_strategy#supplierAccessMgmtStrategy:list"})
    public Result<?> selectCustomPageList(SupplierAccessMgmtStrategyHead supplierAccessMgmtStrategyHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String purchaseOrg = supplierAccessMgmtStrategyHead.getPurchaseOrg();
        String toElsAccount = supplierAccessMgmtStrategyHead.getToElsAccount();
        supplierAccessMgmtStrategyHead.setPurchaseOrg(null);
        supplierAccessMgmtStrategyHead.setToElsAccount(null);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessMgmtStrategyHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SupplierAccessMgmtStrategyHead> pageList = this.supplierAccessMgmtStrategyHeadService.selectCustomPageList((Page<SupplierAccessMgmtStrategyHead>)page, (QueryWrapper<SupplierAccessMgmtStrategyHead>)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)pageList.getRecords())) {
            List records = pageList.getRecords();
            if (StringUtils.isNotBlank((CharSequence)toElsAccount) && StringUtils.isNotBlank((CharSequence)purchaseOrg)) {
                records.forEach(o -> {
                    List<SupplierAccessMgmtQuareviewItem> quareviewItemList = this.supplierAccessMgmtQuareviewItemService.selectByPolicyNumber(toElsAccount, purchaseOrg, o.getPolicyNumber());
                    if (CollUtil.isNotEmpty(quareviewItemList)) {
                        ArrayList supplierAccessMgmtStrategyItems = SysUtil.copyProperties(quareviewItemList, SupplierAccessMgmtStrategyItem.class);
                        supplierAccessMgmtStrategyItems.forEach(t -> t.setAccessLink("0"));
                        List<SupplierAccessMgmtStrategyItem> itemList = o.getItemList();
                        List<Object> collect = new ArrayList();
                        if (CollUtil.isNotEmpty(itemList)) {
                            collect = itemList.stream().filter(i -> !"0".equals(i.getAccessLink())).collect(Collectors.toList());
                        }
                        supplierAccessMgmtStrategyItems.addAll(collect);
                        o.setItemList(supplierAccessMgmtStrategyItems);
                    }
                });
            }
            pageList.setRecords(records);
        }
        return Result.ok(pageList);
    }
}

