/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.excel;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.common.util.PwVerifyUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsPwComplexityAndMinLenDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.enumerate.SourceTypeEnum;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.util.PanguSupplierMasterCheckUtils;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="supplierMasterDataExcelHandler")
public class SupplierMasterDataExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Pattern CHINA_PHONE = Pattern.compile("^((13[0-9])|(14[0,1,4-9])|(15[0-3,5-9])|(16[2,5,6,7])|(17[0-8])|(18[0-9])|(19[0-3,5-9]))\\d{8}$");
    @Resource
    private InvokeBaseRpcService templateHeadService;
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService supplierinvokeEnterpriseRpcService;
    @Lazy
    @Resource
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;
    @Lazy
    @Resource
    private PanguSupplierMasterCheckUtils panguSupplierMasterCheckUtils;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        Assert.notEmpty((Collection)dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        List templateList = this.templateHeadService.getDefaultTemplateByType("supplierMasterData");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERWRdXdWFWESWCLWIrW_969a25c1", (String)"\u8bf7\u5148\u914d\u7f6e\u3010\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u3011\u4e1a\u52a1\u3010\u9ed8\u8ba4\u3011\u6a21\u677f\u3002"));
        ElsEnterpriseInfoDTO pEnterpriseInfo = this.supplierinvokeEnterpriseRpcService.getByElsAccount(TenantContext.getTenant());
        SupplierMasterData supplierMasterData = this.supplierMasterDataService.buildDefaultValue(((TemplateHeadDTO)templateList.get(0)).getElsAccount(), ((TemplateHeadDTO)templateList.get(0)).getTemplateNumber(), ((TemplateHeadDTO)templateList.get(0)).getTemplateVersion() + "");
        Map mapDefault = (Map)JSON.parseObject((String)JSON.toJSONString((Object)((Object)supplierMasterData)), Map.class);
        String deployWay = SysUtil.getDeployWay();
        String els_account = "cloud".equals(deployWay) ? "100000" : SysUtil.getPurchaseAccount();
        ElsPwComplexityAndMinLenDTO complexityAndMinLen = this.supplierInvokeAccountRpcService.getComplexityAndMinLen(els_account);
        String complexity = "";
        int minLength = 0;
        if (complexityAndMinLen != null) {
            complexity = complexityAndMinLen.getComplexity();
            minLength = complexityAndMinLen.getMinLength();
        }
        List<String> supplierNameList = this.supplierMasterDataService.geSupplierNameListByElsAccount(TenantContext.getTenant());
        ArrayList supplierName = new ArrayList();
        ArrayList<SupplierMasterData> entityList = new ArrayList<SupplierMasterData>();
        for (Map data : dataList) {
            String msg;
            if (supplierName.contains((String)data.get("supplierName"))) {
                msg = I18nUtil.translate((String)"i18n_alert_uNWFsjVBjRdXRL_eabd138f", (String)"\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u91cd\u590d\u7684\u4f9b\u5e94\u5546\u540d\u79f0");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (CollUtil.isNotEmpty(supplierNameList) && supplierNameList.contains((String)data.get("supplierName"))) {
                msg = I18nUtil.translate((String)"i18n_alert_rRdXIOMKRdXdWF_478e4141", (String)"\u8be5\u4f9b\u5e94\u5546\u5df2\u7ecf\u5b58\u5728\u4f9b\u5e94\u5546\u4e3b\u6570\u636e");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (data.containsKey("personPhone") && StringUtils.isNotBlank((CharSequence)((String)data.get("personPhone"))) && !CHINA_PHONE.matcher((String)data.get("personPhone")).matches()) {
                msg = I18nUtil.translate((String)"i18n_alert_ltyomKNS_53ca8482", (String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (data.containsKey("personEmail") && StringUtils.isNotBlank((CharSequence)((String)data.get("personEmail"))) && !SupplierMasterDataExcelHandler.checkEmaile((String)data.get("personEmail"))) {
                msg = I18nUtil.translate((String)"i18n_alert_jdmKNS_e2a736cc", (String)"\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (!data.containsKey("personPassword") || StringUtils.isBlank((CharSequence)((String)data.get("personPassword")))) {
                msg = I18nUtil.translate((String)"i18n_alert_RvjwoxOLV_adecb9be", (String)"\u7ba1\u7406\u5458\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            String complexityVerifyStr = PwVerifyUtil.pwComplexityVerifyStr((String)complexity, (int)minLength, (String)((String)data.get("personPassword")));
            if (StringUtils.isNotBlank((CharSequence)complexityVerifyStr)) {
                this.errorAdd(excelImportDTO, complexityVerifyStr, data);
                continue;
            }
            SupplierMasterData entity = (SupplierMasterData)((Object)this.transferEntity(data = this.buildDefaultValue(mapDefault, data), SupplierMasterData.class, excelImportDTO));
            if (null == entity) continue;
            entity.setElsAccount(TenantContext.getTenant());
            entity.setBusAccount(TenantContext.getTenant());
            if (pEnterpriseInfo != null) {
                entity.setPurchaseName(pEnterpriseInfo.getName());
            }
            if (StringUtils.isBlank((CharSequence)entity.getSourceType())) {
                entity.setSourceType(SourceTypeEnum.BATCH_IMPORT.getValue());
            }
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion() + "");
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entityList.add(entity);
        }
        this.panguSupplierMasterCheckUtils.checkSupplierMasterParam(SysUtil.getLoginUser().getElsAccount(), entityList.size());
        this.supplierMasterDataService.saveImportData(entityList);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }

    public static boolean checkEmaile(String emaile) {
        String RULE_EMAIL = "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
        Pattern p = Pattern.compile(RULE_EMAIL);
        Matcher m = p.matcher(emaile);
        return m.matches();
    }

    public Map buildDefaultValue(Map<String, Object> mapDefault, Map<String, Object> data) {
        if (mapDefault == null) {
            return data;
        }
        for (String key : mapDefault.keySet()) {
            if (data.containsKey(key)) {
                Object obj = data.get(key);
                if (obj != null && !((String)obj).trim().equals("")) continue;
                data.put(key, mapDefault.get(key));
                continue;
            }
            data.put(key, mapDefault.get(key));
        }
        return data;
    }
}

