/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.job;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.supplier.service.SupplierAccessMgmtQuareviewHeadService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CertificatedInfoJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(CertificatedInfoJob.class);
    private final String LOCK_PREFIX = "certificatedInfo_schedule_certificatedInfoJob";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SupplierAccessMgmtQuareviewHeadService supplierAccessMgmtQuareviewHeadService;

    public void execute(String parameter) {
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String tenantId = paramObj.getString("tenantId");
        if (StrUtil.isBlank((CharSequence)tenantId)) {
            tenantId = "100000";
        }
        TenantContext.setTenant((String)tenantId);
        String requestId = TenantContext.getTenant();
        if (!this.redisUtil.tryGetDistributedLock("certificatedInfo_schedule_certificatedInfoJob", requestId, 50000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdXLiJLRvIKLSiKRcWVxPVBRc_5c1c55b4", (String)"\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        try {
            log.info(":::\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599\u7ba1\u7406CertificatedInfoJob start");
            JSONObject object = JSONObject.parseObject((String)parameter);
            String elsAccount = StringUtils.isBlank((CharSequence)object.getString("elsAccount")) ? "100000" : object.getString("elsAccount");
            TenantContext.setTenant((String)elsAccount);
            LoginUser user = SysUtil.getLoginUser();
            if (user != null && StringUtils.isBlank((CharSequence)user.getElsAccount())) {
                LoginUser loginUser = new LoginUser();
                loginUser.setElsAccount(elsAccount);
                loginUser.setSubAccount("1001");
                LoginUserContext.setUser((LoginUser)loginUser);
            } else {
                LoginUser loginUser = new LoginUser();
                loginUser.setElsAccount(elsAccount);
                loginUser.setSubAccount("1001");
                LoginUserContext.setUser((LoginUser)loginUser);
            }
            this.supplierAccessMgmtQuareviewHeadService.updateCertificatedInfoStatusInJob();
            log.info(":::\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599\u7ba1\u7406CertificatedInfoJob end");
            LoginUserContext.clear();
        }
        catch (Exception e) {
            log.info(Thread.currentThread().getName() + "\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock("certificatedInfo_schedule_certificatedInfoJob", requestId);
            LoginUserContext.clear();
        }
    }
}

