/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.api.dto.BaseDTO;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.ElsBusinessTransferHisDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.myschedule.entity.MySchedule;
import com.els.modules.myschedule.mapper.MyScheduleMapper;
import com.els.modules.myschedule.service.MyScheduleService;
import com.els.modules.supplier.entity.PurchaseVisitHead;
import com.els.modules.supplier.entity.PurchaseVisitItem;
import com.els.modules.supplier.entity.SaleVisitHead;
import com.els.modules.supplier.entity.SaleVisitItem;
import com.els.modules.supplier.enumerate.VisitStatusEnum;
import com.els.modules.supplier.mapper.PurchaseVisitHeadMapper;
import com.els.modules.supplier.mapper.PurchaseVisitItemMapper;
import com.els.modules.supplier.mapper.SaleVisitHeadMapper;
import com.els.modules.supplier.service.SaleVisitHeadService;
import com.els.modules.supplier.service.SaleVisitItemService;
import com.els.modules.supplier.vo.SaleVisitHeadTransferVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SaleVisitHeadServiceImpl
extends BaseServiceImpl<SaleVisitHeadMapper, SaleVisitHead>
implements SaleVisitHeadService {
    @Autowired
    private SaleVisitItemService saleVisitItemService;
    @Autowired
    private PurchaseVisitHeadMapper purchaseVisitHeadMapper;
    @Autowired
    private PurchaseVisitItemMapper purchaseVisitItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private MyScheduleService myScheduleService;
    @Resource
    private MyScheduleMapper myScheduleMapper;
    private final SimpleDateFormat DATA_FORMART = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleVisitHead saleVisitHead, List<SaleVisitItem> saleVisitItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        saleVisitHead.setVisitStatus(VisitStatusEnum.NEW.getValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        saleVisitHead.setBusAccount(saleVisitHead.getToElsAccount());
        saleVisitHead.setVisitAccount(loginUser.getElsAccount());
        saleVisitHead.setVisitSupplierName(loginUser.getEnterpriseName());
        if (StringUtils.isBlank((CharSequence)saleVisitHead.getVisitNumber())) {
            saleVisitHead.setVisitNumber(this.invokeBaseRpcService.getNextCode("purchaseBookVisitNumber", (Object)saleVisitHead, saleVisitHead.getBusAccount()));
        }
        ((SaleVisitHeadMapper)this.baseMapper).insert((Object)saleVisitHead);
        super.setHeadDefaultValue((BaseEntity)saleVisitHead);
        this.insertData(saleVisitHead, saleVisitItemList, saleAttachmentList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleVisitHead saleVisitHead, List<SaleVisitItem> saleVisitItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        int count = ((SaleVisitHeadMapper)this.baseMapper).updateById((Object)saleVisitHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.saleVisitItemService.deleteByMainId(saleVisitHead.getId());
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleVisitHead.getId());
        this.insertData(saleVisitHead, saleVisitItemList, saleAttachmentList);
    }

    private void insertData(SaleVisitHead saleVisitHead, List<SaleVisitItem> saleVisitItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        if (!CollectionUtils.isEmpty(saleVisitItemList)) {
            for (SaleVisitItem saleVisitItem : saleVisitItemList) {
                saleVisitItem.setHeadId(saleVisitHead.getId());
                saleVisitItem.setVisitNumber(saleVisitHead.getVisitNumber());
                saleVisitItem.setToElsAccount(saleVisitHead.getToElsAccount());
                SysUtil.setSysParam((BaseEntity)saleVisitItem, (BaseEntity)saleVisitHead);
            }
            this.saleVisitItemService.saveBatch(saleVisitItemList, 2000);
        }
        if (CollectionUtil.isNotEmpty(saleAttachmentList)) {
            for (SaleAttachmentDTO saleAttachmentDTO : saleAttachmentList) {
                saleAttachmentDTO.setId(null);
                saleAttachmentDTO.setHeadId(saleVisitHead.getId());
                SysUtil.setSysParam((BaseDTO)saleAttachmentDTO, (BaseEntity)saleVisitHead);
                saleAttachmentDTO.setBusinessType("saleBookVisit");
                saleAttachmentDTO.setSendStatus("0");
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.saleVisitItemService.deleteByMainId(id);
        ((SaleVisitHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleVisitItemService.deleteByMainId(serializable.toString());
            ((SaleVisitHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(SaleVisitHead saleVisitHead, List<SaleVisitItem> saleVisitItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        int count = this.myScheduleMapper.selectWithoutElsAccountConflict(saleVisitHead.getToElsAccount(), saleVisitHead.getIntervieweePrincipal(), saleVisitHead.getVisitStartTime(), saleVisitHead.getVisitEndTime());
        Assert.isTrue((count == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APUZmCKIIjBLpAVVVHVUZmCKI_dad8d2b2", (String)"\u5f53\u524d\u9884\u7ea6\u62dc\u8bbf\u65f6\u95f4\u5df2\u6709\u65e5\u7a0b\u5b89\u6392\uff0c\u8bf7\u91cd\u65b0\u66f4\u65b0\u9884\u7ea6\u62dc\u8bbf\u65f6\u95f4\u3002"));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.eq(MySchedule::getSubAccount, (Object)saleVisitHead.getVisitPrincipal());
        queryWrapper.lt(MySchedule::getBeginTime, (Object)saleVisitHead.getVisitEndTime());
        queryWrapper.gt(MySchedule::getEndTime, (Object)saleVisitHead.getVisitStartTime());
        Assert.isTrue((this.myScheduleService.count((Wrapper)queryWrapper) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APIIjBLjVPsMKm_5dbd60fd", (String)"\u5f53\u524d\u5b9a\u4e49\u7684\u65e5\u7a0b\u6709\u51b2\u7a81\uff0c\u4fdd\u5b58\u5931\u8d25\uff01"));
        if (StringUtils.isBlank((CharSequence)saleVisitHead.getId())) {
            this.saveMain(saleVisitHead, saleVisitItemList, saleAttachmentList);
        } else {
            this.updateMain(saleVisitHead, saleVisitItemList, saleAttachmentList);
        }
        saleVisitHead.setSendTime(new Date());
        if ("1".equals(saleVisitHead.getTeamwork())) {
            saleVisitHead.setVisitStatus(VisitStatusEnum.WAIT_CONFIRM.getValue());
        } else {
            saleVisitHead.setVisitStatus(VisitStatusEnum.WAIT_VISIT.getValue());
        }
        PurchaseVisitHead purchaseVisitHead = (PurchaseVisitHead)((Object)SysUtil.copyProperties((Object)((Object)saleVisitHead), PurchaseVisitHead.class));
        purchaseVisitHead.setId(null);
        purchaseVisitHead.setRelationId(saleVisitHead.getId());
        purchaseVisitHead.setVisitNumber(saleVisitHead.getVisitNumber());
        purchaseVisitHead.setElsAccount(saleVisitHead.getToElsAccount());
        if (StringUtils.isNotBlank((CharSequence)saleVisitHead.getRelationId())) {
            PurchaseVisitHead oldPurchaseVisitHead = (PurchaseVisitHead)((Object)this.purchaseVisitHeadMapper.selectById((Serializable)((Object)saleVisitHead.getRelationId())));
            if (oldPurchaseVisitHead != null) {
                purchaseVisitHead.setId(oldPurchaseVisitHead.getId());
                purchaseVisitHead.setDataVersion(oldPurchaseVisitHead.getDataVersion());
                this.purchaseVisitHeadMapper.updateById((Object)purchaseVisitHead);
                this.purchaseVisitItemMapper.deleteByMainId(purchaseVisitHead.getId());
                this.inserPurchaseVistItem(purchaseVisitHead, saleVisitItemList);
                this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseVisitHead.getId());
                this.insertPurchaseAttachment(purchaseVisitHead, saleAttachmentList);
            } else {
                this.purchaseVisitHeadMapper.insert((Object)purchaseVisitHead);
                this.inserPurchaseVistItem(purchaseVisitHead, saleVisitItemList);
                this.insertPurchaseAttachment(purchaseVisitHead, saleAttachmentList);
            }
        } else {
            this.purchaseVisitHeadMapper.insert((Object)purchaseVisitHead);
            this.inserPurchaseVistItem(purchaseVisitHead, saleVisitItemList);
            this.insertPurchaseAttachment(purchaseVisitHead, saleAttachmentList);
        }
        saleVisitHead.setRelationId(purchaseVisitHead.getId());
        this.updateById((Object)saleVisitHead);
        this.sendAppointMsg(saleVisitHead, saleVisitHead.getToElsAccount(), saleVisitHead.getIntervieweePrincipal(), "publish");
    }

    public void inserPurchaseVistItem(PurchaseVisitHead visitHead, List<SaleVisitItem> saleVisitItemList) {
        ArrayList<PurchaseVisitItem> purchaseVisitItemList = new ArrayList<PurchaseVisitItem>();
        for (SaleVisitItem saleVisitItem : saleVisitItemList) {
            PurchaseVisitItem purchaseVisitItem = (PurchaseVisitItem)((Object)SysUtil.copyProperties((Object)((Object)saleVisitItem), PurchaseVisitItem.class));
            purchaseVisitItem.setId(null);
            purchaseVisitItem.setHeadId(visitHead.getId());
            purchaseVisitItem.setVisitNumber(visitHead.getVisitNumber());
            purchaseVisitItem.setItemNumber(saleVisitItem.getItemNumber());
            purchaseVisitItem.setElsAccount(saleVisitItem.getToElsAccount());
            purchaseVisitItem.setToElsAccount(saleVisitItem.getElsAccount());
            purchaseVisitItemList.add(purchaseVisitItem);
        }
        if (!purchaseVisitItemList.isEmpty()) {
            this.purchaseVisitItemMapper.insertBatchSomeColumn(purchaseVisitItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void confirmedMain(String id) {
        SaleVisitHead saleVisitHead = (SaleVisitHead)((Object)this.getById((Serializable)((Object)id)));
        String status = VisitStatusEnum.WAIT_VISIT.getValue();
        saleVisitHead.setVisitStatus(status);
        this.updateById((Object)saleVisitHead);
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        purchaseVisitHead.setId(saleVisitHead.getRelationId());
        purchaseVisitHead.setVisitStatus(status);
        this.purchaseVisitHeadMapper.updateById((Object)purchaseVisitHead);
        this.saveMyScheduleInfo(saleVisitHead, "visit");
        this.saveMyScheduleInfo(saleVisitHead, "interviewee");
        this.sendAppointMsg(saleVisitHead, saleVisitHead.getVisitAccount(), saleVisitHead.getVisitPrincipal(), "confirm");
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void rejectedMain(String id, String rejectReason) {
        SaleVisitHead saleVisitHead = (SaleVisitHead)((Object)this.getById((Serializable)((Object)id)));
        String status = VisitStatusEnum.REJECTED.getValue();
        saleVisitHead.setVisitStatus(status);
        if (StrUtil.isNotBlank((CharSequence)rejectReason)) {
            saleVisitHead.setRejectReason(rejectReason);
        }
        this.updateById((Object)saleVisitHead);
        PurchaseVisitHead purchaseVisitHead = (PurchaseVisitHead)((Object)this.purchaseVisitHeadMapper.selectById((Serializable)((Object)saleVisitHead.getRelationId())));
        purchaseVisitHead.setId(saleVisitHead.getRelationId());
        purchaseVisitHead.setVisitStatus(status);
        if (StrUtil.isNotBlank((CharSequence)rejectReason)) {
            purchaseVisitHead.setRejectReason(rejectReason);
        }
        if ("0".equals(purchaseVisitHead.getAudit())) {
            purchaseVisitHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseVisitHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        this.purchaseVisitHeadMapper.updateById((Object)purchaseVisitHead);
        this.sendAppointMsg(saleVisitHead, saleVisitHead.getVisitAccount(), saleVisitHead.getVisitPrincipal(), "refund");
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void invalid(SaleVisitHead saleVisitHead) {
        SaleVisitHead visitHead = new SaleVisitHead();
        visitHead.setId(saleVisitHead.getId());
        visitHead.setVisitStatus(VisitStatusEnum.INVALID.getValue());
        this.updateById((Object)visitHead);
        if (StringUtils.isNotBlank((CharSequence)saleVisitHead.getRelationId())) {
            PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
            purchaseVisitHead.setId(saleVisitHead.getRelationId());
            purchaseVisitHead.setVisitStatus(VisitStatusEnum.INVALID.getValue());
            this.purchaseVisitHeadMapper.updateById((Object)purchaseVisitHead);
        }
    }

    @Override
    public void copyMain(String id) {
        List saleAttachmentList;
        SaleVisitHead saleVisitHead = (SaleVisitHead)((Object)this.getById((Serializable)((Object)id)));
        saleVisitHead.setId(null);
        saleVisitHead.setRelationId(null);
        saleVisitHead.setElsAccount(TenantContext.getTenant());
        saleVisitHead.setVisitStatus(null);
        saleVisitHead.setVisitNumber(null);
        saleVisitHead.setSendTime(null);
        saleVisitHead.setFlowId(null);
        saleVisitHead.setCreateBy(null);
        saleVisitHead.setCreateTime(null);
        saleVisitHead.setUpdateBy(null);
        saleVisitHead.setUpdateTime(null);
        List<SaleVisitItem> saleVisitItemList = this.saleVisitItemService.selectByMainId(id);
        if (CollUtil.isNotEmpty(saleVisitItemList)) {
            saleVisitItemList.forEach(item -> {
                item.setHeadId(null);
                item.setCreateBy(null);
                item.setCreateTime(null);
                item.setUpdateBy(null);
                item.setUpdateTime(null);
            });
        }
        if (CollUtil.isNotEmpty((Collection)(saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id)))) {
            saleAttachmentList.forEach(item -> {
                item.setHeadId(null);
                item.setRelationId(null);
                item.setCreateBy(null);
                item.setCreateTime(null);
                item.setUpdateBy(null);
                item.setUpdateTime(null);
            });
        }
        this.saveMain(saleVisitHead, saleVisitItemList, saleAttachmentList);
    }

    @Override
    public void transfer(SaleVisitHeadTransferVO saleVisitHeadTransferVO) {
        SaleVisitHead saleVisitHead = new SaleVisitHead();
        BeanUtils.copyProperties((Object)((Object)saleVisitHeadTransferVO), (Object)((Object)saleVisitHead));
        boolean b = this.updateById((Object)saleVisitHead);
        Assert.isTrue((boolean)b, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        PurchaseVisitHead purchaseVisitHead = (PurchaseVisitHead)((Object)this.purchaseVisitHeadMapper.selectById((Serializable)((Object)saleVisitHead.getRelationId())));
        purchaseVisitHead.setIntervieweePrincipal(saleVisitHead.getIntervieweePrincipal());
        purchaseVisitHead.setIntervieweePhone(saleVisitHead.getIntervieweePhone());
        purchaseVisitHead.setIntervieweePrincipalName(saleVisitHead.getIntervieweePrincipalName());
        int i = this.purchaseVisitHeadMapper.updateById((Object)purchaseVisitHead);
        LoginUser loginUser = SysUtil.getLoginUser();
        ElsBusinessTransferHisDTO elsBusinessTransferHis = saleVisitHeadTransferVO.getElsBusinessTransferHis();
        elsBusinessTransferHis.setTransferBy(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        elsBusinessTransferHis.setTransferTime(new Date());
        this.invokeBaseRpcService.add(saleVisitHeadTransferVO.getElsBusinessTransferHis());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MySchedule::getSourceNumber, (Object)saleVisitHead.getVisitNumber());
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)saleVisitHead.getToElsAccount());
        MySchedule oldSchedule = (MySchedule)((Object)this.myScheduleService.getOne((Wrapper)queryWrapper));
        if (oldSchedule != null) {
            this.myScheduleService.delete(oldSchedule.getId());
        }
        this.saveMyScheduleInfo(saleVisitHead, "interviewee");
        this.sendAppointMsg(saleVisitHead, saleVisitHead.getVisitAccount(), saleVisitHead.getVisitPrincipal(), "transfer");
        this.sendAppointMsg(saleVisitHead, saleVisitHead.getToElsAccount(), saleVisitHead.getIntervieweePrincipal(), "transfer");
    }

    @Override
    public void summary(SaleVisitHead saleVisitHead, List<SaleAttachmentDTO> saleAttachmentList) {
        if ("1".equals(saleVisitHead.getTeamwork())) {
            saleVisitHead.setVisitStatus(VisitStatusEnum.WAIT_EVALUATION.getValue());
        } else {
            saleVisitHead.setVisitStatus(VisitStatusEnum.COMPLETED.getValue());
        }
        this.updateById((Object)saleVisitHead);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleVisitHead.getId());
        this.insertAttachmentData(saleVisitHead, saleAttachmentList);
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        purchaseVisitHead.setId(saleVisitHead.getRelationId());
        purchaseVisitHead.setVisitStatus(saleVisitHead.getVisitStatus());
        purchaseVisitHead.setVisitSummary(saleVisitHead.getVisitSummary());
        this.purchaseVisitHeadMapper.updateById((Object)purchaseVisitHead);
        purchaseVisitHead = (PurchaseVisitHead)((Object)this.purchaseVisitHeadMapper.selectById((Serializable)((Object)saleVisitHead.getRelationId())));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(saleVisitHead.getRelationId());
        this.insertPurchaseAttachment(purchaseVisitHead, saleAttachmentList);
    }

    @Override
    public void evaluation(SaleVisitHead saleVisitHead, List<SaleAttachmentDTO> saleAttachmentList) {
        saleVisitHead.setVisitStatus(VisitStatusEnum.COMPLETED.getValue());
        this.updateById((Object)saleVisitHead);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleVisitHead.getId());
        this.insertAttachmentData(saleVisitHead, saleAttachmentList);
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        purchaseVisitHead.setId(saleVisitHead.getRelationId());
        purchaseVisitHead.setVisitStatus(saleVisitHead.getVisitStatus());
        purchaseVisitHead.setVisitEvaluation(saleVisitHead.getVisitEvaluation());
        this.purchaseVisitHeadMapper.updateById((Object)purchaseVisitHead);
        purchaseVisitHead = (PurchaseVisitHead)((Object)this.purchaseVisitHeadMapper.selectById((Serializable)((Object)saleVisitHead.getRelationId())));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(saleVisitHead.getRelationId());
        this.insertPurchaseAttachment(purchaseVisitHead, saleAttachmentList);
    }

    public void saveMyScheduleInfo(SaleVisitHead saleVisitHead, String visitType) {
        MySchedule mySchedule = new MySchedule();
        if ("visit".equals(visitType)) {
            mySchedule.setElsAccount(saleVisitHead.getVisitAccount());
            mySchedule.setSubAccount(saleVisitHead.getVisitPrincipal());
            mySchedule.setSourceId(saleVisitHead.getId());
            mySchedule.setSourceNumber(saleVisitHead.getVisitNumber());
            mySchedule.setContent("\u9884\u7ea6\u62dc\u8bbf:" + saleVisitHead.getVisitNumber() + "\uff0c\u9884\u7ea6\u65f6\u95f4:" + this.DATA_FORMART.format(saleVisitHead.getVisitStartTime()) + "-" + this.DATA_FORMART.format(saleVisitHead.getVisitEndTime()) + "\uff0c\u88ab\u8bbf\u8005:" + saleVisitHead.getSupplierName() + "-" + saleVisitHead.getIntervieweePrincipal() + "\uff0c\u88ab\u8bbf\u8d1f\u8d23\u4eba\u7535\u8bdd:" + saleVisitHead.getIntervieweePhone());
            mySchedule.setBeginTime(saleVisitHead.getVisitStartTime());
            mySchedule.setEndTime(saleVisitHead.getVisitEndTime());
        } else {
            mySchedule.setElsAccount(saleVisitHead.getToElsAccount());
            mySchedule.setSubAccount(saleVisitHead.getIntervieweePrincipal());
            mySchedule.setSourceId(saleVisitHead.getId());
            mySchedule.setSourceNumber(saleVisitHead.getVisitNumber());
            mySchedule.setContent("\u9884\u7ea6\u62dc\u8bbf:" + saleVisitHead.getVisitNumber() + "\uff0c\u9884\u7ea6\u65f6\u95f4:" + this.DATA_FORMART.format(saleVisitHead.getVisitStartTime()) + "-" + this.DATA_FORMART.format(saleVisitHead.getVisitEndTime()) + "\uff0c\u6765\u8bbf\u8005:" + saleVisitHead.getVisitSupplierName() + "-" + saleVisitHead.getVisitPrincipalName() + "\uff0c\u6765\u8bbf\u8d1f\u8d23\u4eba\u7535\u8bdd:" + saleVisitHead.getVisitPhone());
            mySchedule.setBeginTime(saleVisitHead.getVisitStartTime());
            mySchedule.setEndTime(saleVisitHead.getVisitEndTime());
        }
        this.myScheduleService.add(mySchedule);
    }

    private void insertAttachmentData(SaleVisitHead saleVisitHead, List<SaleAttachmentDTO> saleAttachmentList) {
        if (CollectionUtil.isNotEmpty(saleAttachmentList)) {
            for (SaleAttachmentDTO entity : saleAttachmentList) {
                entity.setId(null);
                entity.setHeadId(saleVisitHead.getId());
                entity.setElsAccount(saleVisitHead.getElsAccount());
                entity.setBusinessType("saleBookVisit");
                entity.setSendStatus("0");
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentList);
        }
    }

    private void insertPurchaseAttachment(PurchaseVisitHead purchaseVisitHead, List<SaleAttachmentDTO> saleAttachmentList) {
        if (CollectionUtil.isNotEmpty(saleAttachmentList)) {
            ArrayList purchaseAttachmentList = SysUtil.copyProperties(saleAttachmentList, PurchaseAttachmentDTO.class);
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setId(null);
                entity.setHeadId(purchaseVisitHead.getId());
                entity.setElsAccount(purchaseVisitHead.getElsAccount());
                entity.setBusinessType("bookVisit");
                entity.setSendStatus("0");
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn((List)purchaseAttachmentList);
        }
    }

    public void sendAppointMsg(SaleVisitHead head, String elsAccount, String account, String msgType) {
        String str = JSON.toJSONString((Object)((Object)head));
        JSONObject jsonObject = JSONObject.parseObject((String)str);
        MsgParamsVO msgParamsVO = this.parameterAssemble(elsAccount, account, jsonObject);
        MqUtil.sendBusMsg((String)head.getToElsAccount(), (String)"saleBookVisit", (String)msgType, (MsgParamsVO)msgParamsVO);
    }

    private MsgParamsVO parameterAssemble(String toElsAccount, String account, JSONObject jsonObject) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(toElsAccount, account);
        accountList.add(subAccount);
        receiverMap.put(toElsAccount, accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        msgParamsVO.setParams((Object)paramMap);
        return msgParamsVO;
    }
}

