/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.supplier.entity.SupplierAccessMgmtStrategyHead;
import com.els.modules.supplier.entity.SupplierAccessMgmtStrategyItem;
import com.els.modules.supplier.enumerate.SupplierAccessMgmtStrategyStatusEnum;
import com.els.modules.supplier.mapper.SupplierAccessMgmtStrategyHeadMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.service.SupplierAccessMgmtStrategyHeadService;
import com.els.modules.supplier.service.SupplierAccessMgmtStrategyItemService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SupplierAccessMgmtStrategyHeadServiceImpl
extends BaseServiceImpl<SupplierAccessMgmtStrategyHeadMapper, SupplierAccessMgmtStrategyHead>
implements SupplierAccessMgmtStrategyHeadService {
    @Autowired
    private SupplierAccessMgmtStrategyItemService supplierAccessMgmtStrategyItemService;
    @Autowired
    private SupplierInvokeBaseRpcService invokeBaseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SupplierAccessMgmtStrategyHead supplierAccessMgmtStrategyHead, List<SupplierAccessMgmtStrategyItem> supplierAccessMgmtStrategyItemList) {
        supplierAccessMgmtStrategyHead.setId(null);
        if (StringUtils.isBlank((CharSequence)supplierAccessMgmtStrategyHead.getPolicyStatus())) {
            supplierAccessMgmtStrategyHead.setPolicyStatus(SupplierAccessMgmtStrategyStatusEnum.NEW.getValue());
        }
        supplierAccessMgmtStrategyHead.setPolicyNumber(this.invokeBaseRpcService.getNextCode("accessMgmtStrategyNumber", (Object)supplierAccessMgmtStrategyHead));
        ((SupplierAccessMgmtStrategyHeadMapper)this.baseMapper).insert((Object)supplierAccessMgmtStrategyHead);
        super.setHeadDefaultValue((BaseEntity)supplierAccessMgmtStrategyHead);
        this.insertData(supplierAccessMgmtStrategyHead, supplierAccessMgmtStrategyItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SupplierAccessMgmtStrategyHead supplierAccessMgmtStrategyHead, List<SupplierAccessMgmtStrategyItem> supplierAccessMgmtStrategyItemList) {
        int count = ((SupplierAccessMgmtStrategyHeadMapper)this.baseMapper).updateById((Object)supplierAccessMgmtStrategyHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.supplierAccessMgmtStrategyItemService.deleteByMainId(supplierAccessMgmtStrategyHead.getId());
        this.insertData(supplierAccessMgmtStrategyHead, supplierAccessMgmtStrategyItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publishMain(SupplierAccessMgmtStrategyHead supplierAccessMgmtStrategyHead, List<SupplierAccessMgmtStrategyItem> supplierAccessMgmtStrategyItemList) {
        supplierAccessMgmtStrategyHead.setPolicyStatus(SupplierAccessMgmtStrategyStatusEnum.PUBLISH.getValue());
        if (StringUtils.isNotBlank((CharSequence)supplierAccessMgmtStrategyHead.getId())) {
            this.updateMain(supplierAccessMgmtStrategyHead, supplierAccessMgmtStrategyItemList);
        } else {
            this.saveMain(supplierAccessMgmtStrategyHead, supplierAccessMgmtStrategyItemList);
        }
    }

    private void insertData(SupplierAccessMgmtStrategyHead supplierAccessMgmtStrategyHead, List<SupplierAccessMgmtStrategyItem> supplierAccessMgmtStrategyItemList) {
        if (!CollectionUtils.isEmpty(supplierAccessMgmtStrategyItemList)) {
            for (SupplierAccessMgmtStrategyItem entity : supplierAccessMgmtStrategyItemList) {
                entity.setHeadId(supplierAccessMgmtStrategyHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)supplierAccessMgmtStrategyHead);
            }
            this.supplierAccessMgmtStrategyItemService.saveBatch(supplierAccessMgmtStrategyItemList, 2000);
        }
    }

    @Override
    public void invalidById(String id) {
        SupplierAccessMgmtStrategyHead head = new SupplierAccessMgmtStrategyHead();
        head.setId(id);
        head.setPolicyStatus(SupplierAccessMgmtStrategyStatusEnum.INVALID.getValue());
        ((SupplierAccessMgmtStrategyHeadMapper)this.baseMapper).updateById((Object)head);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.supplierAccessMgmtStrategyItemService.deleteByMainId(id);
        ((SupplierAccessMgmtStrategyHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.supplierAccessMgmtStrategyItemService.deleteByMainId(serializable.toString());
            ((SupplierAccessMgmtStrategyHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public IPage<SupplierAccessMgmtStrategyHead> selectCustomPageList(Page<SupplierAccessMgmtStrategyHead> page, QueryWrapper<SupplierAccessMgmtStrategyHead> queryWrapper) {
        return ((SupplierAccessMgmtStrategyHeadMapper)this.baseMapper).selectCustomPageList(page, queryWrapper);
    }
}

