/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataAndEnterpriseInfoDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.entity.SupplierInfoChangeHead;
import com.els.modules.supplier.entity.SupplierInfoChangeItem;
import com.els.modules.supplier.entity.SupplierInfoChangeRejection;
import com.els.modules.supplier.entity.SupplierMasterCustom1;
import com.els.modules.supplier.entity.SupplierMasterCustom10;
import com.els.modules.supplier.entity.SupplierMasterCustom2;
import com.els.modules.supplier.entity.SupplierMasterCustom3;
import com.els.modules.supplier.entity.SupplierMasterCustom4;
import com.els.modules.supplier.entity.SupplierMasterCustom5;
import com.els.modules.supplier.entity.SupplierMasterCustom6;
import com.els.modules.supplier.entity.SupplierMasterCustom7;
import com.els.modules.supplier.entity.SupplierMasterCustom8;
import com.els.modules.supplier.entity.SupplierMasterCustom9;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.enumerate.SupplierInfoChangStatusEnum;
import com.els.modules.supplier.mapper.SupplierInfoChangeHeadMapper;
import com.els.modules.supplier.mapper.SupplierInfoChangeItemMapper;
import com.els.modules.supplier.mapper.SupplierInfoChangeRejectionMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.PurchaseCertificatedInfoService;
import com.els.modules.supplier.service.SupplierInfoChangeHeadService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.util.assist.SupplierFiledJointAssist;
import com.els.modules.supplier.util.assist.SupplierFiledRecordAssist;
import com.els.modules.supplier.vo.EnterpriseInfoVo;
import com.els.modules.supplier.vo.FieldRecordVo;
import com.els.modules.supplier.vo.SupplierInfoChangeHeadVO;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SupplierInfoChangeHeadServiceImpl
extends BaseServiceImpl<SupplierInfoChangeHeadMapper, SupplierInfoChangeHead>
implements SupplierInfoChangeHeadService {
    private static final Logger log = LoggerFactory.getLogger(SupplierInfoChangeHeadServiceImpl.class);
    @Autowired
    private SupplierInfoChangeHeadMapper supplierInfoChangeHeadMapper;
    @Autowired
    private SupplierInfoChangeItemMapper supplierInfoChangeItemMapper;
    @Autowired
    private SupplierInfoChangeRejectionMapper supplierInfoChangeRejectionMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService supplierinvokeEnterpriseRpcService;
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    @Lazy
    private PurchaseCertificatedInfoService purchaseCertificatedInfoService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SupplierMasterDataVO supplierMasterDataVO) {
        String accessCategory;
        if (StringUtils.isNotBlank((CharSequence)supplierMasterDataVO.getSupplierMasterDataId())) {
            supplierMasterDataVO.setId(supplierMasterDataVO.getSupplierMasterDataId());
        }
        if (StringUtils.isNotBlank((CharSequence)supplierMasterDataVO.getAccessCategory()) && (accessCategory = supplierMasterDataVO.getAccessCategory()).substring(accessCategory.length() - 1).equals(";")) {
            supplierMasterDataVO.setAccessCategory(accessCategory.substring(0, accessCategory.length() - 1));
        }
        String elsAccount = TenantContext.getTenant();
        String changeId = supplierMasterDataVO.getSupplierInfoChangeId();
        SupplierInfoChangeHead supplierInfoChangeHead = this.saveInfoHead(supplierMasterDataVO, supplierMasterDataVO.getElsAccount(), elsAccount);
        SupplierInfoChangeItem supplierInfoChangeItem = this.saveInfoItem(changeId, supplierMasterDataVO, supplierInfoChangeHead, elsAccount);
        supplierMasterDataVO.setSupplierInfoChangeDataVersion(supplierInfoChangeHead.getDataVersion());
        supplierMasterDataVO.setSupplierInfoChangeId(supplierInfoChangeHead.getId());
        supplierMasterDataVO.setId(supplierInfoChangeItem.getHeadId());
    }

    public SupplierInfoChangeHead saveInfoHead(SupplierMasterDataVO supplierMasterDataVO, String optElsAccount, String elsAccount) {
        SupplierMasterData masterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)supplierMasterDataVO), (Object)((Object)masterData));
        String needAudit = StringUtils.isNotBlank((CharSequence)masterData.getNeedAudit()) ? masterData.getNeedAudit() : "0";
        SupplierInfoChangeHead supplierInfoChangeHead = new SupplierInfoChangeHead();
        String changeId = supplierMasterDataVO.getSupplierInfoChangeId();
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            log.info("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u4fe1\u606f-----start");
            supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)changeId)));
            supplierInfoChangeHead.setDataVersion(supplierMasterDataVO.getSupplierInfoChangeDataVersion());
        } else {
            String changeNumber = this.invokeBaseRpcService.getNextCode("supplierInfoChangeNumber", (Object)supplierInfoChangeHead, supplierMasterDataVO.getElsAccount());
            supplierInfoChangeHead.setChangeNumber(changeNumber);
            if (!optElsAccount.equals(elsAccount)) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"supplier_id", (Object)supplierMasterDataVO.getId());
                queryWrapper.eq((Object)"is_deleted", (Object)"0");
                queryWrapper.isNotNull((Object)"publish_status");
                queryWrapper.in((Object)"status", Arrays.asList("3"));
                Integer count = this.supplierInfoChangeHeadMapper.selectCount((Wrapper)queryWrapper);
                if (count > 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tkKmMKLMLjAEAHt_2d296e71", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4f01\u4e1a\u53d8\u66f4\u5355\u3002"));
                }
            }
        }
        supplierInfoChangeHead.setSupplierId(masterData.getId());
        if (StringUtils.isBlank((CharSequence)supplierInfoChangeHead.getInitiatorElsAccount())) {
            supplierInfoChangeHead.setInitiatorElsAccount(elsAccount);
        }
        supplierInfoChangeHead.setElsAccount(masterData.getElsAccount());
        supplierInfoChangeHead.setBusAccount(masterData.getElsAccount());
        if (StringUtils.isBlank((CharSequence)masterData.getPurchaseName())) {
            ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierinvokeEnterpriseRpcService.getByElsAccount(masterData.getElsAccount());
            supplierInfoChangeHead.setPurchaseName(elsEnterpriseInfo.getName());
        } else {
            supplierInfoChangeHead.setPurchaseName(masterData.getPurchaseName());
        }
        supplierInfoChangeHead.setAuditChangeTypeCode(supplierMasterDataVO.getAuditChangeTypeCode());
        supplierInfoChangeHead.setToElsAccount(masterData.getToElsAccount());
        supplierInfoChangeHead.setSupplierName(masterData.getSupplierName());
        supplierInfoChangeHead.setTemplateAccount(masterData.getTemplateAccount());
        supplierInfoChangeHead.setTemplateName(masterData.getTemplateName());
        supplierInfoChangeHead.setTemplateNumber(masterData.getTemplateNumber());
        supplierInfoChangeHead.setTemplateVersion(masterData.getTemplateVersion());
        supplierInfoChangeHead.setSupplierCode(masterData.getSupplierCode());
        supplierInfoChangeHead.setFile(JSONObject.toJSONString(supplierMasterDataVO.getSupplierInfoChangeAttachmentList()));
        if (!"1".equals(supplierInfoChangeHead.getPublishStatus()) && !optElsAccount.equals(elsAccount)) {
            supplierInfoChangeHead.setPublishStatus("0");
        }
        if (StringUtils.isBlank((CharSequence)supplierInfoChangeHead.getPublishStatus())) {
            if (needAudit.equals("0")) {
                supplierInfoChangeHead.setNeedAudit(needAudit);
                supplierInfoChangeHead.setAuditStatus("4");
            } else {
                supplierInfoChangeHead.setNeedAudit(needAudit);
                supplierInfoChangeHead.setAuditStatus("0");
            }
        }
        supplierInfoChangeHead.setStatus(StringUtils.isBlank((CharSequence)supplierInfoChangeHead.getStatus()) ? SupplierInfoChangStatusEnum.NEW.getValue() : supplierInfoChangeHead.getStatus());
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            boolean count = this.updateById((Object)supplierInfoChangeHead);
            Assert.isTrue((boolean)count, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        } else {
            this.supplierInfoChangeHeadMapper.insert((Object)supplierInfoChangeHead);
        }
        return supplierInfoChangeHead;
    }

    public SupplierInfoChangeItem saveInfoItem(String changeId, SupplierMasterDataVO supplierMasterDataVO, SupplierInfoChangeHead supplierInfoChangeHead, String elsAccount) {
        SupplierInfoChangeItem supplierInfoChangeItem = new SupplierInfoChangeItem();
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            supplierInfoChangeItem = this.supplierInfoChangeItemMapper.selectByMainId(changeId).get(0);
        }
        supplierInfoChangeItem.setHeadId(supplierInfoChangeHead.getId());
        supplierInfoChangeItem.setChangeNumber(supplierInfoChangeHead.getChangeNumber());
        if (StringUtils.isBlank((CharSequence)supplierInfoChangeItem.getInitiatorElsAccount())) {
            supplierInfoChangeItem.setInitiatorElsAccount(elsAccount);
        }
        supplierInfoChangeItem.setElsAccount(supplierMasterDataVO.getElsAccount());
        supplierInfoChangeItem.setToElsAccount(supplierMasterDataVO.getToElsAccount());
        supplierInfoChangeItem.setUpdateAfterData(JSONObject.toJSONString((Object)((Object)supplierMasterDataVO)));
        List<SupplierAddressInfo> addressInfoList = supplierMasterDataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> bankInfoList = supplierMasterDataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> contactsInfoList = supplierMasterDataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> orgInfoList = supplierMasterDataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> custom1List = supplierMasterDataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> custom2List = supplierMasterDataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> custom3List = supplierMasterDataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> custom4List = supplierMasterDataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> custom5List = supplierMasterDataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> custom6List = supplierMasterDataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> custom7List = supplierMasterDataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> custom8List = supplierMasterDataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> custom9List = supplierMasterDataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> custom10List = supplierMasterDataVO.getSupplierMasterCustom10List();
        log.info("\u83b7\u53d6\u4fee\u6539\u524d\u7684\u3010\u65e7\u6570\u636e\u3011-----start");
        SupplierMasterDataVO oldMasterDataVO = this.supplierMasterDataService.getDataById(supplierMasterDataVO.getId());
        log.info("\u83b7\u53d6\u4fee\u6539\u524d\u7684\u3010\u65e7\u6570\u636e\u3011-----end");
        SupplierMasterData oldMasterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)oldMasterDataVO), (Object)((Object)oldMasterData));
        List<SupplierAddressInfo> oldAddressInfoList = oldMasterDataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> oldBankInfoList = oldMasterDataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> oldContactsInfoList = oldMasterDataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> oldOrgInfoList = oldMasterDataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> oldCustom1List = oldMasterDataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> oldCustom2List = oldMasterDataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> oldCustom3List = oldMasterDataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> oldCustom4List = oldMasterDataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> oldCustom5List = oldMasterDataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> oldCustom6List = oldMasterDataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> oldCustom7List = oldMasterDataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> oldCustom8List = oldMasterDataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> oldCustom9List = oldMasterDataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> oldCustom10List = oldMasterDataVO.getSupplierMasterCustom10List();
        supplierInfoChangeItem.setUpdateBeforeData(JSONObject.toJSONString((Object)((Object)oldMasterDataVO)));
        String accessCategroy = "";
        for (SupplierOrgInfo entity : orgInfoList) {
            if (!StringUtils.isNotBlank((CharSequence)entity.getAccessCategory())) continue;
            accessCategroy = accessCategroy + entity.getAccessCategory() + ";";
        }
        supplierMasterDataVO.setAccessCategory(accessCategroy);
        List<Object> list = new ArrayList<FieldRecordVo>();
        list.addAll(SupplierFiledRecordAssist.getHeadFiledRecord("headData", oldMasterData.getId(), "1", (Object)oldMasterDataVO, (Object)supplierMasterDataVO));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierAddressInfoList", addressInfoList, oldAddressInfoList, new SupplierAddressInfo()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierBankInfoList", bankInfoList, oldBankInfoList, new SupplierBankInfo()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierContactsInfoList", contactsInfoList, oldContactsInfoList, new SupplierContactsInfo()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierOrgInfoList", orgInfoList, oldOrgInfoList, new SupplierOrgInfo()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom1List", custom1List, oldCustom1List, new SupplierMasterCustom1()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom2List", custom2List, oldCustom2List, new SupplierMasterCustom2()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom3List", custom3List, oldCustom3List, new SupplierMasterCustom3()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom4List", custom4List, oldCustom4List, new SupplierMasterCustom4()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom5List", custom5List, oldCustom5List, new SupplierMasterCustom5()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom6List", custom6List, oldCustom6List, new SupplierMasterCustom6()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom7List", custom7List, oldCustom7List, new SupplierMasterCustom7()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom8List", custom8List, oldCustom8List, new SupplierMasterCustom8()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom9List", custom9List, oldCustom9List, new SupplierMasterCustom9()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom10List", custom10List, oldCustom10List, new SupplierMasterCustom10()));
        if (!list.isEmpty() && list.size() > 0) {
            String[] str = new String[]{"supplierInfoChangeId", "supplierInfoChangeNumber", "supplierMasterDataId", "auditChangeTypeCode", "createBy", "createById", "id", "createTime", "updateBy", "updateTime", "deleted", "keyWord", "updateById"};
            List<String> strList = Arrays.asList(str);
            if ((list = list.stream().filter(o -> !strList.contains(o.getField())).collect(Collectors.toList())).isEmpty() || list.size() == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_sMKmWLIiucrjVHW_7dae2e32", (String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u672a\u68c0\u6d4b\u5230\u4fee\u6539\u7684\u4fe1\u606f\uff01"));
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_sMKmWLIiucrjVHW_7dae2e32", (String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u672a\u68c0\u6d4b\u5230\u4fee\u6539\u7684\u4fe1\u606f\uff01"));
        }
        supplierInfoChangeItem.setUpdateFieldData(JSONObject.toJSONString(list));
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            this.supplierInfoChangeItemMapper.updateById((Object)supplierInfoChangeItem);
        } else {
            this.supplierInfoChangeItemMapper.insert((Object)supplierInfoChangeItem);
        }
        return supplierInfoChangeItem;
    }

    @Override
    public String insertPurchaseInfoChang(List<SupplierMasterDataAndEnterpriseInfoDTO> purchaseList, String type) {
        SupplierMasterDataVO newMasterDataVO = null;
        SupplierMasterDataVO oldMasterDataVO = null;
        ArrayList<SupplierInfoChangeHead> supplierInfoChangeIds = new ArrayList<SupplierInfoChangeHead>();
        for (SupplierMasterDataAndEnterpriseInfoDTO infoDTO : purchaseList) {
            newMasterDataVO = (SupplierMasterDataVO)((Object)SysUtil.copyProperties((Object)infoDTO, SupplierMasterDataVO.class));
            newMasterDataVO = this.setPropertiesByEnterpriseInfo(newMasterDataVO, infoDTO.getElsEnterpriseInfoNew());
            List<SupplierContactsInfo> contactsInfoListNew = newMasterDataVO.getSupplierContactsInfoList();
            contactsInfoListNew.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierContactsInfoListNew(), SupplierContactsInfo.class));
            newMasterDataVO.setSupplierContactsInfoList(contactsInfoListNew);
            List<SupplierAddressInfo> addressInfoListNew = newMasterDataVO.getSupplierAddressInfoList();
            addressInfoListNew.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierAddressInfoListNew(), SupplierAddressInfo.class));
            newMasterDataVO.setSupplierAddressInfoList(addressInfoListNew);
            List<SupplierBankInfo> bankInfoListNew = newMasterDataVO.getSupplierBankInfoList();
            bankInfoListNew.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierBankInfoListNew(), SupplierBankInfo.class));
            newMasterDataVO.setSupplierBankInfoList(bankInfoListNew);
            oldMasterDataVO = (SupplierMasterDataVO)((Object)SysUtil.copyProperties((Object)infoDTO, SupplierMasterDataVO.class));
            oldMasterDataVO = this.setPropertiesByEnterpriseInfo(oldMasterDataVO, infoDTO.getElsEnterpriseInfoOld());
            List<SupplierContactsInfo> contactsInfoListOld = oldMasterDataVO.getSupplierContactsInfoList();
            contactsInfoListOld.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierContactsInfoListOld(), SupplierContactsInfo.class));
            oldMasterDataVO.setSupplierContactsInfoList(contactsInfoListOld);
            List<SupplierAddressInfo> addressInfoListOld = oldMasterDataVO.getSupplierAddressInfoList();
            addressInfoListOld.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierAddressInfoListOld(), SupplierAddressInfo.class));
            oldMasterDataVO.setSupplierAddressInfoList(addressInfoListOld);
            List<SupplierBankInfo> bankInfoListOld = oldMasterDataVO.getSupplierBankInfoList();
            bankInfoListOld.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierBankInfoListOld(), SupplierBankInfo.class));
            oldMasterDataVO.setSupplierBankInfoList(bankInfoListOld);
            List purchaseAttachmentDTOList = JSONObject.parseArray((String)infoDTO.getSupplierInfoChangeAttachmentJson(), PurchaseAttachmentDTO.class);
            newMasterDataVO.setSupplierInfoChangeAttachmentList(purchaseAttachmentDTOList);
            oldMasterDataVO.setSupplierInfoChangeAttachmentList(purchaseAttachmentDTOList);
            SupplierInfoChangeHead head = this.insertPurchaseInfoChang(newMasterDataVO, oldMasterDataVO, type);
            if (head == null) continue;
            supplierInfoChangeIds.add(head);
        }
        List<String> msgInfoList = this.getMsgInfoList(supplierInfoChangeIds);
        String join = String.join((CharSequence)"\uff0c", msgInfoList);
        return join;
    }

    @Override
    public boolean isExistUnconfirmed(String elsAccount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"to_els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.eq((Object)"status", (Object)"3");
        queryWrapper.eq((Object)"publish_status", (Object)"1");
        Integer count = this.supplierInfoChangeHeadMapper.selectCount((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    public boolean isExistInfoUpdate(EnterpriseInfoVo enterpriseInfoVo, EnterpriseInfoVo enterpriseInfoVoOld) {
        com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = new com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO();
        BeanUtils.copyProperties((Object)((Object)enterpriseInfoVo), (Object)elsEnterpriseInfoDTO);
        List<SupplierContactsInfo> supplierContactsInfoList = enterpriseInfoVo.getSupplierContactsInfoList();
        List<SupplierAddressInfo> supplierAddressInfoList = enterpriseInfoVo.getSupplierAddressInfoList();
        List<SupplierBankInfo> supplierBankInfoList = enterpriseInfoVo.getSupplierBankInfoList();
        com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO elsEnterpriseInfoDTOOld = new com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO();
        BeanUtils.copyProperties((Object)((Object)enterpriseInfoVoOld), (Object)elsEnterpriseInfoDTOOld);
        List<SupplierContactsInfo> supplierContactsInfoListOld = enterpriseInfoVoOld.getSupplierContactsInfoList();
        List<SupplierAddressInfo> supplierAddressInfoListOld = enterpriseInfoVoOld.getSupplierAddressInfoList();
        List<SupplierBankInfo> supplierBankInfoListOld = enterpriseInfoVoOld.getSupplierBankInfoList();
        ArrayList<FieldRecordVo> list = new ArrayList<FieldRecordVo>();
        list.addAll(SupplierFiledRecordAssist.getHeadFiledRecord("headData", elsEnterpriseInfoDTOOld.getId(), "1", elsEnterpriseInfoDTOOld, elsEnterpriseInfoDTO));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierAddressInfoList", supplierAddressInfoList, supplierAddressInfoListOld, new SupplierAddressInfo()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierBankInfoList", supplierBankInfoList, supplierBankInfoListOld, new SupplierBankInfo()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierContactsInfoList", supplierContactsInfoList, supplierContactsInfoListOld, new SupplierContactsInfo()));
        if (!list.isEmpty() && list.size() > 0) {
            return list.size() == 1 && ((FieldRecordVo)list.get(0)).getField().equals("supplierInfoChangeId");
        }
        return true;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(SupplierMasterDataVO supplierMasterDataVO) {
        String supplierInfoChangeId = supplierMasterDataVO.getSupplierInfoChangeId();
        SupplierInfoChangeHead supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)supplierInfoChangeId)));
        supplierInfoChangeHead.setNeedAudit("0");
        supplierInfoChangeHead.setAuditStatus("4");
        supplierInfoChangeHead.setStatus(SupplierInfoChangStatusEnum.EFFECTIVE.getValue());
        int count = this.supplierInfoChangeHeadMapper.updateById((Object)supplierInfoChangeHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        List<SupplierInfoChangeItem> changeItemList = this.supplierInfoChangeItemMapper.selectByMainId(supplierInfoChangeId);
        SupplierInfoChangeItem infoChangeItem = changeItemList.get(0);
        String updateAfterData = infoChangeItem.getUpdateAfterData();
        SupplierMasterDataVO masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)updateAfterData, SupplierMasterDataVO.class));
        SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(masterDataVO.getElsAccount(), masterDataVO.getToElsAccount());
        masterDataVO.setDataVersion(masterData != null ? masterData.getDataVersion() : masterDataVO.getDataVersion());
        this.supplierMasterDataService.updateMainNoAudit(masterDataVO);
        supplierMasterDataVO.setId(supplierInfoChangeId);
        super.sendMessage(supplierInfoChangeHead.getElsAccount(), "SupplierInfoChange", "purchasePublish", supplierInfoChangeHead.getId(), "supplierInfoChangeBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{supplierInfoChangeHead.getToElsAccount()}));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SupplierMasterDataVO supplierMasterDataVO) {
    }

    @Override
    public JSONObject getDataById(String id) {
        SupplierInfoChangeHead changeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
        List<SupplierInfoChangeItem> supplierInfoChangeItemList = this.supplierInfoChangeItemMapper.selectByMainId(id);
        SupplierInfoChangeItem changeItem = supplierInfoChangeItemList.get(0);
        String beforeData = changeItem.getUpdateBeforeData();
        String updateAfterData = changeItem.getUpdateAfterData();
        SupplierMasterDataVO dataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)beforeData, SupplierMasterDataVO.class));
        List<PurchaseCertificatedInfo> supplierCertificatedInfoList = this.purchaseCertificatedInfoService.getPurchaseCertificatedListByToElsAccount(changeHead.getElsAccount(), changeHead.getToElsAccount());
        dataVO.setSupplierCertificatedInfoList(supplierCertificatedInfoList);
        SupplierMasterDataVO dataVOAfter = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)updateAfterData, SupplierMasterDataVO.class));
        dataVO.setSupplierInfoChangeAttachmentList(dataVOAfter.getSupplierInfoChangeAttachmentList());
        List<SupplierAddressInfo> addressInfoList = dataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> bankInfoList = dataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> contactsInfoList = dataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> orgInfoList = dataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> custom1List = dataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> custom2List = dataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> custom3List = dataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> custom4List = dataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> custom5List = dataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> custom6List = dataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> custom7List = dataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> custom8List = dataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> custom9List = dataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> custom10List = dataVO.getSupplierMasterCustom10List();
        String fieldData = changeItem.getUpdateFieldData();
        ArrayList recordVoList = JSONObject.parseArray((String)fieldData, FieldRecordVo.class);
        if (recordVoList == null) {
            recordVoList = new ArrayList();
        }
        List<FieldRecordVo> headRecordList = recordVoList.parallelStream().filter(o -> "headData".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> addressRecordList = recordVoList.parallelStream().filter(o -> "supplierAddressInfoList".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> bankRecordList = recordVoList.parallelStream().filter(o -> "supplierBankInfoList".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> contactsRecordList = recordVoList.parallelStream().filter(o -> "supplierContactsInfoList".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> orgRecordList = recordVoList.parallelStream().filter(o -> "supplierOrgInfoList".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom1RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom1List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom2RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom2List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom3RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom3List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom4RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom4List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom5RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom5List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom6RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom6List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom7RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom7List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom8RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom8List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom9RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom9List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom10RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom10List".equals(o.getGroup())).collect(Collectors.toList());
        JSONObject jsonObject = JSONObject.parseObject((String)beforeData);
        JSONObject headObject = SupplierFiledJointAssist.getHeadJsonObject(changeHead.getElsAccount(), headRecordList, dataVO, SupplierMasterDataVO.class);
        jsonObject.putAll((Map)headObject);
        jsonObject = this.getDateTypeToString(jsonObject);
        jsonObject.put("infoChangId", (Object)changeHead.getId());
        jsonObject.put("supplierInfoChangeId", (Object)changeHead.getId());
        jsonObject.put("infoChangFlowId", (Object)changeHead.getFlowId());
        jsonObject.put("infoChangWorkFlowType", (Object)changeHead.getWorkFlowType());
        jsonObject.put("infoChangAuditStatus", (Object)changeHead.getAuditStatus());
        jsonObject.put("infoChangStatus", (Object)changeHead.getStatus());
        jsonObject.put("infoChangPublishStatus", (Object)changeHead.getPublishStatus());
        jsonObject.put("infoChangNeedAudit", (Object)changeHead.getNeedAudit());
        jsonObject.put("auditChangeTypeCode", (Object)changeHead.getAuditChangeTypeCode());
        jsonObject.put("supplierInfoChangeDataVersion", (Object)changeHead.getDataVersion());
        JSONObject groupHasStart = SupplierFiledJointAssist.getGroupHasStart(changeHead.getTemplateAccount(), changeHead.getTemplateNumber(), changeHead.getTemplateVersion(), headRecordList, addressRecordList, bankRecordList, contactsRecordList, orgRecordList, custom1RecordList, custom2RecordList, custom3RecordList, custom4RecordList, custom5RecordList, custom6RecordList, custom7RecordList, custom8RecordList, custom9RecordList, custom10RecordList);
        jsonObject.putAll((Map)groupHasStart);
        jsonObject.put("supplierAddressInfoList", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), addressRecordList, addressInfoList, SupplierAddressInfo.class));
        jsonObject.put("supplierBankInfoList", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), bankRecordList, bankInfoList, SupplierBankInfo.class));
        jsonObject.put("supplierContactsInfoList", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), contactsRecordList, contactsInfoList, SupplierContactsInfo.class));
        jsonObject.put("supplierOrgInfoList", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), orgRecordList, orgInfoList, SupplierOrgInfo.class));
        jsonObject.put("supplierMasterCustom1List", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), custom1RecordList, custom1List, SupplierMasterCustom1.class));
        jsonObject.put("supplierMasterCustom2List", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), custom2RecordList, custom2List, SupplierMasterCustom2.class));
        jsonObject.put("supplierMasterCustom3List", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), custom3RecordList, custom3List, SupplierMasterCustom3.class));
        jsonObject.put("supplierMasterCustom4List", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), custom4RecordList, custom4List, SupplierMasterCustom4.class));
        jsonObject.put("supplierMasterCustom5List", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), custom5RecordList, custom5List, SupplierMasterCustom5.class));
        jsonObject.put("supplierMasterCustom6List", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), custom6RecordList, custom6List, SupplierMasterCustom6.class));
        jsonObject.put("supplierMasterCustom7List", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), custom7RecordList, custom7List, SupplierMasterCustom7.class));
        jsonObject.put("supplierMasterCustom8List", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), custom8RecordList, custom8List, SupplierMasterCustom8.class));
        jsonObject.put("supplierMasterCustom9List", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), custom9RecordList, custom9List, SupplierMasterCustom9.class));
        jsonObject.put("supplierMasterCustom10List", (Object)SupplierFiledJointAssist.getItemJsonArray(changeHead.getElsAccount(), custom10RecordList, custom10List, SupplierMasterCustom10.class));
        String afterData = changeItem.getUpdateAfterData();
        JSONObject afterDataJson = JSONObject.parseObject((String)afterData);
        jsonObject.put("frozenFunction", (Object)afterDataJson.getString("frozenFunction"));
        jsonObject.put("supplierMasterFrozenList", (Object)afterDataJson.getJSONArray("supplierMasterFrozenList"));
        jsonObject.put("supplierMasterFrozenHistoryList", (Object)afterDataJson.getJSONArray("supplierMasterFrozenHistoryList"));
        return jsonObject;
    }

    @Override
    public SupplierMasterDataVO getAfterDataById(String id) {
        SupplierInfoChangeHead changeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
        List<SupplierInfoChangeItem> supplierInfoChangeItemList = this.supplierInfoChangeItemMapper.selectByMainId(id);
        SupplierInfoChangeItem changeItem = supplierInfoChangeItemList.get(0);
        String afterData = changeItem.getUpdateAfterData();
        SupplierMasterDataVO dataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)afterData, SupplierMasterDataVO.class));
        dataVO.setSupplierInfoChangeId(id);
        dataVO.setSupplierInfoChangeNumber(changeHead.getChangeNumber());
        List<PurchaseCertificatedInfo> supplierCertificatedInfoList = this.purchaseCertificatedInfoService.getPurchaseCertificatedListByToElsAccount(changeHead.getElsAccount(), changeHead.getToElsAccount());
        dataVO.setSupplierCertificatedInfoList(supplierCertificatedInfoList);
        dataVO.setSupplierMasterDataId(dataVO.getId());
        dataVO.setId(changeHead.getId());
        dataVO.setAuditChangeTypeCode(changeHead.getAuditChangeTypeCode());
        dataVO.setSupplierInfoChangeDataVersion(changeHead.getDataVersion());
        return dataVO;
    }

    @Override
    public SupplierInfoChangeHead getInfoChangById(String id) {
        return (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.supplierInfoChangeItemMapper.deleteByMainId(id);
        this.supplierInfoChangeHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    public void invalidById(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            SupplierInfoChangeHead supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
            if (AuditStatusEnum.AUDIT_DOING.getValue().equals(supplierInfoChangeHead.getAuditStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_AHty0nRCiKUzsShku_a8b00fdb", (String)"\u53d8\u66f4\u5355\u53f7:${0}\u91c7\u8d2d\u65b9\u6b63\u5728\u5ba1\u6279\u4e2d\uff0c\u65e0\u6cd5\u4f5c\u5e9f\u3002", (String[])new String[]{supplierInfoChangeHead.getChangeNumber()}));
            }
            supplierInfoChangeHead.setStatus(SupplierInfoChangStatusEnum.INVALID.getValue());
            int count = this.supplierInfoChangeHeadMapper.updateById((Object)supplierInfoChangeHead);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void releaseByIds(String id) {
        int count;
        String supicCoordination;
        Assert.hasText((String)id, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a"));
        SupplierInfoChangeHead head = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
        if (head == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        }
        List<SupplierInfoChangeItem> changeItemList = this.supplierInfoChangeItemMapper.selectByMainId(id);
        String updateAfterData = changeItemList.get(0).getUpdateAfterData();
        SupplierMasterDataVO masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)updateAfterData, SupplierMasterDataVO.class));
        head.setPublishStatus("1");
        head.setStatus(SupplierInfoChangStatusEnum.CONFIRM.getValue());
        if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(head.getAuditStatus())) {
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        head.setNeedAudit(masterDataVO.getNeedAudit());
        if ("1".equals(head.getNeedAudit())) {
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        if ("0".equals(head.getNeedAudit())) {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)(supicCoordination = this.supplierMasterDataService.getSupplierChangeCollaborationConditions(masterDataVO.getElsAccount())))) {
            if (supicCoordination.contains(masterDataVO.getSupplierStatus())) {
                head.setStatus(SupplierInfoChangStatusEnum.WAIT_CONFIRM.getValue());
            } else {
                head.setStatus(SupplierInfoChangStatusEnum.CONFIRM.getValue());
                head.setNeedAudit("0");
                head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
        }
        if (SupplierInfoChangStatusEnum.CONFIRM.getValue().equals(head.getStatus())) {
            SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(masterDataVO.getElsAccount(), masterDataVO.getToElsAccount());
            masterDataVO.setDataVersion(masterData != null ? masterData.getDataVersion() : masterDataVO.getDataVersion());
            this.supplierMasterDataService.updateMainNoAudit(masterDataVO);
            head.setNeedAudit("0");
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        Assert.isTrue(((count = this.supplierInfoChangeHeadMapper.updateById((Object)head)) != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        super.sendMessage(head.getElsAccount(), "SupplierInfoChange", "salePublish", head.getId(), "supplierInfoChangeBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{head.getToElsAccount()}));
    }

    public void releaseByIdsOld(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            List<String> ids = Arrays.asList(id.replace(" ", "").split(","));
            SupplierInfoChangeHead supplierInfoChangeHead = new SupplierInfoChangeHead();
            supplierInfoChangeHead.setStatus(SupplierInfoChangStatusEnum.WAIT_CONFIRM.getValue());
            supplierInfoChangeHead.setPublishStatus("1");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", ids);
            this.supplierInfoChangeHeadMapper.update((Object)supplierInfoChangeHead, (Wrapper)queryWrapper);
            List headList = this.supplierInfoChangeHeadMapper.selectList((Wrapper)queryWrapper);
            if (!headList.isEmpty() && headList.size() > 0) {
                for (SupplierInfoChangeHead head : headList) {
                    super.sendMessage(head.getElsAccount(), "SupplierInfoChange", "salePublish", head.getId(), "supplierInfoChangeBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{head.getToElsAccount()}));
                }
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmById(String id) {
        SupplierInfoChangeHead changeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
        SupplierInfoChangeItem changeItem = this.supplierInfoChangeItemMapper.selectByMainId(changeHead.getId()).get(0);
        String afterData = changeItem.getUpdateAfterData();
        changeHead.setStatus(SupplierInfoChangStatusEnum.CONFIRM.getValue());
        int count = this.supplierInfoChangeHeadMapper.updateById((Object)changeHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        SupplierMasterDataVO masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)afterData, SupplierMasterDataVO.class));
        masterDataVO.setEnterpriseInfoRecordId("");
        SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(masterDataVO.getElsAccount(), masterDataVO.getToElsAccount());
        masterDataVO.setDataVersion(masterData != null ? masterData.getDataVersion() : masterDataVO.getDataVersion());
        this.supplierMasterDataService.updateMainNoAudit(masterDataVO);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void rejectedById(SupplierInfoChangeHead head) {
        if (StringUtils.isNotBlank((CharSequence)head.getId())) {
            SupplierInfoChangeHead oldHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)head.getId())));
            if (oldHead != null && StringUtils.isBlank((CharSequence)oldHead.getPurchaseName())) {
                ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierinvokeEnterpriseRpcService.getByElsAccount(oldHead.getElsAccount());
                oldHead.setPurchaseName(elsEnterpriseInfo != null ? elsEnterpriseInfo.getName() : "");
            }
            oldHead.setStatus(SupplierInfoChangStatusEnum.BLACKLIST.getValue());
            oldHead.setRejectReason(head.getRejectReason());
            int count = this.supplierInfoChangeHeadMapper.updateById((Object)oldHead);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
            SupplierInfoChangeRejection rejection = new SupplierInfoChangeRejection();
            rejection.setHeadId(oldHead.getId());
            rejection.setChangeNumber(oldHead.getChangeNumber());
            rejection.setElsAccount(oldHead.getElsAccount());
            rejection.setToElsAccount(oldHead.getToElsAccount());
            rejection.setOpinion(head.getRejectReason());
            this.supplierInfoChangeRejectionMapper.insert((Object)rejection);
            super.sendMessage(oldHead.getElsAccount(), "SupplierInfoChange", "purchaseReject", oldHead.getId(), "supplierInfoChangeBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{oldHead.getToElsAccount()}));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.supplierInfoChangeItemMapper.deleteByMainId(serializable.toString());
            this.supplierInfoChangeHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public boolean isHaveNewAndWaitConfirm(String supplierId, String status) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.and(and -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)and.eq((Object)"supplier_id", (Object)supplierId);
        });
        queryWrapper.and(and -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)and.or(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)wrapper.eq((Object)"status", (Object)SupplierInfoChangStatusEnum.NEW.getValue())).and(t -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)t.eq((Object)"publish_status", (Object)"")).or()).isNull((Object)"publish_status");
                });
            })).or(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)wrapper.eq((Object)"status", (Object)SupplierInfoChangStatusEnum.WAIT_CONFIRM.getValue())).and(t -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)t.eq((Object)"publish_status", (Object)"1");
                });
            })).or(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)wrapper.eq((Object)"status", (Object)SupplierInfoChangStatusEnum.BLACKLIST.getValue())).and(t -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)t.eq((Object)"publish_status", (Object)"1");
                });
            });
        });
        Integer count = this.supplierInfoChangeHeadMapper.selectCount((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    public Result<?> isHaveNewAndWaitConfirmOrNewData(String supplierId, String status) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.eq((Object)"status", (Object)status);
        queryWrapper.isNotNull((Object)"publish_status");
        Integer count = this.supplierInfoChangeHeadMapper.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rnRXMKLMLjAHtFW_b17a9e8b", (String)"\u8be5\u91c7\u8d2d\u5546\u5b58\u5728\u672a\u5b8c\u6210\u7684\u53d8\u66f4\u5355\u636e\uff01"));
        }
        queryWrapper.clear();
        queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.eq((Object)"status", (Object)"0");
        queryWrapper.eq((Object)"publish_status", (Object)"0");
        List infoChangeHeadList = this.supplierInfoChangeHeadMapper.selectList((Wrapper)queryWrapper);
        if (!infoChangeHeadList.isEmpty() && infoChangeHeadList.size() > 0) {
            SupplierInfoChangeHead supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)infoChangeHeadList.get(0));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("status", "0");
            map.put("data", (Object)supplierInfoChangeHead);
            return Result.ok(map);
        }
        queryWrapper.clear();
        queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.eq((Object)"status", (Object)"5");
        queryWrapper.eq((Object)"publish_status", (Object)"1");
        List list = this.supplierInfoChangeHeadMapper.selectList((Wrapper)queryWrapper);
        if (!list.isEmpty() && list.size() > 0) {
            SupplierInfoChangeHead supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)list.get(0));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("status", "5");
            map.put("data", (Object)supplierInfoChangeHead);
            return Result.ok(map);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("status", "-1");
        map.put("data", null);
        return Result.ok(map);
    }

    @Override
    public Result<?> isHaveNewData(String supplierId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.eq((Object)"status", (Object)"0");
        queryWrapper.eq((Object)"publish_status", (Object)"0");
        List infoChangeHeadList = this.supplierInfoChangeHeadMapper.selectList((Wrapper)queryWrapper);
        if (!infoChangeHeadList.isEmpty() && infoChangeHeadList.size() > 0) {
            SupplierInfoChangeHead supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)infoChangeHeadList.get(0));
            return Result.ok((Object)((Object)supplierInfoChangeHead));
        }
        queryWrapper.clear();
        queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.eq((Object)"status", (Object)"5");
        queryWrapper.eq((Object)"publish_status", (Object)"1");
        List list = this.supplierInfoChangeHeadMapper.selectList((Wrapper)queryWrapper);
        if (!list.isEmpty() && list.size() > 0) {
            SupplierInfoChangeHead supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)list.get(0));
            return Result.ok((Object)((Object)supplierInfoChangeHead));
        }
        return Result.error((String)"Unable to find data");
    }

    @Override
    public List<SupplierInfoChangeHead> getEffectiveListBySupplierId(String supplierId) {
        ArrayList<String> status = new ArrayList<String>();
        status.add("1");
        status.add("4");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.in((Object)"status", status);
        queryWrapper.orderByDesc((Object)"create_time");
        List list = this.supplierInfoChangeHeadMapper.selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public IPage<SupplierInfoChangeHead> selectChangInfoAndEnterprisePage(Page<SupplierInfoChangeHead> page, QueryWrapper<SupplierInfoChangeHead> queryWrapper) {
        return this.supplierInfoChangeHeadMapper.selectChangInfoAndEnterprisePage(page, queryWrapper);
    }

    @Override
    public JSONObject getChangInfoDataById(String id) {
        SupplierInfoChangeHead supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)this.getById((Serializable)((Object)id)));
        SupplierInfoChangeHeadVO supplierInfoChangeHeadVO = (SupplierInfoChangeHeadVO)((Object)BeanUtil.copyProperties((Object)((Object)supplierInfoChangeHead), SupplierInfoChangeHeadVO.class, (String[])new String[0]));
        Result result = Result.ok((Object)((Object)supplierInfoChangeHeadVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    @Override
    public void saveMainToChangInfo(SupplierMasterDataVO supplierMasterDataVO, boolean isUpdMasterData) {
        String accessCategory;
        if (StringUtils.isNotBlank((CharSequence)supplierMasterDataVO.getAccessCategory()) && (accessCategory = supplierMasterDataVO.getAccessCategory()).substring(accessCategory.length() - 1).equals(";")) {
            supplierMasterDataVO.setAccessCategory(accessCategory.substring(0, accessCategory.length() - 1));
        }
        String elsAccount = TenantContext.getTenant();
        String changeId = supplierMasterDataVO.getSupplierInfoChangeId();
        SupplierInfoChangeHead supplierInfoChangeHead = this.saveInfoHead(supplierMasterDataVO, supplierMasterDataVO.getElsAccount(), elsAccount);
        SupplierInfoChangeItem supplierInfoChangeItem = this.saveInfoItem(changeId, supplierMasterDataVO, supplierInfoChangeHead, elsAccount);
        supplierInfoChangeHead.setNeedAudit("0");
        supplierInfoChangeHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        supplierInfoChangeHead.setStatus(SupplierInfoChangStatusEnum.EFFECTIVE.getValue());
        this.supplierInfoChangeHeadMapper.updateById((Object)supplierInfoChangeHead);
        if (isUpdMasterData) {
            SupplierMasterDataVO masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)supplierInfoChangeItem.getUpdateAfterData(), SupplierMasterDataVO.class));
            masterDataVO.setEnterpriseInfoRecordId("");
            SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(masterDataVO.getElsAccount(), masterDataVO.getToElsAccount());
            masterDataVO.setDataVersion(masterData != null ? masterData.getDataVersion() : masterDataVO.getDataVersion());
            this.supplierMasterDataService.updateMainNoAudit(masterDataVO);
        }
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SupplierInfoChangeHead insertPurchaseInfoChang(SupplierMasterDataVO newMasterDataVO, SupplierMasterDataVO oldMasterDataVO, String updateType) {
        String needAudit;
        List<SupplierAddressInfo> addressInfoList = newMasterDataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> bankInfoList = newMasterDataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> contactsInfoList = newMasterDataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> orgInfoList = newMasterDataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> custom1List = newMasterDataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> custom2List = newMasterDataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> custom3List = newMasterDataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> custom4List = newMasterDataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> custom5List = newMasterDataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> custom6List = newMasterDataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> custom7List = newMasterDataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> custom8List = newMasterDataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> custom9List = newMasterDataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> custom10List = newMasterDataVO.getSupplierMasterCustom10List();
        SupplierMasterData oldMasterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)oldMasterDataVO), (Object)((Object)oldMasterData));
        List<SupplierAddressInfo> oldAddressInfoList = oldMasterDataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> oldBankInfoList = oldMasterDataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> oldContactsInfoList = oldMasterDataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> oldOrgInfoList = oldMasterDataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> oldCustom1List = oldMasterDataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> oldCustom2List = oldMasterDataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> oldCustom3List = oldMasterDataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> oldCustom4List = oldMasterDataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> oldCustom5List = oldMasterDataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> oldCustom6List = oldMasterDataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> oldCustom7List = oldMasterDataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> oldCustom8List = oldMasterDataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> oldCustom9List = oldMasterDataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> oldCustom10List = oldMasterDataVO.getSupplierMasterCustom10List();
        String elsAccount = TenantContext.getTenant();
        SupplierMasterData masterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)oldMasterDataVO), (Object)((Object)masterData));
        SupplierInfoChangeHead supplierInfoChangeHead = new SupplierInfoChangeHead();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"supplier_id", (Object)masterData.getId());
        wrapper.eq((Object)"initiator_els_account", (Object)elsAccount);
        wrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.eq((Object)"status", (Object)"0")).or()).eq((Object)"status", (Object)"5");
        });
        wrapper.isNotNull((Object)"publish_status");
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        List changeHeadList = this.supplierInfoChangeHeadMapper.selectList((Wrapper)wrapper);
        if (CollUtil.isNotEmpty((Collection)changeHeadList) && changeHeadList.size() > 0) {
            supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)changeHeadList.get(0));
        }
        if (supplierInfoChangeHead == null || StringUtils.isBlank((CharSequence)supplierInfoChangeHead.getChangeNumber())) {
            supplierInfoChangeHead = new SupplierInfoChangeHead();
            String changeNumber = this.invokeBaseRpcService.getNextCode("supplierInfoChangeNumber", (Object)supplierInfoChangeHead, oldMasterDataVO.getElsAccount());
            supplierInfoChangeHead.setChangeNumber(changeNumber);
        }
        String changeId = supplierInfoChangeHead.getId();
        supplierInfoChangeHead.setSupplierId(masterData.getId());
        if (StringUtils.isBlank((CharSequence)supplierInfoChangeHead.getInitiatorElsAccount())) {
            supplierInfoChangeHead.setInitiatorElsAccount(elsAccount);
        }
        supplierInfoChangeHead.setElsAccount(masterData.getElsAccount());
        supplierInfoChangeHead.setBusAccount(masterData.getElsAccount());
        if (StringUtils.isBlank((CharSequence)masterData.getPersonName())) {
            ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = this.supplierinvokeEnterpriseRpcService.getByElsAccount(masterData.getElsAccount());
            supplierInfoChangeHead.setPurchaseName(elsEnterpriseInfoDTO != null ? elsEnterpriseInfoDTO.getName() : "");
        } else {
            supplierInfoChangeHead.setPurchaseName(masterData.getPurchaseName());
        }
        supplierInfoChangeHead.setToElsAccount(masterData.getToElsAccount());
        supplierInfoChangeHead.setSupplierName(masterData.getSupplierName());
        supplierInfoChangeHead.setTemplateAccount(masterData.getTemplateAccount());
        supplierInfoChangeHead.setTemplateName(masterData.getTemplateName());
        supplierInfoChangeHead.setTemplateNumber(masterData.getTemplateNumber());
        supplierInfoChangeHead.setTemplateVersion(masterData.getTemplateVersion());
        supplierInfoChangeHead.setSupplierCode(masterData.getSupplierCode());
        supplierInfoChangeHead.setFile(JSONObject.toJSONString(newMasterDataVO.getSupplierInfoChangeAttachmentList()));
        String string = needAudit = StringUtils.isNotBlank((CharSequence)masterData.getNeedAudit()) ? masterData.getNeedAudit() : "0";
        if (needAudit.equals("0")) {
            supplierInfoChangeHead.setNeedAudit(needAudit);
            supplierInfoChangeHead.setAuditStatus("4");
        } else {
            supplierInfoChangeHead.setNeedAudit(needAudit);
            supplierInfoChangeHead.setAuditStatus("0");
        }
        if ("0".equals(updateType)) {
            supplierInfoChangeHead.setStatus(StringUtils.isBlank((CharSequence)supplierInfoChangeHead.getStatus()) ? "0" : supplierInfoChangeHead.getStatus());
            supplierInfoChangeHead.setPublishStatus(StringUtils.isBlank((CharSequence)supplierInfoChangeHead.getPublishStatus()) ? "0" : supplierInfoChangeHead.getPublishStatus());
        }
        if ("1".equals(updateType)) {
            supplierInfoChangeHead.setStatus(SupplierInfoChangStatusEnum.CONFIRM.getValue());
            String supicCoordination = this.supplierMasterDataService.getSupplierChangeCollaborationConditions(supplierInfoChangeHead.getElsAccount());
            if (StringUtils.isNotBlank((CharSequence)supicCoordination)) {
                if (supicCoordination.contains(newMasterDataVO.getSupplierStatus())) {
                    supplierInfoChangeHead.setStatus(SupplierInfoChangStatusEnum.WAIT_CONFIRM.getValue());
                    if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(supplierInfoChangeHead.getAuditStatus())) {
                        supplierInfoChangeHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                    }
                } else {
                    supplierInfoChangeHead.setStatus(SupplierInfoChangStatusEnum.CONFIRM.getValue());
                }
            }
            supplierInfoChangeHead.setPublishStatus("1");
        }
        if (SupplierInfoChangStatusEnum.CONFIRM.getValue().equals(supplierInfoChangeHead.getStatus())) {
            supplierInfoChangeHead.setNeedAudit("0");
            supplierInfoChangeHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if (StringUtils.isBlank((CharSequence)changeId)) {
            supplierInfoChangeHead.setIsNewAdd("0");
            this.supplierInfoChangeHeadMapper.insert((Object)supplierInfoChangeHead);
        } else {
            supplierInfoChangeHead.setIsNewAdd("1");
            int count = this.supplierInfoChangeHeadMapper.updateById((Object)supplierInfoChangeHead);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        SupplierInfoChangeItem supplierInfoChangeItem = new SupplierInfoChangeItem();
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            supplierInfoChangeItem = this.supplierInfoChangeItemMapper.selectByMainId(changeId).get(0);
        }
        supplierInfoChangeItem.setHeadId(supplierInfoChangeHead.getId());
        supplierInfoChangeItem.setChangeNumber(supplierInfoChangeHead.getChangeNumber());
        if (StringUtils.isBlank((CharSequence)supplierInfoChangeItem.getInitiatorElsAccount())) {
            supplierInfoChangeItem.setInitiatorElsAccount(elsAccount);
        }
        supplierInfoChangeItem.setElsAccount(masterData.getElsAccount());
        supplierInfoChangeItem.setToElsAccount(masterData.getToElsAccount());
        supplierInfoChangeItem.setUpdateAfterData(JSONObject.toJSONString((Object)((Object)newMasterDataVO)));
        supplierInfoChangeItem.setUpdateBeforeData(JSONObject.toJSONString((Object)((Object)oldMasterDataVO)));
        String accessCategroy = "";
        for (SupplierOrgInfo entity : orgInfoList) {
            if (!StringUtils.isNotBlank((CharSequence)entity.getAccessCategory())) continue;
            accessCategroy = accessCategroy + entity.getAccessCategory() + ";";
        }
        newMasterDataVO.setAccessCategory(accessCategroy);
        List<Object> list = new ArrayList<FieldRecordVo>();
        list.addAll(SupplierFiledRecordAssist.getHeadFiledRecord("headData", oldMasterData.getId(), "1", (Object)oldMasterDataVO, (Object)newMasterDataVO));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierAddressInfoList", addressInfoList, oldAddressInfoList, new SupplierAddressInfo()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierBankInfoList", bankInfoList, oldBankInfoList, new SupplierBankInfo()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierContactsInfoList", contactsInfoList, oldContactsInfoList, new SupplierContactsInfo()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierOrgInfoList", orgInfoList, oldOrgInfoList, new SupplierOrgInfo()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom1List", custom1List, oldCustom1List, new SupplierMasterCustom1()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom2List", custom2List, oldCustom2List, new SupplierMasterCustom2()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom3List", custom3List, oldCustom3List, new SupplierMasterCustom3()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom4List", custom4List, oldCustom4List, new SupplierMasterCustom4()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom5List", custom5List, oldCustom5List, new SupplierMasterCustom5()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom6List", custom6List, oldCustom6List, new SupplierMasterCustom6()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom7List", custom7List, oldCustom7List, new SupplierMasterCustom7()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom8List", custom8List, oldCustom8List, new SupplierMasterCustom8()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom9List", custom9List, oldCustom9List, new SupplierMasterCustom9()));
        list.addAll(SupplierFiledRecordAssist.getItemFiledRecord("supplierMasterCustom10List", custom10List, oldCustom10List, new SupplierMasterCustom10()));
        if (!list.isEmpty() && list.size() > 0) {
            String[] str = new String[]{"supplierInfoChangeId", "supplierInfoChangeNumber", "supplierMasterDataId", "auditChangeTypeCode", "createBy", "createById", "id", "createTime", "updateBy", "updateTime", "deleted", "keyWord", "updateById"};
            List<String> strList = Arrays.asList(str);
            if (((list = list.stream().filter(o -> !strList.contains(o.getField())).collect(Collectors.toList())).isEmpty() || list.size() == 0) && StringUtils.isBlank((CharSequence)changeId)) {
                this.supplierInfoChangeHeadMapper.deleteById((Serializable)((Object)supplierInfoChangeHead.getId()));
                return null;
            }
            supplierInfoChangeItem.setUpdateFieldData(JSONObject.toJSONString(list));
        } else if (StringUtils.isBlank((CharSequence)changeId)) {
            this.supplierInfoChangeHeadMapper.deleteById((Serializable)((Object)supplierInfoChangeHead.getId()));
            return null;
        }
        if (StringUtils.isBlank((CharSequence)supplierInfoChangeItem.getId())) {
            this.supplierInfoChangeItemMapper.insert((Object)supplierInfoChangeItem);
        } else {
            this.supplierInfoChangeItemMapper.updateById((Object)supplierInfoChangeItem);
        }
        if (SupplierInfoChangStatusEnum.CONFIRM.getValue().equals(supplierInfoChangeHead.getStatus())) {
            SupplierMasterDataVO masterDataVO;
            String updateAfterData = supplierInfoChangeItem.getUpdateAfterData();
            masterData = this.supplierMasterDataService.getByAccount((masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)updateAfterData, SupplierMasterDataVO.class))).getElsAccount(), masterDataVO.getToElsAccount());
            masterDataVO.setDataVersion(masterData != null ? masterData.getDataVersion() : masterDataVO.getDataVersion());
            this.supplierMasterDataService.updateMainNoAudit(masterDataVO);
        }
        if ("1".equals(updateType)) {
            super.sendMessage(supplierInfoChangeHead.getElsAccount(), "SupplierInfoChange", "salePublish", supplierInfoChangeHead.getId(), "supplierInfoChangeBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{supplierInfoChangeHead.getToElsAccount()}));
        }
        return supplierInfoChangeHead;
    }

    private List<String> getMsgInfoList(List<SupplierInfoChangeHead> supplierInfoChangeIds) {
        ArrayList<String> msgList = new ArrayList<String>();
        if (CollUtil.isNotEmpty(supplierInfoChangeIds) && supplierInfoChangeIds.size() > 0) {
            Map<String, List<SupplierInfoChangeHead>> collect = supplierInfoChangeIds.stream().collect(Collectors.groupingBy(SupplierInfoChangeHead::getStatus));
            for (String key : collect.keySet()) {
                List<SupplierInfoChangeHead> notExists;
                List<SupplierInfoChangeHead> exists;
                Map<Boolean, List<SupplierInfoChangeHead>> map;
                List<SupplierInfoChangeHead> headList = collect.get(key);
                if (key.equals(SupplierInfoChangStatusEnum.NEW.getValue())) {
                    map = headList.stream().collect(Collectors.partitioningBy(e -> e.getIsNewAdd().equals("1")));
                    exists = map.get(true);
                    notExists = map.get(false);
                    if (CollUtil.isNotEmpty(exists) && exists.size() > 0) {
                        exists.forEach(o -> {
                            String translate = I18nUtil.translate((String)"i18n_alert_AE[01]VHAHtIHV2_2e9dd0f5", (String)"\u4f01\u4e1a[${0}-${1}]\u4fe1\u606f\u53d8\u66f4\u5355\u5df2\u66f4\u65b0(${2})", (String[])new String[]{o.getElsAccount(), o.getPurchaseName(), o.getChangeNumber()});
                            msgList.add(translate);
                        });
                    }
                    if (CollUtil.isNotEmpty(notExists) && notExists.size() > 0) {
                        notExists.forEach(o -> {
                            String translate = I18nUtil.translate((String)"i18n_alert_AE[01]VHAHtIcI2_882bb5b8", (String)"\u4f01\u4e1a[${0}-${1}]\u4fe1\u606f\u53d8\u66f4\u5355\u5df2\u521b\u5efa(${2})", (String[])new String[]{o.getElsAccount(), o.getPurchaseName(), o.getChangeNumber()});
                            msgList.add(translate);
                        });
                    }
                }
                if (key.equals(SupplierInfoChangStatusEnum.BLACKLIST.getValue()) && CollUtil.isNotEmpty(headList) && headList.size() > 0) {
                    headList.forEach(o -> {
                        String translate = I18nUtil.translate((String)"i18n_alert_AE[01]VHAHtIHV2_2e9dd0f5", (String)"\u4f01\u4e1a[${0}-${1}]\u4fe1\u606f\u53d8\u66f4\u5355\u5df2\u66f4\u65b0(${2})", (String[])new String[]{o.getElsAccount(), o.getPurchaseName(), o.getChangeNumber()});
                        msgList.add(translate);
                    });
                }
                if (key.equals(SupplierInfoChangStatusEnum.CONFIRM.getValue())) {
                    map = headList.stream().collect(Collectors.partitioningBy(e -> e.getIsNewAdd().equals("1")));
                    exists = map.get(true);
                    notExists = map.get(false);
                    if (CollUtil.isNotEmpty(exists) && exists.size() > 0) {
                        exists.forEach(o -> {
                            String translate = I18nUtil.translate((String)"i18n_alert_AE[01]VHAHtIHVGIRL2_f03318a7", (String)"\u4f01\u4e1a[${0}-${1}]\u4fe1\u606f\u53d8\u66f4\u5355\u5df2\u66f4\u65b0\u5e76\u5df2\u786e\u8ba4(${2})", (String[])new String[]{o.getElsAccount(), o.getPurchaseName(), o.getChangeNumber()});
                            msgList.add(translate);
                        });
                    }
                    if (CollUtil.isNotEmpty(notExists) && notExists.size() > 0) {
                        notExists.forEach(o -> {
                            String translate = I18nUtil.translate((String)"i18n_alert_AE[01]VHAHtIcIGIRL2_52eae3ea", (String)"\u4f01\u4e1a[${0}-${1}]\u4fe1\u606f\u53d8\u66f4\u5355\u5df2\u521b\u5efa\u5e76\u5df2\u786e\u8ba4(${2})", (String[])new String[]{o.getElsAccount(), o.getPurchaseName(), o.getChangeNumber()});
                            msgList.add(translate);
                        });
                    }
                }
                if (!key.equals(SupplierInfoChangStatusEnum.WAIT_CONFIRM.getValue())) continue;
                map = headList.stream().collect(Collectors.partitioningBy(e -> e.getIsNewAdd().equals("1")));
                exists = map.get(true);
                notExists = map.get(false);
                if (CollUtil.isNotEmpty(exists) && exists.size() > 0) {
                    exists.forEach(o -> {
                        String translate = I18nUtil.translate((String)"i18n_alert_AE[01]VHAHtIHVGhx2_f998e5d1", (String)"\u4f01\u4e1a[${0}-${1}]\u4fe1\u606f\u53d8\u66f4\u5355\u5df2\u66f4\u65b0\u5e76\u53d1\u5e03(${2})", (String[])new String[]{o.getElsAccount(), o.getPurchaseName(), o.getChangeNumber()});
                        msgList.add(translate);
                    });
                }
                if (!CollUtil.isNotEmpty(notExists) || notExists.size() <= 0) continue;
                notExists.forEach(o -> {
                    String translate = I18nUtil.translate((String)"i18n_alert_AE[01]VHAHtIcIGhx2_80e9262e", (String)"\u4f01\u4e1a[${0}-${1}]\u4fe1\u606f\u53d8\u66f4\u5355\u5df2\u521b\u5efa\u5e76\u53d1\u5e03(${2})", (String[])new String[]{o.getElsAccount(), o.getPurchaseName(), o.getChangeNumber()});
                    msgList.add(translate);
                });
            }
        }
        return msgList;
    }

    private JSONObject getDateTypeToString(JSONObject jsonObject) {
        if (jsonObject.getDate("fromTime") != null) {
            jsonObject.put("fromTime", (Object)new SimpleDateFormat("yyyy-MM-dd").format(jsonObject.getDate("fromTime")));
        }
        if (jsonObject.getDate("approvedTime") != null) {
            jsonObject.put("approvedTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("approvedTime")));
        }
        if (jsonObject.getDate("updateTimes") != null) {
            jsonObject.put("updateTimes", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("updateTimes")));
        }
        if (jsonObject.getDate("establishTime") != null) {
            jsonObject.put("establishTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("establishTime")));
        }
        if (jsonObject.getDate("toTime") != null) {
            jsonObject.put("toTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("toTime")));
        }
        if (jsonObject.getDate("revokeDate") != null) {
            jsonObject.put("revokeDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("revokeDate")));
        }
        if (jsonObject.getDate("cancelDate") != null) {
            jsonObject.put("cancelDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("cancelDate")));
        }
        if (jsonObject.getDate("registerDate") != null) {
            jsonObject.put("registerDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("registerDate")));
        }
        if (jsonObject.getDate("createTime") != null) {
            jsonObject.put("createTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("createTime")));
        }
        if (jsonObject.getDate("updateTime") != null) {
            jsonObject.put("updateTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("updateTime")));
        }
        if (jsonObject.getDate("supplierTermDate") != null) {
            jsonObject.put("supplierTermDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("supplierTermDate")));
        }
        return jsonObject;
    }

    private SupplierMasterDataVO setPropertiesByEnterpriseInfo(SupplierMasterDataVO supplierMasterDataVO, com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO ElsEnterpriseInfoDTO2) {
        supplierMasterDataVO.setName(ElsEnterpriseInfoDTO2.getName());
        supplierMasterDataVO.setPercentileScore(ElsEnterpriseInfoDTO2.getPercentileScore());
        supplierMasterDataVO.setStaffNumRange(ElsEnterpriseInfoDTO2.getStaffNumRange());
        supplierMasterDataVO.setFromTime(ElsEnterpriseInfoDTO2.getFromTime());
        supplierMasterDataVO.setType(ElsEnterpriseInfoDTO2.getType());
        supplierMasterDataVO.setBondBame(ElsEnterpriseInfoDTO2.getBondBame());
        supplierMasterDataVO.setMicroEnt(ElsEnterpriseInfoDTO2.getMicroEnt());
        supplierMasterDataVO.setUsedBondName(ElsEnterpriseInfoDTO2.getUsedBondName());
        supplierMasterDataVO.setRegNumber(ElsEnterpriseInfoDTO2.getRegNumber());
        supplierMasterDataVO.setRegCapital(ElsEnterpriseInfoDTO2.getRegCapital());
        supplierMasterDataVO.setRegInstitute(ElsEnterpriseInfoDTO2.getRegInstitute());
        supplierMasterDataVO.setRegLocation(ElsEnterpriseInfoDTO2.getRegLocation());
        supplierMasterDataVO.setIndustry(ElsEnterpriseInfoDTO2.getIndustry());
        supplierMasterDataVO.setApprovedTime(ElsEnterpriseInfoDTO2.getApprovedTime());
        supplierMasterDataVO.setUpdateTimes(ElsEnterpriseInfoDTO2.getUpdateTimes());
        supplierMasterDataVO.setSocialStaffNum(ElsEnterpriseInfoDTO2.getSocialStaffNum());
        supplierMasterDataVO.setTags(ElsEnterpriseInfoDTO2.getTags());
        supplierMasterDataVO.setTaxNumber(ElsEnterpriseInfoDTO2.getTaxNumber());
        supplierMasterDataVO.setBusinessScope(ElsEnterpriseInfoDTO2.getBusinessScope());
        supplierMasterDataVO.setProperty3(ElsEnterpriseInfoDTO2.getProperty3());
        supplierMasterDataVO.setAlias(ElsEnterpriseInfoDTO2.getAlias());
        supplierMasterDataVO.setOrgNumber(ElsEnterpriseInfoDTO2.getOrgNumber());
        supplierMasterDataVO.setRegStatus(ElsEnterpriseInfoDTO2.getRegStatus());
        supplierMasterDataVO.setEstablishTime(ElsEnterpriseInfoDTO2.getEstablishTime());
        supplierMasterDataVO.setBondType(ElsEnterpriseInfoDTO2.getBondType());
        supplierMasterDataVO.setLegalPersonName(ElsEnterpriseInfoDTO2.getLegalPersonName());
        supplierMasterDataVO.setToTime(ElsEnterpriseInfoDTO2.getToTime());
        supplierMasterDataVO.setActualCapital(ElsEnterpriseInfoDTO2.getActualCapital());
        supplierMasterDataVO.setCompanyOrgType(ElsEnterpriseInfoDTO2.getCompanyOrgType());
        supplierMasterDataVO.setBase(ElsEnterpriseInfoDTO2.getBase());
        supplierMasterDataVO.setArea(ElsEnterpriseInfoDTO2.getArea());
        supplierMasterDataVO.setCountry(ElsEnterpriseInfoDTO2.getCountry());
        supplierMasterDataVO.setCreditCode(ElsEnterpriseInfoDTO2.getCreditCode());
        supplierMasterDataVO.setHistoryNames(ElsEnterpriseInfoDTO2.getHistoryNames());
        supplierMasterDataVO.setHistoryNameList(ElsEnterpriseInfoDTO2.getHistoryNameList());
        supplierMasterDataVO.setBondNum(ElsEnterpriseInfoDTO2.getBondNum());
        supplierMasterDataVO.setRegCapitalCurrency(ElsEnterpriseInfoDTO2.getRegCapitalCurrency());
        supplierMasterDataVO.setActualCapitalCurrency(ElsEnterpriseInfoDTO2.getActualCapitalCurrency());
        supplierMasterDataVO.setEmail(ElsEnterpriseInfoDTO2.getEmail());
        supplierMasterDataVO.setWebsiteList(ElsEnterpriseInfoDTO2.getWebsiteList());
        supplierMasterDataVO.setPhoneNumber(ElsEnterpriseInfoDTO2.getPhoneNumber());
        supplierMasterDataVO.setRevokeDate(ElsEnterpriseInfoDTO2.getRevokeDate());
        supplierMasterDataVO.setRevokeReason(ElsEnterpriseInfoDTO2.getRevokeReason());
        supplierMasterDataVO.setCancelDate(ElsEnterpriseInfoDTO2.getCancelDate());
        supplierMasterDataVO.setCancelReason(ElsEnterpriseInfoDTO2.getCancelReason());
        supplierMasterDataVO.setCity(ElsEnterpriseInfoDTO2.getCity());
        supplierMasterDataVO.setDistrict(ElsEnterpriseInfoDTO2.getDistrict());
        supplierMasterDataVO.setCategory(ElsEnterpriseInfoDTO2.getCategory());
        supplierMasterDataVO.setCategoryBig(ElsEnterpriseInfoDTO2.getCategoryBig());
        supplierMasterDataVO.setCategoryMiddle(ElsEnterpriseInfoDTO2.getCategoryMiddle());
        supplierMasterDataVO.setCategorySmall(ElsEnterpriseInfoDTO2.getCategorySmall());
        supplierMasterDataVO.setRegisterDate(ElsEnterpriseInfoDTO2.getRegisterDate());
        supplierMasterDataVO.setBusinessLicense(ElsEnterpriseInfoDTO2.getBusinessLicense());
        supplierMasterDataVO.setStaging(ElsEnterpriseInfoDTO2.getStaging());
        supplierMasterDataVO.setStagingReason(ElsEnterpriseInfoDTO2.getStagingReason());
        return supplierMasterDataVO;
    }
}

