/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.supplier.entity.PurchaseVisitHead;
import com.els.modules.supplier.entity.PurchaseVisitItem;
import com.els.modules.supplier.mapper.PurchaseVisitHeadMapper;
import com.els.modules.supplier.mapper.PurchaseVisitItemMapper;
import com.els.modules.supplier.service.VisitHeadMsgBusinessService;
import com.els.modules.supplier.vo.PurchaseVisitHeadVO;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class VisitHeadMsgBusinessServiceImpl
implements VisitHeadMsgBusinessService {
    private final PurchaseVisitHeadMapper purchaseVisitHeadMapper;
    private final PurchaseVisitItemMapper purchaseVisitItemMapper;
    private final InvokeAccountRpcService invokeAccountRpcService;

    @Override
    public JSONObject getVisitDataById(String id) {
        PurchaseVisitHead purchaseVisitHead = (PurchaseVisitHead)((Object)this.purchaseVisitHeadMapper.selectById((Serializable)((Object)id)));
        List<PurchaseVisitItem> purchaseVisitItems = this.purchaseVisitItemMapper.selectByMainId(id);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject urlParam = new JSONObject();
        urlParam.put("templateNumber", (Object)purchaseVisitHead.getTemplateNumber());
        urlParam.put("templateVersion", (Object)purchaseVisitHead.getTemplateVersion());
        urlParam.put("busAccount", (Object)purchaseVisitHead.getElsAccount());
        urlParam.put("id", (Object)purchaseVisitHead.getRelationId());
        urlParam.put("businessType", (Object)"bookVisit");
        receiveParamMap.put(purchaseVisitHead.getToElsAccount(), urlParam);
        return this.packageNoSupplierMsgParams(purchaseVisitHead, purchaseVisitItems);
    }

    private JSONObject packageNoSupplierMsgParams(PurchaseVisitHead purchaseVisitHead, List<PurchaseVisitItem> purchaseVisitItemList) {
        PurchaseVisitHeadVO purchaseVisitHeadVO = new PurchaseVisitHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseVisitHead), (Object)((Object)purchaseVisitHeadVO));
        purchaseVisitHeadVO.setPurchaseVisitItemList(purchaseVisitItemList);
        Result result = Result.ok((Object)((Object)purchaseVisitHeadVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        StringBuilder serviceAddress = new StringBuilder((String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("service.address"));
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(purchaseVisitHead.getToElsAccount(), "1001");
        String outOrderConfirmUrl = SysUtil.getSaleOrderConfirm((ElsSubAccountDTO)subAccount, (String)purchaseVisitHead.getRelationId()).toString();
        jsonObject.put("serviceAddress", (Object)serviceAddress);
        jsonObject.put("userName", (Object)purchaseVisitHead.getSupplierName());
        return jsonObject;
    }

    public VisitHeadMsgBusinessServiceImpl(PurchaseVisitHeadMapper purchaseVisitHeadMapper, PurchaseVisitItemMapper purchaseVisitItemMapper, InvokeAccountRpcService invokeAccountRpcService) {
        this.purchaseVisitHeadMapper = purchaseVisitHeadMapper;
        this.purchaseVisitItemMapper = purchaseVisitItemMapper;
        this.invokeAccountRpcService = invokeAccountRpcService;
    }
}

