/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.knowledge.dto.KnowledgeCatalogueDTO;
import com.els.modules.knowledge.dto.KnowledgePermDTO;
import com.els.modules.knowledge.entity.KnowledgeAccountPerm;
import com.els.modules.knowledge.entity.KnowledgeBase;
import com.els.modules.knowledge.entity.KnowledgeBaseCatalogue;
import com.els.modules.knowledge.entity.KnowledgeInteract;
import com.els.modules.knowledge.entity.KnowledgeVisitor;
import com.els.modules.knowledge.enumerate.KnowledgeClassificationStatus;
import com.els.modules.knowledge.enumerate.KnowledgeStatusEnum;
import com.els.modules.knowledge.enumerate.KnowledgeVisitorPermEnum;
import com.els.modules.knowledge.mapper.KnowledgeAccountPermMapper;
import com.els.modules.knowledge.mapper.KnowledgeBaseCatalogueMapper;
import com.els.modules.knowledge.mapper.KnowledgeBaseMapper;
import com.els.modules.knowledge.mapper.KnowledgeCollectMapper;
import com.els.modules.knowledge.mapper.KnowledgeVisitorMapper;
import com.els.modules.knowledge.service.KnowledgeAccountPermService;
import com.els.modules.knowledge.service.KnowledgeBaseCatalogueService;
import com.els.modules.knowledge.service.KnowledgeBaseService;
import com.els.modules.knowledge.vo.KnowledgeBaseListVo;
import com.els.modules.knowledge.vo.KnowledgeBaseVo;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class KnowledgeBaseServiceImpl
extends BaseServiceImpl<KnowledgeBaseMapper, KnowledgeBase>
implements KnowledgeBaseService {
    @Autowired
    private KnowledgeAccountPermMapper purchaseKnowledgeAccountPermMapper;
    @Autowired
    private KnowledgeBaseCatalogueMapper knowledgeBaseCatalogueMapper;
    @Autowired
    private BaseRpcService baseRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private KnowledgeCollectMapper knowledgeCollectMapper;
    @Autowired
    private KnowledgeVisitorMapper knowledgeVisitorMapper;

    @Override
    @SrmTransaction
    public void savePurchaseKnowledgeBase(KnowledgeBase base) {
        boolean permCheck;
        KnowledgeVisitorPermEnum permEnum = KnowledgeVisitorPermEnum.build(base.getVisitorPerm());
        if (null == permEnum) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKAPJLmAbWR_2010dd9d", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u8d44\u6599\u67e5\u770b\u6743\u9650\u503c") + ":" + base.getVisitorPerm());
        }
        boolean bl = permCheck = (KnowledgeVisitorPermEnum.IN_CUSTOM.getValue().equals(base.getVisitorPerm()) || KnowledgeVisitorPermEnum.OUT_CUSTOM.getValue().equals(base.getVisitorPerm())) && CollectionUtils.isEmpty(base.getVisitorPermElsAccount());
        if (permCheck) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VWiFJLjCQbW_3d58317a", (String)"\u8bf7\u5148\u9009\u62e9\u8d44\u6599\u7684\u8bbf\u95ee\u6743\u9650"));
        }
        ((KnowledgeBaseMapper)this.baseMapper).insert((Object)base);
        this.saveKnowledgePerm(Collections.singletonList(base.getId()), base.getVisitorPermElsAccount());
        this.saveAttachment(base, base.getAttachmentList());
    }

    private void saveKnowledgeBaseCatalogue(KnowledgeBase base) {
        KnowledgeBaseCatalogue baseCatalogue = new KnowledgeBaseCatalogue();
        baseCatalogue.setKnowledgeId(base.getId());
        baseCatalogue.setClassificationBy(base.getUpdateBy());
        baseCatalogue.setClassificationTime(base.getUpdateTime());
        baseCatalogue.setDataVersion(0);
        baseCatalogue.setSaleKnowledgeStatus(KnowledgeClassificationStatus.BEEN_CLASSIFIED.getValue());
        baseCatalogue.setSaleKnowledgeCatalogue(base.getKnowledgeCatalogue());
        baseCatalogue.setElsAccount(base.getElsAccount());
        this.knowledgeBaseCatalogueMapper.insert(baseCatalogue);
    }

    private void saveAttachment(KnowledgeBase base, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setCreateTime(null);
                entity.setId(null);
                entity.setCreateBy(null);
                entity.setUpdateBy(null);
                entity.setUpdateTime(null);
                entity.setHeadId(base.getId());
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)base);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    @Override
    public void updatePurchaseKnowledgeBase(KnowledgeBase base) {
        boolean permCheck;
        KnowledgeVisitorPermEnum permEnum = KnowledgeVisitorPermEnum.build(base.getVisitorPerm());
        if (null == permEnum) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKAPJLmAbWR_2010dd9d", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u8d44\u6599\u67e5\u770b\u6743\u9650\u503c") + ":" + base.getVisitorPerm());
        }
        boolean bl = permCheck = (KnowledgeVisitorPermEnum.IN_CUSTOM.getValue().equals(base.getVisitorPerm()) || KnowledgeVisitorPermEnum.OUT_CUSTOM.getValue().equals(base.getVisitorPerm())) && CollectionUtils.isEmpty(base.getVisitorPermElsAccount());
        if (permCheck) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VWiFJLjCQbW_3d58317a", (String)"\u8bf7\u5148\u9009\u62e9\u8d44\u6599\u7684\u8bbf\u95ee\u6743\u9650"));
        }
        this.removeKnowledgePerm(base.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(base.getId());
        this.saveKnowledgePerm(Collections.singletonList(base.getId()), base.getVisitorPermElsAccount());
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(BaseEntity::getId, (Object)base.getId())).eq(BaseEntity::getElsAccount, (Object)base.getElsAccount());
        int count = ((KnowledgeBaseMapper)this.baseMapper).update((Object)base, (Wrapper)wrapper);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.saveAttachment(base, base.getAttachmentList());
    }

    private void updateKnowledgeBaseCatalogue(KnowledgeBase base) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(KnowledgeBaseCatalogue::getElsAccount, (Object)TenantContext.getTenant())).eq(KnowledgeBaseCatalogue::getKnowledgeId, (Object)base.getId())).last(" limit 1");
        KnowledgeBaseCatalogue catalogue = (KnowledgeBaseCatalogue)this.knowledgeBaseCatalogueMapper.selectOne((Wrapper)wrapper);
        if (null == catalogue) {
            this.saveKnowledgeBaseCatalogue(base);
            return;
        }
        catalogue.setClassificationBy(base.getUpdateBy());
        catalogue.setClassificationTime(base.getUpdateTime());
        catalogue.setSaleKnowledgeCatalogue(base.getKnowledgeCatalogue());
        this.knowledgeBaseCatalogueMapper.updateById(catalogue);
    }

    @Override
    public void delPurchaseKnowledgeBase(String id) {
        LambdaUpdateWrapper delete = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)delete.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(BaseEntity::getId, (Object)id);
        int row = ((KnowledgeBaseMapper)this.baseMapper).delete((Wrapper)delete);
        if (row <= 0) {
            return;
        }
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(KnowledgeBaseCatalogue::getKnowledgeId, (Object)id)).eq(KnowledgeBaseCatalogue::getElsAccount, (Object)TenantContext.getTenant());
        this.knowledgeBaseCatalogueMapper.delete((Wrapper)wrapper);
        LambdaUpdateWrapper collect = Wrappers.lambdaUpdate();
        LambdaUpdateWrapper visitor = Wrappers.lambdaUpdate();
        collect.eq(KnowledgeInteract::getKnowledgeId, (Object)id);
        visitor.eq(KnowledgeInteract::getKnowledgeId, (Object)id);
        this.knowledgeCollectMapper.delete((Wrapper)collect);
        this.knowledgeVisitorMapper.delete((Wrapper)visitor);
    }

    @Override
    public void delBatchPurchaseKnowledgeBase(List<String> idList) {
        ((KnowledgeBaseMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Page<KnowledgeBaseVo> pageSaleKnowledgeByCatalogue(Page<KnowledgeBase> page, QueryWrapper<KnowledgeBase> queryWrapper, KnowledgeBase base) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).pageSaleKnowledgeByCatalogue(page, base, queryWrapper, loginUser.getElsAccount());
    }

    @Override
    public Page<KnowledgeBaseVo> pagePurchaseKnowledgeByCatalogue(Page<KnowledgeBase> page, QueryWrapper<KnowledgeBase> queryWrapper, KnowledgeBase base) {
        LoginUser loginUser = SysUtil.getLoginUser();
        if ("1".equals(AdminFlagUtil.getAdminFlag())) {
            return ((KnowledgeBaseMapper)this.baseMapper).pagePurchaseListByCatalogueAdmin(page, base, queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount());
        }
        return ((KnowledgeBaseMapper)this.baseMapper).pagePurchaseListByCatalogue(page, base, queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void publish(KnowledgeBase base) {
        boolean permCheck;
        KnowledgeVisitorPermEnum permEnum = KnowledgeVisitorPermEnum.build(base.getVisitorPerm());
        if (null == permEnum) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKAPJLmAbWR_2010dd9d", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u8d44\u6599\u67e5\u770b\u6743\u9650\u503c") + ":" + base.getVisitorPerm());
        }
        boolean bl = permCheck = (KnowledgeVisitorPermEnum.IN_CUSTOM.getValue().equals(base.getVisitorPerm()) || KnowledgeVisitorPermEnum.OUT_CUSTOM.getValue().equals(base.getVisitorPerm())) && CollectionUtils.isEmpty(base.getVisitorPermElsAccount());
        if (permCheck) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VWiFJLjCQbW_3d58317a", (String)"\u8bf7\u5148\u9009\u62e9\u8d44\u6599\u7684\u8bbf\u95ee\u6743\u9650"));
        }
        this.removeKnowledgePerm(base.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(base.getId());
        this.saveKnowledgePerm(Collections.singletonList(base.getId()), base.getVisitorPermElsAccount());
        base.setStatus(KnowledgeStatusEnum.PUBLISH.getValue());
        int count = ((KnowledgeBaseMapper)this.baseMapper).updateById((Object)base);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.saveAttachment(base, base.getAttachmentList());
    }

    @Override
    public KnowledgeBase querySaleById(String id) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).querySaleById(TenantContext.getTenant(), id, loginUser.getElsAccount());
    }

    private void removeKnowledgePerm(String knowledgeId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(KnowledgeAccountPerm::getKnowledgeId, (Object)knowledgeId);
        this.purchaseKnowledgeAccountPermMapper.delete((Wrapper)wrapper);
    }

    private void removeKnowledgePerms(List<String> knowledgeId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(KnowledgeAccountPerm::getKnowledgeId, knowledgeId);
        this.purchaseKnowledgeAccountPermMapper.delete((Wrapper)wrapper);
    }

    private void saveKnowledgePerm(List<String> knowledgeIds, List<String> account) {
        if (CollectionUtil.isEmpty(account)) {
            return;
        }
        knowledgeIds = knowledgeIds.stream().distinct().collect(Collectors.toList());
        ArrayList accountPerms = Lists.newArrayList();
        for (String knowledgeId : knowledgeIds) {
            accountPerms.addAll(account.stream().map(p -> new KnowledgeAccountPerm(knowledgeId, (String)p)).collect(Collectors.toList()));
        }
        ((KnowledgeAccountPermService)SpringContextUtils.getBean(KnowledgeAccountPermService.class)).saveBatch(accountPerms);
    }

    @Override
    public IPage<KnowledgeBase> pageSaleBase(Page<KnowledgeBase> page, QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String deptCode = CharSequenceUtil.emptyToDefault((CharSequence)SysUtil.getLoginUser().getOrgCode(), (String)"");
        if ("1".equals(AdminFlagUtil.getAdminFlag())) {
            return ((KnowledgeBaseMapper)this.baseMapper).pageSaleBaseAdmin(page, queryWrapper, loginUser.getElsAccount(), deptCode);
        }
        return ((KnowledgeBaseMapper)this.baseMapper).pageSaleBase(page, queryWrapper, loginUser.getElsAccount(), deptCode);
    }

    @Override
    public IPage<KnowledgeBase> pagePurchaseBase(Page<KnowledgeBase> page, QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String deptCode = CharSequenceUtil.emptyToDefault((CharSequence)SysUtil.getLoginUser().getOrgCode(), (String)"");
        if ("1".equals(AdminFlagUtil.getAdminFlag())) {
            return ((KnowledgeBaseMapper)this.baseMapper).pagePurchaseBaseAdmin(page, queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount(), deptCode);
        }
        return ((KnowledgeBaseMapper)this.baseMapper).pagePurchaseBase(page, queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount(), deptCode);
    }

    @Override
    public List<KnowledgeBase> listPurchaseBase(QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).listPurchaseBase(queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount());
    }

    @Override
    public List<KnowledgeBase> listPurchaseBaseToCount(QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String deptCode = CharSequenceUtil.emptyToDefault((CharSequence)SysUtil.getLoginUser().getOrgCode(), (String)"");
        if ("1".equals(AdminFlagUtil.getAdminFlag())) {
            return ((KnowledgeBaseMapper)this.baseMapper).listPurchaseBaseAdminCount(queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount(), deptCode);
        }
        return ((KnowledgeBaseMapper)this.baseMapper).listPurchaseBaseToCount(queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount(), deptCode);
    }

    @Override
    public List<KnowledgeBase> listSaleBase(QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).listSaleBase(queryWrapper, loginUser.getElsAccount());
    }

    @Override
    public List<KnowledgeBase> listSaleBaseToCount(QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        if ("1".equals(AdminFlagUtil.getAdminFlag())) {
            return ((KnowledgeBaseMapper)this.baseMapper).listSaleBaseAdminToCount(queryWrapper, loginUser.getElsAccount());
        }
        return ((KnowledgeBaseMapper)this.baseMapper).listSaleBaseToCount(queryWrapper, loginUser.getElsAccount());
    }

    @Override
    public void freeze(String id) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(KnowledgeBase::getStatus, (Object)KnowledgeStatusEnum.PUBLISH.getValue())).eq(BaseEntity::getId, (Object)id);
        wrapper.set(KnowledgeBase::getStatus, (Object)KnowledgeStatusEnum.FROZEN.getValue());
        ((KnowledgeBaseMapper)this.baseMapper).update((Object)new KnowledgeBase(), (Wrapper)wrapper);
    }

    @Override
    public void thaw(String id) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(KnowledgeBase::getStatus, (Object)KnowledgeStatusEnum.FROZEN.getValue())).eq(BaseEntity::getId, (Object)id);
        wrapper.set(KnowledgeBase::getStatus, (Object)KnowledgeStatusEnum.PUBLISH.getValue());
        ((KnowledgeBaseMapper)this.baseMapper).update((Object)new KnowledgeBase(), (Wrapper)wrapper);
    }

    @Override
    public void cancel(String id) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).ne(KnowledgeBase::getStatus, (Object)KnowledgeStatusEnum.NEW.getValue())).eq(BaseEntity::getId, (Object)id);
        wrapper.set(KnowledgeBase::getStatus, (Object)KnowledgeStatusEnum.CANCEL.getValue());
        ((KnowledgeBaseMapper)this.baseMapper).update((Object)new KnowledgeBase(), (Wrapper)wrapper);
    }

    @Override
    public long countPurchaseBaseVisitor(QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).countPurchaseBaseVisitor(queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount());
    }

    @Override
    public Page<KnowledgeVisitor> pagePurchaseBaseVisitor(Page<KnowledgeVisitor> page, QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).pagePurchaseBaseVisitor(page, queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount());
    }

    @Override
    public long countPurchaseBaseComment(QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).countPurchaseBaseComment(queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount());
    }

    @Override
    public Page<KnowledgeBaseListVo> pagePurchaseBaseComment(Page<KnowledgeBaseListVo> page, QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).pagePurchaseBaseComment(page, queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount());
    }

    @Override
    public long countSaleBaseComment(QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).countSaleBaseComment(queryWrapper, loginUser.getElsAccount());
    }

    @Override
    public Page<KnowledgeBaseListVo> pageSaleBaseComment(Page<KnowledgeBaseListVo> page, QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).pageSaleBaseComment(page, queryWrapper, loginUser.getElsAccount());
    }

    @Override
    public List<KnowledgeBase> listSaleBaseByCatalogueId(String catalogueId) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).listSaleBaseByCatalogueId(catalogueId, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void settingVisitorPerm(KnowledgePermDTO permDTO) {
        boolean permCheck;
        List<String> knowledgeIds = permDTO.getKnowledgeId();
        String visitorPerm = permDTO.getVisitorPerm();
        List<String> visitorPermElsAccount = permDTO.getVisitorPermElsAccount();
        KnowledgeVisitorPermEnum permEnum = KnowledgeVisitorPermEnum.build(visitorPerm);
        if (null == permEnum) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKAPJLmAbWR_2010dd9d", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u8d44\u6599\u67e5\u770b\u6743\u9650\u503c") + ":" + visitorPerm);
        }
        boolean bl = permCheck = (KnowledgeVisitorPermEnum.IN_CUSTOM.getValue().equals(visitorPerm) || KnowledgeVisitorPermEnum.OUT_CUSTOM.getValue().equals(visitorPerm)) && CollectionUtils.isEmpty(visitorPermElsAccount);
        if (permCheck) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VWiFJLjCQbW_3d58317a", (String)"\u8bf7\u5148\u9009\u62e9\u8d44\u6599\u7684\u8bbf\u95ee\u6743\u9650"));
        }
        this.removeKnowledgePerms(knowledgeIds);
        this.saveKnowledgePerm(knowledgeIds, visitorPermElsAccount);
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)updateWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(BaseEntity::getId, knowledgeIds);
        updateWrapper.set(KnowledgeBase::getVisitorPerm, (Object)visitorPerm);
        ((KnowledgeBaseMapper)this.baseMapper).update((Object)new KnowledgeBase(), (Wrapper)updateWrapper);
    }

    @Override
    public List<KnowledgeVisitor> listPurchaseBaseVisitor(QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).listPurchaseBaseVisitor(queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount());
    }

    @Override
    public List<KnowledgeVisitor> listSaleBaseVisitor(QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((KnowledgeBaseMapper)this.baseMapper).listSaleBaseVisitor(queryWrapper, loginUser.getElsAccount());
    }

    @Override
    public void settingCatalogue(KnowledgeCatalogueDTO catalogueDTO) {
        String knowledgeCatalogueId = catalogueDTO.getKnowledgeCatalogueId();
        List<String> knowledgeId = catalogueDTO.getKnowledgeId().stream().collect(Collectors.toList());
        LambdaQueryWrapper selectDb = Wrappers.lambdaQuery();
        selectDb.select(new SFunction[]{BaseEntity::getId});
        ((LambdaQueryWrapper)selectDb.in(BaseEntity::getId, knowledgeId)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List dbList = ((KnowledgeBaseMapper)this.baseMapper).selectList((Wrapper)selectDb);
        List dbIds = dbList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(dbIds)) {
            LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
            ((LambdaUpdateWrapper)wrapper.in(BaseEntity::getId, dbIds)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            wrapper.set(KnowledgeBase::getKnowledgeCatalogue, (Object)knowledgeCatalogueId);
            ((KnowledgeBaseMapper)this.baseMapper).update((Object)new KnowledgeBase(), (Wrapper)wrapper);
        }
        knowledgeId.removeAll(dbIds);
        if (CollectionUtil.isNotEmpty(knowledgeId)) {
            this.changeKnowbaseCatalogue(knowledgeId, knowledgeCatalogueId);
        }
    }

    @Override
    public List<KnowledgeBaseListVo> listPurchaseBaseComment(QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String deptCode = CharSequenceUtil.emptyToDefault((CharSequence)SysUtil.getLoginUser().getOrgCode(), (String)"");
        if ("1".equals(AdminFlagUtil.getAdminFlag())) {
            return ((KnowledgeBaseMapper)this.baseMapper).listPurchaseBaseCommentAdmin(queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount());
        }
        return ((KnowledgeBaseMapper)this.baseMapper).listPurchaseBaseComment(queryWrapper, loginUser.getElsAccount(), loginUser.getElsAccount() + "_" + loginUser.getSubAccount(), loginUser.getSubAccount(), deptCode);
    }

    @Override
    public List<KnowledgeBaseListVo> listSaleBaseComment(QueryWrapper<KnowledgeBase> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        if ("1".equals(AdminFlagUtil.getAdminFlag())) {
            return ((KnowledgeBaseMapper)this.baseMapper).listSaleBaseComment(queryWrapper, loginUser.getElsAccount());
        }
        return ((KnowledgeBaseMapper)this.baseMapper).listSaleBaseComment(queryWrapper, loginUser.getElsAccount());
    }

    @Override
    public void saleSettingCatalogue(KnowledgeCatalogueDTO catalogueDTO) {
        String knowledgeCatalogueId = catalogueDTO.getKnowledgeCatalogueId();
        List<String> knowledgeId = catalogueDTO.getKnowledgeId().stream().distinct().collect(Collectors.toList());
        this.changeKnowbaseCatalogue(knowledgeId, knowledgeCatalogueId);
    }

    private void changeKnowbaseCatalogue(List<String> knowledgeId, String knowledgeCatalogueId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(KnowledgeBaseCatalogue::getElsAccount, (Object)TenantContext.getTenant())).in(KnowledgeBaseCatalogue::getKnowledgeId, knowledgeId);
        List updateList = this.knowledgeBaseCatalogueMapper.selectList((Wrapper)wrapper);
        ArrayList addList = Lists.newArrayList();
        List dbKnowledgeIds = updateList.stream().map(KnowledgeBaseCatalogue::getKnowledgeId).collect(Collectors.toList());
        DateTime classificationTime = DateUtil.date();
        for (String kId : knowledgeId) {
            if (dbKnowledgeIds.contains(kId)) continue;
            KnowledgeBaseCatalogue baseCatalogue = new KnowledgeBaseCatalogue();
            baseCatalogue.setKnowledgeId(kId);
            baseCatalogue.setClassificationBy(SysUtil.getLoginUser().getSubAccount());
            baseCatalogue.setClassificationTime((Date)classificationTime);
            baseCatalogue.setDataVersion(0);
            baseCatalogue.setSaleKnowledgeStatus(KnowledgeClassificationStatus.BEEN_CLASSIFIED.getValue());
            baseCatalogue.setSaleKnowledgeCatalogue(knowledgeCatalogueId);
            baseCatalogue.setElsAccount(TenantContext.getTenant());
            addList.add(baseCatalogue);
        }
        for (KnowledgeBaseCatalogue catalogue : updateList) {
            catalogue.setClassificationBy(SysUtil.getLoginUser().getSubAccount());
            catalogue.setClassificationTime((Date)classificationTime);
            catalogue.setSaleKnowledgeStatus(KnowledgeClassificationStatus.BEEN_CLASSIFIED.getValue());
            catalogue.setSaleKnowledgeCatalogue(knowledgeCatalogueId);
        }
        addList.addAll(updateList);
        if (CollectionUtil.isNotEmpty((Collection)addList)) {
            ((KnowledgeBaseCatalogueService)SpringContextUtils.getBean(KnowledgeBaseCatalogueService.class)).saveOrUpdateBatch(addList);
        }
    }
}

