/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.event.AsyncEventNotifier;
import com.els.common.event.AsyncEventType;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.knowledge.entity.KnowledgeInteract;
import com.els.modules.knowledge.entity.KnowledgeLike;
import com.els.modules.knowledge.event.SupplierAsyncEventType;
import com.els.modules.knowledge.mapper.KnowledgeLikeMapper;
import com.els.modules.knowledge.service.KnowledgeLikeService;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeLikeServiceImpl
extends ServiceImpl<KnowledgeLikeMapper, KnowledgeLike>
implements KnowledgeLikeService {
    @Override
    public boolean checkIfExists(String knowledgeId, String accountId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(KnowledgeInteract::getAccountId, (Object)accountId)).eq(KnowledgeInteract::getKnowledgeId, (Object)knowledgeId);
        return ((KnowledgeLikeMapper)this.baseMapper).selectCount((Wrapper)wrapper) > 0;
    }

    @Override
    public boolean logLike(String knowledgeId, String knowledgeTitle, String accountId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(KnowledgeInteract::getAccountId, (Object)accountId)).eq(KnowledgeInteract::getKnowledgeId, (Object)knowledgeId);
        ((KnowledgeLikeMapper)this.baseMapper).delete((Wrapper)wrapper);
        LoginUser loginUser = SysUtil.getLoginUser();
        KnowledgeLike like = new KnowledgeLike();
        like.setKnowledgeId(knowledgeId);
        like.setCreateTime(new Date());
        like.setKnowledgeId(knowledgeId);
        like.setKnowledgeTitle(knowledgeTitle);
        like.setAccountId(loginUser.getId());
        like.setCreateBy(loginUser.getElsAccount() + "_" + loginUser.getSubAccount());
        ((KnowledgeLikeMapper)this.baseMapper).insert(like);
        AsyncEventNotifier.notify((String)knowledgeId, (AsyncEventType)SupplierAsyncEventType.KNOWLEDGE_VOLUME_REFRESH);
        return false;
    }

    @Override
    public Integer countKnowledge(String dataId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(KnowledgeInteract::getKnowledgeId, (Object)dataId);
        return ((KnowledgeLikeMapper)this.baseMapper).selectCount((Wrapper)wrapper);
    }

    @Override
    public List<String> check(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.in(KnowledgeInteract::getKnowledgeId, ids)).eq(KnowledgeInteract::getAccountId, (Object)SysUtil.getLoginUser().getId());
        wrapper.select(new SFunction[]{KnowledgeInteract::getKnowledgeId});
        List list = ((KnowledgeLikeMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return list.stream().map(KnowledgeInteract::getKnowledgeId).collect(Collectors.toList());
    }

    @Override
    public void removeLike(String knowledgeId, String userId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(KnowledgeInteract::getKnowledgeId, (Object)knowledgeId)).eq(KnowledgeInteract::getAccountId, (Object)userId);
        ((KnowledgeLikeMapper)this.baseMapper).delete((Wrapper)wrapper);
    }
}

