/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.partnership.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.partnership.entity.PartnershipInvitation;
import com.els.modules.partnership.service.PartnershipInvitationService;
import com.els.modules.partnership.vo.InvitationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5408\u4f5c\u9080\u7ea6\u8bb0\u5f55"})
@RestController
@RequestMapping(value={"/supplier/partnershipInvitation"})
public class PartnershipInvitationController
extends BaseController<PartnershipInvitation, PartnershipInvitationService> {
    @Autowired
    private PartnershipInvitationService partnershipInvitationService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u53d1\u51fa\u7684\u9080\u7ea6\u5355", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u53d1\u51fa\u7684\u9080\u7ea6\u5355")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"supplier#partnershipInvitation:list"})
    @PermissionDataView(businessType="invitationSent")
    public Result<?> queryPageList(PartnershipInvitation partnershipInvitation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)partnershipInvitation), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.partnershipInvitationService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u6536\u5230\u7684\u9080\u7ea6\u5355", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u6536\u5230\u7684\u9080\u7ea6\u5355")
    @GetMapping(value={"/list-receive"})
    @RequiresPermissions(value={"supplier#partnershipInvitation:list"})
    @PermissionDataView(businessType="invitationReceive")
    public Result<?> queryPageReceiveList(PartnershipInvitation partnershipInvitation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)partnershipInvitation), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.partnershipInvitationService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"supplier#partnershipInvitation:list"})
    @PermissionDataView(businessType="invitationSent")
    public Result<?> queryTabsCount(PartnershipInvitation partnershipInvitation, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)partnershipInvitation), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"confirm_status", "count(0) as participateQuantity"});
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"confirm_status");
        List list = ((PartnershipInvitationService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PartnershipInvitation::getConfirmStatus, PartnershipInvitation::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "confirmStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("InvitationConfirmStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "confirmStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @GetMapping(value={"/counts-receive"})
    @RequiresPermissions(value={"supplier#partnershipInvitation:list"})
    @PermissionDataView(businessType="invitationReceive")
    public Result<?> queryReceiveTabsCount(PartnershipInvitation partnershipInvitation, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)partnershipInvitation), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"confirm_status", "count(0) as participateQuantity"});
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"confirm_status");
        List list = ((PartnershipInvitationService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PartnershipInvitation::getConfirmStatus, PartnershipInvitation::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "confirmStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("InvitationConfirmStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "confirmStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u5408\u4f5c\u9080\u7ea6\u8bb0\u5f55-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"supplier#partnershipInvitation:save"})
    public Result<?> add(@RequestBody InvitationVO invitationVO) {
        this.partnershipInvitationService.add(invitationVO);
        return Result.ok((Object)invitationVO);
    }

    @AutoLog(value="\u5408\u4f5c\u9080\u7ea6\u8bb0\u5f55-\u63d0\u9192")
    @ApiOperation(value="\u63d0\u9192", notes="\u63d0\u9192")
    @PostMapping(value={"/remind"})
    @RequiresPermissions(value={"supplier#partnershipInvitation:remind"})
    public Result<?> remind(@RequestBody PartnershipInvitation partnershipInvitation) {
        this.partnershipInvitationService.remind(partnershipInvitation);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5408\u4f5c\u9080\u7ea6\u8bb0\u5f55-\u786e\u8ba4")
    @ApiOperation(value="\u786e\u8ba4", notes="\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"supplier#partnershipInvitation:confirm"})
    public Result<?> confirm(@RequestBody InvitationVO invitationVO) {
        return Result.ok((String)this.partnershipInvitationService.confirm(invitationVO));
    }

    @AutoLog(value="\u5408\u4f5c\u9080\u7ea6\u8bb0\u5f55-\u62d2\u7edd")
    @ApiOperation(value="\u62d2\u7edd", notes="\u62d2\u7edd")
    @PostMapping(value={"/reject"})
    @RequiresPermissions(value={"supplier#partnershipInvitation:reject"})
    public Result<?> reject(@RequestBody PartnershipInvitation partnershipInvitation) {
        this.partnershipInvitationService.reject(partnershipInvitation);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"supplier#partnershipInvitation:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PartnershipInvitation partnershipInvitation = (PartnershipInvitation)((Object)this.partnershipInvitationService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)partnershipInvitation));
    }
}

