/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.performance.dto.PurchasePerformanceReportItemDto;
import com.els.modules.performance.entity.PurchasePerformanceReportGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.entity.PurchasePerformanceReportItem;
import com.els.modules.performance.entity.PurchasePerformanceReportNormWeight;
import com.els.modules.performance.entity.PurchasePerformanceReportSupplier;
import com.els.modules.performance.enumerate.PerformanceCreateTypeEnum;
import com.els.modules.performance.enumerate.PerformanceReportSendStatusEnum;
import com.els.modules.performance.enumerate.PerformanceReportStatusEnum;
import com.els.modules.performance.enumerate.ScoreMethodEnum;
import com.els.modules.performance.excel.PurchasePerformanceReportHeadExportServiceImpl;
import com.els.modules.performance.excel.PurchasePerformanceReportItemEvaExportServiceImpl;
import com.els.modules.performance.excel.PurchasePerformanceReportItemEvaImportService;
import com.els.modules.performance.mapper.PurchasePerformanceReportHeadMapper;
import com.els.modules.performance.service.PurchasePerformanceReportGradService;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.service.PurchasePerformanceReportItemService;
import com.els.modules.performance.vo.PurchasePerformanceReportHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/performance/purchasePerformanceReportHead"})
@Api(tags={"\u91c7\u8d2d\u7ee9\u6548"})
@BusinessModule(module="performanceReport")
public class PurchasePerformanceReportHeadController
extends BaseController<PurchasePerformanceReportHead, PurchasePerformanceReportHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceReportHeadController.class);
    @Autowired
    private PurchasePerformanceReportHeadService purchasePerformanceReportHeadService;
    @Autowired
    private PurchasePerformanceReportItemService purchasePerformanceReportItemService;
    @Autowired
    private PurchasePerformanceReportGradService purchasePerformanceReportGradService;
    @Autowired
    private PurchasePerformanceReportHeadMapper purchasePerformanceReportHeadMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchasePerformanceReportItemEvaImportService purchasePerformanceReportItemEvaImportService;

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548-\u5206\u9875\u5217\u8868\u67e5\u8be2", logType=2, busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:list"})
    @PermissionDataView(businessType="performanceReport")
    public Result<?> queryPageList(PurchasePerformanceReportHead purchasePerformanceReportHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="myToDo", defaultValue="0") Boolean myToDo, HttpServletRequest req) {
        Page page;
        IPage pageList;
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchasePerformanceReportHead), (Map)req.getParameterMap());
        if (myToDo.booleanValue()) {
            LoginUser loginUser = SysUtil.getLoginUser();
            queryWrapper.exists("select 1 from purchase_performance_report_item where purchase_performance_report_item.head_id = purchase_performance_report_head.id and els_account = '" + loginUser.getElsAccount() + "' and sub_account like '" + loginUser.getSubAccount() + "_%' and is_deleted = '0'");
        }
        if ((pageList = this.purchasePerformanceReportHeadService.page((IPage)(page = new Page((long)pageNo.intValue(), (long)pageSize.intValue())), (Wrapper)queryWrapper)).getRecords().isEmpty()) {
            return Result.ok((Object)pageList);
        }
        List headIds = pageList.getRecords().stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.select(new SFunction[]{PurchasePerformanceReportItem::getHeadId, PurchasePerformanceReportItem::getScorer}).in(PurchasePerformanceReportItem::getScoringMethod, (Collection)Lists.newArrayList((Object[])new String[]{ScoreMethodEnum.MANUAL_SCORE_NORM.getValue(), ScoreMethodEnum.MANUAL_SCORE.getValue()}))).in(PurchasePerformanceReportItem::getHeadId, headIds);
        List itemList = this.purchasePerformanceReportItemService.list((Wrapper)wrapper);
        Map groupMap = itemList.stream().collect(Collectors.groupingBy(PurchasePerformanceReportItem::getHeadId, Collectors.mapping(PurchasePerformanceReportItem::getScorer, Collectors.toList())));
        IPage result = (IPage)Convert.convert(IPage.class, (Object)pageList);
        String subAccount = SysUtil.getLoginUser().getSubAccount() + "_" + SysUtil.getLoginUser().getRealname();
        List voList = Convert.toList(PurchasePerformanceReportHeadVO.class, (Object)pageList.getRecords());
        for (PurchasePerformanceReportHeadVO vo : voList) {
            List list = groupMap.get(vo.getId());
            if (CollUtil.isNotEmpty(list)) {
                List collect = list.stream().filter(CharSequenceUtil::isNotEmpty).map(x -> x.split("_")[0]).collect(Collectors.toList());
                if (list.contains(subAccount) || collect.contains(SysUtil.getLoginUser().getSubAccount())) {
                    vo.setCanScorer(true);
                    continue;
                }
            }
            vo.setCanScorer(false);
        }
        result.setRecords(voList);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u8d22\u52a1\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u884c", notes="\u8d22\u52a1\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u884c")
    @GetMapping(value={"/financeQuerySample"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:list"})
    @PermissionDataView(businessType="performanceReport")
    public Result<?> financeQuerySample(PurchasePerformanceReportHead purchasePerformanceReportHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String keyWord;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (req.getParameterMap().get("keyWord") != null && ((String[])req.getParameterMap().get("keyWord")).length > 0 && !StringUtils.isEmpty((CharSequence)(keyWord = ((String[])req.getParameterMap().get("keyWord"))[0]))) {
            queryWrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.like((Object)"report_number", (Object)keyWord)).or()).like((Object)"report_name", (Object)keyWord));
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchasePerformanceReportHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:add"})
    @PermissionDataOpt(businessType="performanceReport", beanClass=PurchasePerformanceReportHeadService.class)
    public Result<?> add(@RequestBody PurchasePerformanceReportHeadVO purchasePerformanceReportHeadPage) {
        PurchasePerformanceReportHead purchasePerformanceReportHead = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHeadPage), (Object)((Object)purchasePerformanceReportHead));
        List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList = purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList();
        if (purchasePerformanceReportItemList.size() > 0) {
            for (PurchasePerformanceReportItemDto list : purchasePerformanceReportItemList) {
                if (list.getScore() == null || purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList().get(0).getFullScore().compareTo(purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList().get(0).getScore()) >= 0) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_field_SNzWxOfUkz_7d0be346", (String)"\u586b\u5165\u5206\u6570\u4e0d\u80fd\u5927\u4e8e\u603b\u5206"));
            }
        }
        purchasePerformanceReportHead.setCreationMethod(PerformanceCreateTypeEnum.MANUAL.getValue());
        purchasePerformanceReportHead.setRequiredSend(StrUtil.blankToDefault((CharSequence)purchasePerformanceReportHeadPage.getRequiredSend(), (String)"0"));
        purchasePerformanceReportHead.setRequiredAudit(StrUtil.blankToDefault((CharSequence)purchasePerformanceReportHeadPage.getRequiredAudit(), (String)"1"));
        purchasePerformanceReportHead.setReportStatus(PerformanceReportStatusEnum.NEW.getValue());
        purchasePerformanceReportHead.setSendStatus(PerformanceReportSendStatusEnum.NOT_SENT_YET.getValue());
        purchasePerformanceReportHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.purchasePerformanceReportHeadService.saveMainNew(purchasePerformanceReportHead, purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList(), purchasePerformanceReportHeadPage.getPurchasePerformanceNormGradList(), purchasePerformanceReportHeadPage.getPurchasePerformanceReportNormWeightList(), purchasePerformanceReportHeadPage.getPurchasePerformanceReportSupplierList(), purchasePerformanceReportHeadPage.getPurchasePerformanceReportAttachmentList());
        return Result.ok((Object)((Object)purchasePerformanceReportHead));
    }

    @SrmValidated
    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u7f16\u8f91", busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:edit"})
    @PermissionDataOpt(businessType="performanceReport", beanClass=PurchasePerformanceReportHeadService.class)
    public Result<?> edit(@RequestBody PurchasePerformanceReportHeadVO purchasePerformanceReportHeadPage) {
        if (!PerformanceReportStatusEnum.NEW.getValue().equals(purchasePerformanceReportHeadPage.getReportStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tXsBIhxWxqAt_1b86d147", (String)"\u7ee9\u6548\u62a5\u8868\u5df2\u53d1\u5e03,\u4e0d\u53ef\u7f16\u8f91"));
        }
        List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList = purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList();
        if (purchasePerformanceReportItemList.size() > 0) {
            for (Object list : purchasePerformanceReportItemList) {
                if (list.getScore() == null || purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList().get(0).getFullScore().compareTo(purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList().get(0).getScore()) >= 0) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_field_SNzWxOfUkz_7d0be346", (String)"\u586b\u5165\u5206\u6570\u4e0d\u80fd\u5927\u4e8e\u603b\u5206"));
            }
        }
        PurchasePerformanceReportHead purchasePerformanceReportHead = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHeadPage), (Object)((Object)purchasePerformanceReportHead));
        if ("1".equals(purchasePerformanceReportHead.getRequiredAudit())) {
            purchasePerformanceReportHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchasePerformanceReportHead.setRequiredAudit("0");
            purchasePerformanceReportHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        purchasePerformanceReportHead.setReportStatus(PerformanceReportStatusEnum.NEW.getValue());
        purchasePerformanceReportHead.setPerformanceRate(null);
        purchasePerformanceReportHead.setPerformanceScore(null);
        for (PurchasePerformanceReportItem purchasePerformanceReportItem : purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList()) {
            purchasePerformanceReportItem.setScoreTime(null);
            purchasePerformanceReportItem.setScore(purchasePerformanceReportItem.getScore());
            purchasePerformanceReportItem.setNormValue(null);
        }
        this.purchasePerformanceReportHeadService.updateMainNew(purchasePerformanceReportHead, purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList(), purchasePerformanceReportHeadPage.getPurchasePerformanceNormGradList(), purchasePerformanceReportHeadPage.getPurchasePerformanceReportNormWeightList(), purchasePerformanceReportHeadPage.getPurchasePerformanceReportSupplierList(), purchasePerformanceReportHeadPage.getPurchasePerformanceReportAttachmentList());
        String id = purchasePerformanceReportHead.getId();
        return this.queryById(id);
    }

    @SrmValidated
    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u8bc4\u5206")
    @ApiOperation(value="\u8bc4\u5206", notes="\u8bc4\u5206")
    @PostMapping(value={"/evaOpt"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:evaOpt"})
    @PermissionDataOpt(businessType="performanceReport", beanClass=PurchasePerformanceReportHeadService.class)
    public Result<?> evaOpt(@RequestBody PurchasePerformanceReportHeadVO purchasePerformanceReportHeadPage) {
        PurchasePerformanceReportHead purchasePerformanceReportHead = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHeadPage), (Object)((Object)purchasePerformanceReportHead));
        List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList = purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList();
        if (purchasePerformanceReportItemList.size() > 0) {
            for (PurchasePerformanceReportItemDto list : purchasePerformanceReportItemList) {
                if (list.getScore() == null || purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList().get(0).getFullScore().compareTo(purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList().get(0).getScore()) >= 0) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_field_SNzWxOfUkz_7d0be346", (String)"\u586b\u5165\u5206\u6570\u4e0d\u80fd\u5927\u4e8e\u603b\u5206"));
            }
        }
        this.purchasePerformanceReportHeadService.evaOpt(purchasePerformanceReportHead, purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList());
        return Result.ok((Object)((Object)purchasePerformanceReportHead));
    }

    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u8bc4\u5206\u8f6c\u529e")
    @ApiOperation(value="\u8bc4\u5206\u8f6c\u529e", notes="\u8bc4\u5206\u8f6c\u529e")
    @PostMapping(value={"/evaTransfer"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:evaOpt"})
    @PermissionDataOpt(businessType="performanceReport", beanClass=PurchasePerformanceReportHeadService.class)
    public Result<?> evaTransfer(@RequestBody List<String> ids, @RequestParam(value="transferAccount") String transferAccount) {
        this.purchasePerformanceReportHeadService.evaTransfer(ids, transferAccount);
        return Result.ok();
    }

    @SrmValidated
    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u8bc4\u5206\u4fdd\u5b58")
    @ApiOperation(value="\u8bc4\u5206\u4fdd\u5b58", notes="\u8bc4\u5206\u4fdd\u5b58")
    @PostMapping(value={"/evaOptSave"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:evaOpt"})
    @PermissionDataOpt(businessType="performanceReport", beanClass=PurchasePerformanceReportHeadService.class)
    public Result<?> evaOptSave(@RequestBody PurchasePerformanceReportHeadVO purchasePerformanceReportHeadPage) {
        PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)purchasePerformanceReportHeadPage.getId())));
        List itemList = Convert.toList(PurchasePerformanceReportItem.class, purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList());
        this.purchasePerformanceReportHeadService.evaOptSave(head, itemList);
        return Result.ok((Object)((Object)head));
    }

    @SrmValidated
    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u8bc4\u5206\u63d0\u4ea4")
    @ApiOperation(value="\u8bc4\u5206\u63d0\u4ea4", notes="\u8bc4\u5206\u63d0\u4ea4")
    @PostMapping(value={"/evaOptSubmit"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:evaOpt"})
    public Result<?> evaOptSubmit(@RequestBody PurchasePerformanceReportHeadVO purchasePerformanceReportHeadPage) {
        List<PurchasePerformanceReportItem> itemList;
        PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)purchasePerformanceReportHeadPage.getId())));
        List<PurchasePerformanceReportItem> newItemList = Convert.toList(PurchasePerformanceReportItem.class, purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"head_id", (Object)head.getId());
        List reportItemList = this.purchasePerformanceReportItemService.list((Wrapper)queryWrapper);
        List<PurchasePerformanceReportItem> oldItemList = this.queryEvaByIdListToReportItems(reportItemList);
        if (newItemList.size() == oldItemList.size()) {
            itemList = newItemList;
            this.beforeEvaOptSubmit(itemList);
        } else if (CollectionUtils.isEmpty((Collection)newItemList)) {
            itemList = oldItemList;
            this.beforeEvaOptSubmit(itemList);
        } else {
            itemList = new ArrayList<PurchasePerformanceReportItem>();
            for (PurchasePerformanceReportItem old : oldItemList) {
                Optional<PurchasePerformanceReportItem> first = newItemList.stream().filter(o -> old.getId().equals(o.getId())).findFirst();
                if (first.isPresent()) {
                    PurchasePerformanceReportItem item = first.get();
                    itemList.add(item);
                    continue;
                }
                itemList.add(old);
            }
            this.beforeEvaOptSubmitOther(itemList);
        }
        this.purchasePerformanceReportHeadService.evaOptSubmit(head, itemList);
        return Result.ok((Object)((Object)head));
    }

    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u62c9\u53d6\u6700\u65b0\u7684\u7ee9\u6548")
    @ApiOperation(value="\u62c9\u53d6\u6700\u65b0\u7684\u7ee9\u6548", notes="\u62c9\u53d6\u6700\u65b0\u7684\u7ee9\u6548")
    @GetMapping(value={"/getLastPerformance"})
    @PermissionDataView(businessType="performanceReport")
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:list"})
    public Result<?> getLastPerformance(@RequestParam String toElsAccount) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(PurchasePerformanceReportHead::getToElsAccount, (Object)toElsAccount);
        lambdaQueryWrapper.eq(PurchasePerformanceReportHead::getReportStatus, (Object)PerformanceReportStatusEnum.EVA_COMPLETED.getValue());
        lambdaQueryWrapper.orderByDesc(BaseEntity::getCreateTime);
        lambdaQueryWrapper.last(" limit 1");
        PurchasePerformanceReportHead purchasePerformanceReportHead = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadMapper.selectOne((Wrapper)lambdaQueryWrapper));
        return Result.ok((Object)((Object)purchasePerformanceReportHead));
    }

    @SrmValidated
    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u53d1\u5e03", logType=2, busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:publish"})
    @PermissionDataOpt(businessType="performanceReport", beanClass=PurchasePerformanceReportHeadService.class)
    public Result<?> publish(@RequestBody PurchasePerformanceReportHeadVO purchasePerformanceReportHeadPage) {
        PurchasePerformanceReportHead head = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHeadPage), (Object)((Object)head));
        List<PurchasePerformanceReportItemDto> itemDtoList = purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList();
        List<PurchasePerformanceReportNormWeight> normWeightList = purchasePerformanceReportHeadPage.getPurchasePerformanceReportNormWeightList();
        List<PurchasePerformanceReportSupplier> supplierList = purchasePerformanceReportHeadPage.getPurchasePerformanceReportSupplierList();
        List<PurchasePerformanceReportGrad> gradList = purchasePerformanceReportHeadPage.getPurchasePerformanceNormGradList();
        List<PurchaseAttachmentDTO> attachmentList = purchasePerformanceReportHeadPage.getPurchasePerformanceReportAttachmentList();
        this.beforePushCheck(purchasePerformanceReportHeadPage, head, itemDtoList, normWeightList, supplierList, gradList);
        this.purchasePerformanceReportHeadService.performancePublishNew(head, itemDtoList, gradList, normWeightList, supplierList, attachmentList);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u53d1\u9001", logType=2, busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u53d1\u9001", notes="\u53d1\u9001")
    @PostMapping(value={"/send"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:send"})
    @PermissionDataOpt(businessType="performanceReport", beanClass=PurchasePerformanceReportHeadService.class)
    public Result<?> send(@RequestBody PurchasePerformanceReportHeadVO purchasePerformanceReportHeadPage) {
        PurchasePerformanceReportHead purchasePerformanceReportHead = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHeadPage), (Object)((Object)purchasePerformanceReportHead));
        purchasePerformanceReportHead.setSendStatus(PerformanceReportSendStatusEnum.HAS_BEEN_SENT.getValue());
        this.purchasePerformanceReportHeadService.sendReportToSale(purchasePerformanceReportHead, purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664", busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:delete"})
    @PermissionDataOpt(businessType="performanceReport", beanClass=PurchasePerformanceReportHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchasePerformanceReportHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u6279\u91cf\u5220\u9664", busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchasePerformanceReportHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2", busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"performanceTemplate#PurchasePerformanceTemplateHead:view"})
    @PermissionDataOpt(businessType="performanceReport", beanClass=PurchasePerformanceReportHeadService.class)
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        return Result.ok((Object)((Object)this.purchasePerformanceReportHeadService.queryById(id)));
    }

    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2\u8bc4\u5206\u5217\u8868", busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u8bc4\u5206\u5217\u8868", notes="\u901a\u8fc7id\u67e5\u8be2\u8bc4\u5206\u5217\u8868")
    @GetMapping(value={"/queryEvaById"})
    @RequiresPermissions(value={"performanceTemplate#PurchasePerformanceTemplateHead:view"})
    public Result<?> queryEvaById(@RequestParam(name="id", required=true) String id) {
        PurchasePerformanceReportHead purchasePerformanceReportHead = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchasePerformanceReportHeadVO purchasePerformanceReportHeadVO = new PurchasePerformanceReportHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHead), (Object)((Object)purchasePerformanceReportHeadVO));
        List<PurchasePerformanceReportItem> purchasePerformanceReportItemList = this.purchasePerformanceReportItemService.selectByMainId(id);
        String subAccount = this.getCurrentUser().getSubAccount();
        List itemList = purchasePerformanceReportItemList.stream().filter(o -> ScoreMethodEnum.isScoreByManual(o.getScoringMethod()) && CharSequenceUtil.isNotBlank((CharSequence)o.getSubAccount()) && o.getSubAccount().split("_")[0].equals(subAccount)).collect(Collectors.toList());
        purchasePerformanceReportHeadVO.setPurchasePerformanceReportItemList(Convert.toList(PurchasePerformanceReportItemDto.class, itemList));
        return Result.ok((Object)((Object)purchasePerformanceReportHeadVO));
    }

    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2\u8bc4\u5206\u5217\u8868", busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u8bc4\u5206\u5217\u8868", notes="\u901a\u8fc7id\u67e5\u8be2\u8bc4\u5206\u5217\u8868")
    @GetMapping(value={"/queryEvaByIdList"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:evaOpt"})
    public Result<?> queryEvaByIdList(PurchasePerformanceReportItem item, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        queryWrapper.orderByAsc((Object[])new String[]{"norm_type_sort", "norm_sort"});
        List purchasePerformanceReportItemList = this.purchasePerformanceReportItemService.list((Wrapper)queryWrapper);
        List<PurchasePerformanceReportItem> itemList = this.queryEvaByIdListToReportItems(purchasePerformanceReportItemList);
        return Result.ok(itemList);
    }

    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @PostMapping(value={"/queryEvaExportXls"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:export"})
    public ModelAndView queryEvaExportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchasePerformanceReportItemEvaExportServiceImpl.class);
    }

    @ApiOperation(value="\u5bfc\u5165", notes="\u5bfc\u5165")
    @PostMapping(value={"/evaImportExcel"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:import"})
    public Result<?> importExcel(HttpServletRequest request) {
        String id = request.getParameter("id");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile file = (MultipartFile)fileMap.get("file");
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
        }
        catch (IOException e) {
            log.error("\u5bfc\u5165Excel\u6570\u636e\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return Result.error((String)I18nUtil.translate((String)"i18n__uNWWWWWWFQIKmW_c5c74f92", (String)"\u5bfc\u5165Excel\u6570\u636e\u6587\u4ef6\u5931\u8d25!"));
        }
        String fileSuffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        if (!"xlsx".equals(fileSuffix) && !"xls".equals(fileSuffix)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ROuNWWWWWQI_974a414a", (String)"\u53ea\u80fd\u5bfc\u5165excel\u6587\u4ef6"));
        }
        Result<?> result = this.purchasePerformanceReportItemEvaImportService.importExcel(id, inputStream);
        return result;
    }

    @AutoLog(value="\u7ee9\u6548\u7ba1\u7406\u62a5\u8868-\u4f9b\u5e94\u5546\u753b\u50cf", busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u7ee9\u6548\u7ba1\u7406\u62a5\u8868-\u4f9b\u5e94\u5546\u753b\u50cf", notes="\u7ee9\u6548\u7ba1\u7406\u62a5\u8868-\u4f9b\u5e94\u5546\u753b\u50cf")
    @GetMapping(value={"/getSupplierScore"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:list", "supplier_master_data#supplierMasterData:picImage", "supplier_master_data#supplierMasterData:list", "supplier_master_data#supplierMasterData:supplierPicImage"}, logical=Logical.OR)
    public Result<?> getSupplierCategoryScore(@RequestParam(name="toElsAccount") String toElsAccount) {
        List<PurchasePerformanceReportItem> list = this.purchasePerformanceReportHeadService.getSupplierScore(toElsAccount);
        return Result.ok(list);
    }

    @ApiOperation(value="\u901a\u8fc7\u7ee9\u6548\u7ba1\u7406id\u67e5\u8be2\u7ee9\u6548\u7ba1\u7406\u62a5\u8868\u884c\u8868", notes="\u901a\u8fc7\u7ee9\u6548\u7ba1\u7406id\u67e5\u8be2\u7ee9\u6548\u7ba1\u7406\u62a5\u8868\u884c\u8868")
    @GetMapping(value={"/queryPurchasePerformanceReportItemByMainId"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:list"})
    public Result<?> queryPurchasePerformanceReportItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchasePerformanceReportItem> purchasePerformanceReportItemList = this.purchasePerformanceReportItemService.selectByMainId(id);
        return Result.ok(purchasePerformanceReportItemList);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:export"})
    @PermissionDataView(businessType="performanceReport")
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchasePerformanceReportHeadExportServiceImpl.class);
    }

    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="performanceReport")
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:list"})
    public Result<?> queryTabsCount(PurchasePerformanceReportHead purchasePerformanceReportHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchasePerformanceReportHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"report_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"report_status");
        List list = ((PurchasePerformanceReportHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchasePerformanceReportHead::getReportStatus, PurchasePerformanceReportHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "reportStatus", null, all));
        List srmStatusDictList = this.invokeBaseRpcService.queryDictItemsByCode("performanceReportStatus", TenantContext.getTenant());
        for (DictDTO status : srmStatusDictList) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "reportStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u7ee9\u6548\u62a5\u8868-\u590d\u5236")
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copy"})
    @RequiresPermissions(value={"performanceReport#PurchasePerformanceReportHead:copy"})
    @PermissionDataOpt(businessType="performanceReport", beanClass=PurchasePerformanceReportHeadService.class)
    public Result<?> copy(@RequestParam String id) {
        PurchasePerformanceReportHead head = this.purchasePerformanceReportHeadService.copy(id);
        return Result.ok((Object)((Object)head));
    }

    public List<PurchasePerformanceReportItem> queryEvaByIdListToReportItems(List<PurchasePerformanceReportItem> purchasePerformanceReportItemList) {
        String subAccount = this.getCurrentUser().getSubAccount();
        return purchasePerformanceReportItemList.stream().filter(o -> ScoreMethodEnum.isScoreByManual(o.getScoringMethod()) && CharSequenceUtil.isNotBlank((CharSequence)o.getSubAccount()) && o.getSubAccount().split("_")[0].equals(subAccount)).collect(Collectors.toList());
    }

    public void beforePushCheck(@RequestBody PurchasePerformanceReportHeadVO headVO, PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> itemDtoList, List<PurchasePerformanceReportNormWeight> normWeightList, List<PurchasePerformanceReportSupplier> supplierList, List<PurchasePerformanceReportGrad> gradList) {
        Assert.isNotEmpty(itemDtoList, (String)I18nUtil.translate((String)"i18n_alert_VSMsBcWF_a9fada62", (String)"\u8bf7\u586b\u5199\u62a5\u8868\u884c\u6570\u636e"));
        Assert.isNotEmpty(gradList, (String)I18nUtil.translate((String)"i18n_alert_VSMUzHFcWF_2b88a70", (String)"\u8bf7\u586b\u5199\u8bc4\u5206\u7ec6\u5219\u884c\u6570\u636e"));
        Assert.isNotEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_VSMKdRdXEWF_401ca134", (String)"\u8bf7\u586b\u5199\u9002\u5e94\u4f9b\u5e94\u5546\u884c\u6570\u636e"));
        Boolean isWeightStrategy = "1".equals(head.getIsWeightStrategy());
        if (CollectionUtils.isNotEmpty(itemDtoList)) {
            for (PurchasePerformanceReportItemDto itemDto : itemDtoList) {
                if (itemDto.getScore() != null && itemDto.getFullScore().compareTo(itemDto.getScore()) < 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_field_SNzWxOfUkz_7d0be346", (String)"\u586b\u5165\u5206\u6570\u4e0d\u80fd\u5927\u4e8e\u603b\u5206"));
                }
                if (isWeightStrategy.booleanValue() && !"1".equals(itemDto.getAttachNorm())) {
                    if (itemDto.getNormWeight() == null) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WtXsBcVHWjWRBbsWWxOV_46b82620", (String)"\u3010\u7ee9\u6548\u62a5\u8868\u884c\u4fe1\u606f\u3011\u7684 \u6307\u6807\u6743\u91cd% \u4e0d\u80fd\u7a7a"));
                    }
                    if (BigDecimal.ZERO.compareTo(itemDto.getNormWeight()) == 0) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WtXsBcVHWjWRBbsWWxOLW_90474250", (String)"\u3010\u7ee9\u6548\u62a5\u8868\u884c\u4fe1\u606f\u3011\u7684 \u6307\u6807\u6743\u91cd% \u4e0d\u80fd\u4e3a0"));
                    }
                    if (BigDecimal.ZERO.compareTo(itemDto.getNormWeight()) > 0) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WtXsBcVHWjWRBbsWWxOSMBW_a16501d9", (String)"\u3010\u7ee9\u6548\u62a5\u8868\u884c\u4fe1\u606f\u3011\u7684 \u6307\u6807\u6743\u91cd% \u4e0d\u80fd\u586b\u5199\u8d1f\u6570"));
                    }
                }
                if (!ScoreMethodEnum.isScoreByManual(itemDto.getScoringMethod()) || !StringUtils.isBlank((CharSequence)itemDto.getSubAccount())) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WtXsBcVHWjWRBAcLWlRSMRBWSNWlRSMjzWjWUzBFLWxOLV_5df2c868", (String)"\u3010\u7ee9\u6548\u62a5\u8868\u884c\u4fe1\u606f\u3011\u7684 \u6307\u6807\u7c7b\u578b\u4e3a\uff08\u624b\u5de5\u586b\u5199\u6307\u6807 \u6216\u8005 \u624b\u5de5\u586b\u5199\u5f97\u5206\uff09\u7684<\u8bc4\u5206\u8d1f\u8d23\u4eba>\u4e0d\u80fd\u4e3a\u7a7a"));
            }
        }
        if (isWeightStrategy.booleanValue()) {
            Assert.isNotEmpty(normWeightList, (String)I18nUtil.translate((String)"i18n_alert_WRBAcbVcWFWxOLV_a3b4c1e1", (String)"\u3010\u6307\u6807\u7c7b\u578b\u6743\u91cd\u884c\u6570\u636e\u3011\u4e0d\u80fd\u4e3a\u7a7a"));
            for (PurchasePerformanceReportNormWeight weight : normWeightList) {
                if (weight.getNormWeight() == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WRBAcbVcWFWjWRBbsWWxOV_cde30158", (String)"\u3010\u6307\u6807\u7c7b\u578b\u6743\u91cd\u884c\u6570\u636e\u3011\u7684 \u6307\u6807\u6743\u91cd% \u4e0d\u80fd\u7a7a"));
                }
                if (BigDecimal.ZERO.compareTo(weight.getNormWeight()) == 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WRBAcbVcWFWjWRBbsWWxOLW_ee77ce18", (String)"\u3010\u6307\u6807\u7c7b\u578b\u6743\u91cd\u884c\u6570\u636e\u3011\u7684 \u6307\u6807\u6743\u91cd% \u4e0d\u80fd\u4e3a0"));
                }
                if (BigDecimal.ZERO.compareTo(weight.getNormWeight()) <= 0) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WRBAcbVcWFWjWRBbsWWxOSMBW_35a1bba1", (String)"\u3010\u6307\u6807\u7c7b\u578b\u6743\u91cd\u884c\u6570\u636e\u3011\u7684 \u6307\u6807\u6743\u91cd% \u4e0d\u80fd\u586b\u5199\u8d1f\u6570"));
            }
        }
        if (!PerformanceReportStatusEnum.NEW.getValue().equals(headVO.getReportStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tXsBIhx_f88b0862", (String)"\u7ee9\u6548\u62a5\u8868\u5df2\u53d1\u5e03"));
        }
    }

    public void beforeEvaOptSubmit(List<PurchasePerformanceReportItem> itemList) {
        for (int i = 0; i < itemList.size(); ++i) {
            if (itemList.get(i).getNormValue() == null && ScoreMethodEnum.MANUAL_SCORE_NORM.getValue().equals(itemList.get(i).getScoringMethod())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_TyWWWWWLHcUz_64e4b09d", (String)"\u5e8f\u53f7${0}\uff0c\u672a\u8fdb\u884c\u8bc4\u5206", (String[])new String[]{String.valueOf(i + 1)}));
            }
            if (itemList.get(i).getScore() == null && ScoreMethodEnum.MANUAL_SCORE.getValue().equals(itemList.get(i).getScoringMethod())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_TyWWWWWLHcUz_64e4b09d", (String)"\u5e8f\u53f7${0}\uff0c\u672a\u8fdb\u884c\u8bc4\u5206", (String[])new String[]{String.valueOf(i + 1)}));
            }
            if (itemList.get(i).getFullScore() == null || !ScoreMethodEnum.MANUAL_SCORE.getValue().equals(itemList.get(i).getScoringMethod()) || itemList.get(i).getScore().compareTo(itemList.get(i).getFullScore()) <= 0) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_TyWWWWWjzxOfUCz_6aad9e4b", (String)"\u5e8f\u53f7${0}\uff0c\u5f97\u5206\u4e0d\u80fd\u5927\u4e8e\u6ee1\u5206", (String[])new String[]{String.valueOf(i + 1)}));
        }
    }

    public void beforeEvaOptSubmitOther(List<PurchasePerformanceReportItem> itemList) {
        for (int i = 0; i < itemList.size(); ++i) {
            if (itemList.get(i).getNormValue() == null && ScoreMethodEnum.MANUAL_SCORE_NORM.getValue().equals(itemList.get(i).getScoringMethod())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RBAoWWWWWWRdXWWWeyWWWWWLHcUz_bd3bbc7", (String)"\u6307\u6807\u7f16\u7801${0}, \u4f9b\u5e94\u5546ELS\u8d26\u53f7${1}\uff0c\u672a\u8fdb\u884c\u8bc4\u5206", (String[])new String[]{itemList.get(i).getNormNumber(), itemList.get(i).getToElsAccount()}));
            }
            if (itemList.get(i).getScore() == null && ScoreMethodEnum.MANUAL_SCORE.getValue().equals(itemList.get(i).getScoringMethod())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RBAoWWWWWWRdXWWWeyWWWWWLHcUz_bd3bbc7", (String)"\u6307\u6807\u7f16\u7801${0}, \u4f9b\u5e94\u5546ELS\u8d26\u53f7${1}\uff0c\u672a\u8fdb\u884c\u8bc4\u5206", (String[])new String[]{itemList.get(i).getNormNumber(), itemList.get(i).getToElsAccount()}));
            }
            if (itemList.get(i).getFullScore() == null || !ScoreMethodEnum.MANUAL_SCORE.getValue().equals(itemList.get(i).getScoringMethod()) || itemList.get(i).getScore().compareTo(itemList.get(i).getFullScore()) <= 0) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n__RBAoWWWWWWRdXWWWeyWWWWWjzxOfUCz_ae71cae1", (String)"\u6307\u6807\u7f16\u7801${0}, \u4f9b\u5e94\u5546ELS\u8d26\u53f7${1}\uff0c\u5f97\u5206\u4e0d\u80fd\u5927\u4e8e\u6ee1\u5206", (String[])new String[]{itemList.get(i).getNormNumber(), itemList.get(i).getToElsAccount()}));
        }
    }
}

