/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.poi.excel.entity.vo.ExcelTemplateHeadVO;
import com.els.common.excel.service.BaseExportService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.performance.entity.PurchasePerformanceReportItem;
import com.els.modules.performance.enumerate.ScoreMethodEnum;
import com.els.modules.performance.service.PurchasePerformanceReportItemService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchasePerformanceReportItemEvaExportServiceImpl")
public class PurchasePerformanceReportItemEvaExportServiceImpl
extends BaseExportService<PurchasePerformanceReportItem, PurchasePerformanceReportItem, PurchasePerformanceReportItem>
implements ExportDataLoaderService {
    @Autowired
    private PurchasePerformanceReportItemService purchasePerformanceReportItemService;

    public List<PurchasePerformanceReportItem> queryExportData(QueryWrapper<PurchasePerformanceReportItem> queryWrapper, PurchasePerformanceReportItem map, Map<String, String[]> paramMap) {
        List<String> selectionList;
        String selections;
        String[] selectionArray = paramMap.get("selectionsList");
        if (null != selectionArray && selectionArray.length > 0 && ConvertUtils.isNotEmpty((Object)(selections = selectionArray[0])) && CollUtil.isNotEmpty(selectionList = Arrays.asList(selections.split(",")))) {
            queryWrapper.clear();
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
            queryWrapper.in((Object)"id", selectionList);
            queryWrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        }
        List purchasePerformanceReportItemList = this.purchasePerformanceReportItemService.list((Wrapper)queryWrapper);
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        List<PurchasePerformanceReportItem> itemList = purchasePerformanceReportItemList.stream().filter(o -> ScoreMethodEnum.isScoreByManual(o.getScoringMethod()) && CharSequenceUtil.isNotBlank((CharSequence)o.getSubAccount()) && o.getSubAccount().split("_")[0].equals(subAccount)).collect(Collectors.toList());
        if (itemList.isEmpty() || itemList.size() == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        return itemList;
    }

    public long queryExportDataCount(QueryWrapper<PurchasePerformanceReportItem> queryWrapper, PurchasePerformanceReportItem map, Map<String, String[]> paramMap) {
        List<String> selectionList;
        String selections;
        String[] selectionArray = paramMap.get("selectionsList");
        if (null != selectionArray && selectionArray.length > 0 && ConvertUtils.isNotEmpty((Object)(selections = selectionArray[0])) && CollUtil.isNotEmpty(selectionList = Arrays.asList(selections.split(",")))) {
            queryWrapper.clear();
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
            queryWrapper.in((Object)"id", selectionList);
            queryWrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        }
        List purchasePerformanceReportItemList = this.purchasePerformanceReportItemService.list((Wrapper)queryWrapper);
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        long count = purchasePerformanceReportItemList.stream().filter(o -> ScoreMethodEnum.isScoreByManual(o.getScoringMethod()) && CharSequenceUtil.isNotBlank((CharSequence)o.getSubAccount()) && o.getSubAccount().split("_")[0].equals(subAccount)).count();
        return count;
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> map, Map<String, String[]> paramMap) {
        List<String> selectionList;
        String selections;
        QueryWrapper queryWrapper = this.builderWrapper(map, paramMap);
        String[] selectionArray = paramMap.get("selectionsList");
        if (null != selectionArray && selectionArray.length > 0 && ConvertUtils.isNotEmpty((Object)(selections = selectionArray[0])) && CollUtil.isNotEmpty(selectionList = Arrays.asList(selections.split(",")))) {
            queryWrapper.clear();
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
            queryWrapper.in((Object)"id", selectionList);
            queryWrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        }
        List purchasePerformanceReportItemList = this.purchasePerformanceReportItemService.list((Wrapper)queryWrapper);
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        List itemList = purchasePerformanceReportItemList.stream().filter(o -> ScoreMethodEnum.isScoreByManual(o.getScoringMethod()) && CharSequenceUtil.isNotBlank((CharSequence)o.getSubAccount()) && o.getSubAccount().split("_")[0].equals(subAccount)).collect(Collectors.toList());
        if (itemList.isEmpty() || itemList.size() == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        return JSON.toJSONString(itemList);
    }

    public String getBusinessType() {
        return "purchasePerformanceReportItemEvaList";
    }

    public String getBeanName() {
        return "purchasePerformanceReportItemEvaExportExcelDataBatchQueryLoader";
    }

    public ExcelTemplateHeadVO buildTemplateHeadVO(Map<String, Object> map) {
        TemplateHeadDTO headDTO = new TemplateHeadDTO();
        ArrayList headList = Lists.newArrayList();
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_field_tFWW_2756b994", (String)"\u5355\u636eID"), "id", "", ""));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_field_normNumber", (String)"\u6307\u6807\u7f16\u7801"), "normNumber", "", ""));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_title_indexName", (String)"\u6307\u6807\u540d\u79f0"), "normName", "", ""));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_field_normType", (String)"\u6307\u6807\u7c7b\u578b"), "normType", "", ""));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_field_RBAcbsWWW_19bd8152", (String)"\u6307\u6807\u7c7b\u578b\u6743\u91cd(%)'"), "normTypeWeight", "", "##"));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_title_scoringMethod", (String)"\u6253\u5206\u65b9\u5f0f"), "scoringMethod_dictText", "", ""));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_title_supplierELSAccount", (String)"\u4f9b\u5e94\u5546ELS\u8d26\u53f7"), "toElsAccount", "", ""));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_field_supplierName", (String)"\u4f9b\u5e94\u5546\u540d\u79f0"), "supplierName", "", ""));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_title_fullMark", (String)"\u6ee1\u5206"), "fullScore", "", "##"));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_field_RBbsWWW_f094edc2", (String)"\u6307\u6807\u6743\u91cd(%)"), "normWeight", "", "##"));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_title_indexValue", (String)"\u6307\u6807\u503c"), "normValue", "", "##"));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_title_getScore", (String)"\u5f97\u5206"), "score", "", "##"));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_field_bszW_311e5494", (String)"\u6743\u91cd\u5206\u6570"), "weightScore", "", "##"));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_title_scoringPerson", (String)"\u8bc4\u5206\u4eba"), "subAccount", "", ""));
        headList.add(this.buildTemplateConfigHeadDTO(I18nUtil.translate((String)"i18n_title_scoringTime", (String)"\u8bc4\u5206\u65f6\u95f4"), "scoreTime", "", ""));
        headDTO.setTemplateConfigHeadList((List)headList);
        headDTO.setTemplateGroupList(new ArrayList());
        return (ExcelTemplateHeadVO)Convert.convert(ExcelTemplateHeadVO.class, (Object)headDTO);
    }

    private TemplateConfigHeadDTO buildTemplateConfigHeadDTO(String fieldLabel, String fieldName, String fieldType, String format) {
        TemplateConfigHeadDTO configHeadDTO = new TemplateConfigHeadDTO();
        configHeadDTO.setFieldLabel(fieldLabel);
        configHeadDTO.setFieldName(fieldName);
        configHeadDTO.setFieldType(fieldType);
        configHeadDTO.setDataFormat(format);
        return configHeadDTO;
    }
}

