/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.performance.entity.PurchaseNewPerformanceReportHead;
import com.els.modules.performance.entity.PurchaseNewPerformanceReportItem;
import com.els.modules.performance.entity.PurchaseNewPerformanceReportItemGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.entity.PurchasePerformanceReportItem;
import com.els.modules.performance.entity.PurchasePerformanceReportItemGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportSupplier;
import com.els.modules.performance.entity.SaleNewPerformanceReportHead;
import com.els.modules.performance.entity.SaleNewPerformanceReportItem;
import com.els.modules.performance.entity.SaleNewPerformanceReportItemGrad;
import com.els.modules.performance.enumerate.PerformanceReportSendStatusEnum;
import com.els.modules.performance.mapper.PurchaseNewPerformanceReportHeadMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportItemGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportSupplierMapper;
import com.els.modules.performance.service.PurchaseNewPerformanceReportHeadService;
import com.els.modules.performance.service.PurchaseNewPerformanceReportItemGradService;
import com.els.modules.performance.service.PurchaseNewPerformanceReportItemService;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.service.SaleNewPerformanceReportHeadService;
import com.els.modules.performance.service.SaleNewPerformanceReportItemGradService;
import com.els.modules.performance.service.SaleNewPerformanceReportItemService;
import com.els.modules.performance.vo.PerformanceReportVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseNewPerformanceReportHeadServiceImpl
extends BaseServiceImpl<PurchaseNewPerformanceReportHeadMapper, PurchaseNewPerformanceReportHead>
implements PurchaseNewPerformanceReportHeadService {
    @Autowired
    private PurchaseNewPerformanceReportItemService purchaseNewPerformanceReportItemService;
    @Autowired
    private PurchaseNewPerformanceReportItemGradService purchaseNewPerformanceReportItemGradService;
    @Resource
    private PurchasePerformanceReportItemGradMapper purchasePerformanceReportItemGradMapper;
    @Autowired
    private SaleNewPerformanceReportHeadService saleNewPerformanceReportHeadService;
    @Autowired
    private SaleNewPerformanceReportItemService saleNewPerformanceReportItemService;
    @Autowired
    private SaleNewPerformanceReportItemGradService saleNewPerformanceReportItemGradService;
    @Lazy
    @Autowired
    private PurchasePerformanceReportHeadService purchasePerformanceReportHeadService;
    @Lazy
    @Autowired
    private PurchasePerformanceReportSupplierMapper purchasePerformanceReportSupplierMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    private PurchaseNewPerformanceReportHead createPurReportHead(PurchasePerformanceReportHead reportHead, PurchasePerformanceReportSupplier supplier) {
        PurchaseNewPerformanceReportHead newPerformanceReportHead = new PurchaseNewPerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)reportHead), (Object)((Object)newPerformanceReportHead));
        newPerformanceReportHead.setId(IdWorker.getIdStr());
        newPerformanceReportHead.setElsAccount(TenantContext.getTenant());
        newPerformanceReportHead.setToElsAccount(supplier.getToElsAccount());
        newPerformanceReportHead.setSupplierName(supplier.getSupplierName());
        newPerformanceReportHead.setSupplierCode(supplier.getSupplierCode());
        newPerformanceReportHead.setSupplierClassify(supplier.getSupplierClassify());
        newPerformanceReportHead.setSupplierStatus(supplier.getSupplierStatus());
        newPerformanceReportHead.setScore(supplier.getScore());
        newPerformanceReportHead.setGradingScore(supplier.getGradingScore());
        String code = this.invokeBaseRpcService.getNextCode("srmPerformanceManageReportNumber", (Object)newPerformanceReportHead);
        List templates = this.invokeBaseRpcService.getDefaultTemplateByType("performanceManageReport");
        TemplateHeadDTO template = (TemplateHeadDTO)templates.get(0);
        newPerformanceReportHead.setDocNumber(code);
        newPerformanceReportHead.setTemplateNumber(template.getTemplateNumber());
        newPerformanceReportHead.setTemplateName(template.getTemplateName());
        newPerformanceReportHead.setTemplateAccount(template.getElsAccount());
        newPerformanceReportHead.setTemplateVersion(String.valueOf(template.getTemplateVersion()));
        Date now = new Date();
        newPerformanceReportHead.setCreateTime(now);
        newPerformanceReportHead.setUpdateTime(now);
        return newPerformanceReportHead;
    }

    private List<PurchaseNewPerformanceReportItem> createPurReportItem(String headId, List<PurchasePerformanceReportItem> itemList) {
        ArrayList<PurchaseNewPerformanceReportItem> items = new ArrayList<PurchaseNewPerformanceReportItem>();
        List<PurchasePerformanceReportItemGrad> itemGradList = this.purchasePerformanceReportItemGradMapper.selectByMainId(itemList.get(0).getHeadId());
        Map<String, List<PurchasePerformanceReportItemGrad>> mapGrads = itemGradList.stream().collect(Collectors.groupingBy(PurchasePerformanceReportItemGrad::getPerformanceReportItemId));
        int itemNumber = 1;
        for (PurchasePerformanceReportItem item : itemList) {
            PurchaseNewPerformanceReportItem newItem = new PurchaseNewPerformanceReportItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)newItem));
            newItem.setId(IdWorker.getIdStr());
            newItem.setHeadId(headId);
            newItem.setItemNumber(String.valueOf(itemNumber));
            String itemId = StringUtils.isBlank((CharSequence)item.getLastId()) ? item.getId() : item.getLastId();
            ArrayList itemGrads = SysUtil.copyProperties(mapGrads.get(itemId), PurchaseNewPerformanceReportItemGrad.class);
            itemGrads.forEach(itemGrad -> itemGrad.setHeadId(headId).setPerformanceReportItemId(newItem.getId()).setId(IdWorker.getIdStr()));
            newItem.setItemGrads(itemGrads);
            items.add(newItem);
        }
        return items;
    }

    private void createSaleReport(PurchaseNewPerformanceReportHead purHead, List<PurchaseNewPerformanceReportItem> purItemList) {
        SaleNewPerformanceReportHead saleHead = new SaleNewPerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purHead), (Object)((Object)saleHead));
        saleHead.setId(IdWorker.getIdStr());
        saleHead.setElsAccount(purHead.getToElsAccount());
        saleHead.setBusAccount(purHead.getElsAccount());
        saleHead.setToElsAccount(purHead.getElsAccount());
        saleHead.setRelationId(purHead.getId());
        purHead.setRelationId(saleHead.getId());
        this.saleNewPerformanceReportHeadService.save((Object)saleHead);
        ArrayList<SaleNewPerformanceReportItem> saleItemList = new ArrayList<SaleNewPerformanceReportItem>();
        ArrayList saleItemGrads = new ArrayList();
        for (PurchaseNewPerformanceReportItem purItem : purItemList) {
            SaleNewPerformanceReportItem saleItem = new SaleNewPerformanceReportItem();
            BeanUtils.copyProperties((Object)((Object)purItem), (Object)((Object)saleItem));
            saleItem.setId(IdWorker.getIdStr());
            saleItem.setElsAccount(saleHead.getElsAccount());
            saleItem.setRelationId(purItem.getId());
            saleItem.setHeadId(saleHead.getId());
            ArrayList grads = SysUtil.copyProperties(purItem.getItemGrads(), SaleNewPerformanceReportItemGrad.class);
            grads.forEach(grad -> grad.setHeadId(saleHead.getId()).setPerformanceReportItemId(saleItem.getId()).setElsAccount(saleHead.getElsAccount()).setId(IdWorker.getIdStr()));
            saleItemGrads.addAll(grads);
            saleItemList.add(saleItem);
            purItem.setRelationId(saleItem.getId());
        }
        this.saleNewPerformanceReportItemService.saveBatch(saleItemList, 2000);
        if (!CollectionUtils.isEmpty(saleItemGrads)) {
            this.saleNewPerformanceReportItemGradService.saveBatch(saleItemGrads, 2000);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)saleHead)));
        String elsAccount = saleHead.getBusAccount();
        ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = this.invokeAccountRpcService.getByElsAccount(elsAccount);
        if (ObjectUtil.isNotEmpty((Object)elsEnterpriseInfoDTO)) {
            jsonObject.put("purchaseName", (Object)elsEnterpriseInfoDTO.getName());
        } else {
            LoginUser loginUser = SysUtil.getLoginUser();
            if (ObjectUtil.isNotEmpty((Object)loginUser)) {
                jsonObject.put("purchaseName", (Object)loginUser.getEnterpriseName());
            }
        }
        this.sendMsg(saleHead.getToElsAccount(), saleHead.getElsAccount(), jsonObject, "id=" + saleHead.getId(), "performanceManageReport", "performanceManageReportSend");
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void createPerformanceManageReport(PurchasePerformanceReportHead reportHead, PurchasePerformanceReportSupplier supplier) {
        PurchaseNewPerformanceReportHead purReportHead = this.createPurReportHead(reportHead, supplier);
        List<PurchaseNewPerformanceReportItem> reportItems = this.createPurReportItem(purReportHead.getId(), supplier.getItemList());
        if ("1".equals(reportHead.getRequiredSend())) {
            purReportHead.setPublishStatus("1");
            purReportHead.setPublishTime(new Date());
            this.createSaleReport(purReportHead, reportItems);
        } else {
            purReportHead.setPublishStatus("0");
        }
        ((PurchaseNewPerformanceReportHeadMapper)this.baseMapper).insert((Object)purReportHead);
        this.purchaseNewPerformanceReportItemService.saveBatch(reportItems, 2000);
        ArrayList<PurchaseNewPerformanceReportItemGrad> itemGrads = new ArrayList<PurchaseNewPerformanceReportItemGrad>();
        for (PurchaseNewPerformanceReportItem item : reportItems) {
            itemGrads.addAll(item.getItemGrads());
        }
        if (!CollectionUtils.isEmpty(itemGrads)) {
            this.purchaseNewPerformanceReportItemGradService.saveBatch(itemGrads, 2000);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void publishToSale(PerformanceReportVO performanceReportVO) {
        PurchaseNewPerformanceReportHead head = (PurchaseNewPerformanceReportHead)((Object)((PurchaseNewPerformanceReportHeadMapper)this.baseMapper).selectById((Serializable)((Object)performanceReportVO.getId())));
        Assert.isTrue((head != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01"));
        Assert.isTrue((boolean)"0".equals(head.getPublishStatus()), (String)I18nUtil.translate((String)"i18n_alert_tXsxt0IhxxqKhx_6fe4273a", (String)"\u7ee9\u6548\u62a5\u544a\u5355\u3010${0}\u3011\u5df2\u53d1\u5e03\uff0c\u4e0d\u53ef\u518d\u53d1\u5e03\uff01", (String[])new String[]{head.getDocNumber()}));
        List<PurchaseNewPerformanceReportItem> itemList = this.purchaseNewPerformanceReportItemService.selectByMainId(head.getId());
        List<PurchaseNewPerformanceReportItemGrad> itemGradList = this.purchaseNewPerformanceReportItemGradService.selectByMainId(head.getId());
        Map<String, List<PurchaseNewPerformanceReportItemGrad>> mapGrads = itemGradList.stream().collect(Collectors.groupingBy(PurchaseNewPerformanceReportItemGrad::getPerformanceReportItemId));
        for (PurchaseNewPerformanceReportItem item : itemList) {
            item.setItemGrads(mapGrads.get(item.getId()));
        }
        head.setPublishStatus("1");
        head.setPublishTime(new Date());
        this.createSaleReport(head, itemList);
        int count = ((PurchaseNewPerformanceReportHeadMapper)this.baseMapper).updateById((Object)head);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        PurchasePerformanceReportHead purchasePerformanceReportHead = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)head.getReportId())));
        if (purchasePerformanceReportHead != null && !PerformanceReportSendStatusEnum.HAS_BEEN_SENT.getValue().equals(purchasePerformanceReportHead.getSendStatus())) {
            purchasePerformanceReportHead.setSendStatus(PerformanceReportSendStatusEnum.HAS_BEEN_SENT.getValue());
            this.purchasePerformanceReportHeadService.updateById((Object)purchasePerformanceReportHead);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)head.getReportId());
        wrapper.eq((Object)"els_account", (Object)head.getElsAccount());
        wrapper.eq((Object)"to_els_account", (Object)head.getToElsAccount());
        List supplierList = this.purchasePerformanceReportSupplierMapper.selectList((Wrapper)wrapper);
        if (CollUtil.isNotEmpty((Collection)supplierList)) {
            PurchasePerformanceReportSupplier supplier = (PurchasePerformanceReportSupplier)((Object)supplierList.get(0));
            supplier.setSendStatus(PerformanceReportSendStatusEnum.HAS_BEEN_SENT.getValue());
            this.purchasePerformanceReportSupplierMapper.updateById((Object)supplier);
        }
    }
}

