/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.adapter;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.myschedule.entity.MySchedule;
import com.els.modules.myschedule.mapper.MyScheduleMapper;
import com.els.modules.myschedule.service.MyScheduleService;
import com.els.modules.supplier.entity.PurchaseVisitHead;
import com.els.modules.supplier.enumerate.VisitStatusEnum;
import com.els.modules.supplier.service.PurchaseVisitHeadService;
import com.els.modules.supplier.vo.PurchaseVisitHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseVisitAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseVisitHeadService purchaseVisitHeadService;
    @Resource
    private MyScheduleService myScheduleService;
    @Resource
    private MyScheduleMapper myScheduleMapper;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            Object operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                Object operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        PurchaseVisitHead head = (PurchaseVisitHead)((Object)this.purchaseVisitHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    public void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseVisitHead purchaseVisitHead = (PurchaseVisitHead)((Object)this.purchaseVisitHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        if (VisitStatusEnum.NEW.getValue().equals(purchaseVisitHead.getVisitStatus()) && AuditStatusEnum.AUDIT_NEW.getValue().equals(outputParamVO.getAuditStatus())) {
            int count = this.myScheduleMapper.selectWithoutElsAccountConflict(purchaseVisitHead.getToElsAccount(), purchaseVisitHead.getIntervieweePrincipal(), purchaseVisitHead.getVisitStartTime(), purchaseVisitHead.getVisitEndTime());
            Assert.isTrue((count == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APUZmCKIIjBLpAVVVHVUZmCKI_dad8d2b2", (String)"\u5f53\u524d\u9884\u7ea6\u62dc\u8bbf\u65f6\u95f4\u5df2\u6709\u65e5\u7a0b\u5b89\u6392\uff0c\u8bf7\u91cd\u65b0\u66f4\u65b0\u9884\u7ea6\u62dc\u8bbf\u65f6\u95f4\u3002"));
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            queryWrapper.eq(MySchedule::getSubAccount, (Object)purchaseVisitHead.getVisitPrincipal());
            queryWrapper.lt(MySchedule::getBeginTime, (Object)purchaseVisitHead.getVisitEndTime());
            queryWrapper.gt(MySchedule::getEndTime, (Object)purchaseVisitHead.getVisitStartTime());
            Assert.isTrue((this.myScheduleService.count((Wrapper)queryWrapper) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APIIjBLjVPsMKm_5dbd60fd", (String)"\u5f53\u524d\u5b9a\u4e49\u7684\u65e5\u7a0b\u6709\u51b2\u7a81\uff0c\u4fdd\u5b58\u5931\u8d25\uff01"));
        }
        purchaseVisitHead.setAuditStatus(outputParamVO.getAuditStatus());
        purchaseVisitHead.setFlowId(outputParamVO.getProcessRootId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) && "1".equals(purchaseVisitHead.getSend())) {
            PurchaseVisitHeadVO purchaseVisitHeadVO = this.purchaseVisitHeadService.queryById(inputParamVO.getBusinessId());
            purchaseVisitHeadVO.setAuditStatus(outputParamVO.getAuditStatus());
            purchaseVisitHeadVO.setFlowId(outputParamVO.getProcessRootId());
            this.purchaseVisitHeadService.publishAudit(purchaseVisitHeadVO);
        }
        this.purchaseVisitHeadService.updateById((Object)purchaseVisitHead);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_").length > 1 ? account.split("_")[1] : account.split("_")[0]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        Map<String, String> paramMap = inputParamVO.getVariables() == null ? new HashMap() : inputParamVO.getVariables();
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams(paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

