/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.adapter;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.supplier.entity.SupplierAccessHead;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierMasterDataAuditInfo;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.enumerate.SupplierAccessStatusEnum;
import com.els.modules.supplier.enumerate.SupplierStatusEnum;
import com.els.modules.supplier.mapper.SupplierAccessHeadMapper;
import com.els.modules.supplier.mapper.SupplierMasterDataAuditInfoMapper;
import com.els.modules.supplier.mapper.SupplierMasterDataMapper;
import com.els.modules.supplier.mapper.SupplierOrgInfoMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeOrgRpcService;
import com.els.modules.supplier.service.SupplierDevDemandHeadService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SupplierAccessAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private SupplierAccessHeadMapper supplierAccessHeadMapper;
    @Autowired
    private SupplierMasterDataMapper supplierMasterDataMapper;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private SupplierOrgInfoMapper supplierOrgInfoMapper;
    @Autowired
    private SupplierMasterDataAuditInfoMapper supplierMasterDataAuditInfoMapper;
    @Resource
    private SupplierInvokeOrgRpcService supplierInvokeOrgRpcService;
    @Autowired
    private SupplierDevDemandHeadService supplierDevDemandHeadService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            Object operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            SupplierAccessHead accessHead = (SupplierAccessHead)((Object)this.supplierAccessHeadMapper.selectById((Serializable)((Object)inputParamVO.getBusinessId())));
            SupplierMasterData masterData = this.supplierMasterDataMapper.getByAccount(accessHead.getElsAccount(), accessHead.getToElsAccount());
            if (masterData != null) {
                masterData.setSupplierStatus(SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue());
                masterData.setAccessCategory((StringUtils.isBlank((CharSequence)masterData.getAccessCategory()) ? "" : masterData.getAccessCategory()) + ";" + accessHead.getCateCode() + "_" + accessHead.getCateName());
                this.supplierMasterDataMapper.updateById((Object)masterData);
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"relation_id", (Object)masterData.getId());
                ((QueryWrapper)wrapper.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_NEW.getValue())).last(" limit 1");
                SupplierMasterDataAuditInfo oldInfo = (SupplierMasterDataAuditInfo)((Object)this.supplierMasterDataAuditInfoMapper.selectOne((Wrapper)wrapper));
                if (oldInfo != null) {
                    oldInfo.setAccessCategory(masterData.getAccessCategory());
                    this.supplierMasterDataAuditInfoMapper.updateById((Object)oldInfo);
                }
                SupplierOrgInfo info = new SupplierOrgInfo();
                info.setHeadId(masterData.getId());
                info.setElsAccount(masterData.getToElsAccount());
                info.setToElsAccount(masterData.getElsAccount());
                info.setOrgCode(accessHead.getPurchaseOrg());
                PurchaseOrganizationInfoDTO organizationInfo = this.supplierInvokeOrgRpcService.selectByElsAccountAndCode(masterData.getElsAccount(), "purchaseOrganization", accessHead.getPurchaseOrg());
                if (organizationInfo != null) {
                    info.setOrgDesc(organizationInfo.getOrgDesc());
                    info.setOrgId(organizationInfo.getId());
                    info.setOrgCategoryId(organizationInfo.getOrgCategoryCode());
                    info.setOrgCategoryDesc(organizationInfo.getOrgCategoryDesc());
                    info.setOrgFullDesc(organizationInfo.getOrgDesc());
                }
                info.setFrozenFlag("0");
                info.setPrincipal(accessHead.getPrincipal());
                info.setDataSource(accessHead.getAccessNumber());
                info.setRegulationType(accessHead.getRegulationType());
                info.setDeleted(CommonConstant.DEL_FLAG_0);
                info.setAccessed("1");
                info.setAccessCategory(accessHead.getCateCode() + "_" + accessHead.getCateName());
                this.supplierOrgInfoMapper.insert((Object)info);
            }
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                Object operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        SupplierAccessHead accessHead = (SupplierAccessHead)((Object)this.supplierAccessHeadMapper.selectById((Serializable)((Object)inputParamVO.getBusinessId())));
        SupplierMasterData masterData = this.supplierMasterDataMapper.getByAccount(accessHead.getElsAccount(), accessHead.getToElsAccount());
        if (masterData != null && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(masterData.getAuditStatus())) {
            masterData.setAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue());
            this.supplierMasterDataMapper.updateById((Object)masterData);
        }
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        SupplierAccessHead head = (SupplierAccessHead)((Object)this.supplierAccessHeadMapper.selectById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    public void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        SupplierAccessHead accessHead = new SupplierAccessHead();
        accessHead.setId(inputParamVO.getBusinessId());
        accessHead.setAuditStatus(outputParamVO.getAuditStatus());
        accessHead.setFlowId(outputParamVO.getProcessRootId());
        accessHead.setWorkFlowType(outputParamVO.getBpmnType());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            accessHead.setAccessStatus(SupplierAccessStatusEnum.PUBLISH.getValue());
        }
        this.supplierAccessHeadMapper.updateById((Object)accessHead);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            SupplierAccessHead supplierAccessHead = (SupplierAccessHead)((Object)this.supplierAccessHeadMapper.selectById((Serializable)((Object)inputParamVO.getBusinessId())));
            supplierAccessHead.setAccessStatus(SupplierAccessStatusEnum.PUBLISH.getValue());
            this.supplierDevDemandHeadService.updDevDemandItemAccess(supplierAccessHead, null);
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_").length > 1 ? account.split("_")[1] : account.split("_")[0]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        Map<String, String> paramMap = inputParamVO.getVariables() == null ? new HashMap() : inputParamVO.getVariables();
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams(paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

