/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.supplier.entity.SupplierDevDemandHead;
import com.els.modules.supplier.enumerate.DevDemandStatusEnum;
import com.els.modules.supplier.service.SupplierDevDemandHeadService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierDevDemandAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(SupplierDevDemandAuditOptCallBackServiceImpl.class);
    @Autowired
    private SupplierDevDemandHeadService supplierDevDemandHeadService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        log.info("come in SupplierDevDemandAuditOptCallBackServiceImpl to startCallBack\uff1a" + inputParamVO.getBusinessId());
        this.updateStatus(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            Object operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            SupplierDevDemandHead devDemandHead = new SupplierDevDemandHead();
            devDemandHead.setId(inputParamVO.getBusinessId());
            devDemandHead.setStatus(DevDemandStatusEnum.DEVELOPING.getValue());
            devDemandHead.setNeedAudit("1");
            devDemandHead.setAuditStatus(outputParamVO.getAuditStatus());
            devDemandHead.setFlowId(outputParamVO.getProcessRootId());
            devDemandHead.setWorkFlowType(outputParamVO.getBpmnType());
            this.supplierDevDemandHeadService.updateById((Object)devDemandHead);
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                Object operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        SupplierDevDemandHead devDemandHead = new SupplierDevDemandHead();
        devDemandHead.setId(inputParamVO.getBusinessId());
        devDemandHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.supplierDevDemandHeadService.updateById((Object)devDemandHead);
    }

    public JSONObject getDataById(String id) {
        SupplierDevDemandHead head = (SupplierDevDemandHead)((Object)this.supplierDevDemandHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    public void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        SupplierDevDemandHead devDemandHead = new SupplierDevDemandHead();
        devDemandHead.setId(inputParamVO.getBusinessId());
        devDemandHead.setNeedAudit("1");
        devDemandHead.setAuditStatus(outputParamVO.getAuditStatus());
        devDemandHead.setFlowId(outputParamVO.getProcessRootId());
        devDemandHead.setWorkFlowType(outputParamVO.getBpmnType());
        this.supplierDevDemandHeadService.updateById((Object)devDemandHead);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_").length > 1 ? account.split("_")[1] : account.split("_")[0]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        Map<String, String> paramMap = inputParamVO.getVariables() == null ? new HashMap() : inputParamVO.getVariables();
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams(paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(outputParamVO.getAuditStatus())) {
            paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
            paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
            if (account.split("_").length > 2) {
                paramObj.put("taskId", (Object)account.split("_")[2]);
            }
            if (account.split("_").length > 3) {
                paramObj.put("processInstanceId", (Object)account.split("_")[3]);
            }
        } else {
            paramObj.put("id", (Object)inputParamVO.getBusinessId());
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }

    public void sendMsg(String purchaseElsAccount, List<String> toElsAccountList, Object object, String url, String businessType, String operateType) {
        try {
            LoginUser loginUser = SysUtil.getLoginUser();
            CoreInvokeSupplierRpcService coreInvokeSupplierRpcService = (CoreInvokeSupplierRpcService)SpringContextUtils.getBean(CoreInvokeSupplierRpcService.class);
            Map receiverMap = coreInvokeSupplierRpcService.getSupplierContacts(purchaseElsAccount, toElsAccountList, businessType, operateType);
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)purchaseElsAccount);
            msgObj.put("businessType", (Object)businessType);
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("businessObj", (Object)SysUtil.objectToJSON((Object)object));
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            for (String toElsAccount : receiverMap.keySet()) {
                JSONArray toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString(receiverMap.get(toElsAccount)));
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)toElsAccount);
                receiveObj.put("urlParam", (Object)url);
                receiveObj.put("toSubAccountList", (Object)toSubAccountArray);
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            MqUtil.sendBusMsg((String)msgObj.toJSONString());
        }
        catch (Exception e) {
            log.error("sendMsg failed:", (Throwable)e);
        }
    }
}

