/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.supplier.entity.SupplierAccessMgmt;
import com.els.modules.supplier.entity.SupplierAccessMgmtInspection;
import com.els.modules.supplier.entity.SupplierAccessMgmtQuareview;
import com.els.modules.supplier.entity.SupplierAccessMgmtSamplecheck;
import com.els.modules.supplier.service.SupplierAccessMgmtInspectionService;
import com.els.modules.supplier.service.SupplierAccessMgmtQuareviewService;
import com.els.modules.supplier.service.SupplierAccessMgmtSamplecheckService;
import com.els.modules.supplier.service.SupplierAccessMgmtService;
import com.els.modules.supplier.vo.ShiftCertificationVO;
import com.els.modules.supplier.vo.SupplierAccessMgmtVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/supplierAccessMgmt"})
@Api(tags={"\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165"})
@BusinessModule(module="accessMgmt")
public class SupplierAccessMgmtController
extends BaseController<SupplierAccessMgmt, SupplierAccessMgmtService> {
    private static final Logger log = LoggerFactory.getLogger(SupplierAccessMgmtController.class);
    @Autowired
    private SupplierAccessMgmtService supplierAccessMgmtService;
    @Autowired
    private SupplierAccessMgmtQuareviewService supplierAccessMgmtQuareviewService;
    @Autowired
    private SupplierAccessMgmtInspectionService supplierAccessMgmtInspectionService;
    @Autowired
    private SupplierAccessMgmtSamplecheckService supplierAccessMgmtSamplecheckService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:list"})
    @PermissionDataView(businessType="accessMgmt")
    public Result<?> queryPageList(SupplierAccessMgmt supplierAccessMgmt, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessMgmt), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.supplierAccessMgmtService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:list"})
    @PermissionDataView(businessType="accessMgmt")
    public Result<?> queryTabsCount(SupplierAccessMgmt supplierAccessMgmt, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessMgmt), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.select(new String[]{"access_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"access_status");
        List list = this.supplierAccessMgmtService.list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SupplierAccessMgmt::getAccessStatus, SupplierAccessMgmt::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "accessStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmAccessStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "accessStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @SrmValidated
    @AutoLog(busModule="\u4f9b\u5e94\u5546\u51c6\u5165-\u4f9b\u5e94\u5546\u51c6\u5165", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:add"})
    @PermissionDataOpt(businessType="accessMgmt", beanClass=SupplierAccessMgmtService.class)
    public Result<?> add(@RequestBody SupplierAccessMgmtVO supplierAccessMgmtPage) {
        SupplierAccessMgmt supplierAccessMgmt = new SupplierAccessMgmt();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtPage), (Object)((Object)supplierAccessMgmt));
        this.supplierAccessMgmtService.saveMain(supplierAccessMgmt, supplierAccessMgmtPage.getSupplierAccessMgmtQuareviewList(), supplierAccessMgmtPage.getSupplierAccessMgmtInspectionList(), supplierAccessMgmtPage.getSupplierAccessMgmtSamplecheckList(), supplierAccessMgmtPage.getSupplierAccessMgmtAttachmentList());
        return Result.ok((Object)((Object)supplierAccessMgmt));
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u51c6\u5165-\u590d\u5236", notes="\u4f9b\u5e94\u5546\u51c6\u5165-\u590d\u5236")
    @GetMapping(value={"/copyById"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:copy"})
    @PermissionDataOpt(businessType="accessMgmt", beanClass=SupplierAccessMgmtService.class)
    public Result<?> copyById(@RequestParam(name="id") String id) {
        this.supplierAccessMgmtService.copyById(id);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:edit"})
    @PermissionDataOpt(businessType="accessMgmt", beanClass=SupplierAccessMgmtService.class)
    public Result<?> edit(@RequestBody SupplierAccessMgmtVO supplierAccessMgmtPage) {
        SupplierAccessMgmt supplierAccessMgmt = new SupplierAccessMgmt();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtPage), (Object)((Object)supplierAccessMgmt));
        this.supplierAccessMgmtService.updateMain(supplierAccessMgmt, supplierAccessMgmtPage.getSupplierAccessMgmtQuareviewList(), supplierAccessMgmtPage.getSupplierAccessMgmtInspectionList(), supplierAccessMgmtPage.getSupplierAccessMgmtSamplecheckList(), supplierAccessMgmtPage.getSupplierAccessMgmtAttachmentList());
        String id = supplierAccessMgmt.getId();
        return this.queryById(id);
    }

    @SrmValidated
    @AutoLog(busModule="\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165", value="\u63d0\u4ea4\u4fdd\u5b58")
    @ApiOperation(value="\u63d0\u4ea4\u4fdd\u5b58", notes="\u63d0\u4ea4\u4fdd\u5b58")
    @PostMapping(value={"/submitSave"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:submit"})
    @PermissionDataOpt(businessType="accessMgmt", beanClass=SupplierAccessMgmtService.class)
    public Result<?> submitSave(@RequestBody SupplierAccessMgmtVO supplierAccessMgmtPage) {
        SupplierAccessMgmt supplierAccessMgmt = new SupplierAccessMgmt();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtPage), (Object)((Object)supplierAccessMgmt));
        this.supplierAccessMgmtService.submitSave(supplierAccessMgmt, supplierAccessMgmtPage.getSupplierAccessMgmtQuareviewList(), supplierAccessMgmtPage.getSupplierAccessMgmtInspectionList(), supplierAccessMgmtPage.getSupplierAccessMgmtSamplecheckList(), supplierAccessMgmtPage.getSupplierAccessMgmtAttachmentList());
        return Result.ok((Object)((Object)supplierAccessMgmt));
    }

    @SrmValidated
    @AutoLog(busModule="\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:submit"})
    @PermissionDataOpt(businessType="accessMgmt", beanClass=SupplierAccessMgmtService.class)
    public Result<?> publish(@RequestBody SupplierAccessMgmtVO supplierAccessMgmtPage) {
        SupplierAccessMgmt supplierAccessMgmt = new SupplierAccessMgmt();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtPage), (Object)((Object)supplierAccessMgmt));
        this.supplierAccessMgmtService.publishMain(supplierAccessMgmt);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:delete"})
    @PermissionDataOpt(businessType="accessMgmt", beanClass=SupplierAccessMgmtService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.supplierAccessMgmtService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.supplierAccessMgmtService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.supplierAccessMgmtService.queryById(id)));
    }

    @ApiOperation(value="\u901a\u8fc7\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165id\u67e5\u8be2\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165(\u8d44\u8d28\u5ba1\u67e5)", notes="\u901a\u8fc7\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165id\u67e5\u8be2\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165(\u8d44\u8d28\u5ba1\u67e5)")
    @GetMapping(value={"/querysupplierAccessMgmtQuareviewByMainId"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:view"})
    public Result<?> querysupplierAccessMgmtQuareviewListByMainId(@RequestParam(name="id") String id) {
        List<SupplierAccessMgmtQuareview> supplierAccessMgmtQuareviewList = this.supplierAccessMgmtQuareviewService.selectByMainId(id);
        return Result.ok(supplierAccessMgmtQuareviewList);
    }

    @ApiOperation(value="\u901a\u8fc7\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165id\u67e5\u8be2\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165(\u73b0\u573a\u8003\u5bdf)", notes="\u901a\u8fc7\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165id\u67e5\u8be2\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165(\u73b0\u573a\u8003\u5bdf)")
    @GetMapping(value={"/querysupplierAccessMgmtInspectionByMainId"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:view"})
    public Result<?> querysupplierAccessMgmtInspectionListByMainId(@RequestParam(name="id") String id) {
        List<SupplierAccessMgmtInspection> supplierAccessMgmtInspectionList = this.supplierAccessMgmtInspectionService.selectByMainId(id);
        return Result.ok(supplierAccessMgmtInspectionList);
    }

    @ApiOperation(value="\u901a\u8fc7\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165id\u67e5\u8be2\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165(\u6837\u54c1\u68c0\u6d4b)", notes="\u901a\u8fc7\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165id\u67e5\u8be2\u51c6\u5165\u7ba1\u7406-\u4f9b\u5e94\u5546\u51c6\u5165(\u6837\u54c1\u68c0\u6d4b)")
    @GetMapping(value={"/querysupplierAccessMgmtSamplecheckByMainId"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:view"})
    public Result<?> querysupplierAccessMgmtSamplecheckListByMainId(@RequestParam(name="id") String id) {
        List<SupplierAccessMgmtSamplecheck> supplierAccessMgmtSamplecheckList = this.supplierAccessMgmtSamplecheckService.selectByMainId(id);
        return Result.ok(supplierAccessMgmtSamplecheckList);
    }

    @SrmValidated
    @ApiOperation(value="\u8f6c\u5165\u8ba4\u8bc1\u8d44\u6599", notes="\u8f6c\u5165\u8ba4\u8bc1\u8d44\u6599")
    @PostMapping(value={"/shiftTo"})
    @RequiresPermissions(value={"supplier_access_mgmt#supplierAccessMgmt:edit", "supplier_access_mgmt#supplierAccessMgmt:view", "supplier_access_mgmt#supplierAccessMgmt:reCertificationData"}, logical=Logical.OR)
    @PermissionDataOpt(businessType="accessMgmt", beanClass=SupplierAccessMgmtService.class)
    public Result<?> shiftTo(@RequestBody ShiftCertificationVO shiftCertificationVO) {
        this.supplierAccessMgmtService.shiftTo(shiftCertificationVO);
        return Result.ok((Object)shiftCertificationVO);
    }
}

