/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.board.dto.CountDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoRelationDTO;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.entity.SupplierCertificatedInfo;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierMasterFrozen;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.enumerate.SourceTypeEnum;
import com.els.modules.supplier.enumerate.SupplierStatusEnum;
import com.els.modules.supplier.excel.SupplierMasterDataExportServiceImpl;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeVoucherRpcService;
import com.els.modules.supplier.service.RiskService;
import com.els.modules.supplier.service.SupplierAddressInfoService;
import com.els.modules.supplier.service.SupplierBankInfoService;
import com.els.modules.supplier.service.SupplierCertificatedInfoService;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.service.SupplierMasterFrozenService;
import com.els.modules.supplier.service.SupplierOrgInfoService;
import com.els.modules.supplier.vo.EnterpriseBaseInfoVO;
import com.els.modules.supplier.vo.EnterpriseInfoVo;
import com.els.modules.supplier.vo.PagePerformanceSupplierReqVO;
import com.els.modules.supplier.vo.PurchaseYhBranchBankVO;
import com.els.modules.supplier.vo.RegisterVO;
import com.els.modules.supplier.vo.RiskVO;
import com.els.modules.supplier.vo.SupplierBankInfoVO;
import com.els.modules.supplier.vo.SupplierMasterDataResVO;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.modules.supplier.vo.SupplierMasterFrozenVO;
import com.els.modules.supplier.vo.SupplierSearchVO;
import com.els.modules.supplier.vo.SupplyExtendVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/supplier/supplierMaster"})
@Api(tags={"\u4f9b\u5e94\u5546\u4e3b\u6570\u636e"})
@BusinessModule(module="supplierMasterData")
public class SupplierMasterDataController
extends BaseController<SupplierMasterData, SupplierMasterDataService> {
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private SupplierAddressInfoService supplierAddressInfoService;
    @Autowired
    private SupplierBankInfoService supplierBankInfoService;
    @Autowired
    private SupplierCertificatedInfoService supplierCertificatedInfoService;
    @Autowired
    private SupplierContactsInfoService supplierContactsInfoService;
    @Autowired
    private SupplierOrgInfoService supplierOrgInfoService;
    @Resource
    private SupplierInvokeEnterpriseRpcService supplierInvokeEnterpriseRpcService;
    @Autowired
    private SupplierMasterFrozenService supplierMasterFrozenService;
    @Resource
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RiskService riskService;
    @Resource
    private SupplierInvokeVoucherRpcService invokeVoucherRpcService;
    @Autowired
    private SupplierBankInfoService SupplierBankInfoService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET, RequestMethod.POST})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    @PermissionDataView(businessType="supplierMasterData")
    public Result<?> queryPageList(SupplierMasterData supplierMasterData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        List<String> idList;
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Map parameters = req.getParameterMap();
        Set keys = parameters.keySet();
        String frozenFunctionValue = null;
        String purchaseOrg = null;
        String companyOrg = null;
        String purchaseOrgItemList = null;
        String accessCategoryFilter = null;
        String purchaseOrganization = null;
        String accessCategoryList = null;
        String pageFlag = null;
        ArrayList ignoreSupplierStatusList = null;
        for (String string : keys) {
            if ("frozenFunctionValue".equals(string) && parameters.get(string) != null) {
                frozenFunctionValue = ((String[])parameters.get(string))[0];
            }
            if ("purchaseOrg".equals(string) && parameters.get(string) != null) {
                purchaseOrg = ((String[])parameters.get(string))[0];
            }
            if ("companyOrg".equals(string) && parameters.get(string) != null) {
                companyOrg = ((String[])parameters.get(string))[0];
            }
            if ("purchaseOrgItemList".equals(string) && parameters.get(string) != null) {
                purchaseOrgItemList = ((String[])parameters.get(string))[0];
            }
            if ("accessCategoryFilter".equals(string) && parameters.get(string) != null) {
                accessCategoryFilter = ((String[])parameters.get(string))[0];
            }
            if ("purchaseOrganization".equals(string) && parameters.get(string) != null) {
                purchaseOrganization = ((String[])parameters.get(string))[0];
            }
            if ("accessCategoryList".equals(string) && parameters.get(string) != null) {
                accessCategoryList = ((String[])parameters.get(string))[0];
            }
            if ("pageFlag".equals(string) && parameters.get(string) != null) {
                pageFlag = ((String[])parameters.get(string))[0];
            }
            if (!"ignoreSupplierStatusList".equals(string) || parameters.get(string) == null) continue;
            ignoreSupplierStatusList = Lists.newArrayList((Object[])((String[])parameters.get(string))[0].split(","));
        }
        if (CollUtil.isNotEmpty(ignoreSupplierStatusList)) {
            queryWrapper.lambda().notIn(SupplierMasterData::getSupplierStatus, ignoreSupplierStatusList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(frozenFunctionValue)) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)supplierMasterData.getSupplierStatus()) && ("3".equals(supplierMasterData.getSupplierStatus()) || "4".equals(supplierMasterData.getSupplierStatus()))) {
                queryWrapper.notIn((Object)"supplier_status", SupplierStatusEnum.getAllValue());
            } else if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)supplierMasterData.getSupplierStatus())) {
                queryWrapper.notIn((Object)"supplier_status", SupplierStatusEnum.getWeedoutAndBlack());
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(purchaseOrg) && org.apache.commons.lang3.StringUtils.isNotBlank(frozenFunctionValue) && !(idList = this.supplierMasterFrozenService.getFrozenMasterDadaIdList(frozenFunctionValue, "0", purchaseOrg)).isEmpty() && idList.size() > 0) {
            queryWrapper.notIn((Object)"id", idList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(companyOrg) && org.apache.commons.lang3.StringUtils.isNotBlank(frozenFunctionValue) && !(idList = this.supplierMasterFrozenService.getFrozenMasterDadaIdList(frozenFunctionValue, "1", companyOrg)).isEmpty() && idList.size() > 0) {
            queryWrapper.notIn((Object)"id", idList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(purchaseOrgItemList) && org.apache.commons.lang3.StringUtils.isNotBlank(frozenFunctionValue) && !(idList = this.supplierMasterFrozenService.getFrozenMasterDadaIdListToSource(purchaseOrgItemList)).isEmpty() && idList.size() > 0) {
            queryWrapper.notIn((Object)"id", idList);
        }
        if ("1".equals(accessCategoryFilter)) {
            if (org.apache.commons.lang3.StringUtils.isBlank(purchaseOrganization) || org.apache.commons.lang3.StringUtils.isBlank(accessCategoryList)) {
                return Result.ok((Object)new Page());
            }
            ArrayList<String> categoryList = new ArrayList<String>(Arrays.asList(accessCategoryList.split(",")));
            if (!categoryList.contains("all")) {
                List<String> idList2 = this.supplierOrgInfoService.getMasterDateIdListFromOrgInfo(TenantContext.getTenant(), purchaseOrganization, categoryList);
                if (!idList2.isEmpty()) {
                    queryWrapper.in((Object)"id", idList2);
                    if (!"1".equals(pageFlag)) {
                        List masterDataList = this.supplierMasterDataService.list((Wrapper)queryWrapper);
                        Page iPage = new Page(1L, Long.valueOf(masterDataList.size()).longValue(), Long.valueOf(masterDataList.size()).longValue(), true);
                        iPage.setRecords(masterDataList);
                        return Result.ok((Object)iPage);
                    }
                } else {
                    return Result.ok((Object)new Page());
                }
            }
        }
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u7ee9\u6548\u7ba1\u7406-\u4f9b\u5e94\u5546\u67e5\u8be2", notes="\u7ee9\u6548\u7ba1\u7406-\u4f9b\u5e94\u5546\u67e5\u8be2")
    @GetMapping(value={"/pagePerformanceSupplier"})
    @PermissionDataView(businessType="supplierMasterData")
    public Result<?> pagePerformanceSupplier(PagePerformanceSupplierReqVO reqVO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        List<String> supplierAccounts;
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)reqVO, (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqVO.getIgnoreSupplierStatusList())) {
            queryWrapper.notIn((Object)"supplier_status", (Collection)Lists.newArrayList((Object[])reqVO.getIgnoreSupplierStatusList().split(",")));
        }
        if (!CollectionUtils.isEmpty(supplierAccounts = this.invokeVoucherRpcService.selectVoucherElsAccount(reqVO.getReportStartTime(), reqVO.getReportEndTime()))) {
            List accountList = Lists.partition(supplierAccounts, (int)1000);
            queryWrapper.and(qw -> {
                for (int i = 0; i < accountList.size(); ++i) {
                    List accounts = (List)accountList.get(i);
                    if (i == 0) {
                        qw.nested(w -> w.in((Object)"to_els_account", (Collection)accounts));
                        continue;
                    }
                    qw.or(w -> w.in((Object)"to_els_account", (Collection)accounts));
                }
            });
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SupplierMasterDataResVO> pageList = this.supplierMasterDataService.pagePerformanceSupplier((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u804c\u80fd\u8054\u7cfb\u4eba)", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u804c\u80fd\u8054\u7cfb\u4eba)")
    @GetMapping(value={"/contactList"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    @PermissionDataView(businessType="supplierMasterData")
    public Result<?> queryFunctionalContactPageList(SupplierMasterData supplierMasterData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        List<String> idList;
        Map parameterMap = req.getParameterMap();
        String functionName = parameterMap.get("functionName") == null ? "" : String.valueOf(((String[])parameterMap.get("functionName"))[0]);
        LinkedHashMap<String, String[]> params = new LinkedHashMap<String, String[]>();
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            if ("functionName".equals(entry.getKey())) continue;
            params.put((String)entry.getKey(), (String[])entry.getValue());
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), params);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Set keys = params.keySet();
        String frozenFunctionValue = null;
        String purchaseOrg = null;
        String companyOrg = null;
        String purchaseOrgItemList = null;
        String accessCategoryFilter = null;
        String purchaseOrganization = null;
        String accessCategoryList = null;
        ArrayList ignoreSupplierStatusList = null;
        for (String string : keys) {
            if ("frozenFunctionValue".equals(string) && params.get(string) != null) {
                frozenFunctionValue = ((String[])params.get(string))[0];
            }
            if ("purchaseOrg".equals(string) && params.get(string) != null) {
                purchaseOrg = ((String[])params.get(string))[0];
            }
            if ("companyOrg".equals(string) && params.get(string) != null) {
                companyOrg = ((String[])params.get(string))[0];
            }
            if ("purchaseOrgItemList".equals(string) && params.get(string) != null) {
                purchaseOrgItemList = ((String[])params.get(string))[0];
            }
            if ("accessCategoryFilter".equals(string) && params.get(string) != null) {
                accessCategoryFilter = ((String[])params.get(string))[0];
            }
            if ("purchaseOrganization".equals(string) && params.get(string) != null) {
                purchaseOrganization = ((String[])params.get(string))[0];
            }
            if ("accessCategoryList".equals(string) && params.get(string) != null) {
                accessCategoryList = ((String[])params.get(string))[0];
            }
            if (!"ignoreSupplierStatusList".equals(string) || params.get(string) == null) continue;
            ignoreSupplierStatusList = Lists.newArrayList((Object[])((String[])params.get(string))[0].split(","));
        }
        if (CollUtil.isNotEmpty(ignoreSupplierStatusList)) {
            queryWrapper.lambda().notIn(SupplierMasterData::getSupplierStatus, ignoreSupplierStatusList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(frozenFunctionValue)) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)supplierMasterData.getSupplierStatus()) && ("3".equals(supplierMasterData.getSupplierStatus()) || "4".equals(supplierMasterData.getSupplierStatus()))) {
                queryWrapper.notIn((Object)"supplier_status", SupplierStatusEnum.getAllValue());
            } else if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)supplierMasterData.getSupplierStatus())) {
                queryWrapper.notIn((Object)"supplier_status", SupplierStatusEnum.getWeedoutAndBlack());
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(purchaseOrg) && org.apache.commons.lang3.StringUtils.isNotBlank(frozenFunctionValue) && !(idList = this.supplierMasterFrozenService.getFrozenMasterDadaIdList(frozenFunctionValue, "0", purchaseOrg)).isEmpty() && idList.size() > 0) {
            queryWrapper.notIn((Object)"id", idList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(companyOrg) && org.apache.commons.lang3.StringUtils.isNotBlank(frozenFunctionValue) && !(idList = this.supplierMasterFrozenService.getFrozenMasterDadaIdList(frozenFunctionValue, "1", companyOrg)).isEmpty() && idList.size() > 0) {
            queryWrapper.notIn((Object)"id", idList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(purchaseOrgItemList) && org.apache.commons.lang3.StringUtils.isNotBlank(frozenFunctionValue) && !(idList = this.supplierMasterFrozenService.getFrozenMasterDadaIdListToSource(purchaseOrgItemList)).isEmpty() && idList.size() > 0) {
            queryWrapper.notIn((Object)"id", idList);
        }
        if ("1".equals(accessCategoryFilter)) {
            if (org.apache.commons.lang3.StringUtils.isBlank(purchaseOrganization) || org.apache.commons.lang3.StringUtils.isBlank(accessCategoryList)) {
                return Result.ok((Object)new Page());
            }
            ArrayList<String> categoryList = new ArrayList<String>(Arrays.asList(accessCategoryList.split(",")));
            if (!categoryList.contains("all")) {
                List<String> idList2 = this.supplierOrgInfoService.getMasterDateIdListFromOrgInfo(TenantContext.getTenant(), purchaseOrganization, categoryList);
                if (!idList2.isEmpty()) {
                    queryWrapper.in((Object)"id", idList2);
                } else {
                    return Result.ok((Object)new Page());
                }
            }
        }
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        IPage<SupplierMasterDataVO> result = this.supplierMasterDataService.convertToSupplierMasterDataVO((IPage<SupplierMasterData>)pageList, functionName);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8ba1\u7b97\u5355\u67e5\u8be2\u4f9b\u5e94\u5546\u5206\u9875\u5217\u8868", notes="\u8ba1\u7b97\u5355\u67e5\u8be2\u4f9b\u5e94\u5546\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/queryPageListByCalculation"})
    public Result<?> queryPageListByCalculation(SupplierMasterData supplierMasterData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String[] filterPurchaseTypes = (String[])req.getParameterMap().get("ids");
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.in((Object)"supplier_status", new Object[]{SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue(), SupplierStatusEnum.POTENTIAL_SUPPLIER.getValue(), SupplierStatusEnum.UNFAMILIAR_SUPPLIER.getValue()});
        if (null != filterPurchaseTypes && filterPurchaseTypes.length > 0 && !StringUtils.isEmpty((String)filterPurchaseTypes[0])) {
            ArrayList filterPurchaseType = Lists.newArrayList((Object[])filterPurchaseTypes[0].split(","));
            queryWrapper.in((Object)"id", (Collection)filterPurchaseType);
            pageSize = Integer.MAX_VALUE;
        }
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryMasterDataList"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> queryMasterDataList(SupplierMasterData supplierMasterData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u8be2\u4ef7\u901a\u8fc7\u7269\u6599\u5206\u7c7b\u67e5\u8be2\u4f9b\u5e94\u5546", notes="\u8be2\u4ef7\u901a\u8fc7\u7269\u6599\u5206\u7c7b\u67e5\u8be2\u4f9b\u5e94\u5546")
    @GetMapping(value={"/inquiryQueryList"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> inquiryQueryList(@RequestParam(name="cateCode", required=false) String cateCode) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cateCode)) {
            return Result.ok(new ArrayList());
        }
        HashSet<String> codeSet = new HashSet<String>();
        for (String code : cateCode.split(",")) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)code)) continue;
            codeSet.add(code);
        }
        if (codeSet.isEmpty()) {
            return Result.ok(new ArrayList());
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).and(e -> ((LambdaQueryWrapper)((LambdaQueryWrapper)e.isNotNull(SupplierMasterData::getAccessCategory)).or()).ne(SupplierMasterData::getAccessCategory, (Object)""));
        List allList = this.supplierMasterDataService.list((Wrapper)wrapper);
        List returnList = allList.stream().filter(data -> {
            String dbAccessCategoryArray = data.getAccessCategory();
            for (String dbAccessCategory : dbAccessCategoryArray.split(";")) {
                if (!codeSet.contains(dbAccessCategory.split("_")[0])) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        return Result.ok(returnList);
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:add"})
    public Result<?> add(@RequestBody SupplierMasterDataVO supplierMasterDataPage) {
        SupplierMasterData supplierMasterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)supplierMasterDataPage), (Object)((Object)supplierMasterData));
        this.supplierMasterDataService.saveMain(supplierMasterData, supplierMasterDataPage);
        return Result.ok((Object)((Object)supplierMasterData));
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:edit"})
    public Result<?> edit(@RequestBody SupplierMasterDataVO supplierMasterDataPage) {
        this.supplierMasterDataService.updateMain(supplierMasterDataPage);
        String id = supplierMasterDataPage.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.supplierMasterDataService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.supplierMasterDataService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:view", "supplier_master_data#supplierMasterData:edit", "tender#purchaseTenderAgencyLibraryHead:queryById", "enterpriseList#enterpriseList:view", "enterpriseList#enterpriseList:edit", "supplier_info_change#supplierInfoChange:add", "supplier_info_change#supplierInfoChange:edit"}, logical=Logical.OR)
    public Result<?> queryById(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.supplierMasterDataService.getDataById(id)));
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u5730\u5740\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u5730\u5740\u4fe1\u606f")
    @GetMapping(value={"/querySupplierAddressInfoByMainId"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> querySupplierAddressInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierAddressInfo> supplierAddressInfoList = this.supplierAddressInfoService.selectByMainId(id);
        return Result.ok(supplierAddressInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u94f6\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u94f6\u884c\u4fe1\u606f")
    @GetMapping(value={"/querySupplierBankInfoByMainId"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> querySupplierBankInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierBankInfo> supplierBankInfoList = this.supplierBankInfoService.selectByMainId(id);
        return Result.ok(supplierBankInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599\u4fe1\u606f")
    @GetMapping(value={"/querySupplierCertificatedInfoByMainId"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> querySupplierCertificatedInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierCertificatedInfo> supplierCertificatedInfoList = this.supplierCertificatedInfoService.selectByMainId(id);
        return Result.ok(supplierCertificatedInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4fe1\u606f")
    @GetMapping(value={"/querySupplierContactsInfoByMainId"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> querySupplierContactsInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierContactsInfo> supplierContactsInfoList = this.supplierContactsInfoService.selectByMainId(id);
        return Result.ok(supplierContactsInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u7ec4\u7ec7\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u7ec4\u7ec7\u4fe1\u606f")
    @GetMapping(value={"/querySupplierOrgInfoByMainId"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> querySupplierOrgInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierOrgInfo> supplierOrgInfoList = this.supplierOrgInfoService.selectByMainId(id);
        return Result.ok(supplierOrgInfoList);
    }

    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:supplierDataExport"})
    @PermissionDataView(businessType="supplierMasterData")
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, SupplierMasterDataExportServiceImpl.class);
    }

    public SupplierMasterDataVO queryByElsAccount(String elsAccount) {
        String currentAccount = TenantContext.getTenant();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)elsAccount)) {
            elsAccount = currentAccount;
        }
        SupplierMasterDataVO supplierMasterDataVO = new SupplierMasterDataVO();
        if (!currentAccount.equals("100000") && !currentAccount.equals(elsAccount)) {
            SupplierMasterData supplierMasterData = this.supplierMasterDataService.getByAccount(currentAccount, elsAccount);
            BeanUtils.copyProperties((Object)((Object)supplierMasterData), (Object)((Object)supplierMasterDataVO));
        }
        String toELsAccount = null;
        if (!currentAccount.equals(elsAccount) && !currentAccount.equals("100000")) {
            toELsAccount = currentAccount;
        }
        List<SupplierContactsInfo> contactsInfo = this.supplierContactsInfoService.getByAccount(elsAccount, toELsAccount);
        supplierMasterDataVO.setSupplierContactsInfoList(contactsInfo);
        List<SupplierAddressInfo> addressInfo = this.supplierAddressInfoService.getByAccount(elsAccount, toELsAccount);
        supplierMasterDataVO.setSupplierAddressInfoList(addressInfo);
        List<SupplierBankInfo> bankInfo = this.supplierBankInfoService.getByAccount(elsAccount, toELsAccount);
        supplierMasterDataVO.setSupplierBankInfoList(bankInfo);
        List<SupplierOrgInfo> orgInfo = this.supplierOrgInfoService.getByAccount(elsAccount, toELsAccount);
        supplierMasterDataVO.setSupplierOrgInfoList(orgInfo);
        return supplierMasterDataVO;
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f", notes="\u901a\u8fc7id\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f")
    @GetMapping(value={"/queryByEnterpriseId"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> queryByEnterpriseId(@RequestParam(name="id") String id) {
        ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierInvokeEnterpriseRpcService.getById(id);
        if (elsEnterpriseInfo == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n__mhGNWVKHRvjW_638fd67c", (String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
        }
        EnterpriseInfoVo enterpriseInfoVo = new EnterpriseInfoVo();
        BeanUtils.copyProperties((Object)elsEnterpriseInfo, (Object)((Object)enterpriseInfoVo));
        String elsAccount = elsEnterpriseInfo.getElsAccount();
        SupplierMasterDataVO supplierMasterDataVO = this.queryByElsAccount(elsAccount);
        if (supplierMasterDataVO != null) {
            enterpriseInfoVo.setSupplierAddressInfoList(supplierMasterDataVO.getSupplierAddressInfoList());
            enterpriseInfoVo.setSupplierBankInfoList(supplierMasterDataVO.getSupplierBankInfoList());
            enterpriseInfoVo.setSupplierOrgInfoList(supplierMasterDataVO.getSupplierOrgInfoList());
            enterpriseInfoVo.setSupplierContactsInfoList(supplierMasterDataVO.getSupplierContactsInfoList());
        }
        return Result.ok((Object)((Object)enterpriseInfoVo));
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u4ee3\u6ce8\u518c")
    @ApiOperation(value="\u4ee3\u6ce8\u518c", notes="\u4ee3\u6ce8\u518c")
    @PostMapping(value={"/replaceRegister"})
    @RequiresPermissions(value={"supplier_master_data#supplierMaster:replaceRegister"})
    public Result<?> replaceRegister(@RequestBody RegisterVO registerVO) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerVO.getCompanyName())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_title_enterpriseNameCannotBeEmpty", (String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerVO.getContactsName())) {
            registerVO.setContactsName(registerVO.getCompanyName());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerVO.getPassword())) {
            registerVO.setPassword(null);
        }
        return this.supplierMasterDataService.register(registerVO);
    }

    @ApiOperation(value="\u901a\u8fc7\u5f53\u524d\u8d26\u53f7\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f", notes="\u901a\u8fc7\u5f53\u524d\u8d26\u53f7\u83b7\u53d6\u5f53\u524d\u4f01\u4e1a\u4fe1\u606f")
    @GetMapping(value={"/queryCurrentEnterprise"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:queryCurrentEnterprise"})
    public Result<?> queryCurrentEnterprise() {
        String currentAccount = TenantContext.getTenant();
        ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierInvokeEnterpriseRpcService.getByElsAccount(currentAccount);
        if (elsEnterpriseInfo == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_mhGNWVKHRvj_55cacd25", (String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
        }
        EnterpriseInfoVo enterpriseInfoVo = new EnterpriseInfoVo();
        BeanUtils.copyProperties((Object)elsEnterpriseInfo, (Object)((Object)enterpriseInfoVo));
        List<SupplierContactsInfo> contactsInfo = this.supplierContactsInfoService.getDataOnlyAccount(currentAccount);
        enterpriseInfoVo.setSupplierContactsInfoList(contactsInfo);
        List<SupplierAddressInfo> addressInfo = this.supplierAddressInfoService.getDataOnlyAccount(currentAccount);
        enterpriseInfoVo.setSupplierAddressInfoList(addressInfo);
        List<SupplierCertificatedInfo> certificatedInfo = this.supplierCertificatedInfoService.getDataOnlyAccount(currentAccount);
        enterpriseInfoVo.setSupplierCertificatedInfoList(certificatedInfo);
        List<SupplierBankInfo> bankInfo = this.supplierBankInfoService.getDataOnlyAccount(currentAccount);
        enterpriseInfoVo.setSupplierBankInfoList(bankInfo);
        return Result.ok((Object)((Object)enterpriseInfoVo));
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u67e5\u8be2", notes="\u4f9b\u5e94\u5546\u67e5\u8be2")
    @GetMapping(value={"/supplierlist"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> supplierlist(SupplierMasterData supplierMasterData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f9b\u65b9\u4f01\u4e1a\u5bf9\u5e94\u91c7\u8d2d\u65b9\u4fe1\u606f", notes="\u67e5\u8be2\u4f9b\u65b9\u4f01\u4e1a\u5bf9\u5e94\u91c7\u8d2d\u65b9\u4fe1\u606f")
    @GetMapping(value={"/querySupplierData"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> querySupplierData(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        IPage<SupplierMasterData> pageList = this.supplierMasterDataService.pageSupplierDataByToElsAccount(pageNo, pageSize, TenantContext.getTenant());
        List records = pageList.getRecords();
        if (CollUtil.isEmpty((Collection)records)) {
            return Result.ok(pageList);
        }
        List<String> account = records.stream().map(BaseEntity::getElsAccount).collect(Collectors.toList());
        List<ElsEnterpriseInfoDTO> dtos = this.supplierInvokeEnterpriseRpcService.queryByElsAccountList(account);
        if (CollUtil.isNotEmpty(dtos)) {
            Map<String, String> map = dtos.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, ElsEnterpriseInfoDTO::getName, (v1, v2) -> v2));
            for (SupplierMasterData data : pageList.getRecords()) {
                data.setName(map.get(data.getElsAccount()));
            }
        }
        return Result.ok(pageList);
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u6ce8\u518c")
    @ApiOperation(value="\u6ce8\u518c", notes="\u6ce8\u518c")
    @PostMapping(value={"/register"})
    public Result<?> register(@RequestBody RegisterVO registerVO) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerVO.getCompanyName())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_RCRLxOLV_3f6f291f", (String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerVO.getPhoneNumber())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_title_mobilePhoneNumberCannotEmpty", (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerVO.getNoteCode())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ltJOoxOLV_980e86b7", (String)"\u624b\u673a\u6821\u9a8c\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        Object code = this.redisUtil.get("sys:sms:captcha:" + registerVO.getPhoneNumber());
        if (code == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ltOioIKX_e2b7cf4c", (String)"\u624b\u673a\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff01"));
        }
        if (!registerVO.getNoteCode().equals(code)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ltOioNSW_e38d976e", (String)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\uff01"));
        }
        return this.supplierMasterDataService.register(registerVO);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u53d1\u73b0", notes="\u4f9b\u5e94\u5546\u53d1\u73b0")
    @GetMapping(value={"/searchSupplier"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:searchSupplier"})
    public Result<?> searchSupplier(SupplierSearchVO searchVO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Result result = new Result();
        result.setResult((Object)this.supplierMasterDataService.searchSupplier(searchVO, pageNo, pageSize));
        result.setSuccess(true);
        return result;
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u53d1\u73b0--\u67e5\u8be2\u6761\u4ef6", notes="\u4f9b\u5e94\u5546\u53d1\u73b0--\u67e5\u8be2\u6761\u4ef6")
    @GetMapping(value={"/search"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:searchSupplier"})
    public Result<?> search(SupplierSearchVO searchVO) {
        Result result = new Result();
        result.setResult((Object)this.supplierMasterDataService.search(searchVO));
        result.setSuccess(true);
        return result;
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u53d1\u73b0-\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f", notes="\u4f9b\u5e94\u5546\u53d1\u73b0-\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @GetMapping(value={"/queryEnterprise"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:searchSupplier"})
    public Result<?> queryEnterprise(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="name") String name) {
        return this.supplierMasterDataService.queryEnterpriseNew(elsAccount, name);
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u53d1\u73b0-\u8f6c\u6f5c")
    @ApiOperation(value="\u8f6c\u6f5c", notes="\u8f6c\u6f5c")
    @PostMapping(value={"/unfamiliarToPotential"})
    @RequiresPermissions(value={"supplier_master_data#supplierMaster:unfamiliarToPotential"})
    public Result<?> unfamiliarToPotential(@RequestBody RegisterVO registerVO) {
        registerVO.setSourceType(SourceTypeEnum.PLATFIRM_SEARCH.getValue());
        registerVO.setPassword("123456");
        return this.supplierMasterDataService.unfamiliarToPotential(registerVO);
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u53d1\u73b0-\u8f6c\u964c\u751f")
    @ApiOperation(value="\u8f6c\u964c\u751f", notes="\u8f6c\u964c\u751f")
    @PostMapping(value={"/discoverToUnfamiliar"})
    @RequiresPermissions(value={"supplier_master_data#supplierMaster:discoverToUnfamiliar"})
    public Result<?> discoverToUnfamiliar(@RequestBody RegisterVO registerVO) {
        registerVO.setSourceType(SourceTypeEnum.PLATFIRM_SEARCH.getValue());
        registerVO.setPassword("123456");
        return this.supplierMasterDataService.discoverToUnfamiliar(registerVO);
    }

    @GetMapping(value={"/getSubAccounts"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> getSubAccounts(@RequestParam(value="elsAccount") String elsAccount) {
        List<ElsSubAccountDTO> subAccounts = this.supplierInvokeAccountRpcService.getAllByAccount(elsAccount);
        return Result.ok(subAccounts.stream().filter(o -> "1001".equals(o.getSubAccount())).collect(Collectors.toList()));
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf-\u8ba4\u8bc1\u8d44\u6599", notes="\u4f9b\u5e94\u5546\u753b\u50cf-\u8ba4\u8bc1\u8d44\u6599")
    @GetMapping(value={"/certificatedInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list", "supplier_master_data#supplierMasterData:picImage", "supplier_master_data#supplierMasterData:supplierPicImage"}, logical=Logical.OR)
    public Result<?> certificatedInfo(@RequestParam(name="toElsAccount") String toElsAccount) {
        String elsAccount = TenantContext.getTenant();
        SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(elsAccount, toElsAccount);
        if (masterData != null) {
            Result result = new Result();
            result.setResult(this.supplierCertificatedInfoService.selectByMainId(masterData.getId()));
            result.setSuccess(true);
            return result;
        }
        return Result.ok();
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf-\u57fa\u672c\u4fe1\u606f", notes="\u4f9b\u5e94\u5546\u753b\u50cf-\u57fa\u672c\u4fe1\u606f")
    @GetMapping(value={"/baseInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list", "supplier_master_data#supplierMasterData:picImage", "supplier_master_data#supplierMasterData:supplierPicImage"}, logical=Logical.OR)
    public Result<?> baseInfo(@RequestParam(name="toElsAccount") String toElsAccount) {
        ElsEnterpriseInfoRelationDTO relationDTO = this.supplierInvokeEnterpriseRpcService.getByElsAccountAndToelsAccount(TenantContext.getTenant(), toElsAccount);
        if (relationDTO != null) {
            relationDTO.setToElsAccount("");
            return Result.ok((Object)relationDTO);
        }
        ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierInvokeEnterpriseRpcService.getByElsAccount(toElsAccount);
        return Result.ok((Object)elsEnterpriseInfo);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf-\u4f9b\u5e94\u8303\u56f4", notes="\u4f9b\u5e94\u5546\u753b\u50cf-\u4f9b\u5e94\u8303\u56f4")
    @GetMapping(value={"/supplyExtend"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list", "supplier_master_data#supplierMasterData:picImage", "supplier_master_data#supplierMasterData:supplierPicImage"}, logical=Logical.OR)
    public Result<?> supplyExtend(@RequestParam(name="toElsAccount") String toElsAccount) {
        String elsAccount = TenantContext.getTenant();
        SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(elsAccount, toElsAccount);
        if (masterData != null) {
            Result result = new Result();
            SupplyExtendVO extendVO = new SupplyExtendVO();
            List<SupplierOrgInfo> orgInfoList = this.supplierOrgInfoService.selectByMainId(masterData.getId());
            if (CollUtil.isNotEmpty(orgInfoList) && orgInfoList.size() > 0) {
                for (SupplierOrgInfo orgInfo : orgInfoList) {
                    Result resultDict = new Result();
                    resultDict = Result.ok((Object)((Object)orgInfo));
                    DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
                    dictAspect.parseDictText((Object)resultDict);
                    JSONObject parseVo = (JSONObject)resultDict.getResult();
                    orgInfo.setOrgCode(parseVo.getString("orgCode_dictText"));
                }
            }
            extendVO.setOrgInfos(orgInfoList);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterData.getAccessCategory())) {
                extendVO.setAccessCategroy(masterData.getAccessCategory().split(";"));
            }
            result.setResult((Object)extendVO);
            result.setSuccess(true);
            return result;
        }
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f", notes="\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f")
    @GetMapping(value={"/getContractInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> getContractInfo(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"to_els_account", (Object)toElsAccount);
        IPage<SupplierContactsInfo> pageList = this.supplierContactsInfoService.selectListPage((Page<SupplierContactsInfo>)page, (QueryWrapper<SupplierContactsInfo>)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)pageList.getRecords()) && pageList.getRecords().size() > 0) {
            List records = pageList.getRecords();
            records.forEach(o -> {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)o.getHeadId())) {
                    o.setToElsAccount(null);
                }
            });
            pageList.setRecords(records);
        }
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f", notes="\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f")
    @GetMapping(value={"/getContract"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> getContract(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"to_els_account", (Object)toElsAccount);
        IPage<SupplierContactsInfo> pageList = this.supplierContactsInfoService.selectListPage((Page<SupplierContactsInfo>)page, (QueryWrapper<SupplierContactsInfo>)queryWrapper);
        List<ElsSubAccountDTO> elsSubAccountDTOList = null;
        Page pageList2 = new Page();
        ArrayList list = new ArrayList();
        if (pageList.getRecords().size() == 0) {
            elsSubAccountDTOList = this.supplierInvokeAccountRpcService.getAllByAccount(elsAccount);
        } else {
            List records = pageList.getRecords();
            records.forEach(o -> {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)o.getHeadId())) {
                    o.setToElsAccount(null);
                }
            });
            pageList.setRecords(records);
            elsSubAccountDTOList = new ArrayList<ElsSubAccountDTO>();
            for (SupplierContactsInfo supplierContactsInfo : pageList.getRecords()) {
                ElsSubAccountDTO elsSubAccountDTO = new ElsSubAccountDTO();
                elsSubAccountDTO.setPost(supplierContactsInfo.getPosition());
                elsSubAccountDTO.setEmail(supplierContactsInfo.getEmail());
                elsSubAccountDTO.setRealname(supplierContactsInfo.getName());
                elsSubAccountDTO.setPhone(supplierContactsInfo.getTelphone());
                elsSubAccountDTOList.add(elsSubAccountDTO);
            }
        }
        BeanUtils.copyProperties(pageList, (Object)pageList2);
        pageList2.setRecords(elsSubAccountDTOList);
        return Result.ok((Object)pageList2);
    }

    @ApiOperation(value="\u83b7\u53d6\u5730\u5740\u4fe1\u606f", notes="\u83b7\u53d6\u5730\u5740\u4fe1\u606f")
    @GetMapping(value={"/getAddressInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> getAddressInfo(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)toElsAccount);
        queryWrapper.eq((Object)"to_els_account", (Object)elsAccount);
        IPage<SupplierAddressInfo> pageList = this.supplierAddressInfoService.selectListPage((Page<SupplierAddressInfo>)page, (QueryWrapper<SupplierAddressInfo>)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)pageList.getRecords()) && pageList.getRecords().size() > 0) {
            List records = pageList.getRecords();
            records.forEach(o -> {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)o.getHeadId())) {
                    o.setToElsAccount(null);
                }
            });
            pageList.setRecords(records);
        }
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u83b7\u53d6\u94f6\u884c\u4fe1\u606f", notes="\u83b7\u53d6\u94f6\u884c\u4fe1\u606f")
    @GetMapping(value={"/getBankInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> getBankInfo(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)toElsAccount);
        queryWrapper.eq((Object)"to_els_account", (Object)elsAccount);
        IPage<SupplierBankInfo> pageList = this.supplierBankInfoService.selectListPage((Page<SupplierBankInfo>)page, (QueryWrapper<SupplierBankInfo>)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)pageList.getRecords()) && pageList.getRecords().size() > 0) {
            List records = pageList.getRecords();
            records.forEach(o -> {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)o.getHeadId())) {
                    o.setToElsAccount(null);
                }
            });
            pageList.setRecords(records);
        }
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u98ce\u9669\u67e5\u8be2", notes="\u98ce\u9669\u67e5\u8be2")
    @PostMapping(value={"/queryRisk"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:risk", "supplier_master_data#supplierMasterData:supplierRisk"}, logical=Logical.OR)
    public Result<?> queryRisk(@RequestBody RiskVO riskVO) {
        return this.riskService.queryRisk(riskVO);
    }

    @ApiOperation(value="\u98ce\u9669\u67e5\u8be2", notes="\u98ce\u9669\u67e5\u8be2")
    @PostMapping(value={"/refreshAllRisk"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:risk", "supplier_master_data#supplierMasterData:supplierRisk"}, logical=Logical.OR)
    public Result<?> refreshAllRisk(String list) {
        List<String> collect = new ArrayList<String>();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)list)) {
            HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
            Result<?> result = this.queryPageList(new SupplierMasterData(), 1, Integer.MAX_VALUE, httpServletRequest);
            IPage result1 = (IPage)result.getResult();
            collect = result1.getRecords().stream().map(SupplierMasterData::getToElsAccount).distinct().collect(Collectors.toList());
        } else {
            String[] split = list.split(",");
            collect = new ArrayList(split.length);
            Collections.addAll(collect, split);
        }
        List<String> strings = this.riskService.refreshAllRisk(collect);
        return Result.ok((String)org.apache.commons.lang3.StringUtils.join(strings, (String)","));
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u66f4\u65b0\u57fa\u7840\u4fe1\u606f")
    @ApiOperation(value="\u66f4\u65b0\u57fa\u7840\u4fe1\u606f", notes="\u66f4\u65b0\u57fa\u7840\u4fe1\u606f")
    @PostMapping(value={"/updateBaseInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:updateBaseInfo"})
    public Result<?> updateBaseInfo(@RequestBody SupplierMasterData supplierMasterData) {
        return this.supplierMasterDataService.updateBaseInfo(supplierMasterData);
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u66f4\u65b0\u57fa\u7840\u4fe1\u606f\u3010\u786e\u8ba4\u3011")
    @ApiOperation(value="\u66f4\u65b0\u57fa\u7840\u4fe1\u606f\u3010\u786e\u8ba4\u3011", notes="\u66f4\u65b0\u57fa\u7840\u4fe1\u606f\u3010\u786e\u8ba4\u3011")
    @PostMapping(value={"/confirmUpdateBaseInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:updateBaseInfo"})
    public Result<?> confirmUpdateBaseInfo(@RequestBody EnterpriseBaseInfoVO baseInfoVO) {
        this.supplierMasterDataService.confirmUpdateBaseInfo(baseInfoVO);
        return Result.ok((String)I18nUtil.translate((String)"i18n_title_operationSuccess", (String)"\u64cd\u4f5c\u6210\u529f\uff01"));
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    @PermissionDataView(businessType="supplierMasterData")
    public Result<?> queryTabsCount(SupplierMasterData supplierMasterData, HttpServletRequest req) {
        ArrayList<CountDTO> result = new ArrayList<CountDTO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"supplier_status", "count(0) as participate_quantity"});
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"supplier_status");
        List list = ((SupplierMasterDataService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SupplierMasterData::getSupplierStatus, SupplierMasterData::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        String path = "/srm/supplier/purchase/supplierMaster/list";
        result.add(new CountDTO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "supplierStatus", null, all, "", path));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmSupplierStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountDTO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "supplierStatus", status.getValue(), total, "", path));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5224\u65ad\u4f9b\u5e94\u5546\u662f\u5426\u88ab\u51bb\u7ed3", notes="\u5224\u65ad\u4f9b\u5e94\u5546\u662f\u5426\u88ab\u51bb\u7ed3")
    @PostMapping(value={"/isExistFrozenStateData"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> isExistFrozenStateData(@RequestBody SupplierMasterFrozen frozen) {
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(frozen.getToElsAccount());
        SupplierMasterFrozen data = this.supplierMasterFrozenService.isExistFrozenStateData(toElsAccountList, frozen.getFrozenFunction(), frozen.getOrgType(), frozen.getOrgCode());
        if (data != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)data.getId())) {
            String toElsAcount = data.getToElsAccount();
            String orgCodeText = data.getCurrentOrgCodeText();
            String frozenFunctionText = data.getFrozenFunctionText();
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_WWWWWWKWWWWWWjWWWWWWROIqOy_1d833591", (String)"[${0}]\u5728 [${1}]\u7684[${2}]\u529f\u80fd\u5df2\u88ab\u51bb\u7ed3", (String[])new String[]{toElsAcount, orgCodeText, frozenFunctionText}));
        }
        return Result.ok();
    }

    @ApiOperation(value="\u5224\u65ad\u4f9b\u5e94\u5546\u662f\u5426\u88ab\u51bb\u7ed3-\u5bfb\u6e90", notes="\u5224\u65ad\u4f9b\u5e94\u5546\u662f\u5426\u88ab\u51bb\u7ed3-\u5bfb\u6e90")
    @PostMapping(value={"/isExistFrozenSource"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> isExistFrozenSource(@RequestBody SupplierMasterFrozenVO frozen) {
        SupplierMasterFrozen data = this.supplierMasterFrozenService.isExistFrozenSource(frozen);
        if (data != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)data.getId())) {
            String toElsAcount = data.getToElsAccount();
            String orgCodeText = data.getCurrentOrgCodeText();
            String frozenFunctionText = data.getFrozenFunctionText();
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_WWWWWWKWWWWWWjWWWWWWROIqOy_1d833591", (String)"[${0}]\u5728 [${1}]\u7684[${2}]\u529f\u80fd\u5df2\u88ab\u51bb\u7ed3", (String[])new String[]{toElsAcount, orgCodeText, frozenFunctionText}));
        }
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7elsAccount\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f", notes="\u901a\u8fc7elsAccount\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f")
    @GetMapping(value={"/queryEnterpriseByElsAccount"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> queryEnterpriseByElsAccount(@RequestParam(name="elsAccount") String elsAccount) {
        ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierInvokeEnterpriseRpcService.getByElsAccount(elsAccount);
        if (elsEnterpriseInfo == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_mhGNWVKHRvj_55cacd25", (String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
        }
        return Result.ok((Object)elsEnterpriseInfo);
    }

    @ApiOperation(value="\u901a\u8fc7elsAccount\u83b7\u53d6\u4f9b\u5e94\u5546\u753b\u50cf\u9875\u9762\u4fe1\u606f", notes="\u901a\u8fc7elsAccount\u83b7\u53d6\u4f9b\u5e94\u5546\u753b\u50cf\u9875\u9762\u4fe1\u606f")
    @GetMapping(value={"/getSupplierPortraitInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> getSupplierPortraitInfo(@RequestParam(name="elsAccount") String elsAccount) {
        return Result.ok((Object)this.supplierMasterDataService.getSupplierPortraitInfo(elsAccount));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u4eceERP\u83b7\u53d6\u6570\u636e")
    @ApiOperation(value="\u4eceERP\u83b7\u53d6\u6570\u636e", notes="\u4eceERP\u83b7\u53d6\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:getDataByErp"})
    public Result<?> getDataByErp() {
        this.supplierMasterDataService.getDataByErp();
        return Result.ok();
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-SRM\u63a8\u9001\u6d88\u606f\u5230ERP")
    @ApiOperation(value="SRM\u63a8\u9001\u6d88\u606f\u5230ERP", notes="SRM\u63a8\u9001\u6d88\u606f\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:pushDataToErp"})
    @PermissionDataOpt(businessType="supplierMasterData", beanClass=SupplierMasterDataService.class)
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ids)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ViFYdjWF_6327d1b2", (String)"\u8bf7\u9009\u62e9\u63a8\u9001\u7684\u6570\u636e"));
        }
        this.supplierMasterDataService.pushDataToErp(ids);
        return Result.ok();
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u591a\u9875\u7b7e\u5bfc\u51fa")
    @ApiOperation(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u591a\u9875\u7b7e\u5bfc\u51fa", notes="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u591a\u9875\u7b7e\u5bfc\u51fa")
    @PostMapping(value={"/exportDetailData"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:supplierInfoExport"})
    public void exportDetailData(HttpServletRequest request, HttpServletResponse response, @RequestBody Map<String, Object> param) {
        String headIds = (String)param.get("headIds");
        Assert.hasText((String)headIds, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        String tabs = (String)param.get("tabs");
        this.supplierMasterDataService.exportDetailData(headIds, tabs, response);
    }

    @ApiOperation(value="\u5929\u773c\u67e5-\u5e55\u540e\u5173\u7cfb\u53d1\u73b0\uff08\u5f02\u6b65\uff09\u6d4b\u8bd5", notes="\u5929\u773c\u67e5-\u5e55\u540e\u5173\u7cfb\u53d1\u73b0\uff08\u5f02\u6b65\uff09\u6d4b\u8bd5")
    @GetMapping(value={"/queryBehindRelationship"})
    public JSONObject queryBehindRelationship() {
        ArrayList<String> supplierNameList = new ArrayList<String>();
        supplierNameList.add("\u5e7f\u5dde\u68b5\u52d2\u58eb\u8d38\u6613\u6709\u9650\u516c\u53f8");
        supplierNameList.add("\u7ebd\u5929\u8d38\u6613\uff08\u6df1\u5733\uff09\u6709\u9650\u516c\u53f8");
        supplierNameList.add("\u5e7f\u5dde\u7ebd\u5929\u8d38\u6613\u6709\u9650\u516c\u53f8");
        return this.riskService.queryBehindRelationship(supplierNameList);
    }

    @AutoLog(value="\u8865\u507f\u65e7\u6570\u636e-\u7528\u5b8c\u4ee5\u540e\u4f1a\u5220\u9664")
    @ApiOperation(value="\u8865\u507f\u65e7\u6570\u636e", notes="\u8865\u507f\u65e7\u6570\u636e")
    @GetMapping(value={"/noToken/compensateForOldData"})
    public Result<?> compensateForOldData(HttpServletRequest request, HttpServletResponse response) {
        this.supplierMasterDataService.compensateForOldData();
        return Result.ok((String)"!\u6267\u884c\u7ed3\u675f\uff01");
    }

    @AutoLog(value="\u6839\u636e\u4f9b\u5e94\u5546\u8d26\u53f7\u67e5\u8be2\u9ed8\u8ba4\u94f6\u884c\u8d26\u53f7\u4fe1\u606f")
    @ApiOperation(value="\u6839\u636e\u4f9b\u5e94\u5546\u8d26\u53f7\u67e5\u8be2\u9ed8\u8ba4\u94f6\u884c\u8d26\u53f7\u4fe1\u606f", notes="\u6839\u636e\u4f9b\u5e94\u5546\u8d26\u53f7\u67e5\u8be2\u9ed8\u8ba4\u94f6\u884c\u8d26\u53f7\u4fe1\u606f")
    @GetMapping(value={"/getBankByElsAccount"})
    public Result<?> getBankByElsAccount(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="companyCode") String companyCode, @RequestParam(name="orgCode") String orgCode, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        List SupplierOrgInfoList2;
        SupplierBankInfoVO supplierBankInfoVO = new SupplierBankInfoVO();
        List<SupplierBankInfo> supplierBankInfoList = this.supplierInvokeEnterpriseRpcService.getBankByElsAccount(elsAccount);
        if (CollectionUtil.isNotEmpty(supplierBankInfoList)) {
            List supplierBankInfo2;
            List supplierBankInfos = supplierBankInfoList.stream().filter(SupplierBankInfo2 -> SupplierBankInfo2.getCompany().equals(companyCode)).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(supplierBankInfos)) {
                SupplierBankInfo supplierBankInfo1 = (SupplierBankInfo)((Object)supplierBankInfos.get(0));
                BeanUtils.copyProperties((Object)((Object)supplierBankInfo1), (Object)((Object)supplierBankInfoVO));
            }
            if (CollectionUtil.isEmpty(supplierBankInfos) && CollectionUtil.isNotEmpty(supplierBankInfo2 = supplierBankInfoList.stream().filter(SupplierBankInfo2 -> SupplierBankInfo2.getDefaultAccount().equals("1")).collect(Collectors.toList()))) {
                SupplierBankInfo supplierBankInfo1 = (SupplierBankInfo)((Object)supplierBankInfo2.get(0));
                BeanUtils.copyProperties((Object)((Object)supplierBankInfo1), (Object)((Object)supplierBankInfoVO));
            }
        }
        List<SupplierOrgInfo> SupplierOrgInfoList = this.supplierInvokeEnterpriseRpcService.getSupplierOrgInfoByElsAccount(elsAccount);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orgCode) && CollectionUtil.isNotEmpty(SupplierOrgInfoList) && CollectionUtil.isNotEmpty(SupplierOrgInfoList2 = SupplierOrgInfoList.stream().filter(SupplierOrgInfo2 -> SupplierOrgInfo2.getOrgCode().equals(orgCode)).collect(Collectors.toList()))) {
            SupplierOrgInfo supplierOrgInfo = SupplierOrgInfoList.get(0);
            supplierBankInfoVO.setPayConditionCode(supplierOrgInfo.getPayConditionCode());
            supplierBankInfoVO.setPaymentMethod(supplierOrgInfo.getPaymentMethod());
        }
        return Result.ok((Object)((Object)supplierBankInfoVO));
    }

    @AutoLog(value="\u6839\u636e\u4f9b\u5e94\u5546\u8d26\u53f7\u67e5\u8be2\u94f6\u884c\u8d26\u53f7\u4fe1\u606f")
    @ApiOperation(value="\u6839\u636e\u4f9b\u5e94\u5546\u8d26\u53f7\u67e5\u8be2\u94f6\u884c\u8d26\u53f7\u4fe1\u606f", notes="\u6839\u636e\u4f9b\u5e94\u5546\u8d26\u53f7\u67e5\u8be2\u94f6\u884c\u8d26\u53f7\u4fe1\u606f")
    @GetMapping(value={"/getBankListByElsAccount"})
    public Result<?> getBankListByElsAccount(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="companyCode") String companyCode, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)companyCode), (Object)"company", (Object)companyCode);
        IPage<SupplierBankInfo> pageList = this.supplierBankInfoService.selectListPage((Page<SupplierBankInfo>)page, (QueryWrapper<SupplierBankInfo>)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)pageList.getRecords()) && pageList.getRecords().size() > 0) {
            List records = pageList.getRecords();
            records.forEach(o -> {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)o.getHeadId())) {
                    o.setToElsAccount(null);
                }
            });
            pageList.setRecords(records);
        }
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/seleBanksPage"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:view"})
    public Result<?> seleBanksPage(PurchaseYhBranchBankVO purchaseMaterialHeadVO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="200") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMaterialHeadVO), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<PurchaseYhBranchBankVO> pageList = this.supplierMasterDataService.seleBanksPage((Page<PurchaseYhBranchBankVO>)page, (QueryWrapper<PurchaseYhBranchBankVO>)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u67e5\u8be2\u65b0\u4f9b\u5e94\u5546\u6570", notes="\u67e5\u8be2\u65b0\u4f9b\u5e94\u5546\u6570")
    @GetMapping(value={"/queryNewSupplierCount"})
    public Result<?> queryNewSupplierCount(SupplierMasterData supplierMasterData, HttpServletRequest req) {
        JSONArray resultArr = new JSONArray();
        Integer count = ((LambdaQueryChainWrapper)this.supplierMasterDataService.lambdaQuery().apply("DATE_FORMAT(create_time,'%Y-%m') = DATE_FORMAT(now(), '%Y-%m')", new Object[0])).count();
        Integer compareLastMonth = ((LambdaQueryChainWrapper)this.supplierMasterDataService.lambdaQuery().apply("DATE_FORMAT(create_time,'%Y-%m') = DATE_FORMAT(date_add(now(), INTERVAL -1 MONTH), '%Y-%m')", new Object[0])).count();
        JSONObject compareMonthObj = new JSONObject();
        compareMonthObj.put("title", (Object)I18nUtil.translate((String)"i18n_field_lXZ_19ea112", (String)"\u6bd4\u4e0a\u6708"));
        compareMonthObj.put("total", (Object)Math.abs(count - compareLastMonth));
        compareMonthObj.put("icon", (Object)(count > compareLastMonth ? "caret-down" : "caret-up"));
        resultArr.add((Object)compareMonthObj);
        Integer compareLastYear = ((LambdaQueryChainWrapper)this.supplierMasterDataService.lambdaQuery().apply("DATE_FORMAT(create_time,'%Y') = DATE_FORMAT( date_add(now(), INTERVAL - 1 YEAR), '%Y')", new Object[0])).count();
        JSONObject compareYearObj = new JSONObject();
        compareYearObj.put("title", (Object)I18nUtil.translate((String)"i18n_field_lMM_19f48ed", (String)"\u6bd4\u53bb\u5e74"));
        compareYearObj.put("total", (Object)Math.abs(count - compareLastYear));
        compareYearObj.put("icon", (Object)(count > compareLastYear ? "caret-down" : "caret-up"));
        resultArr.add((Object)compareYearObj);
        JSONObject resultObj = new JSONObject();
        resultObj.put("total", (Object)count);
        resultObj.put("comparisons", (Object)resultArr);
        return Result.ok((Object)resultObj);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f9b\u5e94\u5546\u5f02\u5e38\u4fe1\u606f", notes="\u67e5\u8be2\u4f9b\u5e94\u5546\u5f02\u5e38\u4fe1\u606f")
    @GetMapping(value={"/abnormalCount"})
    public Result<?> querySupplierAbnormalCount(SupplierMasterData supplierMasterData, HttpServletRequest req) {
        ArrayList<CountDTO> result = new ArrayList<CountDTO>();
        Integer count = ((LambdaQueryChainWrapper)this.supplierCertificatedInfoService.lambdaQuery().lt(SupplierCertificatedInfo::getExpiryDate, (Object)new Date())).count();
        result.add(new CountDTO(I18nUtil.translate((String)"i18n_alert_JRIH_4254feda", (String)"\u8d44\u8d28\u5f02\u5e38"), "supplierAbnormal", "certificatedInfo", count, "", "/srm/supplier/purchase/access/SupplierAccessMgmtQualificationReviewList"));
        Integer abnormalCount = 12;
        result.add(new CountDTO(I18nUtil.translate((String)"i18n_alert_XNLLIH_5c943df6", (String)"\u5546\u54c1\u627f\u8ba4\u5f02\u5e38"), "supplierAbnormal", "sampleCheck", abnormalCount, "", "/srm/sample/sampleHead/list"));
        Integer eightCount = 23;
        result.add(new CountDTO(I18nUtil.translate((String)"i18n_alert_8DrH_2745ce", (String)"8D\u6539\u8fdb"), "supplierAbnormal", "eightReport", eightCount, "", "/srm/quality/eightReport/list"));
        return Result.ok(result);
    }
}

