/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.message.listener;

import com.alibaba.fastjson.JSON;
import com.els.common.context.TokenContext;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.mapper.SupplierMasterDataMapper;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.SupplierMasterDataImportVo;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
public class SupplierMasterDataImportMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(SupplierMasterDataImportMessageConsumer.class);
    private static final String MASTER_DATA_MAPPER = "SupplierMasterDataMapper";
    @Lazy
    @Resource
    private RedisUtil redisUtil;
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SupplierMasterDataMapper supplierMasterDataMapper;

    @Bean(value={"inputSupImport"})
    public Consumer<Message<String>> receive() {
        return message -> {
            String key = (String)message.getHeaders().get((Object)"ROCKET_KEYS");
            String msgBody = (String)message.getPayload();
            SupplierMasterDataImportVo importVo = new SupplierMasterDataImportVo();
            log.info("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5bfc\u5165MQ\u6d88\u8d39 log:  " + msgBody);
            String msgStatus = this.invokeBaseRpcService.getMsgStatusById(key);
            if ("1".equals(msgStatus)) {
                log.error("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5bfc\u5165MQ\u6d88\u8d39-\u6d88\u606fID\uff1a" + key + " \u5df2\u7ecf\u6d88\u8d39\uff0c\u4e0d\u80fd\u91cd\u590d\u6d88\u8d39\uff01");
                return;
            }
            String errorInfo = "";
            try {
                importVo = (SupplierMasterDataImportVo)JSON.parseObject((String)msgBody, SupplierMasterDataImportVo.class);
                LoginUser loginUser = importVo.getLoginUser();
                String tenant = importVo.getTenant();
                String token = importVo.getToken();
                LoginUserContext.setUser((LoginUser)loginUser);
                TenantContext.setTenant((String)tenant);
                TokenContext.setToken((String)token);
                this.supplierMasterDataService.importSupplierMasterDataAsynsDo(importVo);
                log.info(msgBody);
                msgStatus = "1";
            }
            catch (Exception e) {
                log.error("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5bfc\u5165MQ\u6d88\u8d39 log failed:" + msgBody, (Throwable)e);
                msgStatus = "2";
                errorInfo = e.getMessage();
                SupplierMasterData supplierMasterData = importVo.getSupplierMasterData();
                this.supplierMasterDataMapper.delById(supplierMasterData.getId());
            }
            finally {
                this.invokeBaseRpcService.updateRecord(key, msgStatus, errorInfo);
                this.redisUtil.deleteBykeyword(MASTER_DATA_MAPPER);
                LoginUserContext.clear();
                TenantContext.clear();
                TokenContext.clear();
            }
        };
    }
}

