/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierAddressInfoRelation;
import com.els.modules.supplier.mapper.SupplierAddressInfoMapper;
import com.els.modules.supplier.mapper.SupplierAddressInfoRelationMapper;
import com.els.modules.supplier.service.SupplierAddressInfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierAddressInfoServiceImpl
extends ServiceImpl<SupplierAddressInfoMapper, SupplierAddressInfo>
implements SupplierAddressInfoService {
    @Autowired
    private SupplierAddressInfoMapper supplierAddressInfoMapper;
    @Autowired
    private SupplierAddressInfoRelationMapper supplierAddressInfoRelationMapper;

    @Override
    public List<SupplierAddressInfo> selectByMainId(String mainId) {
        return this.supplierAddressInfoMapper.selectByMainId(mainId);
    }

    @Override
    public List<SupplierAddressInfo> getByAccount(String elsAccount, String toElsAccount) {
        if (StringUtils.isBlank((CharSequence)toElsAccount)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)elsAccount);
            queryWrapper.eq((Object)"is_deleted", (Object)0);
            return this.supplierAddressInfoMapper.selectList((Wrapper)queryWrapper);
        }
        List<SupplierAddressInfo> addressInfos = this.supplierAddressInfoMapper.getByAccount(elsAccount, toElsAccount);
        List<SupplierAddressInfoRelation> addressInfoRelationList = this.supplierAddressInfoRelationMapper.getByAccount(elsAccount, toElsAccount);
        ArrayList relationList = SysUtil.copyProperties(addressInfoRelationList, SupplierAddressInfo.class);
        if (CollUtil.isNotEmpty((Collection)relationList) && relationList.size() > 0) {
            relationList.forEach(o -> o.setToElsAccount(null));
        }
        addressInfos.addAll(relationList);
        return addressInfos;
    }

    @Override
    public List<SupplierAddressInfo> getByAccountAndRecordId(String elsAccount, String toElsAccount, String recordId, List<SupplierAddressInfo> oldAddressInfoList) {
        if (StringUtils.isBlank((CharSequence)toElsAccount)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)elsAccount);
            queryWrapper.eq((Object)"is_deleted", (Object)0);
            return this.supplierAddressInfoMapper.selectList((Wrapper)queryWrapper);
        }
        List<SupplierAddressInfo> addressInfos = this.supplierAddressInfoMapper.getByAccount(elsAccount, toElsAccount);
        if (StringUtils.isNotBlank((CharSequence)recordId)) {
            addressInfos.addAll(oldAddressInfoList);
        } else {
            List<SupplierAddressInfoRelation> addressInfoRelationList = this.supplierAddressInfoRelationMapper.getByAccount(elsAccount, toElsAccount);
            ArrayList relationList = SysUtil.copyProperties(addressInfoRelationList, SupplierAddressInfo.class);
            if (CollUtil.isNotEmpty((Collection)relationList) && relationList.size() > 0) {
                relationList.forEach(o -> o.setToElsAccount(null));
            }
            addressInfos.addAll(relationList);
        }
        return addressInfos;
    }

    @Override
    public List<SupplierAddressInfo> getDataOnlyAccount(String elsAccount) {
        List<SupplierAddressInfo> infoList = this.supplierAddressInfoMapper.getByAccount(elsAccount, null);
        if (CollUtil.isNotEmpty(infoList) && infoList.size() > 0) {
            infoList.forEach(o -> {
                if (StringUtils.isNotBlank((CharSequence)o.getTagId())) {
                    o.setId(o.getTagId());
                }
            });
        }
        return infoList;
    }

    @Override
    public void deleteByElsAccount(String elsAccount) {
        this.supplierAddressInfoMapper.deleteByElsAccount(elsAccount);
    }

    @Override
    public IPage<SupplierAddressInfo> selectListPage(Page<SupplierAddressInfo> page, QueryWrapper<SupplierAddressInfo> queryWrapper) {
        return this.supplierAddressInfoMapper.selectListPage(page, queryWrapper);
    }
}

