/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.util;

import com.els.common.exception.ELSBootException;
import com.els.modules.supplier.vo.FieldRecordVo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class TwoBeanComparatorUtils {
    private static final Logger log = LoggerFactory.getLogger(TwoBeanComparatorUtils.class);
    private static final Set<Class<?>> primitiveWrapperSet = new HashSet(10);

    public static String compareBean(Object source, Object target) {
        return TwoBeanComparatorUtils.compareBean(source, target, null);
    }

    public static Map compareBeanToMap(Object source, Object target) {
        return TwoBeanComparatorUtils.compareBeanToMap(source, target, null);
    }

    public static List<FieldRecordVo> compareBeanToFieldRecord(String group, String itemId, String updateType, Object source, Object target) {
        return TwoBeanComparatorUtils.compareBeanToFieldRecordVo(group, itemId, updateType, source, target, null);
    }

    public static String compareBean(Object source, Object target, Map<String, String> propertyTranslationMap) {
        if (source == null) {
            throw new ELSBootException("source is null.");
        }
        if (target == null) {
            throw new ELSBootException("target is null.");
        }
        if (!source.getClass().equals(target.getClass())) {
            throw new ELSBootException("source.class and target.class is not same.");
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = source.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        if (fieldList.isEmpty()) {
            throw new ELSBootException("source.class has no property.");
        }
        return TwoBeanComparatorUtils.compareProperty(source, target, source.getClass(), fieldList, propertyTranslationMap);
    }

    public static Map compareBeanToMap(Object source, Object target, Map<String, String> propertyTranslationMap) {
        if (source == null) {
            throw new ELSBootException("source is null.");
        }
        if (target == null) {
            throw new ELSBootException("target is null.");
        }
        if (!source.getClass().equals(target.getClass())) {
            throw new ELSBootException("source.class and target.class is not same.");
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = source.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        if (fieldList.isEmpty()) {
            throw new ELSBootException("source.class has no property.");
        }
        return TwoBeanComparatorUtils.comparePropertyToMap(source, target, source.getClass(), fieldList, propertyTranslationMap);
    }

    private static List<FieldRecordVo> compareBeanToFieldRecordVo(String group, String itemId, String updateType, Object source, Object target, Map<String, String> propertyTranslationMap) {
        if (source == null) {
            throw new ELSBootException("source is null.");
        }
        if (target == null) {
            throw new ELSBootException("target is null.");
        }
        if (!source.getClass().equals(target.getClass())) {
            throw new ELSBootException("source.class and target.class is not same.");
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = source.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        if (fieldList.isEmpty()) {
            throw new ELSBootException("source.class has no property.");
        }
        return TwoBeanComparatorUtils.comparePropertyToFieldRecordVo(group, itemId, updateType, source, target, source.getClass(), fieldList, propertyTranslationMap);
    }

    private static String compareProperty(Object source, Object target, Class<?> clazz, List<Field> fields, Map<String, String> propertyTranslationMap) {
        StringBuilder sBuilder = new StringBuilder();
        for (Field field : fields) {
            if (!TwoBeanComparatorUtils.isSampleProperty(field.getType())) continue;
            String name = field.getName();
            String nameMapped = null;
            if (propertyTranslationMap != null && !propertyTranslationMap.isEmpty()) {
                if (!propertyTranslationMap.containsKey(name)) continue;
                nameMapped = propertyTranslationMap.get(name);
            }
            Class<?> propertyClazz = field.getClass();
            Object sourcePropertyValue = TwoBeanComparatorUtils.getValueByField(source, clazz, field);
            Object targetPropertyValue = TwoBeanComparatorUtils.getValueByField(target, clazz, field);
            if (nameMapped != null) {
                name = nameMapped;
            }
            TwoBeanComparatorUtils.comparePropertyValue(sBuilder, name, propertyClazz, sourcePropertyValue, targetPropertyValue);
        }
        return sBuilder.toString();
    }

    private static Map<String, Object> comparePropertyToMap(Object source, Object target, Class<?> clazz, List<Field> fields, Map<String, String> propertyTranslationMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields) {
            if (!TwoBeanComparatorUtils.isSampleProperty(field.getType())) continue;
            String name = field.getName();
            String nameMapped = null;
            if (propertyTranslationMap != null && !propertyTranslationMap.isEmpty()) {
                if (!propertyTranslationMap.containsKey(name)) continue;
                nameMapped = propertyTranslationMap.get(name);
            }
            Class<?> propertyClazz = field.getClass();
            Object sourcePropertyValue = TwoBeanComparatorUtils.getValueByField(source, clazz, field);
            Object targetPropertyValue = TwoBeanComparatorUtils.getValueByField(target, clazz, field);
            if (nameMapped != null) {
                name = nameMapped;
            }
            TwoBeanComparatorUtils.comparePropertyValue(map, name, propertyClazz, sourcePropertyValue, targetPropertyValue);
        }
        return map;
    }

    private static List<FieldRecordVo> comparePropertyToFieldRecordVo(String group, String itemId, String updateType, Object source, Object target, Class<?> clazz, List<Field> fields, Map<String, String> propertyTranslationMap) {
        ArrayList<FieldRecordVo> list = new ArrayList<FieldRecordVo>();
        for (Field field : fields) {
            if (!TwoBeanComparatorUtils.isSampleProperty(field.getType())) continue;
            String name = field.getName();
            String nameMapped = null;
            if (propertyTranslationMap != null && !propertyTranslationMap.isEmpty()) {
                if (!propertyTranslationMap.containsKey(name)) continue;
                nameMapped = propertyTranslationMap.get(name);
            }
            Class<?> propertyClazz = field.getClass();
            Object sourcePropertyValue = TwoBeanComparatorUtils.getValueByField(source, clazz, field);
            Object targetPropertyValue = TwoBeanComparatorUtils.getValueByField(target, clazz, field);
            if (nameMapped != null) {
                name = nameMapped;
            }
            TwoBeanComparatorUtils.comparePropertyValue(list, group, itemId, updateType, name, propertyClazz, sourcePropertyValue, targetPropertyValue);
        }
        return list;
    }

    private static Object getValueByField(Object obj, Class<?> clazz, Field field) {
        Object result = null;
        if (field.getGenericType().toString().equals("boolean")) {
            Object methodName = field.getName();
            if (!((String)methodName).startsWith("is")) {
                methodName = "is" + ((String)methodName).substring(0, 1).toUpperCase() + ((String)methodName).substring(1);
            }
            Method method = null;
            try {
                method = clazz.getMethod((String)methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                log.error(e.getMessage());
            }
            catch (SecurityException e) {
                log.error(e.getMessage());
            }
            try {
                if (method != null) {
                    result = method.invoke(obj, new Object[0]);
                }
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                log.error(e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.error(e.getMessage());
            }
        } else {
            try {
                PropertyDescriptor descriptor;
                if (clazz != null && (descriptor = BeanUtils.getPropertyDescriptor(clazz, (String)field.getName())) != null) {
                    Method method = descriptor.getReadMethod();
                    result = method.invoke(obj, new Object[0]);
                }
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage());
                throw new ELSBootException(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                log.error(e.getMessage());
                throw new ELSBootException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.error(e.getMessage());
                throw new ELSBootException(e.getMessage());
            }
        }
        return result;
    }

    private static void comparePropertyValue(StringBuilder sBuilder, String name, Class<?> propertyClazz, Object sourcePropertyValue, Object targetPropertyValue) {
        if (!Objects.equals(sourcePropertyValue, targetPropertyValue)) {
            String sourcePropertyValueStr = TwoBeanComparatorUtils.getFormatStr(sourcePropertyValue);
            String targetPropertyValueStr = TwoBeanComparatorUtils.getFormatStr(targetPropertyValue);
            sBuilder.append(name + ":" + sourcePropertyValueStr + "->" + targetPropertyValueStr + ",");
        }
    }

    private static void comparePropertyValue(Map<String, Object> map, String name, Class<?> propertyClazz, Object sourcePropertyValue, Object targetPropertyValue) {
        String targetPropertyValueStr;
        String sourcePropertyValueStr = TwoBeanComparatorUtils.getFormatStr(sourcePropertyValue);
        if (!Objects.equals(sourcePropertyValueStr, targetPropertyValueStr = TwoBeanComparatorUtils.getFormatStr(targetPropertyValue))) {
            map.put(name, targetPropertyValueStr);
        }
    }

    private static void comparePropertyValue(List<FieldRecordVo> list, String group, String itemId, String updateType, String field, Class<?> propertyClazz, Object initialValue, Object fieldValue) {
        String targetPropertyValueStr;
        String sourcePropertyValueStr = TwoBeanComparatorUtils.getFormatStr(initialValue);
        if (!Objects.equals(sourcePropertyValueStr, targetPropertyValueStr = TwoBeanComparatorUtils.getFormatStr(fieldValue))) {
            FieldRecordVo vo = new FieldRecordVo();
            vo.setGroup(group);
            vo.setItemId(itemId);
            vo.setUpdateType(updateType);
            vo.setField(field);
            vo.setFieldValue(targetPropertyValueStr);
            vo.setInitialValue(sourcePropertyValueStr);
            list.add(vo);
        }
    }

    private static String getFormatStr(Object propertyValue) {
        if (propertyValue == null) {
            return "";
        }
        if (propertyValue instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)propertyValue);
        }
        if (propertyValue instanceof Number) {
            BigDecimal decimal = new BigDecimal(propertyValue.toString());
            return decimal.stripTrailingZeros().toString();
        }
        return propertyValue.toString();
    }

    private static boolean isSampleProperty(Class<?> clazz) {
        if (clazz == null) {
            throw new ELSBootException("class is null");
        }
        return clazz.isPrimitive() || primitiveWrapperSet.contains(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz);
    }

    static {
        primitiveWrapperSet.add(Boolean.class);
        primitiveWrapperSet.add(Byte.class);
        primitiveWrapperSet.add(Character.class);
        primitiveWrapperSet.add(Double.class);
        primitiveWrapperSet.add(Float.class);
        primitiveWrapperSet.add(Integer.class);
        primitiveWrapperSet.add(Long.class);
        primitiveWrapperSet.add(Short.class);
    }
}

