/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.vmi.excel;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.vmi.entity.VmiInventory;
import com.els.modules.vmi.rpc.service.VimInvokeMaterialRpcService;
import com.els.modules.vmi.service.VmiInventoryService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VmiInventoryImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(VmiInventoryImportImpl.class);
    @Autowired
    private VmiInventoryService vmiInventoryService;
    @Resource
    private VimInvokeMaterialRpcService vimInvokeMaterialRpcService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        String elsAccount = TenantContext.getTenant();
        LoginUser user = SysUtil.getLoginUser();
        HashMap<String, PurchaseMaterialHeadDTO> materialMap = new HashMap<String, PurchaseMaterialHeadDTO>();
        ArrayList<VmiInventory> list = new ArrayList<VmiInventory>();
        log.info("vmiInventoryImportImpl:::\u5bfc\u5165-start");
        ArrayList<String> materialNumberList = new ArrayList<String>();
        ArrayList<String> factoryList = new ArrayList<String>();
        ArrayList<String> storageLocationList = new ArrayList<String>();
        ArrayList<String> storageBinList = new ArrayList<String>();
        ArrayList<String> batchNumberList = new ArrayList<String>();
        for (Map data : dataList) {
            VmiInventory vmiInventory = (VmiInventory)((Object)this.transferEntity(data, VmiInventory.class, excelImportDTO));
            if (null == vmiInventory) continue;
            vmiInventory.setElsAccount(elsAccount);
            vmiInventory.setDeleted(CommonConstant.DEL_FLAG_0);
            vmiInventory.setCreateTime(new Date());
            vmiInventory.setCreateBy(user.getSubAccount());
            vmiInventory.setUpdateBy(vmiInventory.getCreateBy());
            vmiInventory.setUpdateTime(vmiInventory.getCreateTime());
            String materialNumber = vmiInventory.getMaterialNumber();
            PurchaseMaterialHeadDTO materialHead = null;
            if (materialMap.containsKey(materialNumber)) {
                materialHead = (PurchaseMaterialHeadDTO)materialMap.get(materialNumber);
            } else {
                ArrayList<String> materialNumbers = new ArrayList<String>();
                materialNumbers.add(materialNumber);
                List<PurchaseMaterialHeadDTO> materialList = this.vimInvokeMaterialRpcService.list(materialNumbers);
                if (materialList.isEmpty()) {
                    String msg = I18nUtil.translate((String)"i18n_alert_empty_material", (String)"\u7269\u6599\u7f16\u53f7\uff1a${0}\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01", (String[])new String[]{materialNumber});
                    this.errorAdd(excelImportDTO, msg, data);
                    excelImportDTO.getErrorDataList().add(data);
                    continue;
                }
                materialHead = materialList.get(0);
                materialMap.put(materialNumber, materialHead);
            }
            vmiInventory.setMaterialGroup(materialHead.getMaterialGroup());
            vmiInventory.setMaterialDesc(materialHead.getMaterialDesc());
            vmiInventory.setMaterialName(materialHead.getMaterialName());
            vmiInventory.setMaterialType(materialHead.getMaterialType());
            vmiInventory.setBrand(materialHead.getBrand());
            StringBuilder sbKey = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)materialNumber)) {
                materialNumberList.add(materialNumber);
                sbKey.append(materialNumber);
            }
            if (StringUtils.isNotBlank((CharSequence)vmiInventory.getFactory())) {
                factoryList.add(vmiInventory.getFactory());
                sbKey.append(";").append(vmiInventory.getFactory());
            }
            if (StringUtils.isNotBlank((CharSequence)vmiInventory.getStorageLocation())) {
                storageLocationList.add(vmiInventory.getStorageLocation());
                sbKey.append(";").append(vmiInventory.getStorageLocation());
            }
            if (StringUtils.isNotBlank((CharSequence)vmiInventory.getStorageBin())) {
                storageBinList.add(vmiInventory.getStorageBin());
                sbKey.append(";").append(vmiInventory.getStorageBin());
            }
            if (StringUtils.isNotBlank((CharSequence)vmiInventory.getBatchNumber())) {
                batchNumberList.add(vmiInventory.getBatchNumber());
                sbKey.append(";").append(vmiInventory.getBatchNumber());
            }
            vmiInventory.setImportStrKey(sbKey.toString());
            list.add(vmiInventory);
        }
        if (list.isEmpty()) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!materialNumberList.isEmpty() && materialNumberList.size() > 0) {
            ((QueryWrapper)queryWrapper.or()).in((Object)"material_number", materialNumberList);
        }
        if (!factoryList.isEmpty() && factoryList.size() > 0) {
            ((QueryWrapper)queryWrapper.or()).in((Object)"factory", factoryList);
        }
        if (!storageLocationList.isEmpty() && storageLocationList.size() > 0) {
            ((QueryWrapper)queryWrapper.or()).in((Object)"storage_location", storageLocationList);
        }
        if (!storageBinList.isEmpty() && storageBinList.size() > 0) {
            ((QueryWrapper)queryWrapper.or()).in((Object)"storage_bin", storageBinList);
        }
        if (!batchNumberList.isEmpty() && batchNumberList.size() > 0) {
            ((QueryWrapper)queryWrapper.or()).in((Object)"batch_number", batchNumberList);
        }
        List oldList = this.vmiInventoryService.list((Wrapper)queryWrapper);
        this.distinguishData(list, oldList);
        log.info("vmiInventoryImportImpl:::\u5bfc\u5165-end");
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }

    public void distinguishData(List<VmiInventory> list, List<VmiInventory> oldList) {
        List<VmiInventory> notExistList = list.stream().filter(vo -> !oldList.stream().map(my -> {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)my.getMaterialNumber())) {
                sb.append(my.getMaterialNumber());
            }
            if (StringUtils.isNotBlank((CharSequence)my.getFactory())) {
                sb.append(";").append(my.getFactory());
            }
            if (StringUtils.isNotBlank((CharSequence)my.getStorageLocation())) {
                sb.append(";").append(my.getStorageLocation());
            }
            if (StringUtils.isNotBlank((CharSequence)my.getStorageBin())) {
                sb.append(";").append(my.getStorageBin());
            }
            if (StringUtils.isNotBlank((CharSequence)my.getBatchNumber())) {
                sb.append(";").append(my.getBatchNumber());
            }
            return sb.toString();
        }).collect(Collectors.toList()).contains(vo.getImportStrKey())).collect(Collectors.toList());
        List existList = list.stream().filter(vo -> oldList.stream().map(my -> {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)my.getMaterialNumber())) {
                sb.append(my.getMaterialNumber());
            }
            if (StringUtils.isNotBlank((CharSequence)my.getFactory())) {
                sb.append(";").append(my.getFactory());
            }
            if (StringUtils.isNotBlank((CharSequence)my.getStorageLocation())) {
                sb.append(";").append(my.getStorageLocation());
            }
            if (StringUtils.isNotBlank((CharSequence)my.getStorageBin())) {
                sb.append(";").append(my.getStorageBin());
            }
            if (StringUtils.isNotBlank((CharSequence)my.getBatchNumber())) {
                sb.append(";").append(my.getBatchNumber());
            }
            return sb.toString();
        }).collect(Collectors.toList()).contains(vo.getImportStrKey())).collect(Collectors.toList());
        ArrayList<VmiInventory> editDataList = new ArrayList<VmiInventory>();
        for (VmiInventory vo2 : existList) {
            List editList = oldList.stream().filter(o -> {
                StringBuilder sb = new StringBuilder();
                if (StringUtils.isNotBlank((CharSequence)o.getMaterialNumber())) {
                    sb.append(o.getMaterialNumber());
                }
                if (StringUtils.isNotBlank((CharSequence)o.getFactory())) {
                    sb.append(";").append(o.getFactory());
                }
                if (StringUtils.isNotBlank((CharSequence)o.getStorageLocation())) {
                    sb.append(";").append(o.getStorageLocation());
                }
                if (StringUtils.isNotBlank((CharSequence)o.getStorageBin())) {
                    sb.append(";").append(o.getStorageBin());
                }
                if (StringUtils.isNotBlank((CharSequence)o.getBatchNumber())) {
                    sb.append(";").append(o.getBatchNumber());
                }
                return vo2.getImportStrKey().equals(sb.toString());
            }).collect(Collectors.toList());
            for (VmiInventory editVo : editList) {
                vo2.setId(editVo.getId());
                editDataList.add(vo2);
            }
        }
        List<VmiInventory> updList = editDataList.stream().distinct().collect(Collectors.toList());
        log.info("vmiInventoryImportImpl:::notExistList-" + notExistList.size() + "\uff1bupdList-" + updList.size());
        log.info("vmiInventoryImportImpl:::data-" + ((Object)editDataList).toString());
        this.importDataToDb(notExistList, updList);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void importDataToDb(List<VmiInventory> notExistList, List<VmiInventory> updList) {
        if (!updList.isEmpty() && updList.size() > 0) {
            this.vmiInventoryService.updateBatchById(updList, 200);
        }
        if (!notExistList.isEmpty() && notExistList.size() > 0) {
            this.vmiInventoryService.saveBatch(notExistList, 200);
        }
    }
}

