package com.doudian.open.api.afterSale_operate.param;

import com.doudian.open.gson.annotations.SerializedName;
import com.doudian.open.utils.JsonUtil;
import com.doudian.open.annotation.OpField;

//auto generated, do not edit

public class Logistics {


	@SerializedName("company_code")
	@OpField(required = false , desc = "物流公司code，使用【/order/logisticsCompanyList】接口获取；type=311仅换货时需要填入", example= "yuantong")
	private String companyCode;

	@SerializedName("logistics_code")
	@OpField(required = false , desc = "物流单号（快递单号），仅type=311仅换货时需要填入", example= "YT31368712931")
	private String logisticsCode;

	@SerializedName("receiver_address_id")
	@OpField(required = false , desc = "收件地址id（推荐使用），必须通过【/address/list】获取【address_id】填入。和after_sale_address_detail字段集合二选一；", example= "95251")
	private Long receiverAddressId;

	@SerializedName("sender_address_id")
	@OpField(required = false , desc = "已废弃字段，（隐藏时间20220610）发件地址id", example= "95252")
	private Long senderAddressId;

	@SerializedName("after_sale_address_detail")
	@OpField(required = false , desc = "商家同意退货/同意换货收件地址详情（不推荐使用）；和receiver_address_id字段二选一（推荐使用）；商家可以自定义退货地址。", example= "-")
	private AfterSaleAddressDetail afterSaleAddressDetail;


	@Override
	public String toString(){
		return JsonUtil.toJson(this);
	}

	
	public void setCompanyCode(String companyCode){
		this.companyCode = companyCode;
	}

	
	public String getCompanyCode(){
		return this.companyCode;
	}

	
	public void setLogisticsCode(String logisticsCode){
		this.logisticsCode = logisticsCode;
	}

	
	public String getLogisticsCode(){
		return this.logisticsCode;
	}

	
	public void setReceiverAddressId(Long receiverAddressId){
		this.receiverAddressId = receiverAddressId;
	}

	
	public Long getReceiverAddressId(){
		return this.receiverAddressId;
	}

	
	public void setSenderAddressId(Long senderAddressId){
		this.senderAddressId = senderAddressId;
	}

	
	public Long getSenderAddressId(){
		return this.senderAddressId;
	}

	
	public void setAfterSaleAddressDetail(AfterSaleAddressDetail afterSaleAddressDetail){
		this.afterSaleAddressDetail = afterSaleAddressDetail;
	}

	
	public AfterSaleAddressDetail getAfterSaleAddressDetail(){
		return this.afterSaleAddressDetail;
	}

}