package com.doudian.open.api.order_invoiceList.param;

import com.doudian.open.gson.annotations.SerializedName;
import com.doudian.open.utils.JsonUtil;
import com.doudian.open.annotation.OpField;

//auto generated, do not edit

public class OrderInvoiceListParam {


	@SerializedName("order_id")
	@OpField(required = false , desc = "父订单ID", example= "4718699311644951110")
	private String orderId;

	@SerializedName("order_status")
	@OpField(required = false , desc = "订单状态，逗号分割", example= "3,5")
	private String orderStatus;

	@SerializedName("start_time")
	@OpField(required = false , desc = "申请创建开始时间，时间戳，秒", example= "1625638841")
	private Long startTime;

	@SerializedName("end_time")
	@OpField(required = false , desc = "申请创建结束时间，时间戳，秒", example= "1625638841")
	private Long endTime;

	@SerializedName("status")
	@OpField(required = false , desc = "开票状态：1待开票、2已开票、3已关闭", example= "1")
	private Integer status;

	@SerializedName("page_no")
	@OpField(required = false , desc = "页数（默认为0，第一页从0开始），page_no* page_size不超过1万", example= "0")
	private Integer pageNo;

	@SerializedName("page_size")
	@OpField(required = false , desc = "请求每页返回的数量，默认20，最多50", example= "20")
	private Integer pageSize;

	@SerializedName("order_by")
	@OpField(required = false , desc = "默认排序规则为asc； 排序方式支持asc/desc", example= "asc")
	private String orderBy;

	@SerializedName("order_field")
	@OpField(required = false , desc = "排序规则： 创建时间排序create_time，不传默认创建时间", example= "create_time")
	private String orderField;


	@Override
	public String toString(){
		return JsonUtil.toJson(this);
	}

	
	public void setOrderId(String orderId){
		this.orderId = orderId;
	}

	
	public String getOrderId(){
		return this.orderId;
	}

	
	public void setOrderStatus(String orderStatus){
		this.orderStatus = orderStatus;
	}

	
	public String getOrderStatus(){
		return this.orderStatus;
	}

	
	public void setStartTime(Long startTime){
		this.startTime = startTime;
	}

	
	public Long getStartTime(){
		return this.startTime;
	}

	
	public void setEndTime(Long endTime){
		this.endTime = endTime;
	}

	
	public Long getEndTime(){
		return this.endTime;
	}

	
	public void setStatus(Integer status){
		this.status = status;
	}

	
	public Integer getStatus(){
		return this.status;
	}

	
	public void setPageNo(Integer pageNo){
		this.pageNo = pageNo;
	}

	
	public Integer getPageNo(){
		return this.pageNo;
	}

	
	public void setPageSize(Integer pageSize){
		this.pageSize = pageSize;
	}

	
	public Integer getPageSize(){
		return this.pageSize;
	}

	
	public void setOrderBy(String orderBy){
		this.orderBy = orderBy;
	}

	
	public String getOrderBy(){
		return this.orderBy;
	}

	
	public void setOrderField(String orderField){
		this.orderField = orderField;
	}

	
	public String getOrderField(){
		return this.orderField;
	}

}