package com.doudian.open.core;

import com.doudian.open.api.token.AccessTokenData;
import com.doudian.open.api.token.AccessTokenResponse;
import com.doudian.open.api.token.RefreshTokenResponse;

public class AccessToken {

    private Long errNo;

    private String message;

    private AccessTokenData data;

    private String logId;

    public static AccessToken wrap(AccessTokenResponse response) {
        AccessToken accessToken = new AccessToken();
        accessToken.errNo = response.getErrNo();
        accessToken.message = response.getMessage();
        accessToken.data = response.getData();
        accessToken.logId = response.getLogId();
        return accessToken;
    }

    public static AccessToken wrap(RefreshTokenResponse response) {
        AccessToken accessToken = new AccessToken();
        accessToken.errNo = response.getErrNo();
        accessToken.message = response.getMessage();
        accessToken.data = response.getData();
        accessToken.logId = response.getLogId();
        return accessToken;
    }

    public static AccessToken wrap(String accessTokenStr, String refreshTokenStr) {
        AccessToken accessToken = new AccessToken();
        AccessTokenData tokenData = new AccessTokenData();
        tokenData.setAccessToken(accessTokenStr);
        tokenData.setRefreshToken(refreshTokenStr);
        accessToken.data = tokenData;
        return accessToken;
    }

    public boolean isSuccess() {
        return errNo != null && errNo == 0;
    }

    public String getAccessToken() {
        if (data != null) {
            return data.getAccessToken();
        }
        return null;
    }

    public Long getExpireIn() {
        if (data != null) {
            return data.getExpiresIn();
        }
        return null;
    }

    public String getScope() {
        if (data != null) {
            return data.getScope();
        }
        return null;
    }

    public String getShopId() {
        if (data  != null) {
            return data.getShopId();
        }
        return null;
    }

    public String getShopName() {
        if (data != null) {
            return data.getShopName();
        }
        return null;
    }

    public String getRefreshToken() {
        if (data != null) {
            return data.getRefreshToken();
        }
        return null;
    }

    public String getAuthorityId() {
        if (data != null) {
            return data.getAuthorityId();
        }
        return null;
    }

    public String getMessage() {
        return this.message;
    }

    public Long getErrNo() {
        return errNo;
    }

    public String getLogId() {
        return logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }
}
