package com.doudian.open.core;

import com.doudian.open.api.token.*;
import java.net.URLEncoder;


public class AccessTokenBuilder {

    //todo注释
    public static AccessToken build(Long shopId) {
        return build(GlobalConfig.getGlobalConfig(), DefaultDoudianOpClient.getDefaultClient(), shopId);
    }

    public static AccessToken build(String code) {
        return build(GlobalConfig.getGlobalConfig(), DefaultDoudianOpClient.getDefaultClient(), code);
    }

    public static AccessToken build(DoudianOpConfig config, DoudianOpClient httpClient, Long shopId) {
        return build(config, httpClient, null, shopId, true);
    }

    public static AccessToken build(DoudianOpConfig config, DoudianOpClient httpClient, String code) {
        return build(config, httpClient, code, null, false);
    }

    public static AccessToken parse(String accessTokenStr) {
        //构造一个AccessTokenResponse
        AccessTokenResponse response = new AccessTokenResponse();
        response.setErrNo(0L);
        AccessTokenData data = new AccessTokenData();
        data.setAccessToken(accessTokenStr);
        response.setData(data);
        return AccessToken.wrap(response);
    }

    public static AccessToken refresh(AccessToken accessToken) {
        return refresh(GlobalConfig.getGlobalConfig(), DefaultDoudianOpClient.getDefaultClient(), accessToken);
    }

    public static AccessToken refresh(String refreshTokenStr) {
        AccessToken accessToken = AccessToken.wrap(null, refreshTokenStr);
        return refresh(GlobalConfig.getGlobalConfig(), DefaultDoudianOpClient.getDefaultClient(), accessToken);
    }

    public static AccessToken refresh(DoudianOpConfig config, DoudianOpClient client, AccessToken accessToken) {
        RefreshTokenRequest request = new RefreshTokenRequest();
        request.setConfig(config);
        request.setClient(client);

        request.getParam().setGrantType("refresh_token");
        request.getParam().setRefreshToken(accessToken.getRefreshToken());

        RefreshTokenResponse response = request.execute(null);
        return AccessToken.wrap(response);
    }

    private static AccessToken build(DoudianOpConfig config, DoudianOpClient client, String code, Long shopId, boolean isSelfAuth) {
        AccessTokenRequest request = new AccessTokenRequest();
        if(isSelfAuth){
            request.getParam().setCode("");
            request.getParam().setGrantType("authorization_self");
            request.getParam().setShopId(shopId);
        } else {
            request.getParam().setCode(code);
            request.getParam().setGrantType("authorization_code");
        }
        request.setConfig(config);
        request.setClient(client);

        AccessTokenResponse resp = request.execute(null);
        return AccessToken.wrap(resp);
    }


    private static String getEncodeString(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        } catch (Exception e) {
            //ignore
        }
        return str;
    }

}
