package com.doudian.open.core;

import com.doudian.open.exception.DoudianOpException;
import com.doudian.open.utils.Logger;

import java.lang.reflect.ParameterizedType;
import java.util.concurrent.Future;

public abstract class DoudianOpRequest<T> implements DoudianOpRequestExecutor {

    private static final Logger LOG = Logger.getLogger(DoudianOpRequest.class);

    private DoudianOpClient client;

    private DoudianOpConfig config;

    private T param;

    public abstract String getUrlPath();

    @SuppressWarnings("unchecked")
    public DoudianOpRequest() {
        client = DefaultDoudianOpClient.getDefaultClient();
        config = GlobalConfig.getGlobalConfig();

        Class<?> paramClass = getSuperClassParameterClass(this.getClass());
        try{
            param = (T) paramClass.newInstance();
        }catch (Exception e){
            throw new DoudianOpException(DoudianOpException.Code.INIT_REQUEST_PARAM_ERROR, e);
        }
    }

    public abstract Class<? extends DoudianOpResponse<?>> getResponseClass();

    @Override
    public <R> R execute(AccessToken accessToken) {
        long now = System.currentTimeMillis();
        R ret = client.request(this, accessToken);
        LOG.info("request total cost: %d", (System.currentTimeMillis() - now));
        return ret;
    }

    @Override
    public <R> Future<R> asyncExecute(AccessToken accessToken) {
        return client.asyncRequest(this, accessToken);
    }

    private Class<?> getSuperClassParameterClass(Class<?> clazz) {
        try {
            return (Class<?>) (((ParameterizedType) clazz.getGenericSuperclass()).getActualTypeArguments()[0]);
        } catch (Exception e) {
            throw new DoudianOpException(e);
        }
    }

    public DoudianOpClient getClient() {
        return client;
    }

    public void setClient(DoudianOpClient client) {
        this.client = client;
    }

    public DoudianOpConfig getConfig() {
        return config;
    }

    public void setConfig(DoudianOpConfig config) {
        this.config = config;
    }

    public T getParam() {
        return param;
    }

    public void setParam(T param) {
        this.param = param;
    }
}
