package com.doudian.open.core;


import com.doudian.open.gson.annotations.SerializedName;

public class DoudianOpResponse<T> {

    @SerializedName("err_no")
    private Long errNo;

    @SerializedName("message")
    private String message;

    @SerializedName("data")
    private T data;

    @SerializedName("log_id")
    private String logId;

    @SerializedName("code")
    private Long code;

    @SerializedName("msg")
    private String msg;

    @SerializedName("sub_code")
    private String subCode;

    @SerializedName("sub_msg")
    private String subMsg;


    private transient String originResponse;

    public boolean isSuccess() {
        return errNo != null && errNo == 0;
    }

    public Long getErrNo() {
        return errNo;
    }

    public void setErrNo(Long errNo) {
        this.errNo = errNo;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getLogId() {
        return logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public Long getCode() {
        return code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getSubCode() {
        return subCode;
    }

    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }

    public String getSubMsg() {
        return subMsg;
    }

    public void setSubMsg(String subMsg) {
        this.subMsg = subMsg;
    }

    public void setOriginResponse(String originResponse) {
        this.originResponse = originResponse;
    }

    public String getOriginResponse() {
        return originResponse;
    }
}
