/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.alliance.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.controller.BaseController;
import com.els.common.vo.CountVO;
import com.els.modules.alliance.dto.H5DTO;
import com.els.modules.alliance.dto.MyGoodsTopmanItemDTO;
import com.els.modules.alliance.entity.MyGoodsImg;
import com.els.modules.alliance.entity.MyPromotionalHead;
import com.els.modules.alliance.entity.MyPromotionalTopmanItem;
import com.els.modules.alliance.service.MyGoodsImgService;
import com.els.modules.alliance.service.MyPromotionalHeadService;
import com.els.modules.alliance.service.MyPromotionalTopmanItemService;
import com.els.modules.alliance.vo.MyPromotionalHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6211\u7684\u63a8\u5e7f"})
@RestController
@RequestMapping(value={"/alliance/myPromotional"})
public class MyPromotionalController
extends BaseController<MyPromotionalHead, MyPromotionalHeadService> {
    private static final Logger log = LoggerFactory.getLogger(MyPromotionalController.class);
    @Autowired
    private MyPromotionalHeadService myPromotionalHeadService;
    @Autowired
    private MyPromotionalTopmanItemService myPromotionalTopmanItemService;
    @Autowired
    private MyGoodsImgService imgService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="promotionAlliance")
    public Result<?> queryPageList(MyPromotionalHead head, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        IPage<MyPromotionalHead> pageList = this.myPromotionalHeadService.queryPage(head, pageNo, pageSize, req);
        return Result.ok(pageList);
    }

    @GetMapping(value={"/h5/list"})
    public Result<?> h5List(MyPromotionalHead head, @RequestParam(value="elsAccount") String elsAccount, @RequestParam(value="openId") String openId, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        List relationIds;
        IPage<MyPromotionalHead> pageList = this.myPromotionalHeadService.queryH5Page(head, elsAccount, openId, pageNo, pageSize, req);
        if (ObjectUtil.isNotEmpty(pageList) && CollUtil.isNotEmpty((Collection)pageList.getRecords()) && CollUtil.isNotEmpty(relationIds = pageList.getRecords().stream().map(x -> x.getRelationId()).collect(Collectors.toList()))) {
            List myGoodsImgs = this.imgService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MyGoodsImg::getDeleted, (Object)"0")).in(MyGoodsImg::getHeadId, relationIds));
            Map<String, MyGoodsImg> imgMap = myGoodsImgs.stream().collect(Collectors.toMap(x -> x.getHeadId(), y -> y));
            pageList.getRecords().forEach(row -> {
                if (ObjectUtil.isNotEmpty((Object)row.getCommissionRate()) && ObjectUtil.isNotEmpty((Object)row.getGoodsPrice())) {
                    try {
                        BigDecimal goodsPrice = new BigDecimal(row.getGoodsPrice());
                        row.setPreCommission(goodsPrice.multiply(this.converCommissionRate(row.getCommissionRate()).divide(new BigDecimal(100))).setScale(2, 4));
                    }
                    catch (Exception e) {
                        log.error("\u4f63\u91d1\u6bd4\u4f8b\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)row.getRelationId()) && ObjectUtil.isNotEmpty(imgMap.get(row.getRelationId()))) {
                    MyGoodsImg img = (MyGoodsImg)((Object)((Object)imgMap.get(row.getRelationId())));
                    if (ObjectUtil.isNotEmpty((Object)img.getGoodsMainImg())) {
                        row.setGoodsMainImg(Arrays.asList(img.getGoodsMainImg().split(",")));
                    }
                    if (ObjectUtil.isNotEmpty((Object)img.getGoodsImg())) {
                        row.setGoodsImg(Arrays.asList(img.getGoodsImg().split(",")));
                    }
                }
            });
        }
        return Result.ok(pageList);
    }

    private BigDecimal converCommissionRate(String str) {
        str = str.replaceAll("%", "");
        BigDecimal de = BigDecimal.ZERO;
        try {
            de = new BigDecimal(str);
        }
        catch (Exception e) {
            log.error("converCommissionRate error", (Throwable)e);
        }
        return de;
    }

    @ApiOperation(value="\u9875\u7b7e\u5217\u8868", notes="\u9875\u7b7e\u5217\u8868")
    @GetMapping(value={"/tabs"})
    public Result<?> queryTabsCount(MyPromotionalHead head, HttpServletRequest req) {
        List<CountVO> result = this.myPromotionalHeadService.queryTabsCount(head, req);
        return Result.ok(result);
    }

    @GetMapping(value={"/h5/queryById"})
    public Result<?> h5QueryById(@RequestParam(value="id") String id) {
        MyGoodsImg myGoodsImgs;
        MyPromotionalHead myPromotionalHead = (MyPromotionalHead)((Object)this.myPromotionalHeadService.getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)myPromotionalHead)), (String)"\u6b64\u5546\u54c1\u5df2\u4e0b\u67b6");
        Assert.isTrue((boolean)CommonConstant.NO_0.equals(myPromotionalHead.getDeleted()), (String)"\u6b64\u5546\u54c1\u5df2\u4e0b\u67b6");
        if (ObjectUtil.isNotEmpty((Object)myPromotionalHead.getCommissionRate()) && ObjectUtil.isNotEmpty((Object)myPromotionalHead.getGoodsPrice())) {
            try {
                BigDecimal goodsPrice = new BigDecimal(myPromotionalHead.getGoodsPrice());
                myPromotionalHead.setPreCommission(goodsPrice.multiply(this.converCommissionRate(myPromotionalHead.getCommissionRate()).divide(new BigDecimal(100))).setScale(2, 4));
            }
            catch (Exception e) {
                log.error("\u4f63\u91d1\u6bd4\u4f8b\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)myPromotionalHead.getRelationId()) && ObjectUtil.isNotEmpty((Object)((Object)(myGoodsImgs = (MyGoodsImg)((Object)this.imgService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MyGoodsImg::getDeleted, (Object)"0")).eq(MyGoodsImg::getHeadId, (Object)myPromotionalHead.getRelationId()), false)))))) {
            if (ObjectUtil.isNotEmpty((Object)myGoodsImgs.getGoodsMainImg())) {
                myPromotionalHead.setGoodsMainImg(Arrays.asList(myGoodsImgs.getGoodsMainImg().split(",")));
            }
            if (ObjectUtil.isNotEmpty((Object)myGoodsImgs.getGoodsImg())) {
                myPromotionalHead.setGoodsImg(Arrays.asList(myGoodsImgs.getGoodsImg().split(",")));
            }
        }
        return Result.ok((Object)((Object)myPromotionalHead));
    }

    @AutoLog(value="\u6211\u7684\u63a8\u5e7f-\u79fb\u9664")
    @ApiOperation(value="\u79fb\u9664", notes="\u79fb\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.myPromotionalHeadService.delMyPromotional(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u6211\u7684\u63a8\u5e7f", value="\u7f6e\u9876/\u53d6\u6d88\u7f6e\u9876")
    @ApiOperation(value="\u7f6e\u9876/\u53d6\u6d88\u7f6e\u9876", notes="\u7f6e\u9876/\u53d6\u6d88\u7f6e\u9876")
    @GetMapping(value={"/topOrCancel"})
    public Result<?> topOrCancel(@RequestParam(name="id") String id, @RequestParam(name="flag") Boolean flag) {
        this.myPromotionalHeadService.topOrCancel(id, flag);
        return this.commonSuccessResult(3);
    }

    @PostMapping(value={"/h5/topOrCancel"})
    public Result<?> h5TopOrCancel(@RequestBody H5DTO.TopDto topDto) {
        this.myPromotionalHeadService.h5TopOrCancel(topDto);
        return this.commonSuccessResult(3);
    }

    @PostMapping(value={"/h5/delete"})
    public Result<?> h5Delete(@RequestBody H5DTO.TopDto topDto) {
        this.myPromotionalHeadService.delH5MyPromotional(topDto);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        MyPromotionalHead myPromotionalHead = (MyPromotionalHead)((Object)this.myPromotionalHeadService.getById((Serializable)((Object)id)));
        MyPromotionalHeadVO vo = new MyPromotionalHeadVO();
        if (myPromotionalHead == null) {
            return Result.ok((Object)((Object)vo));
        }
        BeanUtils.copyProperties((Object)((Object)myPromotionalHead), (Object)((Object)vo));
        List<MyPromotionalTopmanItem> myPromotionalTopmanItems = this.myPromotionalTopmanItemService.selectByMainId(id);
        vo.setMyPromotionalTopmanList(myPromotionalTopmanItems);
        return Result.ok((Object)((Object)vo));
    }

    @AutoLog(value="\u6211\u7684\u63a8\u5e7f-\u6dfb\u52a0\u8fbe\u4eba")
    @ApiOperation(value="\u6dfb\u52a0\u8fbe\u4eba", notes="\u6dfb\u52a0\u8fbe\u4eba")
    @PostMapping(value={"/addTopman"})
    public Result<?> addTopman(@RequestBody MyGoodsTopmanItemDTO dto) {
        this.myPromotionalHeadService.addTopman(dto);
        return Result.ok((Object)((Object)dto));
    }

    @AutoLog(value="\u6211\u7684\u63a8\u5e7f-\u5220\u9664\u8fbe\u4eba")
    @ApiOperation(value="\u5220\u9664\u8fbe\u4eba", notes="\u5220\u9664\u8fbe\u4eba")
    @GetMapping(value={"/deleteTopman"})
    public Result<?> deleteTopman(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.myPromotionalHeadService.deleteTopman(idList);
        return this.commonSuccessResult(4);
    }
}

