/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.alliance.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.util.RedisUtil;
import com.els.modules.alliance.entity.GoodsWechat;
import com.els.modules.alliance.service.GoodsWechatService;
import com.els.modules.alliance.vo.WxSystemUserConfig;
import com.els.modules.enterpriseresource.utils.HttpClientUtil;
import com.els.modules.enterpriseresource.utils.SignUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u4fe1\u83b7\u53d6\u7528\u6237\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/noToken/alliance/wxAuth"})
public class WxLoginController {
    private static final Logger log = LoggerFactory.getLogger(WxLoginController.class);
    private static String APPID = "wxc14d79469f42b8fc";
    private static String APPSECRET = "123fc5d869cad5fdf4d00a412f442899";
    @Value(value="${els.config.service.address}")
    private String address;
    @Autowired
    private GoodsWechatService goodsWechatService;
    @Autowired
    private RedisUtil redisUtil;

    @RequestMapping(value={"/checkToken"})
    public void checkToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        if (SignUtil.checkSignature(signature, timestamp, nonce)) {
            log.info("\u6821\u9a8ctoken\u6210\u529f");
            response.getWriter().print(echostr);
        }
    }

    @RequestMapping(value={"/wxconfig"})
    public Result<?> getWxConfig(String elsAccount) {
        if (elsAccount == null) {
            return Result.error((String)"elsAccount is null !");
        }
        WxSystemUserConfig config = new WxSystemUserConfig();
        config.setAppid(APPID);
        config.setElsAccount(elsAccount);
        config.setAppsecret(APPSECRET);
        return Result.ok((Object)config);
    }

    @PostMapping(value={"/saveUserInfo"})
    public Result<?> saveWxUserInfo(@RequestBody GoodsWechat goodsWechat) {
        return Result.ok();
    }

    @RequestMapping(value={"/login"})
    public Result<?> wxLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String elsAccount = request.getParameter("elsAccount");
        String callBack = this.address + "/els/noToken/alliance/wxAuth/callBack?elsAccount=" + elsAccount;
        log.info("els callBack address is:" + callBack);
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + APPID + "&redirect_uri=" + URLEncoder.encode(callBack) + "&response_type=code&scope=snsapi_userinfo&state=STATE#wechat_redirect";
        log.info("els callBack url is:" + url);
        return Result.ok((String)url);
    }

    @RequestMapping(value={"/callBack"})
    public Result<?> wxCallBack(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String code = request.getParameter("code");
        String elsAccount = request.getParameter("elsAccount");
        String appId = request.getParameter("appid");
        String appsecret = request.getParameter("appsecret");
        log.info("callBack elsAccount:" + elsAccount + "appId :" + appId + "appsecret:" + appsecret);
        if (elsAccount == null || "".equals(elsAccount)) {
            return Result.error((String)"elsAccount\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + APPID + "&secret=" + APPSECRET + "&code=" + code + "&grant_type=authorization_code";
        String result = HttpClientUtil.doGet(url);
        log.info("\u8bf7\u6c42\u83b7\u53d6access_token:" + result);
        JSONObject resultObject = JSON.parseObject((String)result);
        String infoUrl = "https://api.weixin.qq.com/sns/userinfo?access_token=" + resultObject.getString("access_token") + "&openid=" + resultObject.getString("openid") + "&lang=zh_CN";
        String userInfo = HttpClientUtil.doGet(infoUrl);
        JSONObject userInfoJson = JSON.parseObject((String)userInfo);
        String openId = userInfoJson.getString("openid");
        if (openId == null || "".equals(openId)) {
            return Result.error((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u6709\u8bef!");
        }
        GoodsWechat goodsWechat = new GoodsWechat();
        goodsWechat.setElsAccount(elsAccount);
        goodsWechat.setOpenId(userInfoJson.getString("openid"));
        goodsWechat.setNickName(userInfoJson.getString("nickname"));
        goodsWechat.setSex(userInfoJson.getString("sex"));
        goodsWechat.setCity(userInfoJson.getString("city"));
        goodsWechat.setProvince(userInfoJson.getString("province"));
        goodsWechat.setCountry(userInfoJson.getString("country"));
        goodsWechat.setHeadImgUrl(userInfoJson.getString("headimgurl"));
        goodsWechat.setDeleted(0);
        this.goodsWechatService.saveGoodsWechat(goodsWechat);
        log.info("\u8bf7\u6c42\u83b7\u53d6userInfo:" + userInfo);
        return Result.ok((String)userInfo);
    }
}

