/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.excel;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.excel.service.BaseExportService;
import com.els.config.mybatis.TenantContext;
import com.els.modules.companystore.dto.CompanyGoodsHeadQueryDTO;
import com.els.modules.companystore.entity.KsItems;
import com.els.modules.companystore.service.KsItemsService;
import com.els.modules.companystore.vo.KsShopItemsVO;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ksCompanyGoodsHeadExportServiceImpl")
public class KsCompanyGoodsHeadExportServiceImpl
extends BaseExportService<KsItems, KsShopItemsVO, CompanyGoodsHeadQueryDTO> {
    @Autowired
    private KsItemsService ksItemsService;

    public List<KsShopItemsVO> queryExportData(QueryWrapper<KsItems> queryWrapper, CompanyGoodsHeadQueryDTO queryDTO, Map<String, String[]> paramMap) {
        if (ObjectUtil.isNotEmpty((Object)paramMap.get("keyWord"))) {
            String keyWord = paramMap.get("keyWord")[0];
            queryWrapper.and(qr -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)qr.eq((Object)"kwai_item_id", (Object)keyWord)).or(qr2 -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)qr2.like((Object)"title", (Object)keyWord);
                });
            });
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsItemsCategory())) {
            queryWrapper.in((Object)"category_id", (Object[])queryDTO.getKsItemsCategory().split(","));
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsItemsShop())) {
            queryWrapper.eq((Object)"shop_id", (Object)queryDTO.getKsItemsShop());
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsItemsStatus())) {
            queryWrapper.eq((Object)"shelf_status", (Object)queryDTO.getKsItemsStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsTopManNum())) {
            String[] var = queryDTO.getKsTopManNum().split("-");
            queryWrapper.ge((Object)"relationTopManNum", (Object)var[0]);
            queryWrapper.le((Object)"relationTopManNum", (Object)var[1]);
        }
        List<KsShopItemsVO> list = this.ksItemsService.ksListExcel(TenantContext.getTenant(), queryWrapper);
        return list;
    }

    public String getBeanName() {
        return null;
    }

    public String getBusinessType() {
        return null;
    }

    public long queryExportDataCount(QueryWrapper<KsItems> queryWrapper, CompanyGoodsHeadQueryDTO map, Map<String, String[]> paramMap) {
        return this.ksItemsService.count((Wrapper)queryWrapper);
    }
}

