/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.job;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.service.JobRpcService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class DyShopMonitorApiJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(DyShopMonitorApiJob.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;
    @Value(value="${spider-api.dyMonitorUrl}")
    private String dyMonitorUrl;

    public void execute(String parameter) {
        log.info("==============\u76d1\u63a7\u6296\u5e97\u5b9a\u65f6\u4efb\u52a1\u542f\u52a8================");
        List companyStoreHeadList = this.companyStoreHeadService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreHead::getPlatform, (Object)"1")).eq(BaseEntity::getDeleted, (Object)"0")).eq(CompanyStoreHead::getDataType, (Object)"2"));
        if (CollUtil.isEmpty((Collection)companyStoreHeadList)) {
            log.info("\u65e0\u53ef\u76d1\u63a7\u5e97\u94fa");
            return;
        }
        ArrayList shops = Lists.newArrayList();
        companyStoreHeadList.forEach(x -> {
            HashMap shopMap = Maps.newHashMap();
            shopMap.put("shopId", x.getShopId());
            shopMap.put("needShopData", "1".equals(x.getIsPageAdd()));
            shopMap.put("shopName", x.getName());
            shops.add(shopMap);
        });
        HashMap params = Maps.newHashMap();
        params.put("platform", "1");
        params.put("shops", shops);
        ResponseEntity res = this.restTemplate.postForEntity(this.dyMonitorUrl, (Object)params, String.class, new Object[0]);
        log.info("\u76d1\u63a7\u6296\u5e97\u8c03\u7528python\u63a5\u53e3\uff0curl[{}],\u5165\u53c2:[{}],\u54cd\u5e94:[{}]", new Object[]{this.dyMonitorUrl, JSON.toJSONString((Object)params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), res});
        log.info("==============\u76d1\u63a7\u6296\u5e97\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f================");
    }
}

