/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.companystore.dto.CompanyGoodsHeadQueryDTO;
import com.els.modules.companystore.entity.CompanyGoodsItem;
import com.els.modules.companystore.mapper.CompanyGoodsItemMapper;
import com.els.modules.companystore.service.CompanyGoodsItemService;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyGoodsItemServiceImpl
extends BaseServiceImpl<CompanyGoodsItemMapper, CompanyGoodsItem>
implements CompanyGoodsItemService {
    @Autowired
    private CompanyGoodsItemMapper companyGoodsItemMapper;

    @Override
    public List<CompanyGoodsItem> selectByMainId(String mainId) {
        return this.companyGoodsItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<CompanyGoodsItem> queryList(CompanyGoodsHeadQueryDTO queryDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        this.criteriaQuery((QueryWrapper<CompanyGoodsItem>)queryWrapper, queryDTO);
        return ((CompanyGoodsItemMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public CompanyGoodsItem queryGoodsItem(String goodsId, String queryDay) {
        LambdaQueryWrapper queryWrapper = new QueryWrapper().lambda();
        queryWrapper.eq(CompanyGoodsItem::getGoodsId, (Object)goodsId);
        if (StringUtils.isBlank((CharSequence)queryDay)) {
            queryDay = "30";
        }
        queryWrapper.eq(CompanyGoodsItem::getQueryDay, (Object)queryDay);
        return (CompanyGoodsItem)((Object)((CompanyGoodsItemMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    private QueryWrapper<CompanyGoodsItem> criteriaQuery(QueryWrapper<CompanyGoodsItem> queryWrapper, CompanyGoodsHeadQueryDTO queryDTO) {
        Boolean goodsVideo;
        Boolean goodsLive;
        String goodsBrowsesNum;
        String salesNum;
        String timeSelect = queryDTO.getTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "30";
        }
        queryWrapper.lambda().eq(CompanyGoodsItem::getQueryDay, (Object)timeSelect);
        String topman = queryDTO.getGoodsTopmanNum();
        if (StringUtils.isNotBlank((CharSequence)topman)) {
            String[] strings;
            if (topman.contains("-")) {
                strings = topman.split("-");
                queryWrapper.lambda().gt(CompanyGoodsItem::getTopmanNum, (Object)new BigDecimal(strings[0]));
                queryWrapper.lambda().le(CompanyGoodsItem::getTopmanNum, (Object)new BigDecimal(strings[1]));
            } else if (topman.contains(">")) {
                strings = topman.split(">");
                queryWrapper.lambda().gt(CompanyGoodsItem::getTopmanNum, (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.lambda().eq(CompanyGoodsItem::getTopmanNum, (Object)topman);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(salesNum = queryDTO.getGoodsSalesNum()))) {
            String[] strings;
            if (salesNum.contains("-")) {
                strings = salesNum.split("-");
                queryWrapper.lambda().between(CompanyGoodsItem::getSalesNum, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            }
            if (salesNum.contains(">=")) {
                strings = salesNum.split(">=");
                queryWrapper.lambda().ge(CompanyGoodsItem::getSalesNum, (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsBrowsesNum = queryDTO.getGoodsBrowsesNum()))) {
            String[] strings;
            if (goodsBrowsesNum.contains("-")) {
                strings = goodsBrowsesNum.split("-");
                queryWrapper.lambda().between(CompanyGoodsItem::getBrowsesNum, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            }
            if (goodsBrowsesNum.contains(">=")) {
                strings = goodsBrowsesNum.split(">=");
                queryWrapper.lambda().ge(CompanyGoodsItem::getBrowsesNum, (Object)new BigDecimal(strings[1]));
            }
        }
        if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
            queryWrapper.lambda().isNotNull(CompanyGoodsItem::getLivesNum);
        }
        if ((goodsVideo = queryDTO.getGoodsVideo()) != null && goodsVideo.booleanValue()) {
            queryWrapper.lambda().isNotNull(CompanyGoodsItem::getVideosNum);
        }
        return queryWrapper;
    }

    @Override
    public void deleteBatch(List<String> goodsIds) {
        if (CollectionUtil.isNotEmpty(goodsIds)) {
            ((CompanyGoodsItemMapper)this.baseMapper).deleteBatch(goodsIds);
        }
    }

    @Override
    public void insertBatch(List<List<CompanyGoodsItem>> allList) {
        allList.stream().filter(a -> a.size() > 0).forEach(((CompanyGoodsItemMapper)this.baseMapper)::insertBatch);
    }

    @Override
    public CompanyGoodsItem queryCompanyGoodsItem(String goodsId, String topmanTimeSelect) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CompanyGoodsItem::getGoodsId, (Object)goodsId);
        queryWrapper.eq(CompanyGoodsItem::getQueryDay, (Object)topmanTimeSelect);
        queryWrapper.eq(BaseEntity::getDeleted, (Object)0);
        return (CompanyGoodsItem)((Object)((CompanyGoodsItemMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }
}

