/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.doudian.open.api.order_orderDetail.OrderOrderDetailRequest;
import com.doudian.open.api.order_orderDetail.OrderOrderDetailResponse;
import com.doudian.open.api.order_orderDetail.data.OrderOrderDetailData;
import com.doudian.open.api.order_orderDetail.data.ShopOrderDetail;
import com.doudian.open.api.order_orderDetail.param.OrderOrderDetailParam;
import com.doudian.open.core.AccessToken;
import com.doudian.open.core.DoudianOpConfig;
import com.els.common.enumerate.PlatformEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.PermissionDataRpcService;
import com.els.modules.companystore.dto.CompanyStoreQueryDTO;
import com.els.modules.companystore.entity.CompanyStoreOrderHead;
import com.els.modules.companystore.entity.CompanyStoreOrderItem;
import com.els.modules.companystore.mapper.CompanyStoreOrderItemMapper;
import com.els.modules.companystore.service.CompanyStoreOrderHeadService;
import com.els.modules.companystore.service.CompanyStoreOrderItemService;
import com.els.modules.companystore.vo.CompanyStoreOrderItemVO;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CompanyStoreOrderItemServiceImpl
extends BaseServiceImpl<CompanyStoreOrderItemMapper, CompanyStoreOrderItem>
implements CompanyStoreOrderItemService {
    private static final Logger log = LoggerFactory.getLogger(CompanyStoreOrderItemServiceImpl.class);
    @Autowired
    private DoudianOpConfig doudianOpConfig;
    @Autowired
    private CompanyStoreOrderHeadService companyStoreOrderHeadService;
    @Autowired
    private PermissionDataRpcService permissionDataRpcService;

    @Override
    public void add(CompanyStoreOrderItem companyStoreOrderItem) {
        ((CompanyStoreOrderItemMapper)this.baseMapper).insert((Object)companyStoreOrderItem);
    }

    @Override
    public void edit(CompanyStoreOrderItem companyStoreOrderItem) {
        int count = ((CompanyStoreOrderItemMapper)this.baseMapper).updateById((Object)companyStoreOrderItem);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((CompanyStoreOrderItemMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((CompanyStoreOrderItemMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public IPage<CompanyStoreOrderItem> listAll(SimplePostRequestParam<CompanyStoreOrderItemVO> param) throws IllegalAccessException {
        QueryWrapper<CompanyStoreOrderItem> queryWrapper = this.getQueryWrapper(param);
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        IPage<CompanyStoreOrderItem> topManBeanIPage = ((CompanyStoreOrderItemMapper)this.baseMapper).listAll((Page<CompanyStoreOrderItem>)page, queryWrapper, this.permissionDataRpcService.getCompany("companyStore"));
        return topManBeanIPage;
    }

    @Override
    public List<CompanyStoreQueryDTO> getStores(String tenant) {
        return ((CompanyStoreOrderItemMapper)this.baseMapper).getStores(tenant);
    }

    private QueryWrapper<CompanyStoreOrderItem> getQueryWrapper(SimplePostRequestParam<CompanyStoreOrderItemVO> param) throws IllegalAccessException {
        String[] columns;
        String column;
        CompanyStoreOrderItemVO filterInfo = (CompanyStoreOrderItemVO)param.getFilterInfo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntityClass(CompanyStoreOrderItem.class);
        filterInfo.initQueryWrapper((QueryWrapper<CompanyStoreOrderItem>)queryWrapper);
        String keyWord = param.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            queryWrapper.lambda().like(CompanyStoreOrderItem::getShopOrderNo, (Object)keyWord);
        }
        if ((column = param.getColumn()) != null && (columns = column.split(",")).length > 0) {
            final String order = param.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)queryWrapper, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("column", columns);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                }
            }, (Object)((Object)new CompanyStoreOrderItem()));
        }
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        return queryWrapper;
    }

    @Override
    public String getKeyIdOfTopMan(String platform, String topManId) {
        return ((CompanyStoreOrderItemMapper)this.baseMapper).getKeyIdOfTopMan(platform, topManId);
    }

    @Override
    public CompanyStoreOrderItem getByShopIdAndRelationId(String shopId, String relationId) {
        return (CompanyStoreOrderItem)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreOrderItem::getShopId, (Object)shopId)).eq(CompanyStoreOrderItem::getOrderId, (Object)relationId)).eq(BaseEntity::getDeleted, (Object)"0")));
    }

    @Override
    public void pullOrderSkuDetail(CompanyStoreOrderHead headDb) {
        String orderId = headDb.getOrderId();
        OrderOrderDetailData orderOrderDetailData = this.getOrderDetail(orderId);
        ShopOrderDetail shopOrderDetail = orderOrderDetailData.getShopOrderDetail();
        List items = this.convertCompanyStoreOrderItem(shopOrderDetail, headDb);
        if (CollUtil.isNotEmpty(items)) {
            this.remove((Wrapper)Wrappers.lambdaQuery().eq(CompanyStoreOrderItem::getParentOrderId, (Object)orderId));
            items = items.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CompanyStoreOrderItem>(Comparator.comparing(CompanyStoreOrderItem::getOrderId))), ArrayList::new));
            List orderIds = items.stream().map(x -> x.getOrderId()).collect(Collectors.toList());
            List dbs = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CompanyStoreOrderItem::getOrderId, orderIds)).eq(BaseEntity::getDeleted, (Object)"0"));
            Map<String, String> dbMaps = dbs.stream().collect(Collectors.toMap(x -> x.getOrderId(), y -> y.getId()));
            ArrayList add = Lists.newArrayList();
            ArrayList update = Lists.newArrayList();
            for (CompanyStoreOrderItem item : items) {
                if (dbMaps.containsKey(item.getOrderId())) {
                    item.setId(dbMaps.get(item.getOrderId()));
                    update.add(item);
                    continue;
                }
                add.add(item);
            }
            if (CollUtil.isNotEmpty((Collection)add)) {
                this.saveBatch(add);
            }
            if (CollUtil.isNotEmpty((Collection)update)) {
                this.updateBatchById(update);
            }
            headDb.setSync("1");
            this.companyStoreOrderHeadService.updateById((Object)headDb);
        }
    }

    @Override
    public void init(String id) {
        if (StrUtil.isNotBlank((CharSequence)id)) {
            CompanyStoreOrderHead head = (CompanyStoreOrderHead)((Object)this.companyStoreOrderHeadService.getById((Serializable)((Object)id)));
            this.pullOrderSkuDetail(head);
            return;
        }
        List dbHeads = this.companyStoreOrderHeadService.list((Wrapper)Wrappers.lambdaQuery().eq(CompanyStoreOrderHead::getSync, (Object)"0"));
        dbHeads.forEach(x -> {
            try {
                this.pullOrderSkuDetail((CompanyStoreOrderHead)((Object)x));
            }
            catch (Exception e) {
                log.error("[{}]init order detail error", (Object)x.getOrderId(), (Object)e);
            }
        });
    }

    @Override
    public Pair<CompanyStoreOrderHead, List<CompanyStoreOrderItem>> pullOrder(String orderId) {
        OrderOrderDetailData orderOrderDetailData = this.getOrderDetail(orderId);
        ShopOrderDetail shopOrderDetail = orderOrderDetailData.getShopOrderDetail();
        CompanyStoreOrderHead companyStoreOrderHead = new CompanyStoreOrderHead();
        companyStoreOrderHead.setOrderId(shopOrderDetail.getOrderId());
        this.convertHead(companyStoreOrderHead, shopOrderDetail, "307000");
        this.companyStoreOrderHeadService.save((Object)companyStoreOrderHead);
        List<CompanyStoreOrderItem> dbItems = this.convertCompanyStoreOrderItem(shopOrderDetail, companyStoreOrderHead);
        this.saveBatch(dbItems);
        return new Pair((Object)companyStoreOrderHead, dbItems);
    }

    @Override
    public List<CompanyStoreOrderItem> listByHeadId(String id) {
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreOrderItem::getHeadId, (Object)id)).eq(BaseEntity::getDeleted, (Object)"0"));
    }

    private void convertHead(CompanyStoreOrderHead companyStoreOrderHead, ShopOrderDetail detail, String elsAccount) {
        companyStoreOrderHead.setPlatform(detail.getBTypeDesc());
        companyStoreOrderHead.setShopId(detail.getShopId().toString());
        companyStoreOrderHead.setShopId(detail.getShopId().toString());
        companyStoreOrderHead.setOrderId(detail.getOrderId());
        companyStoreOrderHead.setOrderStatus(detail.getOrderStatus().toString());
        companyStoreOrderHead.setOrderStatusDesc(detail.getOrderStatusDesc());
        companyStoreOrderHead.setPayTime(new Date(detail.getPayTime() * 1000L));
        companyStoreOrderHead.setOrderTime(new Date(detail.getCreateTime() * 1000L));
        long time = detail.getOrderExpireTime() * 1000L;
        Date expireDate = new Date(companyStoreOrderHead.getOrderTime().getTime() + time);
        companyStoreOrderHead.setExpireTime(expireDate);
        companyStoreOrderHead.setOrderOpdateTime(new Date(detail.getUpdateTime() * 1000L));
        companyStoreOrderHead.setCancelReasons(detail.getCancelReason());
        companyStoreOrderHead.setOrderAmount(BigDecimal.valueOf(detail.getOrderAmount()));
        companyStoreOrderHead.setPayAmount(BigDecimal.valueOf(detail.getPayAmount()));
        companyStoreOrderHead.setOrderSource(detail.getBTypeDesc());
        companyStoreOrderHead.setRemark(detail.getSellerWords());
        companyStoreOrderHead.setSync("1");
        companyStoreOrderHead.setElsAccount(elsAccount);
        companyStoreOrderHead.setCreateTime(new Date());
    }

    private List<CompanyStoreOrderItem> convertCompanyStoreOrderItem(ShopOrderDetail shopOrderDetail, CompanyStoreOrderHead headDb) {
        String headId = headDb.getId();
        String elsAccount = headDb.getElsAccount();
        List<CompanyStoreOrderItem> dbItems = shopOrderDetail.getSkuOrderList().stream().map(skuOrder -> {
            CompanyStoreOrderItem dbItem = new CompanyStoreOrderItem();
            dbItem.setHeadId(headId);
            dbItem.setOrderId(skuOrder.getOrderId());
            dbItem.setParentOrderId(skuOrder.getParentOrderId());
            dbItem.setShopId(headDb.getShopId());
            dbItem.setShopName(shopOrderDetail.getShopName());
            dbItem.setShopOrderNo(dbItem.getParentOrderId());
            dbItem.setGoodsOrderNo(dbItem.getOrderId());
            dbItem.setOrganId(shopOrderDetail.getShopId().toString());
            dbItem.setOrganName(shopOrderDetail.getShopName());
            dbItem.setCancelReasons(skuOrder.getCancelReason());
            dbItem.setGoodsCategoryLv1(this.convertLong(skuOrder.getFirstCid()));
            dbItem.setGoodsCategoryLv2(this.convertLong(skuOrder.getSecondCid()));
            dbItem.setGoodsCategoryLv3(this.convertLong(skuOrder.getThirdCid()));
            dbItem.setGoodsCategoryLv4(this.convertLong(skuOrder.getFourthCid()));
            dbItem.setGoodsPrice(BigDecimal.valueOf(skuOrder.getOriginAmount()));
            dbItem.setGoodsQuantity(skuOrder.getItemNum());
            dbItem.setPlatform(PlatformEnum.DOU_YIN.getValue());
            dbItem.setVideoId(skuOrder.getVideoId());
            dbItem.setOrderSource(skuOrder.getCBizDesc());
            String popularizeTypeStr = StrUtil.isNotBlank((CharSequence)skuOrder.getVideoId()) ? "\u89c6\u9891\u5e26\u8d27" : (ObjectUtil.isNotEmpty((Object)skuOrder.getRoomId()) && skuOrder.getRoomId() != 0L ? "\u76f4\u64ad\u5e26\u8d27" : "\u5176\u4ed6");
            dbItem.setPopularizeType(popularizeTypeStr);
            dbItem.setLeader(skuOrder.getAuthorName());
            dbItem.setTopmanId(this.convertLong(skuOrder.getAuthorId()));
            dbItem.setTopmanName(skuOrder.getAuthorName());
            dbItem.setSkuId(this.convertLong(skuOrder.getSkuId()));
            dbItem.setGoodsId(skuOrder.getProductIdStr());
            dbItem.setGoodsNo(skuOrder.getOutProductId());
            dbItem.setGoodsName(skuOrder.getProductName());
            dbItem.setGoodsPicture(skuOrder.getProductPic());
            dbItem.setOrderStatus(this.convertLong(skuOrder.getOrderStatus()));
            dbItem.setOrderStatusDesc(skuOrder.getOrderStatusDesc());
            dbItem.setRemark(shopOrderDetail.getSellerWords());
            dbItem.setOrderAmount(BigDecimal.valueOf(skuOrder.getOrderAmount()));
            dbItem.setPayAmount(BigDecimal.valueOf(skuOrder.getPayAmount()));
            dbItem.setOrderTime(new Date(skuOrder.getCreateTime() * 1000L));
            dbItem.setOrderOpdateTime(new Date(skuOrder.getUpdateTime() * 1000L));
            dbItem.setPayTime(new Date(skuOrder.getPayTime() * 1000L));
            long time = skuOrder.getOrderExpireTime() * 1000L;
            Date expireDate = new Date(dbItem.getOrderTime().getTime() + time);
            dbItem.setExpireTime(expireDate);
            dbItem.setElsAccount(elsAccount);
            return dbItem;
        }).collect(Collectors.toList());
        return dbItems;
    }

    private String convertLong(Long var) {
        if (var != null) {
            return var.toString();
        }
        return null;
    }

    private OrderOrderDetailData getOrderDetail(String orderId) {
        OrderOrderDetailRequest request = new OrderOrderDetailRequest();
        request.setConfig(this.doudianOpConfig);
        OrderOrderDetailParam param = (OrderOrderDetailParam)request.getParam();
        param.setShopOrderId(orderId);
        String accessTokenStr = "b532c94f-84d8-49f3-9b01-b36b532573d4";
        String refreshTokenStr = "e3ae870c-835d-4fff-a098-806300a8d00c";
        AccessToken accessToken = AccessToken.wrap((String)accessTokenStr, (String)refreshTokenStr);
        OrderOrderDetailResponse response = (OrderOrderDetailResponse)request.execute(accessToken);
        return (OrderOrderDetailData)response.getData();
    }
}

