/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.alliance.entity.MyGoodsImg;
import com.els.modules.alliance.service.MyGoodsHeadService;
import com.els.modules.alliance.vo.MyGoodsHeadVO;
import com.els.modules.companystore.entity.DyItems;
import com.els.modules.companystore.entity.GoodsContactConfig;
import com.els.modules.companystore.mapper.DyItemsMapper;
import com.els.modules.companystore.service.DyItemsService;
import com.els.modules.companystore.service.GoodsContactConfigService;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateHeadService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DyItemsServiceImpl
extends BaseServiceImpl<DyItemsMapper, DyItems>
implements DyItemsService {
    @Autowired
    @Lazy
    private MyGoodsHeadService myGoodsHeadService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private GoodsContactConfigService goodsContactConfigService;

    @Override
    public void add(DyItems dyItems) {
        ((DyItemsMapper)this.baseMapper).insert((Object)dyItems);
    }

    @Override
    public void edit(DyItems dyItems) {
        int count = ((DyItemsMapper)this.baseMapper).updateById((Object)dyItems);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((DyItemsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((DyItemsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void oneKeyPut(List<String> ids) {
        LoginUser user = SysUtil.getLoginUser();
        List dbs = this.listByIds(ids);
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)dbs), (String)"\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u4e0a\u67b6");
        String code = this.subaccountOrgRpcService.getSubaccountOrgCode();
        GoodsContactConfig goodsContactConfig = (GoodsContactConfig)((Object)this.goodsContactConfigService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)user.getElsAccount())).eq(GoodsContactConfig::getCompany, (Object)code)).eq(GoodsContactConfig::getPlatform, (Object)"1"), false));
        if (StrUtil.isNotBlank((CharSequence)code) && ObjectUtil.isEmpty((Object)((Object)goodsContactConfig))) {
            goodsContactConfig = (GoodsContactConfig)((Object)this.goodsContactConfigService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)user.getElsAccount())).eq(GoodsContactConfig::getPlatform, (Object)"1"), false));
        }
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)goodsContactConfig)), (String)"\u8bf7\u5148\u914d\u7f6e\u79df\u6237\u7684\u9ed8\u8ba4\u8054\u7cfb\u65b9\u5f0f");
        String contactCategory = goodsContactConfig.getContactCategory();
        String contact = goodsContactConfig.getContact();
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)contactCategory), (String)"\u8bf7\u5148\u914d\u7f6e\u79df\u6237\u6216\u516c\u53f8\u7684\u8054\u7cfb\u65b9\u5f0f\u7c7b\u578b");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)contactCategory), (String)"\u8bf7\u5148\u914d\u7f6e\u79df\u6237\u6216\u516c\u53f8\u7684\u8054\u7cfb\u65b9\u5f0f");
        for (DyItems row : dbs) {
            MyGoodsHeadVO myGoodsHeadVO = new MyGoodsHeadVO();
            myGoodsHeadVO.setGoodsId(row.getProductId());
            myGoodsHeadVO.setContactCategory(contactCategory);
            myGoodsHeadVO.setContact(contact);
            myGoodsHeadVO.setGoodsName(row.getTitle());
            myGoodsHeadVO.setCommissionRate(row.getCosRatio());
            myGoodsHeadVO.setGoodsType("2");
            myGoodsHeadVO.setShopId(row.getShopId());
            myGoodsHeadVO.setShopName(row.getShopName());
            myGoodsHeadVO.setGoodsPrice(row.getPrice());
            myGoodsHeadVO.setGoodsUrl(row.getDetailUrl());
            myGoodsHeadVO.setGoodsCategory(row.getCateStr());
            myGoodsHeadVO.setSalesNum(row.getSalesCount30day());
            myGoodsHeadVO.setVideosNum(row.getVideosNum30day());
            myGoodsHeadVO.setLivesNum(row.getLivesNum30day());
            myGoodsHeadVO.setTopmanNum(row.getPromUserAccount30day());
            myGoodsHeadVO.setConvertRate(row.getInversionRate30day());
            myGoodsHeadVO.setPlatform("1");
            MyGoodsImg myGoodsImg = new MyGoodsImg();
            Assert.isTrue((StrUtil.isNotBlank((CharSequence)row.getImgs()) || StrUtil.isNotBlank((CharSequence)row.getImageUrl()) ? 1 : 0) != 0, (String)(row.getTitle() + "\u5546\u54c1\u5546\u54c1\u4e3b\u56fe\u3001\u8f6e\u64ad\u56fe\u5747\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4e0a\u67b6"));
            myGoodsImg.setGoodsMainImg(Optional.ofNullable(row.getImgs()).orElse(row.getImageUrl()));
            myGoodsImg.setGoodsImg(row.getDetailImgs());
            myGoodsHeadVO.setMyGoodsImg(myGoodsImg);
            List templateHeads = this.templateHeadService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)"100000")).eq(BaseEntity::getDeleted, (Object)"0")).eq(TemplateHead::getBusinessType, (Object)"myGoods"));
            Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)templateHeads), (String)"\u8bf7\u5148\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f");
            TemplateHead templateHead = templateHeads.stream().sorted(Comparator.comparing(TemplateHead::getTemplateVersion).reversed()).findFirst().get();
            myGoodsHeadVO.setTemplateAccount(templateHead.getElsAccount());
            myGoodsHeadVO.setTemplateName(templateHead.getTemplateName());
            myGoodsHeadVO.setTemplateNumber(templateHead.getTemplateNumber());
            myGoodsHeadVO.setTemplateVersion(templateHead.getTemplateVersion());
            this.myGoodsHeadService.saveAndSubmit(myGoodsHeadVO);
            row.setIsAdd("1");
            this.updateById((Object)row);
        }
    }

    @Override
    public void resetAddStatus(String goodsId, String elsAccount) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(DyItems::getIsAdd, (Object)"0")).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(DyItems::getProductId, (Object)goodsId));
    }

    public static void main(String[] args) {
        ArrayList templateHeads = Lists.newArrayList();
        TemplateHead head = new TemplateHead();
        head.setTemplateVersion(Integer.valueOf(1));
        templateHeads.add(head);
        TemplateHead head2 = new TemplateHead();
        head2.setTemplateVersion(Integer.valueOf(2));
        templateHeads.add(head2);
        TemplateHead templateHead = templateHeads.stream().sorted(Comparator.comparing(TemplateHead::getTemplateVersion)).findFirst().get();
        System.out.println(templateHead);
    }
}

