/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.PermissionDataRpcService;
import com.els.modules.companystore.entity.KsOrderBaseInfo;
import com.els.modules.companystore.entity.KsOrderBill;
import com.els.modules.companystore.enumerate.KsOrderStatusEnum;
import com.els.modules.companystore.mapper.KsOrderBaseInfoMapper;
import com.els.modules.companystore.service.KsOrderBaseInfoService;
import com.els.modules.companystore.service.KsOrderBillService;
import com.els.modules.companystore.service.KsOrderItemInfoService;
import com.els.modules.companystore.vo.KsOrderVO;
import com.els.modules.companystore.vo.KsShopItemsVO;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class KsOrderBaseInfoServiceImpl
extends BaseServiceImpl<KsOrderBaseInfoMapper, KsOrderBaseInfo>
implements KsOrderBaseInfoService {
    @Autowired
    private KsOrderItemInfoService orderItemInfoService;
    @Autowired
    private KsOrderBillService ksOrderBillService;
    @Autowired
    private PermissionDataRpcService permissionDataRpcService;

    @Override
    public void add(KsOrderBaseInfo ksOrderBaseInfo) {
        ((KsOrderBaseInfoMapper)this.baseMapper).insert((Object)ksOrderBaseInfo);
    }

    @Override
    public void edit(KsOrderBaseInfo ksOrderBaseInfo) {
        int count = ((KsOrderBaseInfoMapper)this.baseMapper).updateById((Object)ksOrderBaseInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((KsOrderBaseInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((KsOrderBaseInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public IPage<KsOrderVO> listAll(Page<KsOrderVO> page, KsOrderVO ksOrderVO) {
        ksOrderVO.setElsAccount(TenantContext.getTenant());
        return ((KsOrderBaseInfoMapper)this.baseMapper).listAll(page, ksOrderVO, this.permissionDataRpcService.getCompany("companyStore"));
    }

    @Override
    public KsOrderVO ksDetail(String id) {
        KsOrderBaseInfo orderBaseInfo = (KsOrderBaseInfo)((Object)this.getById((Serializable)((Object)id)));
        KsOrderVO vo = (KsOrderVO)BeanUtil.copyProperties((Object)((Object)orderBaseInfo), KsOrderVO.class, (String[])new String[0]);
        vo.setOrderTime(orderBaseInfo.getOrderCreateTime());
        KsOrderBill ksOrderBill = (KsOrderBill)((Object)this.ksOrderBillService.getOne((Wrapper)Wrappers.lambdaQuery().eq(KsOrderBill::getOid, (Object)vo.getOid()), false));
        if (ObjectUtil.isNotEmpty((Object)((Object)ksOrderBill))) {
            vo.setSettlementDate(ksOrderBill.getSettlementTime());
            if (ObjectUtil.isNotEmpty((Object)ksOrderBill.getActualPayAmount())) {
                vo.setActualPayAmount((double)ksOrderBill.getActualPayAmount().longValue() / 100.0 + "");
            }
            if (ObjectUtil.isNotEmpty((Object)ksOrderBill.getDistributorCommissionAmount())) {
                vo.setTopManComm((double)ksOrderBill.getDistributorCommissionAmount().longValue() / 100.0 + "");
            }
            if (ObjectUtil.isNotEmpty((Object)ksOrderBill.getDistributorCommissionRate())) {
                vo.setTopManCommRate((double)ksOrderBill.getDistributorCommissionRate().longValue() / 10.0 + "");
            }
            if (ObjectUtil.isNotEmpty((Object)ksOrderBill.getActivityUserCommissionAmount())) {
                vo.setHeadComm((double)ksOrderBill.getActivityUserCommissionAmount().longValue() / 10.0 + "");
            }
            if (ObjectUtil.isNotEmpty((Object)ksOrderBill.getInvestmentPromotionRate())) {
                vo.setHeadCommRate((double)ksOrderBill.getInvestmentPromotionRate().longValue() / 10.0 + "");
            }
            if (ObjectUtil.isNotEmpty((Object)ksOrderBill.getActivityUserId())) {
                vo.setHeadId(ksOrderBill.getActivityUserId().toString());
            }
        }
        vo.setId(vo.getId());
        vo.setStatusDesc(KsOrderStatusEnum.getDescByCode(vo.getStatus()));
        vo.setDistributorName(orderBaseInfo.getDistributorName());
        vo.setDistributorId(orderBaseInfo.getDistributorId());
        return vo;
    }

    @Override
    public List<KsShopItemsVO> getKsOrderItmes(String elsAccount, String id) {
        return ((KsOrderBaseInfoMapper)this.baseMapper).getKsOrderItmes(elsAccount, id);
    }

    public static void main(String[] args) {
        Long a = new Long(15L);
        System.out.println(0.15);
    }
}

