/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterpriseresource.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.amateur.entity.PurchaseAmateurHead;
import com.els.modules.amateur.mapper.PurchaseAmateurHeadMapper;
import com.els.modules.enterpriseresource.dto.DouYinTopManDTO;
import com.els.modules.enterpriseresource.dto.EnterpriseTopManDTO;
import com.els.modules.enterpriseresource.dto.FrozenOrDeleteDTO;
import com.els.modules.enterpriseresource.entity.TopManAddElsRecordEntity;
import com.els.modules.enterpriseresource.entity.TopManElsAddMarkEntity;
import com.els.modules.enterpriseresource.entity.TopManEnterpriseInfoHeadEntity;
import com.els.modules.enterpriseresource.enumerate.DecideStatusEnum;
import com.els.modules.enterpriseresource.enumerate.DecideStatusStrategy;
import com.els.modules.enterpriseresource.exception.EnterpriseTopManException;
import com.els.modules.enterpriseresource.mapper.TopManAddElsRecordMapper;
import com.els.modules.enterpriseresource.mapper.TopManEnterpriseInfoHeadMapper;
import com.els.modules.enterpriseresource.service.TopManAddElsRecordService;
import com.els.modules.enterpriseresource.service.TopManElsAddMarkService;
import com.els.modules.enterpriseresource.service.TopManEnterpriseInfoHeadService;
import com.els.modules.enterpriseresource.utils.EnterpriseTopManBaseUtils;
import com.els.modules.enterpriseresource.utils.spider.entity.TopManDouYinIdEntity;
import com.els.modules.enterpriseresource.utils.spider.properties.McnSpiderMethodType;
import com.els.modules.enterpriseresource.utils.spider.spiderApi.McnSpiderApiUtil;
import com.els.modules.enterpriseresource.vo.TopManDouYinIdVO;
import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TopManAddElsRecordServiceImpl
extends BaseServiceImpl<TopManAddElsRecordMapper, TopManAddElsRecordEntity>
implements TopManAddElsRecordService {
    private static final Logger log = LoggerFactory.getLogger(TopManAddElsRecordServiceImpl.class);
    @Autowired
    private TopManEnterpriseInfoHeadService topManEnterpriseInfoHeadService;
    @Autowired
    private TopManElsAddMarkService topManElsAddMarkService;
    @Autowired
    private PurchaseAmateurHeadMapper purchaseAmateurHeadMapper;
    @Autowired
    private TopManEnterpriseInfoHeadMapper enterpriseInfoHeadMapper;
    @Resource
    private McnSpiderApiUtil mcnSpiderApiUtil;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String COLON = ":";
    private final Object[] decideStatusCheck = new String[]{DecideStatusEnum.CONFIRMED.getCode(), DecideStatusEnum.TO_BE_CONFIRMED.getCode()};

    @Override
    public TopManAddElsRecordEntity queryLastRecordInfo(String platform, String topManId) {
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        TopManAddElsRecordEntity topManAddElsRecordEntity = ((TopManAddElsRecordMapper)this.baseMapper).selectLastRecordInfo(TenantContext.getTenant(), platform, topManId, company);
        if (topManAddElsRecordEntity == null) {
            topManAddElsRecordEntity = new TopManAddElsRecordEntity();
            topManAddElsRecordEntity.setPlatform(platform);
            topManAddElsRecordEntity.setTopmanId(topManId);
        }
        topManAddElsRecordEntity.setId(null);
        return topManAddElsRecordEntity;
    }

    @Override
    public TopManAddElsRecordEntity queryLastRecordInfoNew(EnterpriseTopManDTO dto) {
        String platform = dto.getPlatform();
        String topManId = dto.getTopManId();
        if ("1".equals(platform)) {
            String avatar = dto.getAvatar();
            String topManName = dto.getTopManName();
            String topmanRegion = dto.getTopmanRegion();
            DouYinTopManDTO param = new DouYinTopManDTO();
            param.setAvatar(avatar);
            param.setTopManName(topManName);
            param.setTopmanRegion(topmanRegion);
            TopManDouYinIdVO douYinIdVO = this.getDouYinId(param);
            topManId = douYinIdVO.getUserInfo().getUniqueId();
            if (StringUtils.isBlank((CharSequence)topManId)) {
                log.error("Api\u83b7\u53d6topManId\u5931\u8d25---uid\uff1a" + topManId + "topManName\uff1a" + topManName + "topmanRegion\uff1a" + topmanRegion);
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"Api\u83b7\u53d6topManId\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"));
            }
        }
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        TopManAddElsRecordEntity topManAddElsRecordEntity = ((TopManAddElsRecordMapper)this.baseMapper).selectLastRecordInfo(TenantContext.getTenant(), platform, topManId, company);
        if (topManAddElsRecordEntity == null) {
            topManAddElsRecordEntity = new TopManAddElsRecordEntity();
            topManAddElsRecordEntity.setPlatform(platform);
            topManAddElsRecordEntity.setTopmanId(topManId);
        }
        topManAddElsRecordEntity.setId(null);
        return topManAddElsRecordEntity;
    }

    private TopManDouYinIdVO getDouYinId(DouYinTopManDTO param) {
        String avatar = param.getAvatar();
        String name = param.getTopManName();
        String region = param.getTopmanRegion();
        if (StringUtils.isBlank((CharSequence)avatar) || StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)region)) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        String key = "DetailDouYinId_" + name + "_" + region;
        TopManDouYinIdVO douYinIdVO = null;
        if (!"1".equals(param.getClearCache())) {
            douYinIdVO = (TopManDouYinIdVO)this.redisUtil.get(key);
        }
        HashMap<String, Object> paramBean = new HashMap<String, Object>(1);
        paramBean.put("topman_name", name);
        if (douYinIdVO == null) {
            douYinIdVO = new TopManDouYinIdVO();
            TopManDouYinIdEntity entity = this.mcnSpiderApiUtil.getForEntity(McnSpiderMethodType.DOU_YIN_ID, paramBean, TopManDouYinIdEntity.class);
            this.transitionDouYinId(entity, douYinIdVO, avatar, key);
        } else {
            boolean check = this.mcnSpiderApiUtil.checkCache(McnSpiderMethodType.DOU_YIN_ID, paramBean);
            if (!check) {
                McnSpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDouYinId(param);
                });
            }
        }
        return douYinIdVO;
    }

    private TopManDouYinIdVO transitionDouYinId(TopManDouYinIdEntity entity, TopManDouYinIdVO douYinIdVO, String avatar, String key) {
        if (entity == null) {
            return douYinIdVO;
        }
        String str = avatar.substring(avatar.lastIndexOf("/"), avatar.indexOf("?"));
        for (TopManDouYinIdEntity.Result result : entity.getResult()) {
            if (douYinIdVO.getUserInfo() != null) break;
            TopManDouYinIdEntity.DyUserInfo user = result.getUserInfo();
            TopManDouYinIdEntity.DyUserInfo.AvatarThumb avatarThumb = user.getAvatarThumb();
            String url = avatarThumb.getUrlList().get(0);
            String str2 = url.substring(url.lastIndexOf("/"));
            if (!str2.contains(str)) continue;
            TopManDouYinIdVO.DyUserInfo userInfo = new TopManDouYinIdVO.DyUserInfo();
            userInfo.setUniqueId(user.getUniqueId());
            douYinIdVO.setUserInfo(userInfo);
            douYinIdVO.setIsRedUniqueid(result.getIsRedUniqueid());
            log.info("\u83b7\u53d6\u8fbe\u4ebaID\u6210\u529f:[{}]", (Object)douYinIdVO);
        }
        if (douYinIdVO != null && douYinIdVO.getUserInfo() != null) {
            this.redisUtil.set(key, (Object)douYinIdVO, 14400L);
        }
        return douYinIdVO;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void addRecord(TopManAddElsRecordEntity entity) {
        this.checkRecordValid(entity);
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        QueryWrapper markEntityQueryWrapper = new QueryWrapper();
        markEntityQueryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        ((LambdaQueryWrapper)markEntityQueryWrapper.lambda().eq(TopManElsAddMarkEntity::getPlatform, (Object)entity.getPlatform())).eq(TopManElsAddMarkEntity::getTopmanId, (Object)entity.getTopmanId());
        TopManElsAddMarkEntity oneMark = (TopManElsAddMarkEntity)((Object)this.topManElsAddMarkService.getOne((Wrapper)markEntityQueryWrapper));
        if (oneMark == null) {
            oneMark = new TopManElsAddMarkEntity();
            oneMark.setElsAccount(elsAccount);
            oneMark.setPlatform(entity.getPlatform());
            oneMark.setTopmanId(entity.getTopmanId());
            EnterpriseTopManBaseUtils.initSysPram(oneMark);
            this.topManElsAddMarkService.save((Object)oneMark);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        if (company != null && !"".equals(company)) {
            queryWrapper.lambda().eq(TopManAddElsRecordEntity::getCompany, (Object)company);
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(TopManAddElsRecordEntity::getPlatform, (Object)entity.getPlatform())).eq(TopManAddElsRecordEntity::getTopmanId, (Object)entity.getTopmanId())).in(TopManAddElsRecordEntity::getDecideStatus, this.decideStatusCheck);
        if (((TopManAddElsRecordMapper)this.baseMapper).selectCount((Wrapper)queryWrapper) > 0) {
            throw new EnterpriseTopManException("\u5f53\u524d\u8fbe\u4eba\u5728\u60a8\u7684\u4f01\u4e1a\u4e2d\u5df2\u7ecf\u6709\u76f8\u5173\u7684\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0");
        }
        PurchaseAmateurHead purchaseAmateurHead = this.purchaseAmateurHeadMapper.selectAmateurElsAccountByTopManId(entity.getTopmanId());
        if (purchaseAmateurHead != null) {
            entity.setAmateurElsAccount(purchaseAmateurHead.getToElsAccount());
            LambdaQueryWrapper topManEnterpriseInfoQueryWrapper = new LambdaQueryWrapper();
            topManEnterpriseInfoQueryWrapper.eq(TopManEnterpriseInfoHeadEntity::getTopmanId, (Object)entity.getTopmanId());
            TopManEnterpriseInfoHeadEntity topManEnterpriseInfoHeadEntity = (TopManEnterpriseInfoHeadEntity)((Object)this.topManEnterpriseInfoHeadService.getOne((Wrapper)topManEnterpriseInfoQueryWrapper));
            if (topManEnterpriseInfoHeadEntity != null) {
                topManEnterpriseInfoHeadEntity.setAmateurElsAccount(purchaseAmateurHead.getToElsAccount());
                this.topManEnterpriseInfoHeadService.updateById((Object)topManEnterpriseInfoHeadEntity);
            }
        }
        entity.setElsAccount(elsAccount);
        entity.setSubAccount(subAccount);
        entity.setDecideStatus(DecideStatusEnum.TO_BE_CONFIRMED.getCode());
        entity.setCompany(company);
        EnterpriseTopManBaseUtils.initSysPram(entity);
        ((TopManAddElsRecordMapper)this.baseMapper).insert((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void decideStatusStrategyHandle(String id, DecideStatusStrategy decideStatusStrategy) {
        TopManAddElsRecordEntity entity = (TopManAddElsRecordEntity)((Object)((TopManAddElsRecordMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (entity == null || !entity.getElsAccount().equals(TenantContext.getTenant())) {
            throw new EnterpriseTopManException("\u64cd\u4f5c\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String fromStatus = decideStatusStrategy.getFromStatus().getCode();
        String toStatus = decideStatusStrategy.getToStatus().getCode();
        if (!fromStatus.equals(entity.getDecideStatus())) {
            throw new EnterpriseTopManException("\u64cd\u4f5c\u8bb0\u5f55\u7684\u786e\u8ba4\u72b6\u6001\u9519\u8bef\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        entity.setDecideStatus(toStatus);
        EnterpriseTopManBaseUtils.initSysPram(entity);
        ((TopManAddElsRecordMapper)this.baseMapper).updateById((Object)entity);
        if (DecideStatusStrategy.confirmed.equals((Object)decideStatusStrategy)) {
            this.topManEnterpriseInfoHeadService.insertOrUpdateRecordToHead(entity);
        }
        if (DecideStatusStrategy.deny.equals((Object)decideStatusStrategy) || DecideStatusStrategy.cancel.equals((Object)decideStatusStrategy)) {
            this.removeTopManElsAddMark(entity.getPlatform(), entity.getTopmanId());
        }
    }

    private void removeTopManElsAddMark(String platform, String topmanId) {
        QueryWrapper markEntityQueryWrapper = new QueryWrapper();
        markEntityQueryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        ((LambdaQueryWrapper)markEntityQueryWrapper.lambda().eq(TopManElsAddMarkEntity::getPlatform, (Object)platform)).eq(TopManElsAddMarkEntity::getTopmanId, (Object)topmanId);
        this.topManElsAddMarkService.remove((Wrapper)markEntityQueryWrapper);
        if ("4".equals(platform)) {
            this.redisUtil.dels("bs:" + TenantContext.getTenant() + COLON + "list");
        } else if ("5".equals(platform)) {
            this.redisUtil.dels("blog:" + TenantContext.getTenant() + COLON + "list");
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void frozenOrDelete(FrozenOrDeleteDTO dto) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        LambdaUpdateWrapper enterpriseWrapper = new LambdaUpdateWrapper();
        switch (dto.getType()) {
            case "FROZEN": {
                wrapper.set(TopManAddElsRecordEntity::getDecideStatus, (Object)DecideStatusEnum.FROZEN.getCode());
                wrapper.set(TopManAddElsRecordEntity::getRemark, (Object)dto.getRemark());
                enterpriseWrapper.set(TopManEnterpriseInfoHeadEntity::getDecideStatus, (Object)DecideStatusEnum.FROZEN.getCode());
                break;
            }
            case "NORMAL": {
                wrapper.set(TopManAddElsRecordEntity::getDecideStatus, (Object)DecideStatusEnum.CONFIRMED.getCode());
                enterpriseWrapper.set(TopManEnterpriseInfoHeadEntity::getDecideStatus, (Object)DecideStatusEnum.CONFIRMED.getCode());
                break;
            }
            case "DELETED": {
                if (StringUtils.isBlank((CharSequence)dto.getRemark())) {
                    throw new EnterpriseTopManException.ParamValid("\u79fb\u9664\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                TopManAddElsRecordEntity entity = (TopManAddElsRecordEntity)((Object)((TopManAddElsRecordMapper)this.baseMapper).selectById((Serializable)((Object)dto.getId())));
                if (entity == null || !entity.getElsAccount().equals(TenantContext.getTenant())) {
                    throw new EnterpriseTopManException("\u64cd\u4f5c\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
                }
                this.removeTopManElsAddMark(entity.getPlatform(), entity.getTopmanId());
                wrapper.set(TopManAddElsRecordEntity::getDecideStatus, (Object)DecideStatusEnum.DELETED.getCode());
                wrapper.set(BaseEntity::getDeleted, (Object)"1");
                wrapper.set(TopManAddElsRecordEntity::getRemark, (Object)dto.getRemark());
                enterpriseWrapper.set(TopManEnterpriseInfoHeadEntity::getDecideStatus, (Object)DecideStatusEnum.DELETED.getCode());
                enterpriseWrapper.set(BaseEntity::getDeleted, (Object)"1");
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        wrapper.eq(BaseEntity::getId, (Object)dto.getId());
        ((TopManAddElsRecordMapper)this.baseMapper).update((Object)new TopManAddElsRecordEntity(), (Wrapper)wrapper);
        enterpriseWrapper.eq(TopManEnterpriseInfoHeadEntity::getRecordId, (Object)dto.getId());
        this.enterpriseInfoHeadMapper.update((Object)new TopManEnterpriseInfoHeadEntity(), (Wrapper)enterpriseWrapper);
    }

    private void checkRecordValid(TopManAddElsRecordEntity entity) {
        if (StringUtils.isBlank((CharSequence)entity.getPlatform())) {
            throw new EnterpriseTopManException.ParamValid("\u5e73\u53f0ID\u4e0d\u5141\u8bb8\u4e3anull");
        }
        if (StringUtils.isBlank((CharSequence)entity.getTopmanId())) {
            throw new EnterpriseTopManException.ParamValid("\u8fbe\u4ebaID\u4e0d\u5141\u8bb8\u4e3anull");
        }
    }
}

