/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.popularize.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.popularize.entity.PopularizePlanItem;
import com.els.modules.popularize.entity.PopularizeProjectHead;
import com.els.modules.popularize.entity.PopularizeTopManOfCooperItem;
import com.els.modules.popularize.entity.PopularizeTopmanItem;
import com.els.modules.popularize.service.PopularizeProjectHeadService;
import com.els.modules.popularize.service.PopularizeProjectItemService;
import com.els.modules.popularize.service.PopularizeTopManItemService;
import com.els.modules.popularize.vo.PopularizeProjectManagerVo;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/popularize/popularizeProject"})
@Api(tags={"\u63a8\u5e7f\u9879\u76ee\u7ba1\u7406"})
public class PopularizeProjectManagerController
extends BaseController<PopularizeProjectHead, PopularizeProjectHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PopularizeProjectManagerController.class);
    @Autowired
    private PopularizeProjectHeadService popularizeProjectHeadService;
    @Autowired
    private PopularizeProjectItemService popularizeProjectItemService;
    @Autowired
    private PopularizeTopManItemService popularizeTopManItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="cooperativeExtension")
    public Result<?> queryPageList(PopularizeProjectHead popularizeProjectHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)popularizeProjectHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.popularizeProjectHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u63a8\u5e7f\u9879\u76ee\u7ba1\u7406", value="\u4fdd\u5b58")
    @ApiOperation(value="\u4fdd\u5b58", notes="\u4fdd\u5b58")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PopularizeProjectManagerVo popularizeProjectVo) {
        this.popularizeProjectHeadService.saveMain(popularizeProjectVo);
        PopularizeProjectHead popularizeProjectHead = popularizeProjectVo.getPopularizeProjectHead();
        popularizeProjectHead.setPopularizePlanItem(popularizeProjectVo.getPopularizePlanItem());
        return Result.ok((Object)((Object)popularizeProjectHead));
    }

    @AutoLog(busModule="\u63a8\u5e7f\u9879\u76ee\u7ba1\u7406", value="\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody PopularizeProjectHead popularizeProjectVo) {
        this.popularizeProjectHeadService.submitMain(popularizeProjectVo);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u63a8\u5e7f\u9879\u76ee\u7ba1\u7406", value="\u4f5c\u5e9f\u9879\u76ee")
    @ApiOperation(value="\u4f5c\u5e9f\u9879\u76ee", notes="\u4f5c\u5e9f\u9879\u76ee")
    @GetMapping(value={"/cancel"})
    public Result<?> cancel(@RequestParam(name="id") String id) {
        this.popularizeProjectHeadService.cancel(id);
        return this.commonSuccessResult(7);
    }

    @AutoLog(busModule="\u63a8\u5e7f\u9879\u76ee\u7ba1\u7406", value="\u4f5c\u5e9f\u8ba1\u5212\u884c")
    @ApiOperation(value="\u4f5c\u5e9f\u8ba1\u5212\u884c", notes="\u4f5c\u5e9f\u8ba1\u5212\u884c")
    @GetMapping(value={"/cancelPlanItem"})
    public Result<?> cancelPlanItem(@RequestParam(name="id") String id) {
        this.popularizeProjectItemService.cancel(id);
        return this.commonSuccessResult(7);
    }

    @AutoLog(busModule="\u63a8\u5e7f\u9879\u76ee\u7ba1\u7406", value="\u9879\u76ee\u5b8c\u6210")
    @ApiOperation(value="\u9879\u76ee\u5b8c\u6210", notes="\u9879\u76ee\u5b8c\u6210")
    @GetMapping(value={"/finish"})
    public Result<?> finish(@RequestParam(name="id") String id) {
        this.popularizeProjectHeadService.finish(id);
        return this.commonSuccessResult(8);
    }

    @AutoLog(busModule="\u63a8\u5e7f\u9879\u76ee\u7ba1\u7406", value="\u5220\u9664")
    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="id") String id) {
        this.popularizeProjectHeadService.delete(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PopularizeProjectHead popularizeProjectVo = (PopularizeProjectHead)((Object)this.popularizeProjectHeadService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)popularizeProjectVo));
    }

    @ApiOperation(value="\u901a\u8fc7\u8868\u5934id\u67e5\u8be2\u8ba1\u5212\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u8868\u5934id\u67e5\u8be2\u8ba1\u5212\u884c\u4fe1\u606f")
    @GetMapping(value={"/queryPlanItemByHeadId"})
    public Result<?> queryPlanItemByHeadId(@RequestParam(name="headId") String headId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PopularizePlanItem::getHeadId, (Object)headId);
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List popularizePlanItems = this.popularizeProjectItemService.list((Wrapper)queryWrapper);
        return Result.ok((Object)popularizePlanItems);
    }

    @ApiOperation(value="\u901a\u8fc7\u8868\u5934id\u67e5\u8be2\u8fbe\u4eba\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u8868\u5934id\u67e5\u8be2\u8fbe\u4eba\u884c\u4fe1\u606f")
    @GetMapping(value={"/queryTopManItemByHeadId"})
    public Result<?> queryTopManItemByHeadId(@RequestParam(name="headId") String headId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PopularizeTopmanItem::getHeadId, (Object)headId);
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List<PopularizeTopManOfCooperItem> popularizeTopManItems = this.popularizeTopManItemService.selectListFromTalentCooper(headId);
        return Result.ok(popularizeTopManItems);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PopularizeProjectHead popularizeProjectHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)popularizeProjectHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
        queryWrapper.select(new String[]{"popularize_status", "count(0) as quantity"});
        queryWrapper.groupBy((Object)"popularize_status");
        List list = ((PopularizeProjectHeadService)this.service).list((Wrapper)queryWrapper);
        final Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PopularizeProjectHead::getPopularizeStatus, PopularizeProjectHead::getQuantity));
        final List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("receiptsStatus", TenantContext.getTenant());
        ArrayList<CountVO> result = new ArrayList<CountVO>(srmRectificationAppealStatus.size()){
            {
                super(x0);
                CountVO countVO = new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "popularizeStatus", null, Integer.valueOf(0));
                this.add(countVO);
                Integer all = 0;
                for (DictDTO status : srmRectificationAppealStatus) {
                    Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : (Integer)countMap.get(status.getValue());
                    all = all + total;
                    this.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "popularizeStatus", status.getValue(), total));
                }
                countVO.setTotal(all);
            }
        };
        return Result.ok((Object)result);
    }
}

