/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.samplesend.service.impl;

import com.alibaba.fastjson.JSON;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.samplesend.entity.MerchandiseInventoryHead;
import com.els.modules.samplesend.service.MerchandiseInventoryHeadService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="merchandiseInventoryImportServiceImpl")
public class MerchandiseInventoryImportServiceImpl
implements ExcelImportRpcService {
    @Autowired
    private MerchandiseInventoryHeadService merchandiseInventoryHeadService;
    @Autowired
    private TemplateRpcService templateRpcService;
    protected Log log = LogFactory.getLog(this.getClass());

    @Transactional
    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        MerchandiseInventoryImportHandleBean bean = new MerchandiseInventoryImportHandleBean(dataList);
        this.handle(bean);
        for (List merchandiseInventoryHeads : bean.insertResultList) {
            this.merchandiseInventoryHeadService.insertBatch(merchandiseInventoryHeads);
        }
        for (List merchandiseInventoryHeads : bean.updateResultList) {
            this.merchandiseInventoryHeadService.updateBatch(merchandiseInventoryHeads);
        }
        return dataList;
    }

    private void handle(MerchandiseInventoryImportHandleBean bean) {
        List dataList = bean.dataList;
        int nowIndex = bean.nowIndex++;
        if (dataList.size() == nowIndex) {
            if (bean.materialNumberList.size() > 0) {
                List<MerchandiseInventoryHead> materialList = this.merchandiseInventoryHeadService.listByMaterialNumbers(bean.materialNumberList);
                bean.materialMap = materialList.stream().collect(Collectors.toMap(MerchandiseInventoryHead::getSupplierNo, Function.identity(), (newVal, oldVal) -> oldVal));
            }
            return;
        }
        Map map = (Map)dataList.get(nowIndex);
        MerchandiseInventoryHead importBean = (MerchandiseInventoryHead)((Object)JSON.parseObject((String)JSON.toJSONString((Object)map), MerchandiseInventoryHead.class));
        String supplierNo = importBean.getSupplierNo();
        Assert.hasText((String)supplierNo, (String)I18nUtil.translate((String)"", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        bean.materialNumberList.add(supplierNo);
        this.handle(bean);
        Map materialMap = bean.materialMap;
        MerchandiseInventoryHead oldBean = (MerchandiseInventoryHead)((Object)materialMap.get(supplierNo));
        LoginUser loginUser = SysUtil.getLoginUser();
        if (oldBean != null) {
            MerchandiseInventoryHead finalBean = oldBean;
            finalBean.setTemplateAccount("100000");
            finalBean.setTemplateName("\u5546\u54c1\u5e93\u5b58\u7ba1\u7406");
            finalBean.setTemplateVersion(3);
            finalBean.setTemplateNumber("TC2022050901");
            finalBean.setSupplierName(importBean.getSupplierName());
            finalBean.setBrand(importBean.getBrand());
            finalBean.setCompany(importBean.getCompany());
            finalBean.setSupplierType(importBean.getSupplierType());
            finalBean.setSupplierTypeName(importBean.getSupplierTypeName());
            finalBean.setSupplierGroup(importBean.getSupplierGroup());
            finalBean.setSupplierGroupName(importBean.getSupplierGroupName());
            finalBean.setSupplierDesc(importBean.getSupplierDesc());
            finalBean.setSupplierStandards(importBean.getSupplierStandards());
            finalBean.setInventoryAddressNo(importBean.getInventoryAddressNo());
            finalBean.setInventoryAddressDesc(importBean.getInventoryAddressDesc());
            finalBean.setInventoryAlertQuantity(importBean.getInventoryAlertQuantity());
            finalBean.setInventoryBalanceQuantity(importBean.getInventoryBalanceQuantity());
            finalBean.setRemark(importBean.getRemark());
            finalBean.setUpdateBy(loginUser.getSubAccount());
            finalBean.setUpdateTime(new Date());
            bean.setUpdateResultList(finalBean);
        } else {
            MerchandiseInventoryHead finalBean = importBean;
            finalBean.setTemplateAccount("100000");
            finalBean.setTemplateName("\u5546\u54c1\u5e93\u5b58\u7ba1\u7406");
            finalBean.setTemplateVersion(3);
            finalBean.setTemplateNumber("TC2022050901");
            finalBean.setAssignmentStatus("0");
            TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)bean.templateHeadDTOList.get(0);
            finalBean.setElsAccount(loginUser.getElsAccount());
            finalBean.setCreateBy(loginUser.getSubAccount());
            finalBean.setCreateTime(new Date());
            finalBean.setUpdateBy(loginUser.getSubAccount());
            finalBean.setUpdateBy(loginUser.getSubAccount());
            finalBean.setUpdateTime(new Date());
            bean.setInsertResultList(finalBean);
        }
    }

    static /* synthetic */ TemplateRpcService access$1000(MerchandiseInventoryImportServiceImpl x0) {
        return x0.templateRpcService;
    }

    private class MerchandiseInventoryImportHandleBean {
        private int nowIndex = 0;
        private final List<Map<String, Object>> dataList;
        private final List<String> materialNumberList;
        private final List<List<MerchandiseInventoryHead>> insertResultList;
        private final List<List<MerchandiseInventoryHead>> updateResultList;
        private int insertResultIndex = 0;
        private int updateResultIndex = 0;
        private final List<TemplateHeadDTO> templateHeadDTOList = MerchandiseInventoryImportServiceImpl.access$1000(MerchandiseInventoryImportServiceImpl.this).getDefaultTemplateByType("popularizeProjectManager");
        private Map<String, MerchandiseInventoryHead> materialMap = Collections.emptyMap();

        private MerchandiseInventoryImportHandleBean(List<Map<String, Object>> dataList) {
            if (dataList == null) {
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u5bfc\u5165\u5f02\u5e38\uff1anull"));
            }
            this.dataList = dataList;
            this.materialNumberList = new ArrayList<String>(dataList.size());
            this.insertResultList = new ArrayList<List<MerchandiseInventoryHead>>((int)Math.ceil((double)dataList.size() / 1000.0));
            this.updateResultList = new ArrayList<List<MerchandiseInventoryHead>>(3);
        }

        private void setUpdateResultList(MerchandiseInventoryHead head) {
            List<MerchandiseInventoryHead> merchandiseInventoryHeads;
            if (this.updateResultList.size() == this.updateResultIndex) {
                this.updateResultList.add(new ArrayList(Math.min(1000, this.dataList.size() - this.updateResultIndex * 1000)));
            }
            if ((merchandiseInventoryHeads = this.updateResultList.get(this.updateResultIndex)).size() == 1000) {
                ++this.updateResultIndex;
                this.setUpdateResultList(head);
            } else {
                merchandiseInventoryHeads.add(head);
            }
        }

        private void setInsertResultList(MerchandiseInventoryHead head) {
            List<MerchandiseInventoryHead> merchandiseInventoryHeads;
            if (this.insertResultList.size() == this.insertResultIndex) {
                this.insertResultList.add(new ArrayList(Math.min(1000, this.dataList.size() - this.insertResultIndex * 1000)));
            }
            if ((merchandiseInventoryHeads = this.insertResultList.get(this.insertResultIndex)).size() == 1000) {
                ++this.insertResultIndex;
                this.setInsertResultList(head);
            } else {
                merchandiseInventoryHeads.add(head);
            }
        }
    }
}

