/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.samplesend.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.alliance.entity.MyGoodsSpreaderItem;
import com.els.modules.alliance.entity.MyGoodsTopmanItem;
import com.els.modules.alliance.entity.MyPromotionalHead;
import com.els.modules.alliance.entity.MyPromotionalTopmanItem;
import com.els.modules.alliance.mapper.MyGoodsSpreaderItemMapper;
import com.els.modules.alliance.service.MyGoodsHeadService;
import com.els.modules.alliance.service.MyGoodsTopmanItemService;
import com.els.modules.alliance.service.MyPromotionalHeadService;
import com.els.modules.alliance.service.MyPromotionalTopmanItemService;
import com.els.modules.purchasercooperation.common.utils.PurchaseTalentStatusEnum;
import com.els.modules.purchasercooperation.entity.PurchaserTalentSampleItem;
import com.els.modules.purchasercooperation.exception.PurchaseTalentDataCheckException;
import com.els.modules.purchasercooperation.service.PurchaserTalentSampleItemService;
import com.els.modules.samplesend.entity.LogisticsCompany;
import com.els.modules.samplesend.entity.LogisticsCompanyItem;
import com.els.modules.samplesend.entity.MerchandiseInventoryHead;
import com.els.modules.samplesend.entity.SampleTopMainHead;
import com.els.modules.samplesend.entity.SampleTopMainItem;
import com.els.modules.samplesend.mapper.MerchandiseInventoryHeadMapper;
import com.els.modules.samplesend.mapper.SampleTopMainHeadMapper;
import com.els.modules.samplesend.mapper.SampleTopMainItemMapper;
import com.els.modules.samplesend.service.SampleTopMainHeadService;
import com.els.modules.samplesend.utils.BeanEntityUtils;
import com.els.modules.samplesend.vo.SampleTopMainHeadVo;
import com.els.modules.workflow.api.service.WorkflowAuditRpcService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SampleTopMainHeadServiceImpl
extends BaseServiceImpl<SampleTopMainHeadMapper, SampleTopMainHead>
implements SampleTopMainHeadService {
    private static final Logger log = LoggerFactory.getLogger(SampleTopMainHeadServiceImpl.class);
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SampleTopMainItemMapper sampleTopMainItemMapper;
    @Resource
    private WorkflowAuditRpcService workflowAuditRpcService;
    @Autowired
    private PurchaserTalentSampleItemService sampleItemService;
    @Autowired
    private MerchandiseInventoryHeadMapper merchandiseInventoryHeadMapper;
    @Autowired
    private MyGoodsHeadService myGoodsHeadService;
    @Autowired
    private MyGoodsSpreaderItemMapper myGoodsSpreaderItemMapper;
    @Autowired
    private MyGoodsTopmanItemService myGoodsTopmanItemService;
    @Autowired
    private MyPromotionalHeadService myPromotionalHeadService;
    @Autowired
    private MyPromotionalTopmanItemService myPromotionalTopmanItemService;

    @Override
    @Transactional
    public void add(String status, SampleTopMainHead sampleTopMainHead) {
        if ("0".equals(status)) {
            this.setDefaultParam(sampleTopMainHead);
        }
        this.countGoodsQuantity(sampleTopMainHead);
        int insert = ((SampleTopMainHeadMapper)this.baseMapper).insert((Object)sampleTopMainHead);
        if (insert > 0) {
            this.setSubclass(status, sampleTopMainHead);
        }
        if (StringUtils.isNotBlank((CharSequence)sampleTopMainHead.getFbk1())) {
            this.myGoodsHeadService.addSampleCheck(sampleTopMainHead.getFbk1());
            this.updateAlliance(sampleTopMainHead);
        }
    }

    @Override
    @Transactional
    public void edit(String status, SampleTopMainHead sampleTopMainHead) {
        int i;
        String id = sampleTopMainHead.getId();
        if (!"1".equals(status)) {
            this.checkPrivilege(id);
        }
        this.countGoodsQuantity(sampleTopMainHead);
        if ("0".equals(status)) {
            this.setDefaultParam(sampleTopMainHead);
        }
        if ((i = ((SampleTopMainHeadMapper)this.baseMapper).updateById((Object)sampleTopMainHead)) > 0) {
            this.setSubclass(status, sampleTopMainHead);
        }
    }

    @Override
    @Transactional
    public void submit(SampleTopMainHead sampleTopMainHead) {
        String id = sampleTopMainHead.getId();
        SampleTopMainHead byId = (SampleTopMainHead)((Object)super.getById((Serializable)((Object)id)));
        boolean b = this.setApproveParamStatus(sampleTopMainHead);
        if (byId == null) {
            sampleTopMainHead.setBillCode(this.invokeBaseRpcService.getNextCode("sampleTopMainNumber", (Object)sampleTopMainHead));
            this.countGoodsQuantity(sampleTopMainHead);
            int n = ((SampleTopMainHeadMapper)this.baseMapper).insert((Object)sampleTopMainHead);
        } else {
            ((SampleTopMainHeadMapper)this.baseMapper).updateById((Object)sampleTopMainHead);
        }
        if (b) {
            this.setSubclass("0", sampleTopMainHead);
            this.submitAudit(sampleTopMainHead);
        } else {
            this.updateGoodsStock(sampleTopMainHead);
            this.setSubclass("1", sampleTopMainHead);
        }
        if (StringUtils.isNotBlank((CharSequence)sampleTopMainHead.getFbk1())) {
            this.myGoodsHeadService.addSampleCheck(sampleTopMainHead.getFbk1());
            this.updateAlliance(sampleTopMainHead);
        }
    }

    private void updateAlliance(SampleTopMainHead sampleTopMainHead) {
        MyGoodsSpreaderItem spreaderItem = (MyGoodsSpreaderItem)((Object)this.myGoodsSpreaderItemMapper.selectById((Serializable)((Object)sampleTopMainHead.getFbk1())));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(MyGoodsTopmanItem::getSampleNo, (Object)sampleTopMainHead.getBillCode());
        updateWrapper.set(MyGoodsTopmanItem::getSampleStatus, (Object)sampleTopMainHead.getBillStatus());
        updateWrapper.eq(MyGoodsTopmanItem::getHeadId, (Object)spreaderItem.getId());
        this.myGoodsTopmanItemService.update((Wrapper)updateWrapper);
        MyPromotionalHead promotionalHead = this.myPromotionalHeadService.getByRelationId(spreaderItem.getHeadId());
        if (promotionalHead != null) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(MyPromotionalTopmanItem::getSampleNo, (Object)sampleTopMainHead.getBillCode());
            wrapper.set(MyPromotionalTopmanItem::getSampleStatus, (Object)sampleTopMainHead.getBillStatus());
            wrapper.eq(MyPromotionalTopmanItem::getHeadId, (Object)promotionalHead.getId());
            this.myPromotionalTopmanItemService.update((Wrapper)wrapper);
        }
    }

    @Override
    public void updateGoodsStock(SampleTopMainHead sampleTopMainHead) {
        ArrayList<MerchandiseInventoryHead> ids;
        List<SampleTopMainItem> sampleTopMainItems = sampleTopMainHead.getSampleTopMainItems();
        ArrayList headList = new ArrayList();
        HashMap paramMap = new HashMap();
        if (CollectionUtils.isNotEmpty(sampleTopMainItems)) {
            sampleTopMainItems.forEach(sampleItem -> {
                if ("0".equals(sampleItem.getItemStatus())) {
                    if (paramMap.containsKey(sampleItem.getGoodsId())) {
                        MerchandiseInventoryHead merchandiseInventoryHead = (MerchandiseInventoryHead)((Object)((Object)paramMap.get(sampleItem.getQuantity())));
                        merchandiseInventoryHead.setAssignedQuantity(merchandiseInventoryHead.getAssignedQuantity().add(sampleItem.getQuantity()));
                        paramMap.put(sampleItem.getGoodsId(), merchandiseInventoryHead);
                    } else {
                        MerchandiseInventoryHead merchandiseInventoryHead = new MerchandiseInventoryHead();
                        merchandiseInventoryHead.setId(sampleItem.getGoodsId());
                        merchandiseInventoryHead.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
                        merchandiseInventoryHead.setUpdateTime(new Date());
                        merchandiseInventoryHead.setAssignedQuantity(sampleItem.getQuantity());
                        merchandiseInventoryHead.setElsAccount(TenantContext.getTenant());
                        merchandiseInventoryHead.setSupplierNo(sampleItem.getGoodsCode());
                        paramMap.put(sampleItem.getGoodsId(), merchandiseInventoryHead);
                    }
                }
            });
        }
        if (CollectionUtils.isNotEmpty(ids = new ArrayList<MerchandiseInventoryHead>(paramMap.values()))) {
            log.info("sampleItemUpdateGoodsStock :" + ids);
            int i = this.merchandiseInventoryHeadMapper.updateGoodsStock(ids);
            Assert.isTrue((i > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5546\u54c1\u6570\u91cf\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5"));
        }
    }

    @Override
    @Transactional
    public void updatePurchaserTalenSampleStatus(String status, SampleTopMainHead sampleTopMainHead) {
        List<SampleTopMainItem> sampleTopMainItems;
        if ("0".equals(sampleTopMainHead.getSourceBillType()) && CollectionUtils.isNotEmpty(sampleTopMainItems = sampleTopMainHead.getSampleTopMainItems())) {
            ArrayList<PurchaserTalentSampleItem> sampleItemList = new ArrayList<PurchaserTalentSampleItem>(sampleTopMainItems.size());
            sampleTopMainItems.forEach(a -> {
                PurchaserTalentSampleItem purchaserTalentSampleItem = new PurchaserTalentSampleItem();
                BeanUtils.copyProperties((Object)a, (Object)((Object)purchaserTalentSampleItem));
                sampleItemList.add(purchaserTalentSampleItem);
            });
            this.sampleItemService.affirmTakeById(status, sampleItemList);
        }
    }

    @Override
    public void setSubclass(String status, SampleTopMainHead sampleTopMainHead) {
        String id = sampleTopMainHead.getId();
        List<SampleTopMainItem> sampleTopMainItems = sampleTopMainHead.getSampleTopMainItems();
        Assert.isTrue((!CollectionUtils.isEmpty(sampleTopMainItems) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
        if (CollectionUtils.isNotEmpty(sampleTopMainItems)) {
            String sourceBillType = sampleTopMainHead.getSourceBillType();
            sampleTopMainItems.forEach(sampleTopMainItem -> {
                BeanEntityUtils.initSysPram(sourceBillType, sampleTopMainItem);
                sampleTopMainItem.setHeadId(id);
                sampleTopMainItem.setItemStatus("0".equals(status) ? "0" : status);
            });
            this.sampleTopMainItemMapper.deleteMain(id);
            this.sampleTopMainItemMapper.insertBatchSomeColumn(sampleTopMainItems);
        }
    }

    @Override
    @Transactional
    public void delete(String id) {
        this.checkPrivilege(id);
        int i = ((SampleTopMainHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        if (i > 0) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("head_id", id);
            this.sampleTopMainItemMapper.deleteByMap(paramMap);
        }
    }

    @Override
    public SampleTopMainHead queryById(String id) {
        SampleTopMainHead sampleTopMainHead = (SampleTopMainHead)((Object)((SampleTopMainHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (sampleTopMainHead == null) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("head_id", id);
        paramMap.put("els_account", TenantContext.getTenant());
        List sampleTopMainItems = this.sampleTopMainItemMapper.selectByMap(paramMap);
        sampleTopMainHead.setSampleTopMainItems(sampleTopMainItems);
        return sampleTopMainHead;
    }

    @Override
    @Transactional
    public void sampleDelivery(String status, SampleTopMainHead sampleTopMainHead) {
        this.checkUpdate(status, sampleTopMainHead);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().eq(BaseEntity::getId, (Object)sampleTopMainHead.getId())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).set(SampleTopMainHead::getOrderCode, (Object)sampleTopMainHead.getOrderCode())).set(SampleTopMainHead::getSendNum, (Object)sampleTopMainHead.getSendNum())).set(SampleTopMainHead::getSendAddress, (Object)sampleTopMainHead.getSendAddress())).set(SampleTopMainHead::getBillStatus, (Object)status)).set(BaseEntity::getUpdateBy, (Object)SysUtil.getLoginUser().getSubAccount())).set(BaseEntity::getUpdateTime, (Object)new Date());
        ((SampleTopMainHeadMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
        if ("2".equals(status)) {
            this.setSubclass("2", sampleTopMainHead);
            this.updatePurchaserTalenSampleStatus("2", sampleTopMainHead);
        }
        if (StringUtils.isNotBlank((CharSequence)sampleTopMainHead.getFbk1())) {
            this.updateAlliance(sampleTopMainHead);
        }
    }

    @Override
    public SampleTopMainHead changeVo(SampleTopMainHeadVo sampleTopMainHeadVo) {
        SampleTopMainHead sampleTopMainHead = new SampleTopMainHead();
        sampleTopMainHead = sampleTopMainHeadVo.getSampleTopMainHead();
        sampleTopMainHead.setSampleTopMainItems(sampleTopMainHeadVo.getSampleTopMainItems());
        return sampleTopMainHead;
    }

    @Override
    public void submitAudit(SampleTopMainHead sampleTopMainHead) {
        AuditInputParamDTO auditInputParamVO = new AuditInputParamDTO();
        auditInputParamVO.setBusinessId(sampleTopMainHead.getId());
        if (StringUtils.isNotBlank((CharSequence)sampleTopMainHead.getPubishFlowId())) {
            auditInputParamVO.setRootProcessInstanceId(Long.valueOf(Long.parseLong(sampleTopMainHead.getPubishFlowId())));
        }
        auditInputParamVO.setBusinessType("sampleTopMainApprove");
        auditInputParamVO.setAuditSubject("\u63a8\u5e7f\u5408\u4f5c\u6837\u54c1\u7ba1\u7406\u5355\u636e:" + sampleTopMainHead.getBillCode());
        auditInputParamVO.setParams(JSONObject.toJSONString((Object)((Object)sampleTopMainHead)));
        this.workflowAuditRpcService.submit(auditInputParamVO);
        if (StringUtils.isNotBlank((CharSequence)sampleTopMainHead.getFbk1())) {
            this.updateAlliance(sampleTopMainHead);
        }
    }

    @Override
    public LogisticsCompany selectExpress(String expressNumber) {
        JSONObject object;
        LogisticsCompany logisticsCompanyVO = new LogisticsCompany();
        if (!StringUtils.isEmpty((CharSequence)expressNumber)) {
            JSONObject request = new JSONObject();
            request.put("num", (Object)expressNumber);
            object = this.invokeBaseRpcService.callIPaasInterface(request, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("getExpressInfo"));
            if (!"200".equals(object.getString("code"))) {
                throw new ELSBootException(object.getString("message"));
            }
        } else {
            throw new ELSBootException("\u5feb\u9012\u5355\u53f7\u4e3a\u7a7a!");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)object.getString("data"));
        this.jsonResult(logisticsCompanyVO, jsonObject);
        return logisticsCompanyVO;
    }

    private void jsonResult(LogisticsCompany logisticsCompanyVO, JSONObject jsonObject) {
        if ("-3".equals(jsonObject.getString("status"))) {
            logisticsCompanyVO.setMessage(jsonObject.getString("message"));
            return;
        }
        logisticsCompanyVO.setCurrent(jsonObject.getString("current"));
        logisticsCompanyVO.setCurrentStatus(jsonObject.getString("currentStatus"));
        logisticsCompanyVO.setLatestTime(jsonObject.getString("latest_time"));
        logisticsCompanyVO.setLatestProgress(jsonObject.getString("latest_progress"));
        logisticsCompanyVO.setCompanyName(jsonObject.getString("fullname"));
        logisticsCompanyVO.setCompanyNameIcon(jsonObject.getString("title_logo"));
        ArrayList<LogisticsCompanyItem> objects = new ArrayList<LogisticsCompanyItem>();
        JSONArray context = jsonObject.getJSONArray("data");
        context.forEach(item -> this.jsonToitem((JSONObject)item, objects));
        logisticsCompanyVO.setCompanyItemList(objects);
    }

    private void jsonToitem(JSONObject jsonObject, List<LogisticsCompanyItem> objects) {
        LogisticsCompanyItem logisticsCompanyItem = new LogisticsCompanyItem();
        Date time = jsonObject.getDate("time");
        logisticsCompanyItem.setAcceptTime(time);
        logisticsCompanyItem.setAcceptStation(jsonObject.getString("context"));
        objects.add(logisticsCompanyItem);
    }

    @Override
    @Transactional
    public void receiveGoods(String id) {
        SampleTopMainHead byId = this.queryById(id);
        if (byId == null) {
            throw new PurchaseTalentDataCheckException.NotExist("\u5934\u90e8ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (StringUtils.isNotEmpty((CharSequence)byId.getBillStatus()) && !"2".equals(byId.getBillStatus())) {
            throw new PurchaseTalentDataCheckException.InvalidState(id + ":\u53ea\u80fd\u786e\u8ba4\u5df2\u53d1\u8d27\u72b6\u6001\u7684\u5355\u636e");
        }
        if (!TenantContext.getTenant().equals(byId.getElsAccount())) {
            throw new PurchaseTalentDataCheckException.NoPermission("\u60a8\u65e0\u6743\u64cd\u4f5c\u5934\u90e8ID" + id + "\u7684\u6570\u636e\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4f7f\u7528\u6b63\u89c4\u6e20\u9053\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c");
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().eq(BaseEntity::getId, (Object)id)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).set(SampleTopMainHead::getBillStatus, (Object)"3")).set(BaseEntity::getUpdateBy, (Object)SysUtil.getLoginUser().getSubAccount())).set(BaseEntity::getUpdateTime, (Object)new Date());
        ((SampleTopMainHeadMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
        this.updatePurchaserTalenSampleStatus("4", byId);
        this.setSubclass("3", byId);
        if (StringUtils.isNotBlank((CharSequence)byId.getFbk1())) {
            this.updateAlliance(byId);
        }
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SampleTopMainHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    private boolean setApproveParamStatus(SampleTopMainHead sampleTopMainHead) {
        boolean isApprove = false;
        if (StringUtils.isEmpty((CharSequence)sampleTopMainHead.getPubishAudit())) {
            throw new PurchaseTalentDataCheckException.NotExist("\u53d1\u5e03\u5ba1\u6279\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(sampleTopMainHead.getPubishAudit())) {
            sampleTopMainHead.setBillStatus("1");
            sampleTopMainHead.setPubishAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            sampleTopMainHead.setSubmitStatus("1");
        } else {
            sampleTopMainHead.setBillStatus("0");
            sampleTopMainHead.setPubishAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            sampleTopMainHead.setSubmitStatus("0");
            isApprove = true;
        }
        return isApprove;
    }

    private boolean checkPrivilege(String id) {
        SampleTopMainHead byId = (SampleTopMainHead)((Object)super.getById((Serializable)((Object)id)));
        if (byId == null) {
            throw new PurchaseTalentDataCheckException.NotExist("\u5934\u90e8ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (StringUtils.isNotEmpty((CharSequence)byId.getBillStatus()) && !PurchaseTalentStatusEnum.isNew(byId.getBillStatus())) {
            throw new PurchaseTalentDataCheckException.InvalidState("\u5934\u90e8ID" + id + "\u64cd\u4f5c\u7684\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u7f16\u8f91\u5355\u636e\u72b6\u6001\u4e3a\u65b0\u5efa\u7684\u8fbe\u4eba\u5408\u4f5c\u7ba1\u7406\u4fe1\u606f");
        }
        if (StringUtils.isNotEmpty((CharSequence)byId.getPubishAuditStatus()) && PurchaseTalentStatusEnum.doing(byId.getPubishAuditStatus())) {
            throw new PurchaseTalentDataCheckException.InvalidState("\u8be5\u5355\u636e\u5df2\u5728\u5ba1\u6279\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c");
        }
        if (!TenantContext.getTenant().equals(byId.getElsAccount())) {
            throw new PurchaseTalentDataCheckException.NoPermission("\u60a8\u65e0\u6743\u64cd\u4f5c\u5934\u90e8ID" + id + "\u7684\u6570\u636e\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4f7f\u7528\u6b63\u89c4\u6e20\u9053\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c");
        }
        return true;
    }

    private boolean checkUpdate(String status, SampleTopMainHead sampleTopMainHead) {
        String id = sampleTopMainHead.getId();
        SampleTopMainHead byId = (SampleTopMainHead)((Object)super.getById((Serializable)((Object)id)));
        if (byId == null) {
            throw new PurchaseTalentDataCheckException.NotExist("\u5934\u90e8ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (StringUtils.isNotEmpty((CharSequence)byId.getBillStatus()) && !PurchaseTalentStatusEnum.doing(byId.getBillStatus())) {
            throw new PurchaseTalentDataCheckException.InvalidState("\u8be5\u5355\u636e\u72b6\u6001\u4e0d\u652f\u6301\u53d1\u8d27\uff0c\u53ea\u80fd\u5f85\u53d1\u8d27\u72b6\u6001");
        }
        if (!TenantContext.getTenant().equals(byId.getElsAccount())) {
            throw new PurchaseTalentDataCheckException.NoPermission("\u60a8\u65e0\u6743\u64cd\u4f5c\u5934\u90e8ID" + id + "\u7684\u6570\u636e\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4f7f\u7528\u6b63\u89c4\u6e20\u9053\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c");
        }
        if (status.equals("2")) {
            Assert.isTrue((StringUtils.isNotEmpty((CharSequence)sampleTopMainHead.getOrderCode()) || StringUtils.isNotEmpty((CharSequence)sampleTopMainHead.getSendAddress()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5feb\u9012\u5355\u53f7\u6216\u8005\u5bc4\u9001\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        return true;
    }

    private void setDefaultParam(SampleTopMainHead sampleTopMainHead) {
        sampleTopMainHead.setBillCode(this.invokeBaseRpcService.getNextCode("sampleTopMainNumber", (Object)sampleTopMainHead));
        sampleTopMainHead.setBillStatus("0");
        sampleTopMainHead.setSubmitStatus("0");
        String pubishAudit = StringUtils.isEmpty((CharSequence)sampleTopMainHead.getPubishAudit()) ? "0" : sampleTopMainHead.getPubishAudit();
        sampleTopMainHead.setPubishAudit(pubishAudit);
        String s = StringUtils.isEmpty((CharSequence)sampleTopMainHead.getPubishAudit()) || "0".equals(sampleTopMainHead.getPubishAudit()) ? "4" : "0";
        sampleTopMainHead.setPubishAuditStatus(s);
    }

    private void countGoodsQuantity(SampleTopMainHead sampleTopMainHead) {
        List<SampleTopMainItem> sampleTopMainItems = sampleTopMainHead.getSampleTopMainItems();
        sampleTopMainHead.setSendNum(new BigDecimal(0));
        if (CollectionUtils.isNotEmpty(sampleTopMainItems)) {
            sampleTopMainItems.forEach(a -> sampleTopMainHead.setSendNum(sampleTopMainHead.getSendNum().add(a.getQuantity())));
        }
    }
}

