/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.suppliercooperation.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.suppliercooperation.entity.SupplierTalentManageHead;
import com.els.modules.suppliercooperation.entity.SupplierTalentSampleItem;
import com.els.modules.suppliercooperation.entity.SupplierTalentScheduleItem;
import com.els.modules.suppliercooperation.entity.SupplierTalentWorksItem;
import com.els.modules.suppliercooperation.service.SupplierTalentManageHeadService;
import com.els.modules.suppliercooperation.service.SupplierTalentSampleItemService;
import com.els.modules.suppliercooperation.service.SupplierTalentScheduleItemService;
import com.els.modules.suppliercooperation.service.SupplierTalentWorksItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/talentCooperateManage"})
@Api(tags={"\u4f9b\u5e94\u5546\u5408\u4f5c\u7ba1\u7406"})
public class SupplierTalentManageHeadController
extends BaseController<SupplierTalentManageHead, SupplierTalentManageHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SupplierTalentManageHeadController.class);
    @Autowired
    private SupplierTalentManageHeadService manageHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SupplierTalentSampleItemService sampleItemService;
    @Autowired
    private SupplierTalentScheduleItemService scheduleItemService;
    @Autowired
    private SupplierTalentWorksItemService worksItemService;

    @ApiOperation(value="\u4f9b\u5e94\u5546\u5408\u4f5c\u7ba1\u7406\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u4f9b\u5e94\u5546\u5408\u4f5c\u7ba1\u7406\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="cooperativeExtension")
    public Result<?> queryPageList(SupplierTalentManageHead supplierTalentManageHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        Page<SupplierTalentManageHead> pageList = this.manageHeadService.queryPageList(supplierTalentManageHead, (Page<SupplierTalentManageHead>)page, req);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5408\u4f5c\u7ba1\u7406\u901a\u8fc7id\u67e5\u8be2", notes="\u8fbe\u4eba\u5408\u4f5c\u7ba1\u7406\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SupplierTalentManageHead byId = this.manageHeadService.queryById(id);
        return Result.ok((Object)((Object)byId));
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u5408\u4f5c\u4e4b\u6837\u54c1\u884c\u4fe1\u606f\u7ba1\u7406", value="\u6837\u54c1\u884c\u786e\u8ba4")
    @ApiOperation(value="\u6837\u54c1\u884c\u786e\u8ba4", notes="\u6837\u54c1\u884c\u786e\u8ba4")
    @PostMapping(value={"/affirmTake"})
    public Result<?> affirmTakeById(@RequestBody List<SupplierTalentSampleItem> supplierTalentSampleItems) {
        this.sampleItemService.affirmTakeById(true, "3", supplierTalentSampleItems);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u8fbe\u4eba\u5408\u4f5c\u4e4b\u6863\u671f\u884c\u4fe1\u606f\u7ba1\u7406", value="\u6536\u8d27\u786e\u8ba4")
    @ApiOperation(value="\u6536\u8d27\u786e\u8ba4", notes="\u6536\u8d27\u786e\u8ba4")
    @RequestMapping(value={"/affirm"}, method={RequestMethod.POST})
    public Result<?> affirmById(@RequestBody List<SupplierTalentScheduleItem> supplierTalentScheduleItems) {
        this.scheduleItemService.affirmTakeAndRefuseById(true, "2", supplierTalentScheduleItems);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u8fbe\u4eba\u5408\u4f5c\u4e4b\u6863\u671f\u884c\u4fe1\u606f\u7ba1\u7406", value="\u62d2\u7edd")
    @ApiOperation(value="\u62d2\u7edd", notes="\u62d2\u7edd")
    @RequestMapping(value={"/refuse"}, method={RequestMethod.POST})
    public Result<?> refuseById(@RequestBody List<SupplierTalentScheduleItem> supplierTalentScheduleItems) {
        this.scheduleItemService.affirmTakeAndRefuseById(true, "3", supplierTalentScheduleItems);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u8fbe\u4eba\u5408\u4f5c\u4e4b\u4f5c\u54c1\u884c\u4fe1\u606f\u7ba1\u7406", value="\u4f5c\u54c1\u53d1\u5e03")
    @ApiOperation(value="\u4f5c\u54c1\u53d1\u5e03", notes="\u4f5c\u54c1\u53d1\u5e03")
    @RequestMapping(value={"/works/release"}, method={RequestMethod.POST})
    public Result<?> worksItemRelease(@RequestBody List<SupplierTalentWorksItem> supplierTalentWorksItems) {
        this.worksItemService.worksItemRelease(true, "1", supplierTalentWorksItems);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u8fbe\u4eba\u5408\u4f5c\u4e4b\u4f5c\u54c1\u884c\u4fe1\u606f\u7ba1\u7406", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody List<SupplierTalentWorksItem> supplierTalentWorksItems) {
        this.worksItemService.insertBatch(true, supplierTalentWorksItems);
        return this.commonSuccessResult(2);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(SupplierTalentManageHead supplierTalentManageHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierTalentManageHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"cooperate_bill_status", "count(0) as quantity"});
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"cooperate_bill_status");
        List list = ((SupplierTalentManageHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SupplierTalentManageHead::getCooperateBillStatus, SupplierTalentManageHead::getQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "cooperateBillStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("cooperateBillStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            if (!"1".equals(status.getValue()) && !"2".equals(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "cooperateBillStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

