/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.amateur.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.amateur.entity.PurchaseAmateurHead;
import com.els.modules.amateur.entity.PurchaseAmateurItem;
import com.els.modules.amateur.entity.PurchaseAmateurRelation;
import com.els.modules.amateur.enumerate.AmateurStatusEnum;
import com.els.modules.amateur.enumerate.AmateurStatusItemEnum;
import com.els.modules.amateur.mapper.PurchaseAmateurHeadMapper;
import com.els.modules.amateur.mapper.PurchaseAmateurItemMapper;
import com.els.modules.amateur.mapper.PurchaseAmateurRelationMapper;
import com.els.modules.amateur.rpc.service.InvokeIndustryInfoService;
import com.els.modules.amateur.service.PurchaseAmateurHeadService;
import com.els.modules.amateur.service.PurchaseAmateurItemService;
import com.els.modules.enterpriseresource.entity.TopManAddElsRecordEntity;
import com.els.modules.enterpriseresource.entity.TopManEnterpriseInfoHeadEntity;
import com.els.modules.enterpriseresource.mapper.TopManAddElsRecordMapper;
import com.els.modules.enterpriseresource.service.TopManAddElsRecordService;
import com.els.modules.enterpriseresource.service.TopManEnterpriseInfoHeadService;
import com.els.modules.industryInfo.api.dto.TopManInformationHeadDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseAmateurHeadServiceImpl
extends BaseServiceImpl<PurchaseAmateurHeadMapper, PurchaseAmateurHead>
implements PurchaseAmateurHeadService {
    @Lazy
    @Autowired
    private PurchaseAmateurItemService purchaseAmateurItemService;
    @Lazy
    @Autowired
    private PurchaseAmateurItemMapper purchaseAmateurItemMapper;
    @Lazy
    @Autowired
    private PurchaseAmateurHeadMapper purchaseAmateurHeadMapper;
    @Autowired
    private PurchaseAmateurRelationMapper purchaseAmateurRelationMapper;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private TopManAddElsRecordService topManAddElsRecordServie;
    @Autowired
    private TopManAddElsRecordMapper topManAddElsRecordMapper;
    @Autowired
    private TopManEnterpriseInfoHeadService topManEnterpriseInfoHeadService;
    @Autowired
    private InvokeIndustryInfoService invokeIndustryInfoService;
    private static final int BATCH_INSERT_SIZE = 20;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseAmateurHead purchaseAmateurHead, List<PurchaseAmateurItem> purchaseAmateurItemList) {
        purchaseAmateurHead.setDocumentNumber(this.baseRpcService.getNextCode("srmAmateurAccountManage", (Object)purchaseAmateurHead));
        ((PurchaseAmateurHeadMapper)this.baseMapper).insert((Object)purchaseAmateurHead);
        super.setHeadDefaultValue((BaseEntity)purchaseAmateurHead);
        this.insertData(purchaseAmateurHead, purchaseAmateurItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseAmateurHead purchaseAmateurHead, List<PurchaseAmateurItem> purchaseAmateurItemList) {
        int count = ((PurchaseAmateurHeadMapper)this.baseMapper).updateById((Object)purchaseAmateurHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        List<PurchaseAmateurItem> purchaseAmateurItems = this.purchaseAmateurItemMapper.selectByMainId(purchaseAmateurHead.getId());
        HashMap<String, PurchaseAmateurItem> oldMaps = new HashMap<String, PurchaseAmateurItem>();
        ArrayList<PurchaseAmateurItem> difPurchaseAmateurItemList = new ArrayList<PurchaseAmateurItem>();
        if (CollectionUtil.isNotEmpty(purchaseAmateurItems)) {
            for (PurchaseAmateurItem purchaseAmateurItem : purchaseAmateurItemList) {
                oldMaps.put(purchaseAmateurItem.getName(), purchaseAmateurItem);
            }
            for (PurchaseAmateurItem purchaseAmateurItem : purchaseAmateurItems) {
                if (oldMaps.containsKey(purchaseAmateurItem.getName())) continue;
                difPurchaseAmateurItemList.add(purchaseAmateurItem);
            }
        }
        if (CollectionUtil.isNotEmpty(difPurchaseAmateurItemList)) {
            List topManIds = difPurchaseAmateurItemList.stream().distinct().map(PurchaseAmateurItem::getTopManId).collect(Collectors.toList());
            LambdaQueryWrapper topManAddElsRecordEntityLambdaQueryWrapper = new LambdaQueryWrapper();
            topManAddElsRecordEntityLambdaQueryWrapper.in(TopManAddElsRecordEntity::getTopmanId, topManIds);
            List topManAddElsRecordEntitiyList = this.topManAddElsRecordMapper.selectList((Wrapper)topManAddElsRecordEntityLambdaQueryWrapper);
            ArrayList<TopManAddElsRecordEntity> paramsManAddElsRecordList = new ArrayList<TopManAddElsRecordEntity>();
            for (TopManAddElsRecordEntity topManAddElsRecordEntity : topManAddElsRecordEntitiyList) {
                TopManAddElsRecordEntity topManAddElsRecord = new TopManAddElsRecordEntity();
                topManAddElsRecord.setId(topManAddElsRecordEntity.getId());
                topManAddElsRecord.setAmateurElsAccount("");
                paramsManAddElsRecordList.add(topManAddElsRecord);
            }
            this.topManAddElsRecordServie.updateBatchById(paramsManAddElsRecordList);
            LambdaQueryWrapper entityLambdaQueryWrapper = new LambdaQueryWrapper();
            entityLambdaQueryWrapper.in(TopManEnterpriseInfoHeadEntity::getTopmanId, topManIds);
            List selectList = this.topManEnterpriseInfoHeadService.list((Wrapper)entityLambdaQueryWrapper);
            ArrayList<TopManEnterpriseInfoHeadEntity> updateList = new ArrayList<TopManEnterpriseInfoHeadEntity>(selectList.size());
            for (TopManEnterpriseInfoHeadEntity selectEntity : selectList) {
                TopManEnterpriseInfoHeadEntity updateEntity = new TopManEnterpriseInfoHeadEntity();
                updateEntity.setId(selectEntity.getId());
                updateEntity.setAmateurElsAccount("");
                updateList.add(updateEntity);
            }
            this.topManEnterpriseInfoHeadService.updateBatchById(updateList);
        }
        this.purchaseAmateurItemService.deleteByMainId(purchaseAmateurHead.getId());
        this.insertData(purchaseAmateurHead, purchaseAmateurItemList);
    }

    private void insertData(PurchaseAmateurHead purchaseAmateurHead, List<PurchaseAmateurItem> purchaseAmateurItemList) {
        if (!CollectionUtils.isEmpty(purchaseAmateurItemList)) {
            for (PurchaseAmateurItem entity : purchaseAmateurItemList) {
                entity.setHeadId(purchaseAmateurHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseAmateurHead);
            }
            this.purchaseAmateurItemService.saveBatch(purchaseAmateurItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseAmateurItemService.deleteByMainId(id);
        ((PurchaseAmateurHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseAmateurItemService.deleteByMainId(serializable.toString());
            ((PurchaseAmateurHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public List<PurchaseAmateurHead> getAmateurAccount() {
        LoginUser loginUser = SysUtil.getLoginUser();
        Integer count = this.purchaseAmateurHeadMapper.selectPurchaseAmateurHeadCount(loginUser.getElsAccount());
        int batchSize = 0;
        batchSize = count % 20 == 0 ? count / 20 : count / 20 + 1;
        ArrayList<PurchaseAmateurHead> subAccountAmateurHeadList = new ArrayList<PurchaseAmateurHead>();
        ArrayList<PurchaseAmateurRelation> subAmateurRelationList = new ArrayList<PurchaseAmateurRelation>();
        for (int i = 0; i < batchSize; ++i) {
            List<PurchaseAmateurHead> purchaseAmateurHeadList = this.purchaseAmateurHeadMapper.selectPurchaseAmateurHead(loginUser.getElsAccount(), i * 20, 20);
            for (PurchaseAmateurHead purchaseAmateurHead : purchaseAmateurHeadList) {
                PurchaseAmateurHead subPurchaseAmateurHead = new PurchaseAmateurHead();
                BeanUtils.copyProperties((Object)((Object)purchaseAmateurHead), (Object)((Object)subPurchaseAmateurHead));
                subPurchaseAmateurHead.setId(IdWorker.getIdStr());
                subPurchaseAmateurHead.setElsAccount(loginUser.getElsAccount());
                subAccountAmateurHeadList.add(subPurchaseAmateurHead);
                PurchaseAmateurRelation amateurRelation = new PurchaseAmateurRelation();
                amateurRelation.setElsAccount(loginUser.getElsAccount());
                amateurRelation.setAmateurHeadId(purchaseAmateurHead.getId());
                amateurRelation.setSysnElsAccount(loginUser.getElsAccount());
                amateurRelation.setCreateBy(loginUser.getSubAccount());
                amateurRelation.setCreateTime(new Date());
                amateurRelation.setUpdateBy(loginUser.getSubAccount());
                amateurRelation.setUpdateTime(new Date());
                amateurRelation.setDeleted(Integer.parseInt("0"));
                subAmateurRelationList.add(amateurRelation);
            }
        }
        if (CollectionUtil.isNotEmpty(subAccountAmateurHeadList)) {
            this.purchaseAmateurHeadMapper.insertBatchSomeColumn(subAccountAmateurHeadList);
        }
        if (CollectionUtil.isNotEmpty(subAmateurRelationList)) {
            this.purchaseAmateurRelationMapper.insertBatchSomeColumn(subAmateurRelationList);
        }
        return subAccountAmateurHeadList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void freezenOrUnFreezenById(String id) {
        PurchaseAmateurHead dbPurchaseAmateurHead = (PurchaseAmateurHead)((Object)this.getById((Serializable)((Object)id)));
        if (dbPurchaseAmateurHead == null) {
            throw new ELSBootException("\u7cfb\u7edf\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u5355\u636e\uff0c\u6682\u65f6\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        PurchaseAmateurHead purchaseAmateurHead = new PurchaseAmateurHead();
        purchaseAmateurHead.setId(id);
        if (AmateurStatusEnum.FREEZEN.getValue().equals(dbPurchaseAmateurHead.getDocumentStatus())) {
            purchaseAmateurHead.setDocumentStatus(AmateurStatusEnum.EFFECT.getValue());
        } else if (AmateurStatusEnum.EFFECT.getValue().equals(dbPurchaseAmateurHead.getDocumentStatus())) {
            purchaseAmateurHead.setDocumentStatus(AmateurStatusEnum.FREEZEN.getValue());
        }
        this.updateById((Object)purchaseAmateurHead);
    }

    @Override
    public void submit(PurchaseAmateurHead purchaseAmateurHead, List<PurchaseAmateurItem> purchaseAmateurItemList) {
        if (CollUtil.isNotEmpty(purchaseAmateurItemList)) {
            ArrayList<PurchaseAmateurItem> purchaseAmateurItems = new ArrayList<PurchaseAmateurItem>();
            for (PurchaseAmateurItem purchaseAmateurItem : purchaseAmateurItemList) {
                if (AmateurStatusItemEnum.NEW.getValue().equals(purchaseAmateurItem.getItemStatus())) {
                    PurchaseAmateurItem amateurItem = new PurchaseAmateurItem();
                    amateurItem.setId(purchaseAmateurItem.getId());
                    amateurItem.setItemStatus(AmateurStatusItemEnum.EFFECT.getValue());
                    purchaseAmateurItems.add(amateurItem);
                }
                if (AmateurStatusItemEnum.FREEZEN.getValue().equals(purchaseAmateurItem.getItemStatus())) {
                    UpdateWrapper updateWrapper = new UpdateWrapper();
                    updateWrapper.set((Object)"amateur_els_account", null);
                    updateWrapper.eq((Object)"topman_id", (Object)purchaseAmateurItem.getTopManId());
                    updateWrapper.eq((Object)"amateur_els_account", (Object)purchaseAmateurHead.getToElsAccount());
                    this.topManAddElsRecordServie.update((Wrapper)updateWrapper);
                }
                this.purchaseAmateurItemService.updateBatchById(purchaseAmateurItems);
            }
            PurchaseAmateurHead paramsPurchaseAmateurHead = new PurchaseAmateurHead();
            paramsPurchaseAmateurHead.setId(purchaseAmateurHead.getId());
            paramsPurchaseAmateurHead.setDocumentStatus(AmateurStatusEnum.EFFECT.getValue());
            this.updateById((Object)paramsPurchaseAmateurHead);
            List topManIds = purchaseAmateurItemList.stream().filter(x -> !x.getItemStatus().equals(AmateurStatusItemEnum.FREEZEN.getValue())).distinct().map(PurchaseAmateurItem::getTopManId).collect(Collectors.toList());
            if (CollUtil.isEmpty(topManIds)) {
                return;
            }
            LambdaQueryWrapper topManAddElsRecordEntityLambdaQueryWrapper = new LambdaQueryWrapper();
            topManAddElsRecordEntityLambdaQueryWrapper.in(TopManAddElsRecordEntity::getTopmanId, topManIds);
            List topManAddElsRecordEntitiyList = this.topManAddElsRecordMapper.selectList((Wrapper)topManAddElsRecordEntityLambdaQueryWrapper);
            ArrayList<TopManAddElsRecordEntity> paramsManAddElsRecordList = new ArrayList<TopManAddElsRecordEntity>();
            for (TopManAddElsRecordEntity topManAddElsRecordEntity : topManAddElsRecordEntitiyList) {
                TopManAddElsRecordEntity topManAddElsRecord = new TopManAddElsRecordEntity();
                topManAddElsRecord.setId(topManAddElsRecordEntity.getId());
                topManAddElsRecord.setAmateurElsAccount(purchaseAmateurHead.getToElsAccount());
                paramsManAddElsRecordList.add(topManAddElsRecord);
            }
            this.topManAddElsRecordServie.updateBatchById(paramsManAddElsRecordList);
            LambdaQueryWrapper entityLambdaQueryWrapper = new LambdaQueryWrapper();
            entityLambdaQueryWrapper.in(TopManEnterpriseInfoHeadEntity::getTopmanId, topManIds);
            List selectList = this.topManEnterpriseInfoHeadService.list((Wrapper)entityLambdaQueryWrapper);
            ArrayList<TopManEnterpriseInfoHeadEntity> updateList = new ArrayList<TopManEnterpriseInfoHeadEntity>(selectList.size());
            for (TopManEnterpriseInfoHeadEntity selectEntity : selectList) {
                TopManEnterpriseInfoHeadEntity updateEntity = new TopManEnterpriseInfoHeadEntity();
                updateEntity.setId(selectEntity.getId());
                updateEntity.setAmateurElsAccount(purchaseAmateurHead.getToElsAccount());
                updateList.add(updateEntity);
            }
            this.topManEnterpriseInfoHeadService.updateBatchById(updateList);
        } else {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.set((Object)"amateur_els_account", null);
            updateWrapper.eq((Object)"amateur_els_account", (Object)purchaseAmateurHead.getToElsAccount());
            this.topManAddElsRecordServie.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public void bindTopMan(PurchaseAmateurItem purchaseAmateurItem) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<TopManInformationHeadDTO> topManInformationHeadList = this.invokeIndustryInfoService.selectTopManInformationHeadListByName(purchaseAmateurItem.getName(), purchaseAmateurItem.getBusinessPlatform());
        if (CollectionUtil.isEmpty(topManInformationHeadList)) {
            throw new ELSBootException("\u4f01\u4e1a\u5e93\u65e0\u6b64\u8fbe\u4eba\u4fe1\u606f");
        }
        TopManInformationHeadDTO topManInformation = topManInformationHeadList.get(0);
        PurchaseAmateurHead purchaseAmateurHead = this.purchaseAmateurHeadMapper.selectAmateurElsAccountByTopManId(topManInformation.getTopmanId());
        if (purchaseAmateurHead != null) {
            throw new ELSBootException(purchaseAmateurItem.getName() + "\u8fbe\u4eba\u5df2\u88ab\u8fbe\u4eba\u8d26\u53f7\u7ed1\u5b9a!");
        }
        PurchaseAmateurItem paramsPurchaseAmateurItem = new PurchaseAmateurItem();
        paramsPurchaseAmateurItem.setItemStatus(AmateurStatusItemEnum.NEW.getValue());
        paramsPurchaseAmateurItem.setAvatar(topManInformation.getTopmanAvatar());
        paramsPurchaseAmateurItem.setBusinessPlatform(topManInformation.getPlatform());
        paramsPurchaseAmateurItem.setTopManId(topManInformation.getTopmanId());
        paramsPurchaseAmateurItem.setName(topManInformation.getTopmanName());
        paramsPurchaseAmateurItem.setSex(topManInformation.getTopmanSex());
        paramsPurchaseAmateurItem.setArea(Optional.ofNullable(topManInformation.getRegion()).orElse(""));
        paramsPurchaseAmateurItem.setHeadId(purchaseAmateurItem.getHeadId());
        paramsPurchaseAmateurItem.setElsAccount("100000");
        paramsPurchaseAmateurItem.setCreateBy(loginUser.getSubAccount());
        paramsPurchaseAmateurItem.setCreateTime(new Date());
        paramsPurchaseAmateurItem.setUpdateBy(loginUser.getSubAccount());
        paramsPurchaseAmateurItem.setUpdateTime(new Date());
        this.purchaseAmateurItemMapper.insert((Object)paramsPurchaseAmateurItem);
    }

    @Override
    public IPage<PurchaseAmateurHead> pageLeftEnterpriseInfo(Page<PurchaseAmateurHead> page, QueryWrapper<PurchaseAmateurHead> queryWrapper) {
        return this.purchaseAmateurHeadMapper.selectLeftEnterpriseInfo(page, queryWrapper);
    }
}

