/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.modules.companystore.config.KuaiShouProperties;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.kuaishou.merchant.open.api.KsMerchantApiException;
import com.kuaishou.merchant.open.api.common.utils.PlatformEventSecurityUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/companyStoreAuthorize"})
@Api(tags={"\u4f01\u4e1a\u5e97\u94fa\u5bf9\u63a5\u63a5\u53e3"})
public class CompanyStoreAuthorizeController {
    private static final Logger log = LoggerFactory.getLogger(CompanyStoreAuthorizeController.class);
    @Autowired
    private KuaiShouProperties kuaiShouProperties;
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;
    @Value(value="${els.config.service.address}")
    private String serverPath;

    @ApiOperation(value="\u6388\u6743\u5f00\u59cb\u767b\u8bb0\u5e76\u8f6c\u53d1\u5230\u6296\u5e97\u6388\u6743\u754c\u9762", notes="\u6388\u6743\u5f00\u59cb\u767b\u8bb0\u5e76\u8f6c\u53d1\u5230\u6296\u5e97\u6388\u6743\u754c\u9762")
    @GetMapping(value={"/authorize/start"})
    @ResponseBody
    public Result<?> authorize(@RequestParam(name="shopId") String shopId, HttpServletResponse response) throws IOException {
        boolean b = this.companyStoreHeadService.startAuthorize(shopId);
        if (b) {
            response.sendRedirect("https://www.baidu.com");
        }
        return Result.ok();
    }

    @ApiOperation(value="\u6388\u6743\u56de\u8c03\u5730\u5740", notes="\u6388\u6743\u56de\u8c03\u5730\u5740")
    @GetMapping(value={"/noToken/authorize/callBack"})
    @ResponseBody
    public Result<?> callBack(@RequestParam(name="code") String code, HttpServletResponse response) throws IOException {
        log.info("\u63a5\u6536\u5230\u6296\u5e97\u6388\u6743code:{}", (Object)code);
        try {
            this.companyStoreHeadService.callBack(code);
        }
        catch (IOException e) {
            log.error("\u6296\u97f3\u6388\u6743\u5f02\u5e38", (Throwable)e);
        }
        response.sendRedirect(this.serverPath + "/mcn/brandPromotionSynergy/enterpriseStore/StoreManagement/indexList");
        return Result.ok();
    }

    @ApiOperation(value="\u6388\u6743\u56de\u8c03\u5730\u5740", notes="\u6388\u6743\u56de\u8c03\u5730\u5740")
    @GetMapping(value={"/noToken/ks/authorize/callBack"})
    @ResponseBody
    public Result<?> ksCallBack(@RequestParam(name="code") String code, HttpServletResponse response) throws IOException {
        log.info("\u63a5\u6536\u5230\u5feb\u624b\u6388\u6743\u56de\u8c03:{}", (Object)code);
        this.companyStoreHeadService.ksCallBack(code);
        response.sendRedirect(this.serverPath + "/mcn/brandPromotionSynergy/enterpriseStore/StoreManagement/indexList");
        return Result.ok();
    }

    @RequestMapping(value={"/noToken/ks/msg"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> acceptEvent(@RequestBody String eventsEncoded) throws KsMerchantApiException {
        String events = PlatformEventSecurityUtil.decode((String)eventsEncoded, (String)this.kuaiShouProperties.getMsgSecret());
        log.info("\u63a5\u6536\u5230\u5feb\u624b\u6d88\u606f:{}", (Object)events);
        JSONObject jsonObject = JSON.parseObject((String)events);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", 1);
        if (ObjectUtil.isNotEmpty((Object)jsonObject) && StrUtil.isNotBlank((CharSequence)jsonObject.getString("test")) && jsonObject.getBoolean("test").booleanValue()) {
            return result;
        }
        this.companyStoreHeadService.acceptKsEvent(events);
        return result;
    }
}

