/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.doudian.open.api.buyin_queryShopAllianceOrder.BuyinQueryShopAllianceOrderRequest;
import com.doudian.open.api.buyin_queryShopAllianceOrder.BuyinQueryShopAllianceOrderResponse;
import com.doudian.open.api.buyin_queryShopAllianceOrder.data.ColonelOrderInfo;
import com.doudian.open.api.buyin_queryShopAllianceOrder.data.Data;
import com.doudian.open.api.buyin_queryShopAllianceOrder.data.OrdersItem;
import com.doudian.open.api.buyin_queryShopAllianceOrder.param.BuyinQueryShopAllianceOrderParam;
import com.doudian.open.api.buyin_queryShopAllianceProducts.BuyinQueryShopAllianceProductsRequest;
import com.doudian.open.api.buyin_queryShopAllianceProducts.BuyinQueryShopAllianceProductsResponse;
import com.doudian.open.api.buyin_queryShopAllianceProducts.param.BuyinQueryShopAllianceProductsParam;
import com.doudian.open.api.order_searchList.OrderSearchListRequest;
import com.doudian.open.api.order_searchList.OrderSearchListResponse;
import com.doudian.open.api.order_searchList.data.OrderSearchListData;
import com.doudian.open.api.order_searchList.data.ShopOrderListItem;
import com.doudian.open.api.order_searchList.data.SkuOrderListItem;
import com.doudian.open.api.order_searchList.param.OrderSearchListParam;
import com.doudian.open.core.AccessToken;
import com.doudian.open.core.DoudianOpConfig;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.PlatformEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.companystore.config.KuaiShouProperties;
import com.els.modules.companystore.dto.InitDouDianPullDTO;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.entity.CompanyStoreOrderHead;
import com.els.modules.companystore.entity.DyOrder;
import com.els.modules.companystore.entity.DyOrderItem;
import com.els.modules.companystore.entity.KsItemPlan;
import com.els.modules.companystore.entity.KsItems;
import com.els.modules.companystore.entity.KsItemsCategory;
import com.els.modules.companystore.entity.KsOrderBaseInfo;
import com.els.modules.companystore.entity.KsOrderBill;
import com.els.modules.companystore.entity.KsOrderItemInfo;
import com.els.modules.companystore.entity.KsOrderRefund;
import com.els.modules.companystore.enumerate.AuthStateEnum;
import com.els.modules.companystore.enumerate.CompanyStoreAuthStatusEnum;
import com.els.modules.companystore.mapper.CompanyStoreOrderHeadMapper;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.companystore.service.CompanyStoreOrderHeadService;
import com.els.modules.companystore.service.DyOrderItemService;
import com.els.modules.companystore.service.DyOrderService;
import com.els.modules.companystore.service.KsItemPlanService;
import com.els.modules.companystore.service.KsItemsCategoryService;
import com.els.modules.companystore.service.KsItemsService;
import com.els.modules.companystore.service.KsOrderBaseInfoService;
import com.els.modules.companystore.service.KsOrderBillService;
import com.els.modules.companystore.service.KsOrderItemInfoService;
import com.els.modules.companystore.service.KsOrderRefundService;
import com.els.modules.companystore.utils.DouDianApiUtil;
import com.els.modules.companystore.vo.KsOrderDetailVO;
import com.google.common.collect.Maps;
import com.kuaishou.merchant.open.api.KsMerchantApiException;
import com.kuaishou.merchant.open.api.KsMerchantRequest;
import com.kuaishou.merchant.open.api.client.AccessTokenKsMerchantClient;
import com.kuaishou.merchant.open.api.domain.distribution.DistributePlanView;
import com.kuaishou.merchant.open.api.domain.funds.OrderBillDetail;
import com.kuaishou.merchant.open.api.domain.item.GetCategoryResponseParam;
import com.kuaishou.merchant.open.api.domain.item.GetItemListResponseParam;
import com.kuaishou.merchant.open.api.domain.order.OrderBaseInfo;
import com.kuaishou.merchant.open.api.domain.order.OrderItemInfo;
import com.kuaishou.merchant.open.api.domain.order.OrderList;
import com.kuaishou.merchant.open.api.domain.order.OrderListData;
import com.kuaishou.merchant.open.api.request.distribution.OpenDistributionPlanQueryRequest;
import com.kuaishou.merchant.open.api.request.funds.OpenFundsFinancialBillDetailRequest;
import com.kuaishou.merchant.open.api.request.item.OpenItemCategoryRequest;
import com.kuaishou.merchant.open.api.request.item.OpenItemListGetRequest;
import com.kuaishou.merchant.open.api.request.order.OpenOrderCursorListRequest;
import com.kuaishou.merchant.open.api.response.distribution.OpenDistributionPlanQueryResponse;
import com.kuaishou.merchant.open.api.response.funds.OpenFundsFinancialBillDetailResponse;
import com.kuaishou.merchant.open.api.response.item.OpenItemCategoryResponse;
import com.kuaishou.merchant.open.api.response.item.OpenItemListGetResponse;
import com.kuaishou.merchant.open.api.response.order.OpenOrderCursorListResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CompanyStoreOrderHeadServiceImpl
extends BaseServiceImpl<CompanyStoreOrderHeadMapper, CompanyStoreOrderHead>
implements CompanyStoreOrderHeadService {
    private static final Logger log = LoggerFactory.getLogger(CompanyStoreOrderHeadServiceImpl.class);
    @Autowired
    private KuaiShouProperties kuaiShouProperties;
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private KsOrderBaseInfoService ksOrderBaseInfoService;
    @Autowired
    private KsOrderItemInfoService ksOrderItemInfoService;
    @Autowired
    private KsOrderRefundService ksOrderRefundService;
    @Autowired
    private KsOrderBillService ksOrderBillService;
    @Autowired
    private KsItemsService ksItemsService;
    @Autowired
    private KsItemsCategoryService ksItemsCategoryService;
    @Autowired
    private KsItemPlanService ksItemPlanService;
    @Autowired
    private DouDianApiUtil douDianApiUtil;
    @Autowired
    private DyOrderService dyOrderService;
    @Autowired
    private DyOrderItemService dyOrderItemService;

    @Override
    public void add(CompanyStoreOrderHead companyStoreOrderHead) {
        ((CompanyStoreOrderHeadMapper)this.baseMapper).insert((Object)companyStoreOrderHead);
    }

    @Override
    public void edit(CompanyStoreOrderHead companyStoreOrderHead) {
        int count = ((CompanyStoreOrderHeadMapper)this.baseMapper).updateById((Object)companyStoreOrderHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((CompanyStoreOrderHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((CompanyStoreOrderHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void initPull() {
        ArrayList pullDTOS = Lists.newArrayList();
        String appId = "7109351973857560100";
        String accessTokenStr = "b532c94f-84d8-49f3-9b01-b36b532573d4";
        String refreshTokenStr = "e3ae870c-835d-4fff-a098-806300a8d00c";
        AccessToken accessToken = AccessToken.wrap(accessTokenStr, refreshTokenStr);
        InitDouDianPullDTO dto = new InitDouDianPullDTO();
        dto.setAccessToken(accessToken);
        dto.setElsAccount("307000");
        pullDTOS.add(dto);
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTime(date);
        calendar.add(5, -90);
        Date threeDate = calendar.getTime();
        long endTime = new Date().getTime() / 1000L;
        long startTime = threeDate.getTime() / 1000L;
        List db = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{CompanyStoreOrderHead::getOrderId}).eq(BaseEntity::getElsAccount, (Object)"307000")).eq(BaseEntity::getDeleted, (Object)"0"));
        Map<String, String> dbOrderIds = db.stream().collect(Collectors.toMap(x -> x.getOrderId(), y -> y.getOrderId()));
        long page = 0L;
        Iterator iterator = pullDTOS.iterator();
        if (iterator.hasNext()) {
            InitDouDianPullDTO init = (InitDouDianPullDTO)iterator.next();
            while (true) {
                OrderSearchListRequest request = new OrderSearchListRequest();
                OrderSearchListParam param = (OrderSearchListParam)request.getParam();
                param.setCreateTimeStart(startTime);
                param.setCreateTimeEnd(endTime);
                param.setSize(100L);
                param.setPage(page++);
                param.setOrderBy("create_time");
                param.setOrderAsc(false);
                OrderSearchListResponse response = (OrderSearchListResponse)request.execute(accessToken);
                if (!response.isSuccess()) continue;
                if (CollUtil.isEmpty(((OrderSearchListData)response.getData()).getShopOrderList())) {
                    return;
                }
                this.handleDb((OrderSearchListData)response.getData(), init.getElsAccount(), dbOrderIds);
            }
        }
    }

    @Override
    public CompanyStoreOrderHead getByOrderIdAndShopId(String orderId, String shopId) {
        return (CompanyStoreOrderHead)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreOrderHead::getOrderId, (Object)orderId)).eq(BaseEntity::getDeleted, (Object)"0")).eq(CompanyStoreOrderHead::getShopId, (Object)shopId)));
    }

    private void handleDb(OrderSearchListData orderSearchListData, String elsAccount, Map<String, String> dbOrderIds) {
        List<ShopOrderListItem> shopOrderListItems = orderSearchListData.getShopOrderList();
        ArrayList adds = Lists.newArrayList();
        ArrayList updates = Lists.newArrayList();
        for (ShopOrderListItem item : shopOrderListItems) {
            CompanyStoreOrderHead companyStoreOrderHead = new CompanyStoreOrderHead();
            companyStoreOrderHead.setPlatform(item.getBTypeDesc());
            companyStoreOrderHead.setShopId(item.getShopId().toString());
            companyStoreOrderHead.setShopId(item.getShopId().toString());
            companyStoreOrderHead.setOrderId(item.getOrderId());
            companyStoreOrderHead.setOrderStatus(item.getOrderStatus().toString());
            companyStoreOrderHead.setOrderStatusDesc(item.getOrderStatusDesc());
            companyStoreOrderHead.setPayTime(new Date(item.getPayTime() * 1000L));
            companyStoreOrderHead.setOrderTime(new Date(item.getCreateTime() * 1000L));
            long time = item.getOrderExpireTime() * 1000L;
            Date expireDate = new Date(companyStoreOrderHead.getOrderTime().getTime() + time);
            companyStoreOrderHead.setExpireTime(expireDate);
            companyStoreOrderHead.setOrderOpdateTime(new Date(item.getUpdateTime() * 1000L));
            companyStoreOrderHead.setCancelReasons(item.getCancelReason());
            companyStoreOrderHead.setOrderAmount(BigDecimal.valueOf(item.getOrderAmount()));
            companyStoreOrderHead.setPayAmount(BigDecimal.valueOf(item.getPayAmount()));
            companyStoreOrderHead.setOrderSource(item.getBTypeDesc());
            companyStoreOrderHead.setRemark(item.getSellerWords());
            companyStoreOrderHead.setSync("0");
            companyStoreOrderHead.setElsAccount(elsAccount);
            companyStoreOrderHead.setCreateTime(new Date());
            if (dbOrderIds.containsKey(item.getOrderId())) {
                companyStoreOrderHead.setId(dbOrderIds.get(item.getOrderId()));
                updates.add(companyStoreOrderHead);
                continue;
            }
            adds.add(companyStoreOrderHead);
        }
        if (CollUtil.isNotEmpty((Collection)adds)) {
            this.saveBatch(adds);
        }
        if (CollUtil.isNotEmpty((Collection)updates)) {
            this.updateBatchById(updates);
        }
    }

    private Map<String, CompanyStoreHead> getKsInitData() {
        List list = this.companyStoreHeadService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreHead::getPlatform, (Object)PlatformEnum.KUAI_SHOU.value)).eq(CompanyStoreHead::getAuthState, (Object)AuthStateEnum.AUTHORIZED.getValue())).eq(BaseEntity::getDeleted, (Object)"0")).lt(CompanyStoreHead::getAuthTime, (Object)new Date()));
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)list), (String)"\u672a\u6709\u6388\u6743\u5e97\u94fa");
        Map<String, CompanyStoreHead> storeMap = list.stream().collect(Collectors.toMap(x -> x.getShopId(), y -> y));
        return storeMap;
    }

    @Override
    public void processKsOrder() {
        Map<String, CompanyStoreHead> storeMap = this.getKsInitData();
        for (String openId : storeMap.keySet()) {
            CompanyStoreHead companyStoreHead;
            String ksShopAccessToken = "ks_shop_access_token:" + openId;
            String assertToken = (String)this.redisUtil.get(ksShopAccessToken);
            if (StrUtil.isBlank((CharSequence)assertToken) || ObjectUtil.isEmpty((Object)((Object)(companyStoreHead = storeMap.get(openId)))) || StrUtil.isEmpty((CharSequence)companyStoreHead.getElsAccount()) || "100000".equals(companyStoreHead.getElsAccount())) continue;
            this.pullKsOrder(assertToken, companyStoreHead);
            this.pullKsItem(assertToken, companyStoreHead);
        }
    }

    @Override
    public void processDyOrders() {
        Map<String, CompanyStoreHead> storeMap = this.companyStoreHeadService.getDyInitData();
        for (String shopId : storeMap.keySet()) {
            CompanyStoreHead companyStoreHead = storeMap.get(shopId);
            AccessToken accessToken = this.douDianApiUtil.getToken(shopId);
            if (ObjectUtil.isEmpty((Object)accessToken)) {
                companyStoreHead.setAuthState(CompanyStoreAuthStatusEnum.EXPIRED.getValue());
                continue;
            }
            this.pullDyOrder(companyStoreHead, accessToken);
        }
    }

    private void pullDyOrder(CompanyStoreHead companyStoreHead, AccessToken accessToken) {
        OrderSearchListRequest request = new OrderSearchListRequest();
        request.setConfig(this.douDianApiUtil.getDoudianOpConfig());
        long page = 0L;
        int errorIndex = 10;
        while (page == 0L) {
            try {
                OrderSearchListParam param = (OrderSearchListParam)request.getParam();
                param.setSize(1L);
                param.setSize(20L);
                param.setPage(page);
                DateTime startDateTime = DateUtil.offsetDay((Date)new Date(), (int)-1);
                param.setCreateTimeStart(startDateTime.getTime() / 1000L);
                param.setOrderBy("create_time");
                param.setOrderAsc(false);
                OrderSearchListResponse response = (OrderSearchListResponse)request.execute(accessToken);
                OrderSearchListData orderSearchListData = (OrderSearchListData)response.getData();
                List<ShopOrderListItem> shopOrderListItems = orderSearchListData.getShopOrderList();
                ArrayList dyOrders = Lists.newArrayList();
                ArrayList dyOrderItems = Lists.newArrayList();
                for (ShopOrderListItem orderItem : shopOrderListItems) {
                    DyOrder dyOrder = new DyOrder();
                    dyOrder.setElsAccount(companyStoreHead.getElsAccount());
                    BeanUtil.copyProperties((Object)orderItem, (Object)((Object)dyOrder), (String[])new String[0]);
                    dyOrder.setCreateTime(new Date());
                    dyOrder.setUpdateTime(new Date());
                    if (ObjectUtil.isNotEmpty((Object)orderItem.getCreateTime()) && !orderItem.getCreateTime().equals(0L)) {
                        dyOrder.setOrderCreateTime(new Date(orderItem.getCreateTime() * 1000L));
                        if (ObjectUtil.isNotEmpty((Object)orderItem.getOrderExpireTime()) && !orderItem.getOrderExpireTime().equals(0L)) {
                            dyOrder.setOrderExpireTime(new Date((orderItem.getCreateTime() + orderItem.getOrderExpireTime()) * 1000L));
                        } else {
                            dyOrder.setOrderExpireTime(null);
                        }
                    } else {
                        dyOrder.setOrderCreateTime(null);
                    }
                    if (ObjectUtil.isNotEmpty((Object)orderItem.getUpdateTime()) && !orderItem.getUpdateTime().equals(0L)) {
                        dyOrder.setOrderUpdateTime(new Date(orderItem.getUpdateTime() * 1000L));
                    } else {
                        dyOrder.setOrderUpdateTime(null);
                    }
                    if (ObjectUtil.isNotEmpty((Object)orderItem.getPayTime()) && !orderItem.getPayTime().equals(0L)) {
                        dyOrder.setPayTime(new Date(orderItem.getPayTime() * 1000L));
                    } else {
                        dyOrder.setPayTime(null);
                    }
                    if (ObjectUtil.isNotEmpty((Object)orderItem.getShipTime()) && !orderItem.getShipTime().equals(0L)) {
                        dyOrder.setShipTime(new Date(orderItem.getShipTime() * 1000L));
                    } else {
                        dyOrder.setShipTime(null);
                    }
                    if (ObjectUtil.isNotEmpty((Object)orderItem.getFinishTime()) && !orderItem.getFinishTime().equals(0L)) {
                        dyOrder.setFinishTime(new Date(orderItem.getFinishTime() * 1000L));
                    } else {
                        dyOrder.setFinishTime(null);
                    }
                    dyOrders.add(dyOrder);
                    if (!CollUtil.isNotEmpty(orderItem.getSkuOrderList())) continue;
                    for (SkuOrderListItem skuOrderListItem : orderItem.getSkuOrderList()) {
                        dyOrderItems.add(this.getDyOrderItem(skuOrderListItem, companyStoreHead, accessToken));
                    }
                }
                List orderIds = shopOrderListItems.stream().map(x -> x.getOrderId()).distinct().collect(Collectors.toList());
                if (CollUtil.isNotEmpty(orderIds)) {
                    this.dyOrderService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount())).in(DyOrder::getOrderId, orderIds));
                    this.dyOrderService.saveBatch(dyOrders);
                    this.dyOrderItemService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount())).in(DyOrderItem::getParentOrderId, orderIds));
                    this.dyOrderItemService.saveBatch(dyOrderItems);
                }
                if (CollUtil.isEmpty(orderSearchListData.getShopOrderList())) {
                    return;
                }
                ++page;
            }
            catch (Exception e) {
                --errorIndex;
                log.error("\u62c9\u53d6\u6296\u5e97\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private DyOrderItem getDyOrderItem(SkuOrderListItem skuOrderListItem, CompanyStoreHead companyStoreHead, AccessToken accessToken) {
        DyOrderItem dyOrderItem = (DyOrderItem)((Object)BeanUtil.copyProperties((Object)skuOrderListItem, DyOrderItem.class, (String[])new String[0]));
        dyOrderItem.setElsAccount(companyStoreHead.getElsAccount());
        dyOrderItem.setCreateTime(new Date());
        dyOrderItem.setUpdateTime(new Date());
        if (ObjectUtil.isNotEmpty((Object)skuOrderListItem.getConfirmReceiptTime()) && !skuOrderListItem.getConfirmReceiptTime().equals(0L)) {
            dyOrderItem.setConfirmReceiptTime(new Date(skuOrderListItem.getConfirmReceiptTime() * 1000L));
        } else {
            dyOrderItem.setConfirmReceiptTime(null);
        }
        BuyinQueryShopAllianceOrderRequest request = new BuyinQueryShopAllianceOrderRequest();
        request.setConfig(this.douDianApiUtil.getDoudianOpConfig());
        BuyinQueryShopAllianceOrderParam param = (BuyinQueryShopAllianceOrderParam)request.getParam();
        param.setSize(1L);
        param.setCursor("0");
        param.setOrderIds("4913582559608855817");
        BuyinQueryShopAllianceOrderResponse response = (BuyinQueryShopAllianceOrderResponse)request.execute(accessToken);
        log.debug("BuyinQueryShopAllianceOrderResponse is {}", (Object)JSON.toJSONString((Object)response));
        if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty(response.getData()) && CollUtil.isNotEmpty(((Data)response.getData()).getOrders())) {
            ColonelOrderInfo colonelOrderInfo;
            List<OrdersItem> orders = ((Data)response.getData()).getOrders();
            OrdersItem ordersItem = orders.get(0);
            dyOrderItem.setMediaType(ordersItem.getMediaType());
            dyOrderItem.setSettleTime(ordersItem.getSettleTime());
            dyOrderItem.setPayGoodsAmount(ordersItem.getPayGoodsAmount());
            dyOrderItem.setSettledGoodsAmount(ordersItem.getSettledGoodsAmount());
            dyOrderItem.setRealCommission(ordersItem.getRealCommission());
            dyOrderItem.setEstimatedCommission(ordersItem.getEstimatedCommission());
            dyOrderItem.setAuthorAccount(ordersItem.getAuthorAccount());
            dyOrderItem.setAuthorBuyinId(ordersItem.getAuthorBuyinId());
            dyOrderItem.setAuthorShortId(ordersItem.getAuthorShortId());
            if (ObjectUtil.isNotEmpty((Object)ordersItem.getCommissionRate())) {
                if (ordersItem.getCommissionRate().equals(0L)) {
                    dyOrderItem.setCommissionRate("0");
                } else {
                    dyOrderItem.setCommissionRate(ordersItem.getCommissionRate() / 10000L + "");
                }
            }
            if (ObjectUtil.isNotEmpty((Object)(colonelOrderInfo = ordersItem.getColonelOrderInfo()))) {
                if (ObjectUtil.isNotEmpty((Object)colonelOrderInfo.getActivityId())) {
                    dyOrderItem.setActivityId(colonelOrderInfo.getActivityId() + "");
                }
                if (ObjectUtil.isNotEmpty((Object)colonelOrderInfo.getInstitutionId())) {
                    dyOrderItem.setInstitutionId(colonelOrderInfo.getInstitutionId() + "");
                }
                dyOrderItem.setInstitutionName(colonelOrderInfo.getInstitutionName());
                dyOrderItem.setHeadEstimatedCommission(colonelOrderInfo.getEstimatedCommission());
                dyOrderItem.setHeadRealCommission(colonelOrderInfo.getRealCommission());
                dyOrderItem.setHeadCommissionRate(colonelOrderInfo.getCommissionRate());
            }
            if (ObjectUtil.isNotEmpty((Object)ordersItem.getMediaId())) {
                dyOrderItem.setMediaId(ordersItem.getMediaId() + "");
            }
            log.debug("order is {}", (Object)JSON.toJSONString(orders));
        }
        return dyOrderItem;
    }

    public static void main(String[] args) {
        DateTime startDateTime = DateUtil.offsetDay((Date)new Date(), (int)-90);
        System.out.println(startDateTime.getTime() / 1000L);
        System.out.println(startDateTime.getTime());
        String a = "4913582559608855817";
        DoudianOpConfig doudianOpConfig = new DoudianOpConfig();
        doudianOpConfig.setAppKey("7238784366355154487");
        doudianOpConfig.setAppSecret("1c216dd8-7cab-40fb-99cd-33d2273f68ce");
        AccessToken accessToken = AccessToken.wrap("a771906e-c0a3-42b1-a868-ca4b68be0b54", "501772d3-3de4-437c-b1f7-091e9f409530");
        BuyinQueryShopAllianceProductsRequest request = new BuyinQueryShopAllianceProductsRequest();
        request.setConfig(doudianOpConfig);
        BuyinQueryShopAllianceProductsParam param = (BuyinQueryShopAllianceProductsParam)request.getParam();
        param.setPage(1L);
        param.setSize(20L);
        param.setProductIds(Arrays.asList(3578423368778674234L));
        param.setSortBy("update_time");
        param.setSortOrder("Desc");
        param.setFields(Arrays.asList("is_exclusive"));
        BuyinQueryShopAllianceProductsResponse response = (BuyinQueryShopAllianceProductsResponse)request.execute(accessToken);
        System.out.println(response);
    }

    @Override
    public void initKsItemCategory() {
        Map<String, CompanyStoreHead> storeMap = this.getKsInitData();
        for (String openId : storeMap.keySet()) {
            CompanyStoreHead companyStoreHead;
            String ksShopAccessToken = "ks_shop_access_token:" + openId;
            String assertToken = (String)this.redisUtil.get(ksShopAccessToken);
            if (StrUtil.isBlank((CharSequence)assertToken) || ObjectUtil.isEmpty((Object)((Object)(companyStoreHead = storeMap.get(openId)))) || StrUtil.isEmpty((CharSequence)companyStoreHead.getElsAccount()) || "100000".equals(companyStoreHead.getElsAccount())) continue;
            AccessTokenKsMerchantClient client = new AccessTokenKsMerchantClient(this.kuaiShouProperties.getAppKey(), this.kuaiShouProperties.getSignSecret());
            OpenItemCategoryRequest request = new OpenItemCategoryRequest();
            request.setAccessToken(assertToken);
            request.setApiMethodVersion(1L);
            try {
                OpenItemCategoryResponse response = (OpenItemCategoryResponse)client.execute((KsMerchantRequest)request);
                GetCategoryResponseParam[] responseParams = response.getData();
                ArrayList categories = Lists.newArrayList();
                for (GetCategoryResponseParam responseParam : responseParams) {
                    KsItemsCategory itemsCategory = new KsItemsCategory();
                    itemsCategory.setElsAccount(companyStoreHead.getElsAccount());
                    BeanUtil.copyProperties((Object)responseParam, (Object)((Object)itemsCategory), (String[])new String[0]);
                    categories.add(itemsCategory);
                }
                this.ksItemsCategoryService.remove((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount()));
                this.ksItemsCategoryService.saveBatch(categories);
            }
            catch (KsMerchantApiException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public KsOrderDetailVO getKsOrderDetail(String id) {
        CompanyStoreOrderHead db = (CompanyStoreOrderHead)((Object)this.getById((Serializable)((Object)id)));
        KsOrderDetailVO vo = (KsOrderDetailVO)((Object)BeanUtil.copyProperties((Object)((Object)db), KsOrderDetailVO.class, (String[])new String[0]));
        return vo;
    }

    @Override
    public Map<String, String> getToken() {
        Map<String, CompanyStoreHead> storeMap = this.getKsInitData();
        HashMap shops = Maps.newHashMap();
        for (String openId : storeMap.keySet()) {
            String ksShopAccessToken = "ks_shop_access_token:" + openId;
            String assertToken = (String)this.redisUtil.get(ksShopAccessToken);
            shops.put(openId, assertToken);
        }
        return shops;
    }

    private void pullKsItem(String accessToken, CompanyStoreHead companyStoreHead) {
        AccessTokenKsMerchantClient client = new AccessTokenKsMerchantClient(this.kuaiShouProperties.getAppKey(), this.kuaiShouProperties.getSignSecret());
        OpenItemListGetRequest request = new OpenItemListGetRequest();
        request.setAccessToken(accessToken);
        request.setApiMethodVersion(1L);
        int pageNum = 1;
        int totalPage = 0;
        request.setPageNumber(Integer.valueOf(pageNum));
        OpenItemListGetResponse response = null;
        try {
            while (true) {
                GetItemListResponseParam data;
                Object[] shelfItemInfoResponseParams;
                if (ArrayUtil.isNotEmpty((Object[])(shelfItemInfoResponseParams = (data = (response = (OpenItemListGetResponse)client.execute((KsMerchantRequest)request)).getData()).getItems()))) {
                    ArrayList items = Lists.newArrayList();
                    for (Object param : shelfItemInfoResponseParams) {
                        KsItems ksItems = new KsItems();
                        BeanUtil.copyProperties((Object)param, (Object)((Object)ksItems), (String[])new String[0]);
                        ksItems.setShopName(companyStoreHead.getName());
                        ksItems.setCompany(companyStoreHead.getCompany());
                        ksItems.setShopId(companyStoreHead.getShopId());
                        if (ObjectUtil.isNotEmpty((Object)param.getCreateTime()) && !param.getCreateTime().equals(0L)) {
                            ksItems.setItemCreateTime(new Date(param.getCreateTime()));
                        } else {
                            ksItems.setItemCreateTime(null);
                        }
                        if (ObjectUtil.isNotEmpty((Object)param.getUpdateTime()) && !param.getUpdateTime().equals(0L)) {
                            ksItems.setItemUpdateTime(new Date(param.getUpdateTime()));
                        } else {
                            ksItems.setItemUpdateTime(null);
                        }
                        ksItems.setElsAccount(companyStoreHead.getElsAccount());
                        ksItems.setDeleted(CommonConstant.STATUS_NO);
                        items.add(ksItems);
                    }
                    if (CollUtil.isNotEmpty((Collection)items)) {
                        List ids = items.stream().map(x -> x.getKwaiItemId()).distinct().collect(Collectors.toList());
                        this.ksItemsService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KsItems::getKwaiItemId, ids)).eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount()));
                        this.ksItemsService.saveBatch(items);
                        this.pullItemPlan(items, accessToken);
                    }
                }
                if (pageNum == (totalPage = data.getTotalPage().intValue())) {
                    return;
                }
                ++pageNum;
            }
        }
        catch (KsMerchantApiException e) {
            throw new RuntimeException(e);
        }
    }

    private void pullItemPlan(List<KsItems> items, String accessToken) {
        for (KsItems item : items) {
            try {
                AccessTokenKsMerchantClient client = new AccessTokenKsMerchantClient(this.kuaiShouProperties.getAppKey(), this.kuaiShouProperties.getSignSecret());
                OpenDistributionPlanQueryRequest request = new OpenDistributionPlanQueryRequest();
                request.setAccessToken(accessToken);
                request.setApiMethodVersion(1L);
                request.setItemId(Long.valueOf(item.getKwaiItemId()));
                OpenDistributionPlanQueryResponse response = (OpenDistributionPlanQueryResponse)client.execute((KsMerchantRequest)request);
                if (ObjectUtil.isEmpty((Object)response) || !response.isSuccess() || ObjectUtil.isEmpty((Object)response.getData())) continue;
                DistributePlanView data = response.getData();
                KsItemPlan ksItemPlan = (KsItemPlan)((Object)BeanUtil.copyProperties((Object)data, KsItemPlan.class, (String[])new String[0]));
                if (ObjectUtil.isNotEmpty((Object)data.getCreateTime()) && !data.getCreateTime().equals(0L)) {
                    ksItemPlan.setPlanCreateTime(new Date(data.getCreateTime()));
                } else {
                    ksItemPlan.setPlanCreateTime(null);
                }
                if (ObjectUtil.isNotEmpty((Object)data.getUpdateTime()) && !data.getUpdateTime().equals(0L)) {
                    ksItemPlan.setPlanUpdateTime(new Date(data.getUpdateTime()));
                } else {
                    ksItemPlan.setPlanUpdateTime(null);
                }
                this.ksItemPlanService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(KsItemPlan::getItemId, (Object)item.getKwaiItemId())).eq(BaseEntity::getElsAccount, (Object)item.getElsAccount()));
                ksItemPlan.setElsAccount(item.getElsAccount());
                this.ksItemPlanService.save((Object)ksItemPlan);
            }
            catch (Exception e) {
                log.error("\u62c9\u53d6\u5546\u54c1\u8ba1\u5212\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void pullKsOrder(String accessToken, CompanyStoreHead companyStoreHead) {
        AccessTokenKsMerchantClient client = new AccessTokenKsMerchantClient(this.kuaiShouProperties.getAppKey(), this.kuaiShouProperties.getSignSecret());
        String startKey = "KS_PULL_ORDER_TIME:" + companyStoreHead.getShopId();
        Long startTime = (Long)this.redisUtil.get(startKey);
        if (ObjectUtil.isEmpty((Object)startTime)) {
            startTime = DateUtil.offsetDay((Date)new Date(), (int)-89).getTime();
        }
        boolean endFlag = true;
        String cursor = "";
        while (endFlag) {
            if (startTime > System.currentTimeMillis()) {
                return;
            }
            OpenOrderCursorListRequest request = new OpenOrderCursorListRequest();
            request.setAccessToken(accessToken);
            request.setApiMethodVersion(1L);
            DateUtil.beginOfWeek((Date)new Date());
            request.setOrderViewStatus(Integer.valueOf(1));
            request.setPageSize(Integer.valueOf(50));
            request.setSort(Integer.valueOf(1));
            request.setQueryType(Integer.valueOf(1));
            request.setBeginTime(startTime);
            request.setEndTime(Long.valueOf(DateUtil.offsetWeek((Date)new Date(startTime), (int)1).getTime()));
            request.setCursor(cursor);
            try {
                log.debug("\u62c9\u53d6\u5feb\u624b\u8ba2\u5355\uff0copenid:{},\u5f00\u59cb\u65f6\u95f4:{},\u7ed3\u675f\u65f6\u95f4:{}", new Object[]{companyStoreHead.getShopId(), DateUtil.format((Date)new Date(request.getBeginTime()), (String)"yyyy-MM-dd HH:mm:ss"), DateUtil.format((Date)new Date(request.getEndTime()), (String)"yyyy-MM-dd HH:mm:ss")});
                OpenOrderCursorListResponse response = (OpenOrderCursorListResponse)client.execute((KsMerchantRequest)request);
                log.debug("response is {}", (Object)JSON.toJSONString((Object)response));
                if (response.isSuccess()) {
                    OrderListData orderListData = response.getData();
                    List<OrderList> orderLists = Arrays.asList(orderListData.getOrderList());
                    cursor = orderListData.getCursor();
                    if ("nomore".equals(cursor)) {
                        startTime = request.getEndTime();
                        cursor = "";
                    }
                    ArrayList ksOrderBaseInfos = Lists.newArrayList();
                    ArrayList ksOrderItemInfos = Lists.newArrayList();
                    ArrayList ksOrderRefunds = Lists.newArrayList();
                    if (!CollUtil.isNotEmpty(orderLists)) continue;
                    for (OrderList order : orderLists) {
                        OrderBaseInfo orderBaseInfo = order.getOrderBaseInfo();
                        KsOrderBaseInfo ksOrderBaseInfo = new KsOrderBaseInfo();
                        BeanUtil.copyProperties((Object)orderBaseInfo, (Object)((Object)ksOrderBaseInfo), (String[])new String[0]);
                        ksOrderBaseInfo.setOid(orderBaseInfo.getOid());
                        ksOrderBaseInfo.setShopId(companyStoreHead.getShopId());
                        if (ObjectUtil.isNotEmpty((Object)orderBaseInfo.getCreateTime()) && !orderBaseInfo.getCreateTime().equals(0L)) {
                            ksOrderBaseInfo.setOrderCreateTime(new Date(orderBaseInfo.getCreateTime()));
                        } else {
                            ksOrderBaseInfo.setOrderCreateTime(null);
                        }
                        if (ObjectUtil.isNotEmpty((Object)orderBaseInfo.getUpdateTime()) && !orderBaseInfo.getUpdateTime().equals(0L)) {
                            ksOrderBaseInfo.setOrderUpdateTime(new Date(orderBaseInfo.getUpdateTime()));
                        } else {
                            ksOrderBaseInfo.setOrderUpdateTime(null);
                        }
                        if (ObjectUtil.isNotEmpty((Object)orderBaseInfo.getPayTime()) && !orderBaseInfo.getPayTime().equals(0L)) {
                            ksOrderBaseInfo.setPayTime(new Date(orderBaseInfo.getPayTime()));
                        } else {
                            ksOrderBaseInfo.setPayTime(null);
                        }
                        if (ObjectUtil.isNotEmpty((Object)orderBaseInfo.getSendTime()) && !orderBaseInfo.getSendTime().equals(0L)) {
                            ksOrderBaseInfo.setSendTime(new Date(orderBaseInfo.getSendTime()));
                        } else {
                            ksOrderBaseInfo.setSendTime(null);
                        }
                        if (ObjectUtil.isNotEmpty((Object)orderBaseInfo.getRefundTime()) && !orderBaseInfo.getRefundTime().equals(0L)) {
                            ksOrderBaseInfo.setRefundTime(new Date(orderBaseInfo.getRefundTime()));
                        } else {
                            ksOrderBaseInfo.setRefundTime(null);
                        }
                        if (ObjectUtil.isNotEmpty((Object)orderBaseInfo.getRecvTime()) && !orderBaseInfo.getRecvTime().equals(0L)) {
                            ksOrderBaseInfo.setRecvTime(new Date(orderBaseInfo.getRecvTime()));
                        } else {
                            ksOrderBaseInfo.setRecvTime(null);
                        }
                        if (ObjectUtil.isNotEmpty((Object)order.getOrderCpsInfo())) {
                            if (ObjectUtil.isNotEmpty((Object)order.getOrderCpsInfo().getDistributorId())) {
                                ksOrderBaseInfo.setDistributorId(order.getOrderCpsInfo().getDistributorId().toString());
                            }
                            ksOrderBaseInfo.setDistributorName(order.getOrderCpsInfo().getDistributorName());
                        }
                        ksOrderBaseInfo.setCompany(companyStoreHead.getCompany());
                        ksOrderBaseInfo.setElsAccount(companyStoreHead.getElsAccount());
                        ksOrderBaseInfos.add(ksOrderBaseInfo);
                        OrderItemInfo orderItemInfo = order.getOrderItemInfo();
                        KsOrderItemInfo ksOrderItemInfo = new KsOrderItemInfo();
                        BeanUtil.copyProperties((Object)orderItemInfo, (Object)((Object)ksOrderItemInfo), (String[])new String[0]);
                        ksOrderItemInfo.setElsAccount(companyStoreHead.getElsAccount());
                        ksOrderItemInfo.setOid(ksOrderBaseInfo.getOid());
                        ksOrderItemInfos.add(ksOrderItemInfo);
                        Object[] orderRefundInfos = order.getOrderRefundList();
                        if (ArrayUtil.isNotEmpty((Object[])orderRefundInfos)) {
                            for (Object orderRefundInfo : orderRefundInfos) {
                                KsOrderRefund ksOrderRefund = new KsOrderRefund();
                                BeanUtil.copyProperties((Object)orderRefundInfo, (Object)((Object)ksOrderRefund), (String[])new String[0]);
                                ksOrderRefund.setOid(ksOrderBaseInfo.getOid());
                                ksOrderRefund.setElsAccount(companyStoreHead.getElsAccount());
                                ksOrderRefunds.add(ksOrderRefund);
                            }
                        }
                        this.pullOrderBill(accessToken, orderBaseInfo.getOid(), companyStoreHead.getElsAccount());
                    }
                    log.debug("orderLists is {}", (Object)JSON.toJSONString(orderLists));
                    List oids = ksOrderBaseInfos.stream().map(x -> x.getOid()).distinct().collect(Collectors.toList());
                    this.ksOrderBaseInfoService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KsOrderBaseInfo::getOid, oids)).eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount()));
                    this.ksOrderItemInfoService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KsOrderItemInfo::getOid, oids)).eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount()));
                    this.ksOrderRefundService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KsOrderRefund::getOid, oids)).eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount()));
                    this.ksOrderBaseInfoService.saveBatch(ksOrderBaseInfos);
                    this.ksOrderItemInfoService.saveBatch(ksOrderItemInfos);
                    this.ksOrderRefundService.saveBatch(ksOrderRefunds);
                    continue;
                }
                endFlag = false;
            }
            catch (KsMerchantApiException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void pullOrderBill(String accessToken, Long oid, String elsAccount) {
        AccessTokenKsMerchantClient client = new AccessTokenKsMerchantClient(this.kuaiShouProperties.getAppKey(), this.kuaiShouProperties.getSignSecret());
        OpenFundsFinancialBillDetailRequest request = new OpenFundsFinancialBillDetailRequest();
        request.setAccessToken(accessToken);
        request.setApiMethodVersion(1L);
        request.setOrderId(oid);
        try {
            OpenFundsFinancialBillDetailResponse response = (OpenFundsFinancialBillDetailResponse)client.execute((KsMerchantRequest)request);
            OrderBillDetail orderBillDetail = response.getData();
            if (ObjectUtil.isEmpty((Object)orderBillDetail)) {
                return;
            }
            KsOrderBill ksOrderBill = new KsOrderBill();
            BeanUtil.copyProperties((Object)orderBillDetail, (Object)((Object)ksOrderBill), (String[])new String[0]);
            ksOrderBill.setOid(oid);
            if (ObjectUtil.isNotEmpty((Object)orderBillDetail.getSettlementTime()) && !orderBillDetail.getSettlementTime().equals(0L)) {
                ksOrderBill.setSettlementTime(new Date(orderBillDetail.getSettlementTime()));
            } else {
                ksOrderBill.setSettlementTime(null);
            }
            ksOrderBill.setElsAccount(elsAccount);
            this.ksOrderBillService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(KsOrderBill::getOid, (Object)oid)).eq(BaseEntity::getElsAccount, (Object)elsAccount));
            this.ksOrderBillService.save((Object)ksOrderBill);
        }
        catch (KsMerchantApiException e) {
            log.error("\u62c9\u53d6\u8ba2\u5355\u8d26\u5355\u5f02\u5e38", (Throwable)e);
        }
    }
}

