/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.doudian.open.api.buyin_simplePlanList.BuyinSimplePlanListRequest;
import com.doudian.open.api.buyin_simplePlanList.BuyinSimplePlanListResponse;
import com.doudian.open.api.buyin_simplePlanList.data.BuyinSimplePlanListData;
import com.doudian.open.api.buyin_simplePlanList.data.PromotionsItem;
import com.doudian.open.api.buyin_simplePlanList.param.BuyinSimplePlanListParam;
import com.doudian.open.api.product_detail.ProductDetailRequest;
import com.doudian.open.api.product_detail.ProductDetailResponse;
import com.doudian.open.api.product_detail.data.ProductDetailData;
import com.doudian.open.api.product_detail.param.ProductDetailParam;
import com.doudian.open.api.product_listV2.ProductListV2Request;
import com.doudian.open.api.product_listV2.ProductListV2Response;
import com.doudian.open.api.product_listV2.data.CategoryDetail;
import com.doudian.open.api.product_listV2.data.DataItem;
import com.doudian.open.api.product_listV2.data.ProductListV2Data;
import com.doudian.open.api.product_listV2.param.ProductListV2Param;
import com.doudian.open.core.AccessToken;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.entity.DyShopProduct;
import com.els.modules.companystore.entity.DyShopProductPromotion;
import com.els.modules.companystore.enumerate.CompanyStoreAuthStatusEnum;
import com.els.modules.companystore.mapper.DyShopProductMapper;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.companystore.service.DyShopProductPromotionService;
import com.els.modules.companystore.service.DyShopProductService;
import com.els.modules.companystore.utils.DouDianApiUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DyShopProductServiceImpl
extends BaseServiceImpl<DyShopProductMapper, DyShopProduct>
implements DyShopProductService {
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;
    @Autowired
    private DouDianApiUtil douDianApiUtil;
    @Autowired
    private DyShopProductPromotionService dyShopProductPromotionService;

    @Override
    public void add(DyShopProduct dyShopProduct) {
        ((DyShopProductMapper)this.baseMapper).insert((Object)dyShopProduct);
    }

    @Override
    public void edit(DyShopProduct dyShopProduct) {
        int count = ((DyShopProductMapper)this.baseMapper).updateById((Object)dyShopProduct);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((DyShopProductMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((DyShopProductMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void processDyShopProduct() {
        Map<String, CompanyStoreHead> storeMap = this.companyStoreHeadService.getDyInitData();
        for (String shopId : storeMap.keySet()) {
            CompanyStoreHead companyStoreHead = storeMap.get(shopId);
            AccessToken accessToken = this.douDianApiUtil.getToken(shopId);
            if (ObjectUtil.isEmpty((Object)accessToken)) {
                companyStoreHead.setAuthState(CompanyStoreAuthStatusEnum.EXPIRED.getValue());
                continue;
            }
            this.pull(companyStoreHead, accessToken);
        }
    }

    public void pull(CompanyStoreHead companyStoreHead, AccessToken accessToken) {
        long page = 1L;
        int errorIndex = 10;
        while (page == 1L) {
            ++page;
            try {
                ProductListV2Request request = new ProductListV2Request();
                request.setConfig(this.douDianApiUtil.getDoudianOpConfig());
                ProductListV2Param param = (ProductListV2Param)request.getParam();
                DateTime startDateTime = DateUtil.offsetDay((Date)new Date(), (int)-1);
                param.setStartTime(startDateTime.getTime() / 1000L);
                param.setPage(page);
                param.setSize(10L);
                param.setUseCursor(false);
                ProductListV2Response response = (ProductListV2Response)request.execute(accessToken);
                ProductListV2Data productListV2Data = (ProductListV2Data)response.getData();
                if (ObjectUtil.isEmpty((Object)productListV2Data)) {
                    return;
                }
                List<DataItem> dataItems = productListV2Data.getData();
                if (CollUtil.isEmpty(dataItems)) {
                    return;
                }
                ArrayList dbs = Lists.newArrayList();
                for (DataItem dataItem : dataItems) {
                    DyShopProduct db = new DyShopProduct();
                    BeanUtil.copyProperties((Object)dataItem, (Object)((Object)db), (String[])new String[0]);
                    db.setElsAccount(companyStoreHead.getElsAccount());
                    if (ObjectUtil.isNotEmpty((Object)dataItem.getCreateTime()) && !dataItem.getCreateTime().equals(0L)) {
                        db.setCreateTime(new Date(dataItem.getCreateTime() * 1000L));
                    } else {
                        db.setCreateTime(null);
                    }
                    if (ObjectUtil.isNotEmpty((Object)dataItem.getUpdateTime()) && !dataItem.getUpdateTime().equals(0L)) {
                        db.setUpdateTime(new Date(dataItem.getUpdateTime() * 1000L));
                    } else {
                        db.setUpdateTime(null);
                    }
                    db.setProductHref("https://haohuo.jinritemai.com/views/product/item2?id=" + dataItem.getProductId());
                    db.setShopId(companyStoreHead.getShopId());
                    db.setShopName(companyStoreHead.getName());
                    CategoryDetail categoryDetail2 = dataItem.getCategoryDetail();
                    if (ObjectUtil.isNotEmpty((Object)categoryDetail2)) {
                        if (ObjectUtil.isNotEmpty((Object)categoryDetail2.getFirstCid())) {
                            db.setFirstCid(categoryDetail2.getFirstCid() + "");
                            db.setFirstCname(categoryDetail2.getFirstCname());
                        }
                        if (ObjectUtil.isNotEmpty((Object)categoryDetail2.getSecondCid())) {
                            db.setSecondCid(categoryDetail2.getSecondCid() + "");
                            db.setSecondCname(categoryDetail2.getSecondCname());
                        }
                        if (ObjectUtil.isNotEmpty((Object)categoryDetail2.getThirdCid())) {
                            db.setThirdCid(categoryDetail2.getThirdCid() + "");
                            db.setThirdCname(categoryDetail2.getThirdCname());
                        }
                        if (ObjectUtil.isNotEmpty((Object)categoryDetail2.getFourthCid())) {
                            db.setFourthCid(categoryDetail2.getFourthCid() + "");
                            db.setFourthCname(categoryDetail2.getFourthCname());
                        }
                    }
                    this.handleDetail(db, accessToken);
                    this.handlePlant(db, accessToken);
                    dbs.add(db);
                }
                if (CollUtil.isNotEmpty((Collection)dbs)) {
                    List ids = dbs.stream().map(x -> x.getProductId()).distinct().collect(Collectors.toList());
                    this.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount())).in(DyShopProduct::getProductId, ids));
                    this.saveBatch(dbs);
                }
                ++page;
            }
            catch (Exception e) {
                --errorIndex;
                this.log.error("\u62c9\u53d6\u6296\u5e97\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void handlePlant(DyShopProduct db, AccessToken accessToken) {
        BuyinSimplePlanListRequest request = new BuyinSimplePlanListRequest();
        request.setConfig(this.douDianApiUtil.getDoudianOpConfig());
        BuyinSimplePlanListParam param = (BuyinSimplePlanListParam)request.getParam();
        param.setProductInfo(db.getProductId());
        BuyinSimplePlanListResponse response = (BuyinSimplePlanListResponse)request.execute(accessToken);
        if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty(response.getData()) && CollUtil.isNotEmpty(((BuyinSimplePlanListData)response.getData()).getPromotions())) {
            List<PromotionsItem> promotionsItems = ((BuyinSimplePlanListData)response.getData()).getPromotions();
            ArrayList dbs = Lists.newArrayList();
            for (PromotionsItem promotionsItem : promotionsItems) {
                DyShopProductPromotion productPromotion = (DyShopProductPromotion)((Object)BeanUtil.copyProperties((Object)promotionsItem, DyShopProductPromotion.class, (String[])new String[0]));
                productPromotion.setElsAccount(db.getElsAccount());
                dbs.add(productPromotion);
            }
            this.dyShopProductPromotionService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)db.getElsAccount())).eq(DyShopProductPromotion::getProductId, (Object)db.getProductId()));
            this.dyShopProductPromotionService.saveBatch(dbs);
        }
    }

    private void handleDetail(DyShopProduct db, AccessToken accessToken) {
        ProductDetailRequest request = new ProductDetailRequest();
        request.setConfig(this.douDianApiUtil.getDoudianOpConfig());
        ProductDetailParam param = (ProductDetailParam)request.getParam();
        param.setProductId(db.getProductId());
        ProductDetailResponse response = (ProductDetailResponse)request.execute(accessToken);
        System.out.println(response);
        if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty(response.getData())) {
            ProductDetailData detailData = (ProductDetailData)response.getData();
            if (ObjectUtil.isNotEmpty((Object)detailData.getStandardBrandId())) {
                db.setStandardBrandId(detailData.getStandardBrandId() + "");
            }
            detailData.setDescription(detailData.getDescription());
        }
    }
}

